# Traditional T9
Dieses Handbuch erklärt, wie Sie Traditional T9 in verschiedenen Szenarien konfigurieren und verwenden können. Anweisungen zur Installation und Informationen zu den "Lite"- und "Voll"-Versionen finden Sie im [Installationsleitfaden](https://github.com/sspanak/tt9/blob/master/docs/installation.md) auf GitHub. Außerdem lohnt es sich, die [Hauptseite des Repositories](https://github.com/sspanak/tt9) zu besuchen, die den gesamten Quellcode, einen Entwicklerleitfaden, die Datenschutzerklärung und ergänzende Dokumentationen enthält.

## Ersteinrichtung
Nach der Installation müssen Sie Traditional T9 als Android-Tastatur aktivieren. Klicken Sie dazu auf das Launcher-Symbol. Falls eine Aktion erforderlich ist, sind alle Optionen außer der Ersteinrichtung deaktiviert und es wird ein Label angezeigt: "TT9 ist deaktiviert". Gehen Sie zur Ersteinrichtung und aktivieren Sie es.

_Wenn das Symbol direkt nach der Installation nicht angezeigt wird, starten Sie Ihr Telefon neu. Dies ist eine Energiesparmaßnahme von Android, um die Liste neu installierter Apps nicht sofort zu aktualisieren._

### Verwendung auf einem reinen Touchscreen-Handy
Auf Geräten mit Touchscreen wird außerdem dringend empfohlen, die systemweite Rechtschreibprüfung zu deaktivieren. Ist sie aktiviert, werden einige oder alle eingegebenen Wörter rot unterstrichen.

Ein weiteres Problem besteht darin, dass die Rechtschreibprüfung ein verwirrendes Pop-up-Fenster „Wort hinzufügen“ anzeigen kann. Dieses Dialogfeld fügt neue Wörter zur standardmäßigen Systemtastatur (in der Regel Gboard) hinzu und nicht zum Wörterbuch von Traditional T9.

Um solche Situationen zu vermeiden, muss die systemweite Rechtschreibprüfung deaktiviert werden.

Falls dieser Schritt erforderlich ist, ist der Eintrag „System-Rechtschreibprüfung“ auf dem Bildschirm der Ersteinrichtung aktiv. Tippen Sie darauf, um die Systemkomponente zu deaktivieren. Ist der Eintrag deaktiviert, ist keine weitere Aktion erforderlich.

Nach Abschluss der Ersteinrichtung lesen Sie bitte den Abschnitt [Bildschirmtastatur](#bildschirmtastatur) für weitere Tipps und Hinweise.

### Aktivierung des Prädiktiven Modus
Der Prädiktive Modus erfordert das Laden eines Sprachwörterbuchs, um Wortvorschläge zu bieten. Sie können die aktivierten Sprachen wechseln und ihre Wörterbücher laden unter Einstellungen → [Sprachen](#sprachoptionen). Falls Sie das Laden eines Wörterbuchs vergessen haben, erledigt Traditional T9 dies automatisch, wenn Sie mit dem Tippen beginnen. Weitere Informationen finden Sie [unten](#sprachoptionen).

#### Hinweise für einfache Geräte
Das Laden des Wörterbuchs kann bei leistungsschwachen Geräten zum Absturz führen. Wenn Sie die TT9 "Lite"-Version verwenden, bricht Android den Vorgang möglicherweise ab. Falls das Laden länger als 30 Sekunden dauert, schließen Sie das Ladegerät an oder sorgen Sie dafür, dass der Bildschirm während des Ladens eingeschaltet bleibt.

Sie können dies vermeiden, indem Sie stattdessen die "Voll"-Version verwenden.

#### Hinweise für Android 13 oder höher
Für neu installierte Apps sind die Benachrichtigungen standardmäßig deaktiviert. Es wird empfohlen, diese zu aktivieren, um benachrichtigt zu werden, wenn Wörterbuchaktualisierungen verfügbar sind. Sobald Sie sich dafür entscheiden, sie zu installieren, zeigt TT9 den Fortschritt an. Es werden maximal einmal pro Monat neue Updates veröffentlicht, sodass Sie sich keine Sorgen über zu viele Benachrichtigungen machen müssen.

Sie können die Benachrichtigungen aktivieren, indem Sie zu Einstellungen → Sprachen gehen und Wörterbuchbenachrichtigungen aktivieren.

_Wenn Sie sich entscheiden, die Benachrichtigungen deaktiviert zu lassen, funktioniert TT9 weiterhin einwandfrei. Sie müssen jedoch die Wörterbücher manuell verwalten._

## Einstellungen
Im Einstellungsbildschirm können Sie Sprachen für die Eingabe wählen, die Hotkeys der Tastatur konfigurieren, das Erscheinungsbild der Anwendung ändern oder die Kompatibilität mit Ihrem Telefon verbessern.

### Wie greife ich auf die Einstellungen zu?

#### Methode 1
Tippen Sie auf das Traditional T9-Symbol.

#### Methode 2 (mit Touchscreen)
- Tippen Sie auf ein Text- oder Zahlenfeld, um TT9 zu aktivieren.
- Verwenden Sie die Zahnrad-Taste auf dem Bildschirm.

#### Methode 3 (mit physischer Tastatur)
- Beginnen Sie in einem Text- oder Zahlenfeld zu tippen, um TT9 zu aktivieren.
- Öffnen Sie die Befehlsliste über die Bildschirmtools-Taste oder durch Drücken der zugewiesenen Hotkey-Taste [Standard: Halten ✱].
- Drücken Sie die 2-Taste.

### Navigation in den Einstellungen
Wenn Sie ein Gerät mit physischer Tastatur haben, gibt es zwei Möglichkeiten zur Navigation in den Einstellungen.

1. Verwenden Sie die Hoch-/Runter-Tasten zum Scrollen und OK zum Öffnen oder Aktivieren einer Option.
2. Drücken Sie die Tasten 1–9, um die jeweilige Option auszuwählen, und doppeltippen Sie darauf, um sie zu öffnen/aktivieren. Doppeltippen funktioniert überall auf dem Bildschirm. Beispielsweise wird durch Doppeltippen der 3-Taste die dritte Option aktiviert. Die 0-Taste ist eine praktische Abkürzung zum Scrollen ans Ende, öffnet jedoch nicht die letzte Option.

### Sprachoptionen

#### Wörterbuch laden
Nach der Aktivierung einer oder mehrerer neuer Sprachen müssen die jeweiligen Wörterbücher für den prädiktiven Modus geladen werden. Einmal geladene Wörterbücher bleiben gespeichert, bis Sie eine der „Löschen“-Optionen verwenden. Dies bedeutet, dass Sie Sprachen aktivieren und deaktivieren können, ohne deren Wörterbücher jedes Mal neu laden zu müssen. Nur beim ersten Mal ist dies erforderlich.

Wenn Sie Sprache X verwenden möchten, können Sie sicher alle anderen Sprachen deaktivieren, nur das Wörterbuch X laden (Zeit sparen!) und anschließend die zuvor genutzten Sprachen wieder aktivieren.

Das Neuladen eines Wörterbuchs setzt die Beliebtheit von Vorschlägen auf die Werkseinstellungen zurück. Dies sollte jedoch keine Bedenken auslösen. In den meisten Fällen werden Sie kaum Änderungen in der Reihenfolge der Vorschläge bemerken, es sei denn, Sie verwenden häufig ungewöhnliche Wörter.

#### Automatisches Laden von Wörterbüchern

Falls Sie das Laden eines Wörterbuchs im Einstellungsbildschirm überspringen oder vergessen, wird dies automatisch geschehen, wenn Sie in einer Anwendung den prädiktiven Modus aktivieren. Sie werden gebeten, zu warten, bis das Laden abgeschlossen ist, und können dann direkt mit dem Tippen beginnen.

Gelöschte Wörterbücher werden NICHT automatisch neu geladen. Sie müssen dies manuell durchführen. Nur Wörterbücher für neu aktivierte Sprachen werden automatisch geladen.

#### Wörterbuch löschen
Falls Sie Sprachen X oder Y nicht mehr verwenden, können Sie diese deaktivieren und auch „Nicht ausgewählte löschen“ verwenden, um Speicherplatz freizugeben.

Um alles zu löschen, unabhängig von der Auswahl, verwenden Sie „Alles löschen“.

In allen Fällen bleiben Ihre selbst hinzugefügten Wörter erhalten und werden wiederhergestellt, sobald Sie das jeweilige Wörterbuch neu laden.

#### Hinzugefügte Wörter
Die Option „Exportieren“ ermöglicht es Ihnen, eine CSV-Datei mit allen hinzugefügten Wörtern für alle Sprachen zu erstellen. Diese CSV-Datei kann dann verwendet werden, um Traditional T9 zu verbessern! Gehen Sie zu GitHub und teilen Sie die Wörter in einem [neuen Issue](https://github.com/sspanak/tt9/issues) oder [Pull-Request](https://github.com/sspanak/tt9/pulls). Nach einer Überprüfung werden sie in der nächsten Version aufgenommen.

Mit „Importieren“ können Sie eine zuvor exportierte CSV-Datei importieren. Es gibt jedoch einige Einschränkungen:
- Es können nur Wörter aus Buchstaben importiert werden. Apostrophe, Bindestriche, andere Satzzeichen oder Sonderzeichen sind nicht erlaubt.
- Emojis sind nicht erlaubt.
- Eine CSV-Datei kann maximal 250 Wörter enthalten.
- Sie können bis zu 1000 Wörter importieren, also maximal 4 Dateien x 250 Wörter. Über dieses Limit hinaus können Sie beim Tippen weiterhin Wörter hinzufügen.

Mit „Löschen“ können Sie nach falsch geschriebenen Wörtern suchen und diese oder andere unerwünschte Wörter aus dem Wörterbuch entfernen.

## Physische Tastenkürzel

Alle Tastenkürzel können in den Einstellungen → Tastatur → Tastenkürzel auswählen konfiguriert oder deaktiviert werden.

### Eingabetasten

#### Vorschläge zurück Taste (Standard: Steuerkreuz Links):
Wählt das vorherige Wort/Buchstabenvorschlag aus.

#### Nächster Vorschlag Taste (Standard: Steuerkreuz Rechts):
Wählt das nächste Wort/Buchstabenvorschlag aus.

#### Vorschläge filtern Taste (Standard: Steuerkreuz Oben):
_Nur im Prädiktiven Modus._

- **Einzelner Druck**: Filtert die Vorschlagsliste und zeigt nur diejenigen an, die mit dem aktuellen Wort beginnen. Es spielt keine Rolle, ob es sich um ein vollständiges Wort handelt. Beispiel: Geben Sie "remin" ein und drücken Sie Filtern. Es werden alle Wörter angezeigt, die mit "remin" beginnen: "remin" selbst, "remind", "reminds", "reminded", "reminding" usw.
- **Doppelter Druck**: Erweitert den Filter auf den gesamten Vorschlag. Beispiel: Geben Sie "remin" ein und drücken Sie zweimal Filtern. Es wird zuerst nach "remin" gefiltert und dann auf "remind" erweitert. Sie können den Filter weiter erweitern, bis Sie zum längsten Wörterbucheintrag gelangen.

Filtern ist auch nützlich, um unbekannte Wörter zu tippen. Angenommen, Sie möchten "Anakin" tippen, was nicht im Wörterbuch vorhanden ist. Beginnen Sie mit "A", drücken Sie dann Filtern, um "B" und "C" auszublenden. Drücken Sie dann die Taste 6. Da der Filter aktiviert ist, werden neben den echten Wörterbuchwörtern alle möglichen Kombinationen für 1+6 angezeigt: "A..." + "m", "n", "o". Wählen Sie "n" und drücken Sie Filtern, um Ihre Auswahl zu bestätigen und "An" zu erstellen. Drücken Sie nun die Taste 2, und es werden "An..." + "a", "b" und "c" angeboten. Wählen Sie "a" und fahren Sie fort, bis Sie "Anakin" erhalten.

Wenn das Filtern aktiviert ist, wird der Basistext fett und kursiv dargestellt.

#### Filter löschen Taste (Standard: Steuerkreuz Unten):
_Nur im Prädiktiven Modus._

Entfernt den Vorschlagsfilter, falls aktiviert.

#### Steuerkreuz Mitte (OK oder ENTER):
- Wenn Vorschläge angezeigt werden, wird der aktuell ausgewählte Vorschlag getippt.
- Andernfalls wird die Standardaktion für die aktuelle Anwendung ausgeführt (z. B. eine Nachricht senden, zu einer URL gehen oder eine neue Zeile eingeben).

_**Hinweis:** Jede Anwendung entscheidet selbst, was passiert, wenn OK gedrückt wird, und TT9 hat darauf keinen Einfluss._

_**Hinweis 2:** Um Nachrichten mit OK in Nachrichtenanwendungen zu senden, müssen Sie deren Einstellung „Mit ENTER senden“ oder eine ähnlich benannte Option aktivieren. Wenn die Anwendung keine solche Einstellung hat, unterstützt sie möglicherweise nicht das Senden von Nachrichten auf diese Weise. Verwenden Sie in diesem Fall die App KeyMapper aus dem [Play Store](https://play.google.com/store/apps/details?id=io.github.sds100.keymapper) oder aus [F-droid](https://f-droid.org/packages/io.github.sds100.keymapper/). Diese erkennt Chat-Apps und simuliert beim Drücken oder Halten einer physischer Taste einen Tastendruck auf die Senden-Taste. Weitere Informationen finden Sie im [Schnellstart-Handbuch](https://docs.keymapper.club/quick-start/)._

#### 0-Taste:
- **Im 123 Modus:**
  - **Drücken:** tippt „0“.
  - **Halten:** tippt Sonder-/Mathematikzeichen.
- **Im ABC Modus:**
  - **Drücken:** tippt Leerzeichen, neue Zeile oder Sonder-/Mathematikzeichen.
  - **Halten:** tippt „0“.
- **Im Prädiktiven Modus:**
  - **Drücken:** tippt Leerzeichen, neue Zeile oder Sonder-/Mathematikzeichen.
  - **Doppeldruck:** tippt das Zeichen, das in den Einstellungen für den Prädiktiven Modus zugewiesen wurde (Standard: „.“)
  - **Halten:** tippt „0“.
- **Im Cheonjiin-Modus (Koreanisch):**
  - **Drücken:** Gibt "ㅇ" und "ㅁ" ein.
  - **Halten:** Gibt Leerzeichen, neue Zeilen, "0" oder Sonder-/Mathematikzeichen ein.

#### 1-Taste:
- **Im 123 Modus:**
  - **Drücken:** tippt „1“.
  - **Halten:** tippt Satzzeichen
- **Im ABC Modus:**
  - **Drücken:** tippt Satzzeichen
  - **Halten:** tippt „1“.
- **Im Prädiktiven Modus:**
  - **Drücken:** tippt Satzzeichen
  - **Mehrfaches Drücken:** tippt Emoji
  - **Halten:** tippt „1“.
- **Im Cheonjiin-Modus (Koreanisch):**
  - **Drücken:** tippt den Vokal "ㅣ".
  - **Halten:** tippt Satzzeichen.
  - **Halten, dann drücken:** tippt Emoji.

#### 2- bis 9-Taste:
- **Im 123 Modus:** tippt die entsprechende Zahl
- **Im ABC- und Prädiktiven Modus:** tippt einen Buchstaben oder hält gedrückt, um die entsprechende Zahl zu tippen.

### Funktionstasten

#### Wort hinzufügen Taste:
Fügt ein neues Wort zum Wörterbuch für die aktuelle Sprache hinzu.

#### Rückschritt Taste (Zurück, Löschen oder Rückschritt):
Löscht Text.

Wenn Ihr Telefon über eine spezielle „Löschen“- oder „Löschen“-Taste verfügt, müssen Sie in den Einstellungen nichts festlegen, es sei denn, Sie möchten einen zusätzlichen Rückschritt-Taste verwenden. In diesem Fall wird automatisch die leere Option: „--“ vorab ausgewählt.

Auf Telefonen, die eine kombinierte „Löschen“- und „Zurück“-Taste haben, wird diese Taste automatisch ausgewählt. Sie können jedoch die Funktion „Rückschritt“ einer anderen Taste zuweisen, sodass „Zurück“ nur zurück navigiert.

_**NB:** Die Verwendung der "Zurück"-Taste als Rückschritt funktioniert nicht in allen Anwendungen, insbesondere nicht in Firefox, Spotify und Termux. Diese können die Taste vollständig kontrollieren und ihre Funktion neu definieren, was bedeutet, dass sie das tut, was die App-Entwickler vorgesehen haben. Leider kann daran nichts geändert werden, da die „Zurück“-Taste in Android eine besondere Rolle spielt und deren Verwendung systembedingt eingeschränkt ist._

_**NB 2:** Das Halten der „Zurück“-Taste löst immer die Standard-Systemaktion aus (d. h. zeigt die Liste der laufenden Anwendungen an)._

_In diesen Fällen können Sie eine andere Taste zuweisen (alle anderen Tasten sind voll nutzbar) oder die Rückschritt-Taste auf dem Bildschirm verwenden._

#### Nächster Eingabemodus Taste (Standard: drücken #):
Durchläuft die Eingabemodi (abc → Prädiktiv → 123).

_Der Prädiktive Modus ist in Passwortfeldern nicht verfügbar._

_In reinen Zahlenfeldern ist ein Wechsel des Modus nicht möglich. In solchen Fällen kehrt die Taste zu ihrer Standardfunktion zurück (d. h. „#“ tippen)._

#### Zwischenablage-Werkzeuge Taste:
Zeigt das Zwischenablage-Werkzeugfeld, mit dem Sie Text auswählen, ausschneiden, kopieren und einfügen können. Sie können das Fenster schließen, indem Sie erneut die „✱“-Taste drücken oder in den meisten Anwendungen die Zurück-Taste drücken. Details sind [unten](#zwischenablage-werkzeuge) verfügbar.

#### Nächste Sprache Taste (Standard: Halten #):
Die Eingabesprache ändern, wenn mehrere Sprachen in den Einstellungen aktiviert wurden.

#### Tastatur auswählen Taste:
Öffnet den Android-Dialog "Tastatur wechseln", in dem Sie zwischen allen installierten Tastaturen auswählen können.

#### Umschalttaste (Standard: Drücken ✱):
- **Beim Tippen von Text:** Umschalten zwischen Groß- und Kleinschreibung.
- **Beim Tippen von Sonderzeichen mit der 0-Taste**: Zeigt die nächste Zeichenkategorie an.

#### Einstellungen anzeigen Taste:
Öffnet den Einstellungsbildschirm. Hier können Sie die Sprachen für das Tippen auswählen, die Hotkeys der Tastatur konfigurieren, das Erscheinungsbild der Anwendung ändern oder die Kompatibilität mit Ihrem Telefon verbessern.

#### Rückgängig-Taste:
Macht die letzte Aktion rückgängig. Entspricht dem Drücken von Strg+Z auf einem Computer oder Cmd+Z auf einem Mac.

_Der Verlauf für Rückgängig wird von den Apps verwaltet, nicht von Traditional T9. Das bedeutet, dass Rückgängig möglicherweise nicht in jeder App funktioniert._

#### Wiederholen-Taste:
Wiederholt die zuletzt rückgängig gemachte Aktion. Entspricht dem Drücken von Strg+Y oder Strg+Umschalt+Z auf einem Computer oder Cmd+Y auf einem Mac.

_Ähnlich wie bei „Rückgängig“ ist der Befehl „Wiederholen“ möglicherweise nicht in jeder App verfügbar._

#### Spracheingabe Taste:
Aktiviert die Spracheingabe auf kompatiblen Telefonen. Weitere Informationen finden Sie [unten](#spracheingabe).

#### Befehlsliste Taste / aka Befehlsübersicht / (Standard: Halten ✱):
Zeigt eine Liste aller Befehle (oder Funktionen) an.

Viele Telefone verfügen nur über zwei oder drei "freie" Tasten, die als Hotkeys verwendet werden können. Traditional T9 hat jedoch viele weitere Funktionen, sodass auf der Tastatur einfach kein Platz für alle vorhanden ist. Die Befehlsübersicht löst dieses Problem. Es ermöglicht das Ausführen zusätzlicher Funktionen (oder Befehle) durch Tastenkombinationen.

Im Folgenden finden Sie eine Liste der möglichen Befehle:
- **Einstellungsbildschirm anzeigen (Standardkombination: Halten ✱, Taste 1).** Entspricht dem Drücken der Taste [Einstellungen anzeigen](#einstellungen-anzeigen-taste).
- **Wort hinzufügen (Standardkombination: Halten ✱, Taste 2).** Entspricht dem Drücken der Taste [Wort hinzufügen](#wort-hinzufügen-taste).
- **Spracheingabe (Standardkombination: Halten ✱, Taste 3).** Entspricht dem Drücken der Taste [Spracheingabe](#spracheingabe-taste).
- **Rückgängig (Standardkombination: ✱ halten, Taste 4).** Entspricht dem Drücken [Rückgängig-Taste](#rückgängig-taste)
- **Zwischenablage-Werkzeuge (Standardkombination: Halten ✱, Taste 5).** Entspricht dem Drücken der Taste [Zwischenablage-Werkzeuge](#zwischenablage-werkzeuge-taste).
- **Wiederholen (Standardkombination: ✱ halten, Taste 6).** Entspricht dem Drücken [Wiederholen-Taste](#wiederholen-taste)
- **Andere Tastatur auswählen (Standardkombination: Halten ✱, Taste 8).** Entspricht dem Drücken der Taste [Tastatur auswählen](#tastatur-auswählen-taste).

_Diese Taste hat keine Funktion, wenn das Bildschirm-Layout auf „Virtuelle Tastatur“ eingestellt ist, da alle Tasten für alle möglichen Funktionen bereits auf dem Bildschirm verfügbar sind._

## Bildschirmtastatur
Auf Geräten mit ausschließlich Touchscreen steht eine vollständig funktionsfähige Bildschirmtastatur zur Verfügung, die automatisch aktiviert wird. Wird das Gerät nicht als Touchscreen erkannt, kann sie manuell unter Einstellungen → Erscheinungsbild → Bildschirm-Layout durch Auswahl von „Virtuelles Ziffernfeld“ aktiviert werden.

Auf Geräten mit Touchscreen und physischer Tastatur können die Bildschirmtasten deaktiviert werden, um Platz auf dem Bildschirm zu schaffen. Diese Option finden Sie unter Einstellungen → Erscheinungsbild.

Es wird außerdem empfohlen, das spezielle Verhalten zu deaktivieren, bei dem die „Zurück“-Taste der Funktion „Rücktaste“ zugeordnet ist, da dies nur bei Verwendung einer physischen Tastatur sinnvoll ist. Dies wird in der Regel automatisch gehandhabt. Falls nicht, gehen Sie zu Einstellungen → Tastenfeld → Tastenkombinationen auswählen → Rücktaste und wählen Sie die Option „--“.

### Retro- und moderne Bildschirm-Layouts
Es stehen zwei virtuelle Tastenfeld-Layouts zur Verfügung: Retro und Modern.

Das Retro-Layout umfasst ein Steuerkreuz (D-Pad) mit einer zentralen OK-Taste oben sowie darunter angeordneten Zahlentasten und ähnelt stark den Tastaturen früher Mobiltelefone aus den frühen 2000er-Jahren. Es eignet sich für Nutzer, die ein klassisches Bedienerlebnis bevorzugen, für Geräte mit kleineren Bildschirmen sowie für Personen mit größeren Daumen. Es kann auch für Nutzer interessant sein, die mit eingestellten T9-Tastatur-Apps wie Old Keyboard oder Big Old Keyboard vertraut sind.

Das Modern-Layout bewahrt das typische Erscheinungsbild von Android und verwendet gleichzeitig ein 12-Tasten-Tipplayout. Es verfügt über einen zentralen Block von Zahlentasten (0–9) zur Texteingabe, während Funktionstasten wie Umschalt, Rücktaste, Sprachwechsel und OK (Eingabe) in Spalten links und rechts angeordnet sind.

### Übersicht der virtuellen Tasten
Die Bildschirmtastatur funktioniert genauso wie eine physische Telefontastatur. Tasten mit nur einer Funktion zeigen eine zentrale Beschriftung oder ein Symbol an. Tasten mit einer zusätzlichen Langdruck-Funktion zeigen eine sekundäre Beschriftung oder ein Symbol in der oberen rechten Ecke.

#### Tasten 0–9
Die Zahlentasten werden zum Schreiben von Wörtern und zur Eingabe von Ziffern verwendet. Das Retro-Layout ermöglicht zusätzlich Wischgesten nach links und rechts auf bestimmten Tasten. Falls verfügbar, werden diese Funktionen durch Symbole in der unteren linken oder rechten Ecke der Taste angezeigt.

In der Google-Play-Version können die Wischgesten sowohl für das Retro- als auch für das Modern-Layout angepasst oder deaktiviert werden. Dies erfolgt über Einstellungen → Tastenfeld → Tastenfunktionen.

#### Benutzerdefinierte Texttasten („!“ und „?“)
Standardmäßig fügen diese Tasten die entsprechenden Satzzeichen ein. In numerischen oder Telefon-Eingabefeldern können sie alternative Zeichen wie Sternchen, Raute oder Dezimalpunkt einfügen.

In der Google-Play-Version können diese Tasten angepasst werden. Sie können das Standardzeichen ändern und Aktionen für Wischen nach oben, unten, links und rechts zuweisen. Dies wird unter Einstellungen → Tastenfeld → Tastenfunktionen konfiguriert.

#### Eingabemodus-Taste
- **Drücken:** Durchläuft die Eingabemodi (abc → Prädiktiv → 123).
- **Gedrückt halten:** Wechselt die Eingabesprache, wenn mehrere Sprachen in den Einstellungen aktiviert wurden.
- **Horizontal wischen:** Wechselt zur zuletzt verwendeten Tastatur außer TT9.
- **Vertikal wischen:** Öffnet den Android-Dialog „Tastatur wechseln“, in dem alle installierten Tastaturen ausgewählt werden können.

Die Taste zeigt ein kleines Globus-Symbol an, wenn mehrere Sprachen unter Einstellungen → Sprachen aktiviert wurden. Das Symbol weist darauf hin, dass ein Sprachwechsel durch Gedrückthalten der Taste möglich ist.

_Im Retro-Layout befindet sich die Taste unten rechts._

_Im Modern-Layout befindet sich die Taste unten links._

#### Rücktaste
Löscht Zeichen bei Betätigung. Wenn Einstellungen → Tastenfeld → Schnelles Löschen aktiviert ist, können Sie durch Zurückwischen das vorherige Wort löschen.

#### Filtertaste
- **Drücken:** Filtert die Vorschlagsliste. Siehe [oben](#vorschläge-filtern-taste-standard-steuerkreuz-oben) zur Funktionsweise der Wortfilterung.
- **Gedrückt halten:** Löscht den Filter, sofern aktiv.

_Diese Taste ist nur im Modern-Layout verfügbar. Position: zweite Taste von oben._

_Das Filtern ist nur im prädiktiven Modus möglich._

#### Zwischenablage / Spracheingabe-Taste
- **Drücken:** Öffnet Optionen zum Kopieren, Einfügen und Bearbeiten von Text.
- **Gedrückt halten:** Aktiviert die Spracheingabe.

_Diese Taste ist nur im Modern-Layout verfügbar. Position: dritte Taste von oben._

#### OK-Taste
- **Drücken:** Entspricht dem Drücken der ENTER-Taste auf anderen Tastaturen.

Im Retro-Layout können zusätzlich Wischgesten über Einstellungen → Erscheinungsbild → Tasten aktiviert werden.

- **Nach oben wischen ohne Vorschläge:** Cursor nach oben bewegen (entspricht D-PAD nach oben).
- **Nach unten wischen ohne Vorschläge:** Cursor nach unten bewegen (entspricht D-PAD nach unten).
- **Nach oben wischen bei vorhandenen Vorschlägen:** Vorschlagsliste filtern. Siehe [oben](#vorschläge-filtern-taste-standard-steuerkreuz-oben).
- **Nach unten wischen bei vorhandenen Vorschlägen:** Vorschlagsfilter löschen.

### Tastaturfeld beim Tippen anpassen
In manchen Fällen nimmt das virtuelle Tastenfeld möglicherweise zu viel Platz ein, wodurch Sie Ihren Text oder Anwendungsinhalte nicht sehen können. Sie können die Größe anpassen, indem Sie die Einstellungen-/Befehlspalette-Taste gedrückt halten und ziehen oder die Statusleiste ziehen (dort wird die aktuelle Sprache oder der Eingabemodus angezeigt). Wenn die Höhe zu klein wird, wechselt das Layout automatisch zu „Funktionstasten“ oder „nur Vorschlagsliste“. Beim Vergrößern wechselt das Layout wieder zum „Virtuellen Tastenfeld“. Durch Doppeltippen auf die Statusleiste können Sie das Tastenfeld sofort minimieren oder maximieren.

_Das Ändern der Größe per Doppeltippen ist standardmäßig deaktiviert. Sie können es hier aktivieren: Einstellungen → Erscheinungsbild._

_Das Anpassen der Größe von Traditional T9 führt auch zur Anpassung der aktuellen Anwendung. Beide Aktionen zusammen sind rechnerisch sehr aufwendig und können auf vielen Telefonen zu Flackern oder Ruckeln führen, selbst auf leistungsfähigeren Geräten._

### Höhe der Tasten ändern
Sie können auch die Höhe der Bildschirmtasten ändern. Gehen Sie dazu zu Einstellungen → Erscheinungsbild → Bildschirmtastenhöhe und passen Sie die Größe nach Bedarf an.

Die Standardeinstellung von 100 % ist ein guter Kompromiss zwischen Bedienbarkeit und genutztem Bildschirmplatz. Falls Sie große Finger haben, können Sie die Einstellung erhöhen. Bei größeren Bildschirmen, wie etwa auf einem Tablet, können Sie die Höhe reduzieren.

_Wenn der verfügbare Bildschirmplatz begrenzt ist, ignoriert TT9 diese Einstellung und reduziert automatisch seine Höhe, um der aktuellen Anwendung genug Platz zu lassen._

## Zwischenablage-Werkzeuge
Im Zwischenablage-Werkzeugfeld können Sie Text wie auf einer Computertastatur auswählen, ausschneiden, kopieren und einfügen. Um das Werkzeugfeld zu schließen, drücken Sie die „✱“-Taste, die Zurück-Taste (außer in Webbrowsern, Spotify und einigen anderen Apps) oder eine Buchstabentaste auf der Bildschirmtastatur.

Nachfolgend eine Liste der möglichen Textbefehle:
1. Vorheriges Zeichen auswählen (wie Umschalt + Links auf einer Computertastatur)
2. Auswahl aufheben
3. Nächstes Zeichen auswählen (wie Umschalt + Rechts)
4. Vorheriges Wort auswählen (wie Strg + Umschalt + Links)
5. Alles auswählen
6. Nächstes Wort auswählen (wie Strg + Umschalt + Rechts)
7. Ausschneiden
8. Kopieren
9. Einfügen

Für eine einfachere Bearbeitung sind auch Rückschritt-, Leer- und OK-Tasten aktiv.

## Spracheingabe
Die Spracheingabe ermöglicht die Umwandlung von Sprache in Text, ähnlich wie bei Gboard. Wie andere Tastaturen führt Traditional T9 keine eigene Spracherkennung durch, sondern nutzt die Sprachdienste von Android.

_Die Schaltfläche für die Spracheingabe auf dem Bildschirm ist auf Geräten ohne Unterstützung für Spracheingabe ausgeblendet._

### Geräte mit Google-Diensten
Auf Geräten mit Google-Diensten nutzt TT9 die Google-Infrastruktur, um Ihre gesprochenen Worte in Text umzuwandeln. Unter Android 12 oder älter müssen Sie mit einem WLAN-Netzwerk verbunden sein oder mobile Daten aktivieren, damit diese Methode funktioniert. Ab Android 13 kann TT9 die Spracherkennung sowohl online als auch offline durchführen, unter Verwendung der Sprachpakete des Geräts. Für die Offline-Nutzung stellen Sie sicher, dass Sie alle gewünschten Sprachen herunterladen: Android-Einstellungen → System → Spracherkennung auf dem Gerät → Sprache hinzufügen.

_Die für Google Voice, andere Sprachassistenten oder Tastaturen installierten Sprachpakete funktionieren möglicherweise nicht mit Traditional T9. Es wird empfohlen, die globalen Pakete über den Bildschirm „Spracherkennung auf dem Gerät“ zu installieren._

### Geräte ohne Google-Dienste
So verwenden Sie die Google-Spracherkennung auf Geräten ohne Google-Dienste:

1. Installieren Sie die Google-App:
  - **Android Go:** Google Go (_com.<wbr>google.<wbr>android.<wbr>apps.<wbr>searchlite_)
  - **Standard-Android:** Google-App (_com.<wbr>google.<wbr>android.<wbr>googlequicksearchbox_)
2. Erteilen Sie der Google- bzw. Google-Go-App manuell die Berechtigungen für Mikrofon und Internet.
3. Erteilen Sie TT9 die Mikrofonberechtigung.

_Einige Geräte müssen möglicherweise neu gestartet werden, um die Einrichtung abzuschließen, auch wenn kein Neustart angefordert wird._

### Verwendung nicht von Google stammender Spracheingabe
TT9 unterstützt auch nicht von Google stammende Spracheingabemethoden, z. B. Futo Voice oder Sayboard. Wenn mehrere Spracheingabemethoden verfügbar sind, werden Sie von TT9 zur Auswahl aufgefordert. Ist nur eine nicht von Google stammende Methode installiert, wird sie automatisch verwendet.

## Fehlerbehebung
Für verschiedene Anwendungen oder Geräte ist es möglich, spezielle Optionen zu aktivieren, die Traditional T9 besser kompatibel machen. Diese finden Sie am Ende jeder Einstellungsseite unter dem Abschnitt Kompatibilität.

### Alternative Methode zum Scrollen durch Vorschläge
_In: Einstellungen → Erscheinungsbild._

Auf einigen Geräten kann es im prädiktiven Modus vorkommen, dass die Liste nicht bis zum Ende gescrollt werden kann oder mehrmals vor- und zurückgescrollt werden muss, bis der letzte Vorschlag erscheint. Dieses Problem tritt manchmal bei Android 9 oder älter auf. Aktivieren Sie die Option, falls Sie dieses Problem haben.

### Immer im Vordergrund
_In: Einstellungen → Erscheinungsbild._

Auf einigen Telefonen, insbesondere dem Sonim XP3plus (XP3900), wird Traditional T9 möglicherweise nicht angezeigt, wenn Sie zu tippen beginnen, oder es wird teilweise von den Softkeys verdeckt. In anderen Fällen können weiße Balken darum erscheinen. Das Problem kann in einer bestimmten Anwendung oder in allen auftreten. Um dies zu verhindern, aktivieren Sie die Option „Immer im Vordergrund“.

### Unterer Abstand (Hochformat)
_In: Einstellungen → Erscheinungsbild._

Auf Samsung-Geräten mit Android 15 oder höher kann Traditional T9 zu weit unten auf dem Bildschirm angezeigt werden. In diesem Fall überdeckt die System-Navigationsleiste die letzte Tastaturzeile, wodurch die Tasten nicht mehr nutzbar sind. Der Versuch, ein Leerzeichen einzugeben, OK zu drücken oder den Eingabemodus zu ändern, schließt die Tastatur. Durch Erhöhen des „Unteren Abstands“ auf 48 dp wird dieses Problem behoben.

In anderen Fällen kann unterhalb des Tastenblocks ein unnötiger leerer Bereich erscheinen. Durch Reduzieren des „Unteren Abstands“ auf 0 dp wird dieser entfernt.

_Siehe Bug [#950](https://github.com/sspanak/tt9/issues/950) für weitere Informationen._

_In sehr seltenen Fällen können bei Nicht-Samsung-Geräten dieselben Probleme auftreten. Siehe [#755](https://github.com/sspanak/tt9/issues/755)._

### Schutz vor Tastenwiederholung
_In: Einstellungen → Tastenfeld._

Die Telefone CAT S22 Flip und Qin F21 sind für ihre minderwertigen Tastenfelder bekannt, die im Laufe der Zeit schnell abnutzen und bei einem Tastendruck mehrere Klicks registrieren. Dies kann beim Tippen oder Navigieren in den Telefonmenüs auffallen.

Für CAT-Telefone wird eine Einstellung von 50–75 ms empfohlen. Für das Qin F21 versuchen Sie es mit 20–30 ms. Wenn das Problem weiterhin besteht, erhöhen Sie den Wert etwas, aber versuchen Sie, ihn so niedrig wie möglich zu halten.

_**Hinweis:** Je höher der Wert, desto langsamer müssen Sie tippen. TT9 ignoriert sehr schnelle Tastendrücke._

_**Hinweis 2:** Neben dem oben genannten können Qin-Telefone möglicherweise auch lange Tastendrücke nicht erkennen. In diesem Fall lässt sich leider nichts tun._

### Zusammengesetzten Text anzeigen
_In: Einstellungen → Tastenfeld._

Wenn du Probleme hast, in Deezer oder Smouldering Durtles zu tippen, weil die Vorschläge schnell verschwinden, bevor du sie sehen kannst, deaktiviere diese Option. Dadurch bleibt das aktuelle Wort verborgen, bis du OK oder die Leertaste drückst oder auf die Vorschlagsliste tippst.

Das Problem tritt auf, weil Deezer und Smouldering Durtles manchmal den eingegebenen Text ändern, wodurch TT9 nicht richtig funktioniert.

### Telegram/Snapchat Sticker und Emoji-Panels lassen sich nicht öffnen
Dies passiert, wenn Sie eines der kleineren Layouts verwenden. Es gibt derzeit keine dauerhafte Lösung, aber Sie können den folgenden Workaround nutzen:
- Gehen Sie zu Einstellungen → Erscheinungsbild und aktivieren Sie „Bildschirm-Ziffernblock“.
- Gehen Sie zurück zum Chat und klicken Sie auf die Emoji- oder die Sticker-Taste. Sie werden jetzt angezeigt.
- Sie können nun in die Einstellungen zurückkehren und den Bildschirm-Ziffernblock wieder deaktivieren. Die Emoji- und Sticker-Panels bleiben zugänglich, bis Sie die App oder das Telefon neu starten.

### Traditional T9 erscheint nicht sofort in einigen Anwendungen (nur für Telefone ohne Touchscreen)
Wenn Sie eine Anwendung geöffnet haben, in der Sie tippen können, und TT9 nicht automatisch erscheint, beginnen Sie einfach mit dem Tippen, und es wird angezeigt. Alternativ können Sie auch die Hotkeys drücken, um den [Eingabemodus](#nächster-vorschlag-taste-standard-steuerkreuz-rechts) oder die [Sprache](#nächste-sprache-taste-standard-halten) zu wechseln. Dadurch wird TT9 angezeigt, wenn es verborgen ist.

Auf einigen Geräten bleibt TT9 möglicherweise unsichtbar, egal was Sie tun. In solchen Fällen müssen Sie [Immer im Vordergrund](#immer-im-vordergrund) aktivieren.

**Lange Erklärung.** Der Grund für dieses Problem ist, dass Android primär für Touchscreen-Geräte konzipiert ist und erwartet, dass Sie das Text-/Zahlenfeld berühren, um die Tastatur anzuzeigen. Es ist möglich, TT9 ohne diese Bestätigung anzeigen zu lassen, aber dann vergisst Android manchmal, sie zu verbergen, wenn es nötig ist, z.B. nach der Eingabe einer Telefonnummer oder dem Abschicken von Text in einem Suchfeld.

Um sich an den Android-Standard zu halten, liegt die Kontrolle in Ihren Händen. Drücken Sie einfach eine Taste, um den Bildschirm zu „berühren“ und tippen Sie weiter.

### Auf dem Qin F21 Pro erhöht oder verringert das Halten der 2- oder 8-Taste die Lautstärke anstatt eine Zahl zu tippen
Um dieses Problem zu lindern, gehen Sie zu Einstellungen → Erscheinungsbild und aktivieren Sie das „Statussymbol“. TT9 sollte das Qin F21 automatisch erkennen und die Einstellungen aktivieren. Falls die automatische Erkennung fehlschlägt oder Sie das Symbol aus irgendeinem Grund deaktiviert haben, müssen Sie es aktivieren, damit alle Tasten ordnungsgemäß funktionieren.

**Lange Erklärung.** Das Qin F21 Pro (möglicherweise auch F22) hat eine Hotkey-Anwendung, die das Zuweisen der Lautstärkeregelung an Zahlentasten ermöglicht. Standardmäßig ist der Hotkey-Manager aktiviert, und das Halten der 2-Taste erhöht die Lautstärke, das Halten der 8-Taste verringert sie. Wenn jedoch kein Statussymbol vorhanden ist, geht der Manager davon aus, dass keine Tastatur aktiv ist und regelt die Lautstärke, anstatt die Taste für Traditional T9 zu verwenden, um eine Zahl zu tippen. Durch Aktivieren des Symbols wird der Hotkey-Manager umgangen und alles funktioniert ordnungsgemäß.

### Allgemeine Probleme auf Xiaomi-Telefonen
Xiaomi hat mehrere nicht-standardmäßige Berechtigungen eingeführt, die das ordnungsgemäße Funktionieren von Traditional T9s virtueller Bildschirmtastatur verhindern können. Genauer gesagt funktionieren die Tasten „Einstellungen anzeigen“ und „Wort hinzufügen“ möglicherweise nicht wie vorgesehen. Um dies zu beheben, müssen Sie die Berechtigungen „Pop-up-Fenster anzeigen“ und „Pop-up-Fenster im Hintergrund anzeigen“ für TT9 in den Einstellungen Ihres Telefons erteilen. [Dieser Leitfaden](https://parental-control.flashget.com/how-to-enable-display-pop-up-windows-while-running-in-the-background-on-flashget-kids-on-xiaomi) für eine andere Anwendung erklärt, wie Sie dies tun.

Es wird auch dringend empfohlen, die Berechtigung „Dauerhafte Benachrichtigung“ zu erteilen. Dies ähnelt der Benachrichtigungsberechtigung, die in Android 13 eingeführt wurde. Weitere Informationen finden Sie [oben](#hinweise-für-android-13-oder-höher).

_Die Xiaomi-Probleme wurden in [diesem GitHub-Problem](https://github.com/sspanak/tt9/issues/490) besprochen._

### Spracheingabe dauert sehr lange, um zu stoppen
Es ist [ein bekanntes Problem](https://issuetracker.google.com/issues/158198432) unter Android 10, das Google nie behoben hat. Es ist auf der TT9-Seite nicht möglich, das zu lindern. Um den Sprachbefehl zu beenden, bleiben Sie ein paar Sekunden lang ruhig. Android schaltet das Mikrofon automatisch aus, wenn keine Sprache erkannt wird.

### Meine Banking-App akzeptiert Traditional T9 nicht
Dies stellt kein Problem von TT9 dar. Banken beschränken häufig nicht standardisierte oder quelloffene Tastaturen, weil sie keinerlei Risiko eingehen und automatisch von mangelnder Sicherheit ausgehen. Manche Anbieter gehen noch weiter und stellen eigene Tastaturen bereit, wobei sogar Googles Standardtastatur Gboard blockiert wird. In diesem Fall bleibt Ihnen leider nur die Möglichkeit, auf die ursprüngliche Geräteeingabetastatur zurückzugreifen.

### Vibration funktioniert nicht (nur Touchscreen-Geräte)
Energiespar- und Optimierungsoptionen sowie die "Nicht stören"-Funktion verhindern Vibrationen. Überprüfen Sie in den Systemeinstellungen Ihres Geräts, ob eine dieser Optionen aktiviert ist. Auf einigen Geräten ist es möglich, die Batterieoptimierung individuell für jede Anwendung in den Systemeinstellungen → Anwendungen zu konfigurieren. Falls Ihr Gerät dies erlaubt, deaktivieren Sie die Optimierung für TT9.

Ein weiterer Grund, warum die Vibration nicht funktioniert, könnte sein, dass sie auf Systemebene deaktiviert ist. Prüfen Sie, ob Ihr Gerät die Optionen "Vibration bei Berührung" oder "Vibration bei Tastendruck" in den Systemeinstellungen → Bedienungshilfen bietet, und aktivieren Sie sie. Xiaomi- und OnePlus-Geräte ermöglichen eine noch detailliertere Vibrationssteuerung. Stellen Sie sicher, dass alle relevanten Einstellungen aktiviert sind.

Letztendlich funktioniert die Vibration auf einigen Geräten nicht zuverlässig. Um dies zu beheben, wären zusätzliche Berechtigungen und der Zugriff auf mehr Gerätefunktionen erforderlich. Da TT9 jedoch eine datenschutzfreundliche Tastatur ist, wird ein solcher Zugriff nicht angefordert.

## Häufig gestellte Fragen

### Warum fügen Sie Sprache X nicht hinzu?
Ich würde das gerne tun, aber ich brauche deine Hilfe. Mehr als 40 Sprachen alleine zu unterstützen ist unmöglich. Da ich deine Sprache nicht spreche, ist es schwierig, zuverlässige Ressourcen im Internet zu finden. Hier können Muttersprachler wie du wirklich helfen.
Tatsächlich wurden über 90 % der vorhandenen Sprachen von oder mit der Hilfe engagierter Nutzer hinzugefügt.

Um eine neue Sprache hinzuzufügen, brauche ich eine Rechtschreib-geprüfte Wortliste, vorzugsweise aus einer offiziellen oder akademischen Quelle (zum Beispiel „Großes Wörterbuch der Sprache X“). Solche Listen liefern die besten Wortvorschläge beim Tippen.

Wenn es kein solches Wörterbuch gibt, kannst du auch eine frei herunterladbare Wortliste bereitstellen. Ideal sind 300.000–500.000 Wörter. Wenn deine Sprache viele Beugungen hat (z. B. Änderungen durch Zeit, Geschlecht oder Zahl), werden etwa 1 Million Wörter benötigt.

### In der Sprache XYZ gibt es falsch geschriebene oder fehlende Wörter. Warum werden diese nicht korrigiert?
Wie oben erwähnt: Ich spreche deine Sprache nicht und bemerke solche Fehler möglicherweise gar nicht. Aber mit deiner Hilfe können wir sie beheben und das Wörterbuch für alle verbessern.

### Können Sie Funktion X nicht hinzufügen?
Nein.

Jeder hat seine eigenen Vorlieben. Manche möchten größere Tasten, manche eine andere Anordnung, manche eine Schnellzugriffstaste für ".com", und manche vermissen ihr altes Telefon oder ihre alte Tastatur. Aber bitte versteht, dass ich dies in meiner Freizeit freiwillig mache. Es ist unmöglich, Tausende von unterschiedlichen Wünschen zu erfüllen, von denen einige sich sogar widersprechen.

Henry Ford sagte einmal: „Es kann jede Farbe haben, die der Kunde will, solange sie schwarz ist.“ Ebenso ist Traditional T9 schlicht, effektiv und kostenlos – aber du bekommst, was du bekommst.

### Können Sie die App nicht meinem bevorzugten Gerät (z. B. Sony Ericsson, Xperia, Nokia C2, Samsung) oder meiner bevorzugten Tastatur-App ähnlicher gestalten?
Nein.

Traditional T9 ist nicht als Ersatz oder Klon-App gedacht. Es hat sein eigenes einzigartiges Design, das hauptsächlich von den Nokia 3310 und 6303i inspiriert wurde. Während es das Gefühl der Klassiker einfängt, bietet es eine eigene Erfahrung, die kein Gerät exakt nachahmen wird.

### Sie sollten TouchPal kopieren; es war die beste Tastatur!
Nein. Siehe die vorherigen Punkte.

TouchPal war eine schnelle und reaktionsschnelle Tastatur mit umfangreichen Design-, Anpassungs- und Mehrsprachenfunktionen. Sie war um das Jahr 2015 beliebt, als der Wettbewerb noch begrenzt war. Allerdings war sie nie eine echte T9-Tastatur: Das 12-Tasten-Layout war nur für einige Sprachen verfügbar und ausschließlich für Touchscreens konzipiert.

Im Laufe der Zeit verlagerte sich der Fokus weg vom Wesentlichen – dem Tippen. Werbung wurde eingeführt, Berechtigungen wurden zunehmend aggressiv angefordert, und es begann die Erfassung sensibler Nutzerdaten. Schließlich wurde TouchPal aus dem Play Store entfernt.

Im Gegensatz dazu basiert die [Philosophie](https://github.com/sspanak/tt9/?tab=readme-ov-file#-philosophy) von TT9 auf Open-Source-Prinzipien. Der Quellcode und die Wörterbücher sind öffentlich zugänglich und überprüfbar. Der Schutz der Privatsphäre der Nutzer ist von Anfang an berücksichtigt. Beiträge aus der Community haben zur Verbesserung des Projekts beigetragen, darunter Fehlerbehebungen, neue Sprachen und Übersetzungen. Nutzer können zudem eigene modifizierte Versionen erstellen.

TT9 bietet keine anpassbaren Tastenformen, sondern ein klares und gut lesbares Layout mit Fokus auf effizientes Tippen. Es ahmt den visuellen Stil von TouchPal nicht nach, funktioniert jedoch auf modernen Android-16-Smartphones, auf nostalgisch inspirierten Geräten mit physischen Tastaturen wie dem Qin F21, Cat S22 Flip, Sonim XP3800 sowie sogar auf TV-Fernbedienungen.

Wenn Sie anderer Meinung sind oder Ihren Standpunkt erläutern möchten, beteiligen Sie sich an der [offenen Diskussion](https://github.com/sspanak/tt9/issues/647) auf GitHub. Bitte bleiben Sie dabei respektvoll. Hassbeiträge werden nicht toleriert.

### Android hat mich darauf hingewiesen, dass die Tastatur möglicherweise meine personenbezogenen Daten sammelt, einschließlich Kreditkartennummern und Passwörtern
Dies ist ein standardmäßiger Android-Hinweis, der angezeigt wird, wenn Sie eine beliebige Tastatur installieren und aktivieren, nicht nur Traditional T9. Sie können sicher sein, dass sämtliche Eingaben auf Ihrem Gerät verbleiben. Die Eingabetechnologie ist vollständig quelloffen; Sie können den Code auf GitHub einsehen und sich vergewissern, dass Ihre Privatsphäre geschützt ist.

_Sollten dennoch Bedenken bestehen, konsultieren Sie bitte die Datenschutzrichtlinie der App._

### Ich muss ein QWERTY-Layout verwenden (nur Touchscreen-Geräte)
Traditional T9 ist eine T9-Tastatur und bietet daher kein QWERTY-Layout.

Falls Sie noch lernen, T9 zu verwenden, und gelegentlich zurückwechseln müssen, oder es Ihnen praktischer erscheint, neue Wörter über QWERTY einzugeben, wischen Sie die Eingabemodus-Taste nach oben, um zu einer anderen Tastatur zu wechseln. Weitere Informationen finden Sie in der [Übersicht über die virtuellen Tasten](#übersicht-der-virtuellen-tasten). Denken Sie daran, den anderen gegenüber respektvoll zu sein. Hassbeiträge werden nicht toleriert.

Die meisten anderen Tastaturen erlauben das Zurückwechseln zu Traditional T9, indem Sie die Leertaste oder die „Sprache wechseln“-Taste gedrückt halten. Sehen Sie im jeweiligen Handbuch nach.

### Ich kann die Sprache auf einem Touchscreen-Telefon nicht ändern
Stellen Sie zuerst sicher, dass Sie alle gewünschten Sprachen unter Einstellungen → Sprachen aktiviert haben. Halten Sie dann die [Eingabemodus-Taste](#eingabemodus-taste), um die Sprache zu ändern.

### Wie man Kontraktionen sowie Wörter mit Apostrophen oder Bindestrichen eingibt?
Drücken Sie **1** an der Stelle, an der der Apostroph oder der Bindestrich erscheinen soll. Auch wenn mehrere Satzzeichen vorgeschlagen werden, müssen Sie keines manuell auswählen. Das passendste wird automatisch eingefügt, sobald Sie den nächsten Buchstaben oder ein Leerzeichen eingeben.

Nachfolgend finden Sie praktische Beispiele.

#### Englisch
Kontraktionen sind als separate „Wörter“ verfügbar, sodass Sie sie frei mit anderen Wörtern kombinieren können.

- **Apostrophe:** I'll → 4155, wobei: 4 (I) + 155 ('ll)
- **Bindestriche:** check-in → 24325146, wobei: 24325 (check) + 146 (-in)
- **Mehrere Apostrophe:** rock'n'roll → 7625 (rock) + 161 ('n') + 7655 (roll)
- **Negativformen (immer vollständige Wörter):**
  - can't → 22618
  - don't → 46618
  - usw.

#### Niederländisch
Alle niederländischen Kontraktionen sind ebenfalls als separate Einheiten verfügbar und können mit anderen Wörtern kombiniert werden. Hier können Satzzeichen am Anfang, am Ende oder an beiden Stellen erscheinen.

- ’s-Hertogenbosch → 171 ('s-) + 4372643626724 (Hertogenbosch)

#### Andere Sprachen mit lateinischem Alphabet
Ähnlich wie oben können Sie Kontraktionen und komplexe Ausdrücke in Französisch, Italienisch und anderen Sprachen mit lateinischem Alphabet eingeben.

- **Italienisch:** dov'è → 3681 (dov') + 3 (è)
- **Französisch, Apostrophe:** j'ai → 51 (j') + 24 (ai)
- **Französisch, komplexer Ausdruck:** qu'est-ce que c'est → 781 (qu') + 378123 (est-ce) + 783 (que) + 21378 (c'est)
- **Türkisch:** Antalya'da → 2682592 (Antalya) + 132 ('da)

#### Vollständige Wörter (Ukrainisch und Hebräisch)
Im Ukrainischen und Hebräischen sind Apostrophe immer Teil des Wortes.

- **Ukrainisch:** пам'ять → 525196
- **Hebräisch:** צ'ארלס → 813759

#### Websites
Die gängigsten Domain-Endungen sind in Sprachen mit lateinischem Alphabet als separate „Wörter“ verfügbar, sodass Sie Webadressen schnell und einfach eingeben können.

- google.com → 466453 (google) + 1266 (.com)