# Traditional T9
Цей посібник пояснює, як налаштувати та використовувати Traditional T9 у різних ситуаціях. Для інструкцій з встановлення та інформації про версії "lite" і "full" зверніться до [Інструкції з встановлення](https://github.com/sspanak/tt9/blob/master/docs/installation.md) на GitHub. Також рекомендуємо ознайомитися з [головною сторінкою репозиторію](https://github.com/sspanak/tt9), де розміщено весь вихідний код, посібник для розробників, політику конфіденційності та додаткову документацію.

## Початкове налаштування
Після встановлення спочатку потрібно увімкнути Traditional T9 як клавіатуру Android. Для цього натисніть на іконку запуску. Якщо потрібно виконати будь-яку дію, всі інші параметри, окрім Початкового налаштування, будуть відключені, і з’явиться напис: "TT9 вимкнено". Перейдіть до Початкового налаштування і увімкніть його.

_Якщо ви не бачите іконку відразу після встановлення, перезавантажте телефон, і вона має з’явитися. Це може статися через те, що Android намагається заощадити заряд батареї, не оновлюючи список щойно встановлених додатків._

### Використання на телефоні з сенсорним екраном
На пристроях із сенсорним екраном також наполегливо рекомендується вимкнути системну перевірку правопису. Коли вона увімкнена, деякі або всі введені слова підкреслюються червоним кольором.

Ще одна проблема полягає в тому, що перевірка правопису може показувати заплутане спливаюче вікно «Додати слово». Це вікно додає нові слова до стандартної системної клавіатури (зазвичай Gboard), а не до словника Traditional T9.

Щоб уникнути таких ситуацій, системну перевірку правопису необхідно вимкнути.

Якщо цей крок потрібно виконати, пункт «Системна перевірка правопису» на екрані початкового налаштування буде активним. Натисніть його, щоб вимкнути системний компонент. Якщо пункт вимкнений, жодних дій не потрібно.

Після завершення початкового налаштування ознайомтеся з розділом [Екранна клавіатура](#екранна-клавіатура), щоб дізнатися більше порад і рекомендацій.

### Увімкнення Режиму прогнозування
Режим прогнозування потребує завантаження мовного словника для пропонування слів. Ви можете налаштувати мови та завантажити їх словники в Налаштуваннях → [Мови](#мовні-налаштування). Якщо ви забудете завантажити якийсь словник, Traditional T9 зробить це автоматично під час введення. Додаткову інформацію дивіться [нижче](#мовні-налаштування).

#### Примітки для телефонів нижнього класу
Завантаження словника може перевантажити телефони нижнього класу. Під час використання версії TT9 "lite" це призведе до скасування операції Android. Якщо завантаження займає більше 30 секунд, підключіть зарядний пристрій або забезпечте, щоб екран залишався ввімкненим під час завантаження.

Цього можна уникнути, використовуючи версію "full".

#### Примітки для Android 13 або новішої версії
За замовчуванням сповіщення для нових додатків вимкнені. Рекомендується увімкнути їх, щоб отримувати повідомлення про оновлення словників, і коли ви оберете їх встановлення, TT9 покаже процес завантаження. Нові оновлення виходять максимум раз на місяць, тож не варто хвилюватися про надмірні сповіщення.

Ви можете увімкнути сповіщення, перейшовши до Налаштування → Мови та вмикнувши Сповіщення словника.

_Якщо ви вирішите залишити їх вимкненими, TT9 продовжить працювати без проблем, але словниками доведеться керувати вручну._

## Налаштування
На екрані налаштувань можна вибрати мови для введення, налаштувати гарячі клавіші клавіатури, змінити зовнішній вигляд застосунку або покращити сумісність із телефоном.

### Як відкрити налаштування?

#### Спосіб 1
Натисніть на значок запуску Traditional T9.

#### Спосіб 2 (за допомогою сенсорного екрана)
- Натисніть на текстове або числове поле, щоб увімкнути TT9.
- Використовуйте кнопку з зображенням шестерні на екрані.

#### Спосіб 3 (за допомогою апаратної клавіатури)
- Почніть вводити в текстовому або числовому полі, щоб увімкнути TT9.
- Відкрийте список команд за допомогою кнопки інструментів на екрані або натиснувши призначену гарячу клавішу [За замовчуванням: утримання ✱].
- Натисніть клавішу 2.

### Навігація в Налаштуваннях
Якщо ваш пристрій має апаратну клавіатуру, є два способи навігації в налаштуваннях.

1. Використовуйте клавіші Вгору/Вниз для прокручування та ОК для відкриття або активації параметра.
2. Натискайте клавіші 1-9 для вибору відповідного параметра, а для відкриття/активації двічі натискайте на них. Двічі натиснути можна незалежно від того, де ви перебуваєте на екрані. Наприклад, навіть якщо ви на початку, подвійне натискання клавіші 3 активує третій параметр. Нарешті, клавіша 0 є зручним ярликом для прокрутки до кінця, але не відкриває останній параметр.

### Мовні налаштування

#### Завантаження словника
Після ввімкнення однієї або декількох нових мов необхідно завантажити відповідні словники для Прогнозуючого режиму. Після завантаження словник залишатиметься там, доки ви не скористаєтеся одним із параметрів "видалити". Це означає, що можна вмикати та вимикати мови без необхідності перезавантаження їхніх словників щоразу. Завантажте лише один раз, лише вперше.

Це також означає, що якщо вам потрібно почати використовувати мову X, можна безпечно вимкнути всі інші мови, завантажити лише словник X (і заощадити час!), а потім знову ввімкнути всі мови, які ви використовували раніше.

Майте на увазі, що перезавантаження словника скидає популярність пропозицій до заводських налаштувань. Однак не варто хвилюватися, зазвичай це майже не вплине на порядок пропозицій, якщо ви не використовуєте часто незвичайні слова.

#### Автоматичне завантаження словника

Якщо ви пропустили або забули завантажити словник у Налаштуваннях, це відбудеться автоматично, коли ви перейдете в додаток, де можна вводити текст, і увімкнете Прогнозуючий режим. Вас буде попереджено про необхідність зачекати до завершення, після чого можна розпочинати введення.

Якщо ви видалите один або кілька словників, вони НЕ завантажаться автоматично. Потрібно зробити це вручну. Автоматично завантажаться лише словники для нововвімкнених мов.

#### Видалення словника
Якщо ви припинили використовувати мови X або Y, можна їх вимкнути, а також скористатися параметром "Видалити невибране", щоб звільнити місце.

Щоб видалити все незалежно від вибору, використовуйте параметр "Видалити все".

У всіх випадках ваші додані слова будуть збережені й відновлені, щойно ви перезавантажите відповідний словник.

#### Додані слова
Опція «Експорт» дозволяє створити файл CSV з усіма доданими словами для всіх мов. Потім цей CSV-файл можна використати для покращення Traditional T9! Перейдіть на GitHub і поділіться словами в [новому запиті](https://github.com/sspanak/tt9/issues) або [pull request](https://github.com/sspanak/tt9/pulls). Після перевірки та затвердження слова буде включено до наступної версії.

З опцією "Імпорт" можна імпортувати раніше експортований CSV-файл. Однак існують певні обмеження:
- Можна імпортувати лише слова, що складаються з літер. Апострофи, тире, інші знаки пунктуації або спеціальні символи заборонені.
- Емодзі не дозволені.
- Один CSV-файл може містити максимум 250 слів.
- Можна імпортувати до 1000 слів, тобто максимум 4 файли по 250 слів. Понад цю межу ви все ще можете додавати слова під час введення.

Використовуючи "Видалити", можна знайти та видалити неправильно написані слова або ті, які ви не хочете бачити у словнику.

## Апаратні гарячі клавіші

Всі гарячі клавіші можна переналаштувати або відключити в Налаштуваннях → Клавіатура → Вибір гарячих клавіш.

### Клавіші введення

#### Клавіша попередньої пропозиції (за замовчуванням: D-pad Left):
Вибрати попереднє слово/букву в пропозиції.

#### Клавіша наступної пропозиції (за замовчуванням: D-pad Right):
Вибрати наступне слово/букву в пропозиції.

#### Клавіша фільтрації пропозицій (за замовчуванням: D-pad Up):
_Тільки в режимі прогнозування._

- **Одинарне натискання**: Відфільтрувати список пропозицій, залишивши лише ті, що починаються з поточного слова. Не важливо, чи є це повним словом чи ні. Наприклад, введіть "remin" і натисніть Фільтр. Це залишить всі слова, що починаються з "remin": "remin", "remind", "reminds", "reminded", "reminding" тощо.
- **Подвійне натискання**: Розширити фільтр до повної пропозиції. Наприклад, введіть "remin" і натисніть Фільтр двічі. Спочатку відфільтрується за "remin", а потім фільтр розшириться до "remind". Ви можете продовжувати розширювати фільтр до найдовшого слова у словнику.

Фільтрація також корисна для введення невідомих слів. Наприклад, щоб ввести "Anakin", якого немає у словнику, почніть з "A", потім натисніть Фільтр, щоб приховати "B" та "C". Далі натисніть клавішу 6. Оскільки фільтр увімкнено, крім справжніх слів, буде доступно всі можливі комбінації для 1+6: "A..." + "m", "n", "o". Виберіть "n" і натисніть Фільтр, щоб підтвердити свій вибір і отримати "An". Тепер натискання клавіші 2 надасть "An..." + "a", "b" і "c". Оберіть "a" і продовжуйте, поки не отримаєте "Anakin".

Коли фільтрація увімкнена, основний текст стане жирним та курсивним.

#### Клавіша скидання фільтру (за замовчуванням: D-pad Down):
_Тільки в режимі прогнозування._

Скинути фільтр пропозицій, якщо він застосований.

#### D-pad Center (OK або ENTER):
- Коли пропозиції відображаються, вводить поточну пропозицію.
- В іншому випадку виконує дію за замовчуванням для поточного застосунку (наприклад, надсилає повідомлення, переходить на URL або просто додає новий рядок).

_**Примітка:** Кожен застосунок самостійно вирішує, що робити при натисканні OK, і TT9 не має контролю над цим._

_**Примітка 2:** Для відправлення повідомлень через OK у месенджерах потрібно увімкнути їхнє налаштування "Відправка за ENTER" або подібне. Якщо такого налаштування немає, додаток, ймовірно, не підтримує відправлення таким способом. У цьому випадку використовуйте застосунок KeyMapper з [Play Store](https://play.google.com/store/apps/details?id=io.github.sds100.keymapper) або з [F-droid](https://f-droid.org/packages/io.github.sds100.keymapper/). Він може виявляти чати та імітувати натискання на кнопку надсилання повідомлення після натискання або утримання апаратної клавіші. Ознайомтеся з [посібником швидкого запуску](https://docs.keymapper.club/quick-start/) для отримання додаткової інформації._

#### Клавіша 0:
- **У режимі 123:**
  - **Натискання:** вводить "0".
  - **Утримування:** вводить спеціальні/математичні символи.
- **У режимі ABC:**
  - **Натискання:** вводить пробіл, новий рядок або спеціальні/математичні символи.
  - **Утримування:** вводить "0".
- **У режимі Прогнозування:**
  - **Натискання:** вводить пробіл, новий рядок або спеціальні/математичні символи.
  - **Подвійне натискання:** вводить символ, призначений у налаштуваннях режиму Прогнозування (за замовчуванням ".").
  - **Утримування:** вводить "0".
- **У режимі Чонджиін (Корейська):**
  - **Натискання:** вводить "ㅇ" та "ㅁ".
  - **Утримування:** вводить пробіл, новий рядок, "0" або спеціальні/математичні символи.

#### Клавіша 1:
- **У режимі 123:**
  - **Натискання:** вводить "1".
  - **Утримування:** вводить знаки пунктуації.
- **У режимі ABC:**
  - **Натискання:** вводить знаки пунктуації.
  - **Утримування:** вводить "1".
- **У режимі Прогнозування:**
  - **Натискання:** вводить знаки пунктуації.
  - **Кілька натискань:** вводить емодзі.
  - **Утримування:** вводить "1".
- **У режимі Чонджиін (Корейська):**
  - **Натискання:** вводить голосну "ㅣ".
  - **Утримування:** вводить знаки пунктуації.
  - **Утримування, потім натискань:** вводить емодзі.

#### Клавіші 2 до 9:
- **У режимі 123:** вводить відповідне число.
- **У режимах ABC та Прогнозування:** вводить букву або утримує для введення відповідного числа.

### Функціональні клавіші

#### Клавіша Додати слово:
Додає нове слово до словника для поточної мови.

#### Клавіша Видалити (Назад, Del або Backspace):
Просто видаляє текст.

Якщо на вашому телефоні є спеціальна клавіша "Del" або "Очистити", нічого додатково налаштовувати в Налаштуваннях не потрібно, якщо тільки ви не хочете мати додаткову клавішу Backspace. У цьому випадку автоматично буде обрана порожня опція: "--".

На телефонах із поєднаною функцією "Видалити"/"Назад", ця клавіша вибирається автоматично. Однак ви можете призначити функцію "Backspace" іншій клавіші, тож "Назад" буде тільки повертати назад.

_**Примітка:** Використання "Назад" як backspace не працює у всіх додатках, особливо Firefox, Spotify і Termux. Вони можуть повністю контролювати клавішу та змінювати її функцію, тобто вона виконує задумане розробниками. На жаль, нічого не можна зробити, оскільки "Назад" має особливу роль в Android і його використання обмежене системою._

_**Примітка 2:** Утримання клавіші "Назад" завжди запускає стандартну дію системи (тобто показує список запущених додатків)._

_У таких випадках можна призначити іншу клавішу (всі інші клавіші повністю доступні) або використовувати екранну клавішу видалення._

#### Клавіша Наступний режим введення (за замовчуванням: натискання #):
Перемикає режими введення (АБВ → Прогнозування → 123).

_Режим прогнозування недоступний у полях паролів._

_У полях, де дозволено лише числа, зміна режиму неможлива. У таких випадках клавіша повертається до своєї основної функції (тобто вводить "#")._

#### Клавіша Інструменти буфера обміну:
Відображає панель інструментів буфера обміну, яка дозволяє вибирати, вирізати, копіювати та вставляти текст. Панель можна закрити, повторно натиснувши клавішу "✱" або, у більшості додатків, клавішу «Назад». Докладніше див. [нижче](#інструменти-буфера-обміну).

#### Клавіша Наступна мова (за замовчуванням: утримання #):
Змінити мову введення, якщо в налаштуваннях увімкнено кілька мов.

#### Клавіша Вибрати клавіатуру:
Відкриває діалог Змінити клавіатуру Android, де можна вибрати одну з усіх встановлених клавіатур.

#### Клавіша Shift (за замовчуванням: натискання ✱):
- **Під час введення тексту:** перемикає між великими та малими буквами.
- **Під час введення спеціальних символів за допомогою клавіші 0**: відображає наступну групу символів.

#### Клавіша Відкрити налаштування:
Відкриває екран налаштувань. Тут можна вибрати мови для введення, налаштувати гарячі клавіші клавіатури, змінити вигляд застосунку або покращити сумісність із телефоном.

#### Клавіша Скасування:
Скасовує останню дію. Аналогічно натисканню Ctrl+Z на комп’ютері або Cmd+Z на Mac.

_Історію скасування дій керують самі додатки, а не Traditional T9. Це означає, що скасування може бути недоступним у деяких додатках._

#### Клавіша Повтору:
Повторює останню скасовану дію. Аналогічно натисканню Ctrl+Y або Ctrl+Shift+Z на комп’ютері або Cmd+Y на Mac.

_Як і скасування, команда повтору може бути недоступною в деяких додатках._

#### Клавіша Голосове введення:
Активує голосове введення на телефонах, які це підтримують. Дивіться [нижче](#голосове-введення) для отримання додаткової інформації.

#### Клавіша Список команд / Палета команд / (за замовчуванням: утримання ✱):
Відображає список усіх команд (або функцій).

Багато телефонів мають лише дві або три "вільні" кнопки, які можна використовувати як гарячі клавіші. Однак у Traditional T9 набагато більше функцій, тому просто не вистачає місця для всіх них на клавіатурі. Палета команд вирішує цю проблему, дозволяючи викликати додаткові функції (або команди) за допомогою комбінацій клавіш.

Нижче наведено список можливих команд:
- **Відкрити екран налаштувань (комбінація за замовчуванням: утримання ✱, клавіша 1).** Те ж саме, що натискання [Відкрити налаштування](#клавіша-відкрити-налаштування).
- **Додати слово (комбінація за замовчуванням: утримання ✱, клавіша 2).** Те ж саме, що натискання [Додати слово](#клавіша-додати-слово).
- **Голосове введення (комбінація за замовчуванням: утримання ✱, клавіша 3).** Те ж саме, що натискання [Голосове введення](#клавіша-голосове-введення).
- **Скасувати (комбінація за замовчуванням: утримання ✱, клавіша 4).** Те ж саме, що натискання [Клавіша Скасування](#клавіша-скасування).
- **Інструменти буфера обміну (комбінація за замовчуванням: утримання ✱, клавіша 5).** Те ж саме, що натискання [Інструменти буфера обміну](#клавіша-інструменти-буфера-обміну).
- **Повторити (комбінація за замовчуванням: утримання ✱, клавіша 6).** Те ж саме, що натискання [Клавіша Повтору](#клавіша-повтору).
- **Вибір іншої клавіатури (комбінація за замовчуванням: утримання ✱, клавіша 8).** Те ж саме, що натискання [Вибрати клавіатуру](#клавіша-вибрати-клавіатуру).

_Ця клавіша не працює, коли Розкладка екрана встановлена на "Віртуальна клавіатура", оскільки всі клавіші для всіх можливих функцій вже доступні на екрані._

## Екранна клавіатура
На пристроях лише з сенсорним екраном доступна повнофункціональна екранна клавіатура, яка вмикається автоматично. Якщо пристрій не визначається як такий, що має сенсорний екран, увімкніть її вручну в розділі Налаштування → Зовнішній вигляд → Екранний макет, вибравши «Віртуальна цифрова клавіатура».

На пристроях із сенсорним екраном і апаратною клавіатурою екранні клавіші можна вимкнути, щоб звільнити місце на екрані. Ця опція доступна в розділі Налаштування → Зовнішній вигляд.

Також рекомендується вимкнути спеціальну поведінку, за якої клавіша «Назад» відповідає «Backspace», оскільки це корисно лише під час використання апаратної клавіатури. Зазвичай це виконується автоматично. Якщо ні, перейдіть до Налаштування → Клавіатура → Вибір гарячих клавіш → Клавіша Backspace та виберіть варіант «--».

### Ретро та сучасні екранні макети
Доступні два макети віртуальної клавіатури: ретро та сучасний.

Ретро-макет містить D-pad з центральною клавішею OK у верхній частині та цифрові клавіші нижче, що нагадує клавіатури телефонів початку 2000-х років. Він підходить для користувачів, які шукають традиційний досвід, для пристроїв з меншими екранами та для людей з більшими великими пальцями. Також він може сподобатися тим, хто знайомий зі старими, вже припиненими T9-клавіатурами, такими як Old Keyboard або Big Old Keyboard.

Сучасний макет зберігає стандартний вигляд і поведінку Android, використовуючи 12-клавішний формат введення. Він має центральний блок цифрових клавіш (0–9) для введення тексту, а функціональні клавіші, такі як Shift, Backspace, перемикання мови та OK (Enter), розміщені у стовпцях ліворуч і праворуч.

### Огляд віртуальних клавіш
Екранна клавіатура працює так само, як апаратна телефонна клавіатура. Клавіші з однією функцією відображають центральний напис або піктограму. Клавіші з додатковою функцією при довгому натисканні мають вторинний напис або піктограму у правому верхньому куті.

#### Клавіші 0–9
Цифрові клавіші використовуються для набору слів і введення цифр. У ретро-макеті на деяких клавішах також доступні жести проведення вліво та вправо. За наявності ці функції позначаються піктограмами в нижньому лівому або правому куті клавіші.

У версії Google Play жести проведення можна налаштовувати або вимикати як для ретро-, так і для сучасного макета. Це можна зробити в розділі Налаштування → Клавіатура → Функції клавіш.

#### Клавіші користувацького тексту («!» і «?»)
За замовчуванням ці клавіші вставляють відповідні знаки пунктуації. У числових або телефонних полях введення вони можуть вставляти альтернативні символи, такі як зірочка, решітка або десяткова крапка.

У версії Google Play ці клавіші можна налаштовувати. Ви можете змінити символ за замовчуванням і призначити дії для проведення вгору, вниз, вліво та вправо. Це налаштовується в розділі Налаштування → Клавіатура → Функції клавіш.

#### Клавіша режиму введення
- **Натискання:** Перемикання режимів введення (abc → прогнозний → 123).
- **Утримання:** Зміна мови введення, якщо в налаштуваннях увімкнено кілька мов.
- **Горизонтальне проведення:** Перемикання на останню використану клавіатуру, окрім TT9.
- **Вертикальне проведення:** Відкриття діалогу Android «Змінити клавіатуру», де можна вибрати будь-яку встановлену клавіатуру.

Клавіша відображає невеликий значок глобуса, якщо в розділі Налаштування → Мови увімкнено кілька мов. Значок означає, що мову можна змінити, утримуючи клавішу.

_У ретро-макеті це нижня права клавіша._

_У сучасному макеті це нижня ліва клавіша._

#### Backspace
Видаляє символи при натисканні. Якщо ввімкнено Налаштування → Клавіатура → Швидке видалення, можна провести назад, щоб видалити попереднє слово.

#### Клавіша фільтра
- **Натискання:** Фільтрація списку підказок. Див. [вище](#клавіша-фільтрації-пропозицій-за-замовчуванням-d-pad-up), як працює фільтрація слів.
- **Утримання:** Очищення фільтра, якщо він активний.

_Клавіша доступна лише в сучасному макеті. Розташування: друга клавіша зверху._

_Фільтрація можлива лише в прогнозному режимі._

#### Інструменти буфера обміну / Клавіша голосового введення
- **Натискання:** Відкриття параметрів копіювання, вставлення та редагування тексту.
- **Утримання:** Активація голосового введення.

_Клавіша доступна лише в сучасному макеті. Розташування: третя клавіша зверху._

#### Клавіша OK
- **Натискання:** Аналогічно натисканню клавіші ENTER на інших клавіатурах.

У ретро-макеті також можна увімкнути жести проведення в розділі Налаштування → Зовнішній вигляд → Клавіші.

- **Проведення вгору без підказок:** Переміщення курсора вгору (як D-PAD вгору).
- **Проведення вниз без підказок:** Переміщення курсора вниз (як D-PAD вниз).
- **Проведення вгору з підказками:** Фільтрація списку підказок. Див. [вище](#клавіша-фільтрації-пропозицій-за-замовчуванням-d-pad-up).
- **Проведення вниз з підказками:** Очищення фільтра підказок.

### Зміна розміру панелі клавіатури під час введення
Іноді екранна клавіатура може займати забагато місця, через що не видно, що ви вводите або елементи додатка. Якщо це так, можна змінити розмір, утримуючи та перетягуючи клавішу Налаштування/Палети команд або переміщуючи Рядок стану (де відображається поточна мова або режим введення). Коли висота стає занадто малою, розкладка автоматично змінюється на "Функціональні клавіші" або "Тільки список пропозицій". Відповідно, при збільшенні розміру розкладка змінюється на "Віртуальна клавіатура". Також можна двічі натиснути на рядок стану для миттєвого згортання чи розгортання.

_Зміна розміру подвійним торканням вимкнена за замовчуванням. Ви можете увімкнути її тут: Налаштування → Зовнішній вигляд._

_Зміна розміру Traditional T9 також змінює розмір поточного додатка. Це є обчислювально важким процесом, тому може викликати мерехтіння або пригальмовування на багатьох телефонах, навіть на потужніших._

### Зміна висоти клавіш
Можна також змінити висоту клавіш на екрані. Для цього перейдіть у Налаштування → Зовнішній вигляд → Висота клавіш на екрані та налаштуйте її за бажанням.

Значення за замовчуванням 100% забезпечує гарний баланс між розміром кнопок і зайнятим простором на екрані. Однак, якщо у вас великі пальці, можливо, ви захочете трохи збільшити значення, а якщо використовуєте TT9 на більшому екрані, наприклад, на планшеті, можна зменшити.

_Якщо вільного простору на екрані обмаль, TT9 автоматично зменшить висоту, щоб залишити достатньо місця для поточного додатка, навіть якщо це не передбачено в налаштуваннях._

## Інструменти буфера обміну
На панелі інструментів буфера обміну можна вибирати, вирізати, копіювати та вставляти текст, як на клавіатурі комп’ютера. Щоб вийти з панелі, можна натиснути клавішу "✱" або клавішу "Назад" (крім веббраузерів, Spotify та деяких інших додатків). Також можна натиснути будь-яку буквну клавішу на екранній клавіатурі.

Нижче наведено список можливих команд для роботи з текстом:
1. Вибрати попередній символ (як Shift+Ліворуч на клавіатурі комп’ютера)
2. Скасувати вибір
3. Вибрати наступний символ (як Shift+Праворуч)
4. Вибрати попереднє слово (як Ctrl+Shift+Ліворуч)
5. Вибрати все
6. Вибрати наступне слово (як Ctrl+Shift+Праворуч)
7. Вирізати
8. Копіювати
9. Вставити

Для зручнішого редагування клавіші Backspace, пробіл і OK також активні.

## Голосове введення
Функція голосового введення дозволяє перетворювати мову на текст, подібно до Gboard. Як і всі інші клавіатури, Traditional T9 самостійно не виконує розпізнавання мовлення; замість цього воно звертається до системи телефону.

_Кнопка голосового введення прихована на пристроях, які не підтримують цю функцію._

### Пристрої з Google
На пристроях з Google Services TT9 використовує інфраструктуру Google для перетворення голосу на текст. У Android 12 або нижче для цього потрібне з’єднання з Wi-Fi або ввімкнені мобільні дані. У Android 13 або вище TT9 може виконувати розпізнавання мовлення як онлайн, так і офлайн, використовуючи мовні пакети пристрою. Для офлайн-режиму завантажте потрібні мови з: Налаштування Android → Система → Розпізнавання на пристрої → Додати мову.

_Мовні пакети, встановлені для Google Voice, інших голосових помічників або клавіатур, не гарантують сумісність з Traditional T9. Рекомендується встановлювати глобальні пакети через екран "Розпізнавання на пристрої"._

### Пристрої без Google
На пристроях без Google, якщо є додаток голосового помічника або вбудована клавіатура підтримує голосове введення, буде використано доступну опцію. Але цей метод значно слабший за Google: не працює у шумному середовищі та зазвичай розпізнає лише прості фрази, як-от "відкрити календар" або "увімкнути музику".

### Інші пристрої
Інші телефони без Google зазвичай не підтримують голосове введення. Китайські телефони не мають можливостей розпізнавання мовлення через політику безпеки Китаю. На таких пристроях ви можете спробувати активувати підтримку голосового введення, встановивши додаток Google (назва пакета: "com.google.android.googlequicksearchbox"). Або спробуйте Google Go: "com.google.android.apps.searchlite".

## Усунення несправностей
Для кількох додатків або пристроїв можна ввімкнути спеціальні параметри, які допоможуть Traditional T9 працювати краще з ними. Вони знаходяться в кінці кожного екрана налаштувань, у розділі Сумісності.

### Альтернативний метод прокрутки пропозицій
_У: Налаштування → Зовнішній вигляд._

На деяких пристроях у Прогнозуючому режимі може виникати проблема, коли не вдається прокрутити список до кінця, або потрібно кілька разів прокручувати назад і вперед, щоб з’явилася остання пропозиція. Проблема іноді виникає на Android 9 або раніше. Увімкніть цей параметр, якщо ви стикаєтеся з цією проблемою.

### Завжди поверх інших
_У: Налаштування → Зовнішній вигляд._

На деяких телефонах, особливо Sonim XP3plus (XP3900), Traditional T9 може не з’являтися, коли ви починаєте вводити текст, або частково перекривається м’якими клавішами. В інших випадках навколо нього можуть бути білі смуги. Проблема може виникнути в одному конкретному застосунку або у всіх. Щоб уникнути цього, увімкніть опцію «Завжди поверх інших».

### Нижній відступ (портретна орієнтація)
_У: Налаштування → Зовнішній вигляд._

На пристроях Samsung з Android 15 або новішої версії Traditional T9 може відображатися занадто низько на екрані. У такому разі системна панель навігації перекриває останній ряд клавіатури, роблячи клавіші непридатними для використання. Спроба ввести пробіл, натиснути OK або змінити режим введення призводить до закриття клавіатури. Збільшення параметра «Нижній відступ» до 48dp усуває цю проблему.

В інших випадках під блоком клавіш може з’являтися зайвий порожній простір. Зменшення значення «Нижній відступ» до 0dp дозволяє його прибрати.

_Додаткову інформацію див. у звіті про помилку [#950](https://github.com/sspanak/tt9/issues/950)._

_У дуже рідкісних випадках аналогічні проблеми можуть виникати і на пристроях, відмінних від Samsung. Див. [#755](https://github.com/sspanak/tt9/issues/755)._

### Захист від повторення натискань
_У: Налаштування → Клавіатура._

Телефони CAT S22 Flip і Qin F21 відомі своїми неякісними клавіатурами, які швидко зношуються і починають реєструвати кілька натискань при одному дотику. Ви можете помітити це під час введення тексту або навігації по меню телефону.

Для телефонів CAT рекомендоване значення — 50–75 мс. Для Qin F21 спробуйте з 20–30 мс. Якщо проблема не зникає, збільшіть значення трохи, але намагайтеся тримати його якомога нижчим.

_**Примітка:** Чим вище встановлене значення, тим повільніше доведеться вводити текст. TT9 ігноруватиме дуже швидкі натискання клавіш._

_**Примітка 2:** Крім того, на телефонах Qin також можуть виникати проблеми з виявленням тривалих натискань. На жаль, у цьому випадку нічого не можна зробити._

### Показувати текст під час введення
_У: Налаштування → Клавіатура._

Якщо у вас виникають труднощі з введенням тексту у Deezer або Smouldering Durtles, тому що пропозиції швидко зникають, перш ніж ви їх побачите, вимкніть цю опцію. Це змусить поточне слово залишатися прихованим, поки ви не натиснете OK або Пробіл, або не торкнетеся списку пропозицій.

Проблема виникає через те, що Deezer і Smouldering Durtles іноді змінюють введений вами текст, що спричиняє некоректну роботу TT9.

### Панелі стікерів та емодзі в Telegram/Snapchat не відкриваються
Це трапляється, якщо ви використовуєте один із малих розмірів макетів. Наразі немає постійного вирішення, але ви можете використати наступний обхідний шлях:
- Перейдіть до Налаштування → Зовнішній вигляд і увімкніть Екранну цифрову клавіатуру.
- Поверніться до чату та натисніть кнопку емодзі або стікерів. Тепер вони повинні з’явитися.
- Після цього ви можете повернутися до налаштувань і вимкнути екранну цифрову клавіатуру. Панелі емодзі та стікерів залишатимуться доступними, поки ви не перезапустите застосунок або телефон.

### Traditional T9 не з’являється відразу в деяких програмах (лише для телефонів без сенсорного екрана)
Якщо ви відкрили програму, де можна вводити текст, але TT9 не з’являється автоматично, просто почніть вводити текст, і він з’явиться. Альтернативно, натискання гарячих клавіш для зміни [режиму вводу](#клавіша-наступний-режим-введення-за-замовчуванням-натискання) або [мови](#клавіша-наступна-мова-за-замовчуванням-утримання) також може змусити TT9 з’явитися, коли він прихований.

На деяких пристроях TT9 може залишатися невидимим, незалежно від того, що ви робите. У таких випадках вам потрібно увімкнути [Завжди поверх інших](#завжди-поверх-інших).

**Довге пояснення.** Причина цієї проблеми в тому, що Android в першу чергу розроблений для пристроїв з сенсорним екраном. Тому він очікує, що ви доторкнетеся до текстового/цифрового поля, щоб показати клавіатуру. Можливо змусити TT9 з’являтися без цього підтвердження, але в деяких випадках Android може забути приховати його, коли потрібно. Наприклад, він може залишатися видимим після набору телефонного номера або після відправлення тексту в полі пошуку.

З цієї причини, щоб дотримуватися очікуваних стандартів Android, контроль залишається за вами. Просто натисніть клавішу, щоб «доторкнутися» до екрана та продовжити введення тексту.

### На Qin F21 Pro утримування клавіші 2 або 8 підвищує або знижує гучність замість введення цифри
Щоб зменшити цю проблему, перейдіть до Налаштування → Зовнішній вигляд і увімкніть «Значок статусу». TT9 має автоматично виявити Qin F21 і ввімкнути налаштування, але якщо автоматичне виявлення не спрацює або ви вимкнули значок з якоїсь причини, потрібно залишити його увімкненим, щоб усі клавіші працювали належним чином.

**Довге пояснення.** Qin F21 Pro (і можливо F22) має програму для швидких клавіш, яка дозволяє призначати функції підвищення та зниження гучності цифровим клавішам. За замовчуванням диспетчер швидких клавіш увімкнений, і утримування клавіші 2 збільшує гучність, а клавіші 8 — зменшує її. Проте, коли немає значка статусу, диспетчер вважає, що клавіатура неактивна, і регулює гучність замість того, щоб дозволити Traditional T9 обробляти клавішу та вводити цифру. Тож увімкнення значка просто обходить диспетчер швидких клавіш, і все працює належним чином.

### Загальні проблеми на телефонах Xiaomi
Xiaomi додала кілька нестандартних дозволів на своїх телефонах, що перешкоджає нормальній роботі віртуальної клавіатури Traditional T9 на екрані. Точніше, клавіші «Відкрити Налаштування» та «Додати слово» можуть не виконувати свої функції. Щоб це виправити, потрібно надати дозволи «Відображення спливаючого вікна» та «Відображення спливаючого вікна у фоновому режимі» для TT9 у налаштуваннях телефону. [Цей посібник](https://parental-control.flashget.com/how-to-enable-display-pop-up-windows-while-running-in-the-background-on-flashget-kids-on-xiaomi) для іншої програми пояснює, як це зробити.

Також дуже рекомендується надати дозвіл «Постійне сповіщення». Це схоже на дозвіл «Сповіщення», введений в Android 13. Дивіться [вище](#примітки-для-android-13-або-новішої-версії) для отримання додаткової інформації, чому це потрібно.

_Проблеми з Xiaomi були обговорені в [цьому випуску на GitHub](https://github.com/sspanak/tt9/issues/490)._

### Голосове введення займає дуже багато часу для зупинки
Це [відоме питання](https://issuetracker.google.com/issues/158198432) в Android 10, яке Google так і не виправив. Неможливо виправити це на боці TT9. Щоб зупинити операцію голосового введення, зберігайте тишу кілька секунд. Android автоматично вимикає мікрофон, коли не може виявити жодної мови.

### Мій банківський застосунок не приймає Traditional T9
Це не є проблемою TT9. Банки часто обмежують використання нестандартних або відкритих клавіатур, оскільки не бажають ризикувати та припускають, що вони можуть бути ненадійними. Деякі навіть пропонують власні клавіатури, блокуючи стандартну клавіатуру Google — Gboard. На жаль, у такому випадку єдиним варіантом є перехід на стандартну клавіатуру пристрою.

### Вібрація не працює (лише для пристроїв із сенсорним екраном)
Режими енергозбереження, оптимізації та функція "Не турбувати" можуть блокувати вібрацію. Переконайтеся, що жоден із цих параметрів не ввімкнено у Системних налаштуваннях вашого пристрою. На деяких пристроях можна налаштувати оптимізацію батареї для кожного додатка окремо через Налаштування системи → Додатки. Якщо ваш пристрій підтримує цю функцію, вимкніть оптимізацію для TT9.

Ще однією причиною, через яку вібрація може не працювати, є її вимкнення на рівні системи. Перевірте, чи є у вашому пристрої опції "Вібрація при торканні" або "Вібрація при натисканні клавіш" у Налаштування системи → Спеціальні можливості, та активуйте їх. Пристрої Xiaomi та OnePlus дозволяють ще більш детально налаштовувати вібрацію. Переконайтеся, що всі необхідні параметри увімкнені.

Зрештою, вібрація може ненадійно працювати на деяких пристроях. Для її виправлення знадобляться додаткові дозволи та доступ до функцій пристрою. Проте, оскільки TT9 — це клавіатура, що перш за все зберігає конфіденційність, вона не запитуватиме таких дозволів.

## Часті запитання

### Чому ви не додаєте мову X?
Я із задоволенням би додав, але мені потрібна ваша допомога. Підтримувати понад 40 мов самостійно неможливо. Оскільки я не володію вашою мовою, мені складно знаходити надійні ресурси в інтернеті — і саме тут ви можете допомогти.
Насправді понад 90% мов було додано за участі або за допомогою ентузіастів-носіїв мови.

Щоб додати нову мову, мені потрібен список слів із перевіреним правописом, бажано з офіційного чи академічного джерела (наприклад, «Великий словник мови X»). Такі списки забезпечують найвищу якість підказок під час набору тексту.

Якщо такого словника немає, можна надати будь-який безкоштовний список слів для завантаження. Зазвичай достатньо 300–500 тисяч слів, але якщо в мові багато відмін і форм (час, рід, число тощо), може знадобитися до мільйона.

### У мові XYZ є слова з помилками або відсутні слова. Чому їх не виправлено?
Як уже сказано вище, я не розмовляю вашою мовою і можу навіть не знати про ці помилки. Але з вашою допомогою ми можемо їх виправити й зробити словник кращим для всіх.

### Чи не можна додати функцію X?
Ні.

У кожного свої вподобання. Дехто хоче більші клавіші, дехто — інший порядок розташування, інші хочуть клавішу швидкого введення для ".com", а дехто сумує за своїм старим телефоном або клавіатурою. Але, будь ласка, зрозумійте, що я працюю над цим проєктом добровільно у свій вільний час. Виконати тисячі різних побажань, багато з яких суперечать одне одному, просто неможливо.

Генрі Форд колись сказав: "Клієнт може отримати будь-який колір, який забажає, якщо цей колір чорний." Так само Traditional T9 — це простий, ефективний і безкоштовний інструмент, який ви отримуєте таким, яким він є.

### Чи не можна зробити застосунок більш схожим на мій улюблений пристрій (наприклад, Sony Ericsson, Xperia, Nokia C2, Samsung) або мою улюблену клавіатурну програму?
Ні.

Traditional T9 не призначений для того, щоб бути заміною або копією інших клавіатур. Він має унікальний дизайн, натхненний переважно Nokia 3310 і 6303i. І хоча він передає відчуття класичних телефонів, він не намагається бути точною копією будь-якого пристрою.

### Вам слід скопіювати TouchPal; це була найкраща клавіатура!
Ні. Див. попередні пункти.

TouchPal була швидкою та чутливою клавіатурою з широкими можливостями темування, налаштування та підтримкою кількох мов. Вона була популярною приблизно у 2015 році, коли конкуренція була обмеженою. Однак це ніколи не була справжня T9-клавіатура: 12-клавішне компонування було доступне лише для деяких мов і призначалося виключно для сенсорних екранів.

З часом застосунок почав втрачати фокус на найважливішому — введенні тексту. Було додано рекламу, запити дозволів стали агресивними, а також розпочався збір чутливих даних користувачів. Зрештою TouchPal було видалено з Play Store.

Натомість [філософія](https://github.com/sspanak/tt9/?tab=readme-ov-file#-philosophy) TT9 базується на принципах відкритого програмного забезпечення. Вихідний код і словники є публічно доступними та можуть бути перевірені. Конфіденційність користувачів забезпечується на рівні дизайну. Внески спільноти допомогли покращити проєкт, зокрема шляхом виправлення помилок, додавання нових мов і перекладів. Користувачі також можуть створювати власні модифіковані версії.

TT9 не пропонує таких можливостей, як налаштовувані форми клавіш, натомість забезпечує чисте й читабельне компонування, орієнтоване на ефективне введення тексту. Він не відтворює візуальний стиль TouchPal, проте працює на сучасних смартфонах з Android 16, на пристроях із апаратними клавіатурами в стилі ретро, таких як Qin F21, Cat S22 Flip і Sonim XP3800, а також навіть на пультах дистанційного керування телевізорів.

Якщо ви не погоджуєтеся або бажаєте пояснити свою точку зору, долучайтеся до [відкритого обговорення](https://github.com/sspanak/tt9/issues/647) на GitHub. Будь ласка, дотримуйтеся взаємної поваги. Публікації з проявами ненависті не допускаються.

### Android попередив мене, що клавіатура може збирати мої персональні дані, включно з номерами банківських карток і паролями
Це стандартне попередження Android, яке з’являється під час встановлення та активації будь-якої клавіатури, а не лише Traditional T9. Можете бути певні, що всі введені дані залишаються на вашому пристрої. Механізм введення повністю відкритий; ви можете переглянути його код на GitHub та переконатися, що ваша конфіденційність надійно захищена.

_Якщо у вас усе ж залишилися занепокоєння, будь ласка, ознайомтеся з Політикою конфіденційності застосунку._

### Мені потрібно використовувати розкладку QWERTY (лише для пристроїв із сенсорним екраном)
Traditional T9 — це клавіатура T9, і, як така, вона не має розкладки на кшталт QWERTY.

Якщо ви ще навчаєтеся користуватися T9 і час від часу потрібно повертатися до QWERTY, або ви вважаєте більш зручним вводити нові слова за допомогою QWERTY, проведіть пальцем угору по клавіші режиму введення, щоб перейти до іншої клавіатури. Дивіться [огляд віртуальних клавіш](#огляд-віртуальних-клавіш) для отримання додаткової інформації.

Більшість інших клавіатур дозволяють повернутися до Traditional T9, утримуючи пробіл або клавішу «зміни мови». Перевірте відповідний посібник або інструкцію для отримання додаткової інформації.

### Я не можу змінити мову на сенсорному телефоні
Спочатку переконайтеся, що ви активували всі потрібні мови в Налаштуваннях → Мови. Потім утримуйте [клавішу режиму введення](#клавіша-режиму-введення), щоб змінити мову.

### Як додати скорочення на кшталт «I've» або «don't» до словника?
Усі скорочення для всіх мов уже доступні як окремі слова, тому вам не потрібно нічого додавати. Це забезпечує максимальну гнучкість — ви можете комбінувати будь-яке слово з будь-яким скороченням і значно економити місце для зберігання.

Наприклад, ви можете набрати 've, натиснувши: 183; або 'll, використовуючи: 155. Це означає: "I'll" = 4155 і "we've" = 93183. Також можна набрати "google.com", натиснувши: 466453 (google) 1266 (.com).

Складніший приклад французькою: "Qu'est-ce que c'est" = 781 (qu'), 378123 (est-ce), 783 (que), 21378 (c'est).

_Винятки з правила — це "can't" та "don't" в англійській мові. Тут 't не є окремим словом, але ви все одно можете набрати їх, як описано вище._