package io.github.sspanak.tt9.ime;

import android.view.inputmethod.EditorInfo;

import java.util.LinkedList;

import io.github.sspanak.tt9.ime.modes.InputModeKind;
import io.github.sspanak.tt9.languages.LanguageCollection;
import io.github.sspanak.tt9.languages.LanguageKind;
import io.github.sspanak.tt9.util.Ternary;
import io.github.sspanak.tt9.util.sys.Clipboard;

abstract public class TextEditingHandler extends VoiceHandler {
	protected boolean isLanguageRTL;


	@Override
	protected boolean onStart(EditorInfo field, boolean restarting) {
		detectRTL();
		suggestionOps.setLanguage(LanguageCollection.getLanguage(settings.getInputLanguage()));
		return super.onStart(field, restarting);
	}


	protected void detectRTL() {
		isLanguageRTL = LanguageKind.isRTL(
			LanguageCollection.getLanguage(settings.getInputLanguage())
		);
	}


	protected boolean onNumber(int key, boolean hold, int repeat) {
		if (!shouldBeOff() && mainView.isTextEditingPaletteShown()) {
			onCommand(key);
			return true;
		}

		return super.onNumber(key, hold, repeat);
	}


	@Override
	protected Ternary onBack() {
		if (navigateBack()) {
			return Ternary.TRUE;
		} else {
			return super.onBack();
		}
	}


	private void onCommand(int key) {
		if (!suggestionOps.isEmpty() && key != 9) {
			suggestionOps.acceptCurrent();
		}

		switch (key) {
			case 0:
				if (!InputModeKind.isNumeric(mInputMode)) {
					onText(" ", false);
				}
				break;
			case 1:
				textSelection.selectNextChar(!isLanguageRTL);
				break;
			case 2:
				textSelection.clear();
				break;
			case 3:
				textSelection.selectNextChar(isLanguageRTL);
				break;
			case 4:
				textSelection.selectNextWord(!isLanguageRTL);
				break;
			case 5:
				textSelection.selectAll();
				break;
			case 6:
				textSelection.selectNextWord(isLanguageRTL);
				break;
			case 7:
				cut();
				break;
			case 8:
				copy();
				break;
			case 9:
				paste();
				break;
		}
	}


	protected boolean navigateBack() {
		if (!hideTextEditingPalette()) {
			return super.navigateBack();
		}

		if (settings.isMainLayoutSmall() || settings.isMainLayoutTray()) {
			mainView.showCommandPalette();
		}

		return true;
	}


	private void cut() {
		if (copy()) {
			suggestionOps.clear();
		}
	}


	private boolean copy() {
		CharSequence selectedText = textSelection.getSelectedText();
		if (selectedText.length() == 0) {
			return false;
		}

		Clipboard.copy(this, selectedText);
		return true;
	}


	private void paste() {
		if (!suggestionOps.isEmpty()) {
			suggestionOps.clear();
			return;
		}

		LinkedList<CharSequence> clips = Clipboard.getAll(this);
		if (clips.isEmpty()) {
			return;
		}

		mInputMode.reset();
		suggestionOps.setClipboardItems(clips);
		appHacks.setComposingTextWithHighlightedStem(suggestionOps.getCurrent(), null, false);
	}


	public void showTextEditingPalette() {
		if (inputType.isLimited() || mainView.isTextEditingPaletteShown()) {
			return;
		}

		suggestionOps.cancelDelayedAccept();
		suggestionOps.acceptIncomplete();
		mInputMode.reset();
		stopVoiceInput();

		mainView.showTextEditingPalette();
		Clipboard.setOnChangeListener(this, this::resetStatus);
		resetStatus();
	}


	public boolean hideTextEditingPalette() {
		if (!mainView.isTextEditingPaletteShown()) {
			return false;
		}

		Clipboard.clearListener(this);
		suggestionOps.acceptCurrent();
		mainView.showKeyboard();
		resetStatus();
		return true;
	}
}
