package io.github.sspanak.tt9.commands;

import androidx.annotation.Nullable;

import io.github.sspanak.tt9.ime.TraditionalT9;

public class CmdVoiceInput implements Command {
	public static final String ID = "key_voice_input";
	public String getId() { return ID; }
	public int getIcon() { return io.github.sspanak.tt9.R.drawable.ic_fn_voice; }
	public int getIconOff() { return io.github.sspanak.tt9.R.drawable.ic_fn_voice_off; }
	public int getName() { return io.github.sspanak.tt9.R.string.function_voice_input; }

	public boolean run(io.github.sspanak.tt9.ime.TraditionalT9 tt9) {
		if (tt9 != null) {
			tt9.toggleVoiceInput();
			return true;
		}
		return false;
	}

	public boolean isActive(@Nullable TraditionalT9 tt9) {
		return tt9 != null && tt9.isVoiceInputActive();
	}

	@Override
	public boolean isAvailable(@Nullable TraditionalT9 tt9) {
		return !isMissing(tt9);
	}

	public boolean isMissing(@Nullable TraditionalT9 tt9) {
		return tt9 != null && tt9.isVoiceInputMissing();
	}
}
