import org.jetbrains.kotlin.gradle.ExperimentalWasmDsl
import org.jetbrains.kotlin.gradle.dsl.JvmTarget

plugins {
    alias(libs.plugins.androidLibrary)
    alias(libs.plugins.kotlinMultiplatform)
    alias(libs.plugins.kotlinSerialization)
}

group = "io.github.snd-r.komelia.offline"
version = "unspecified"

kotlin {
    jvmToolchain(17)

    androidTarget { compilerOptions { jvmTarget.set(JvmTarget.JVM_17) } }
    jvm { compilerOptions { jvmTarget.set(JvmTarget.JVM_17) } }
    @OptIn(ExperimentalWasmDsl::class)
    wasmJs {
        outputModuleName = "komelia-webview"
        browser()
    }

    sourceSets {
        all {
            languageSettings.optIn("kotlin.ExperimentalStdlibApi")
            languageSettings.optIn("kotlin.ExperimentalUnsignedTypes")
            languageSettings.optIn("kotlin.time.ExperimentalTime")
            languageSettings.optIn("kotlin.uuid.ExperimentalUuidApi")
        }
        commonMain.dependencies {
            implementation(projects.komeliaDomain.komgaApi)
            implementation(projects.komeliaInfra.database.transaction)
            implementation(projects.komeliaInfra.imageDecoder.shared)

            implementation(libs.filekit.core)
            implementation(libs.coil)
            implementation(libs.kotlin.logging)
            implementation(libs.kotlinx.datetime)
            implementation(libs.kotlinx.coroutines.core)
            implementation(libs.kotlinx.io.core)
            implementation(libs.kotlinx.serialization.core)
            implementation(libs.kotlinx.serialization.json)
            implementation(libs.komga.client)
            implementation(libs.ktor.client.core)
        }

        androidMain.dependencies {
            implementation(libs.commons.compress)
            implementation(libs.androidx.documentfile)
            implementation(libs.androidx.workManager)
            implementation(libs.androidx.workManager.ktx)
        }

        jvmMain.dependencies {
            implementation(libs.commons.compress)
            implementation(libs.ktor.client.okhttp)
            implementation(projects.komeliaInfra.jni)
        }
    }
}
android {
    namespace = "io.github.snd_r.komelia.offline"
    compileSdk = libs.versions.android.compileSdk.get().toInt()

    defaultConfig {
        minSdk = libs.versions.android.minSdk.get().toInt()
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_17
        targetCompatibility = JavaVersion.VERSION_17
    }
}
