//    The GNU General Public License does not permit incorporating this program
//    into proprietary programs.
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <https://www.gnu.org/licenses/>.

package io.github.silinote.ui.configuration;

import android.content.Intent;
import android.os.Bundle;

import androidx.preference.PreferenceFragmentCompat;

import com.jaredrummler.cyanea.prefs.CyaneaSettingsActivity;

import io.github.silinote.MainActivity;
import io.github.silinote.R;

public class ConfigurationFragment extends PreferenceFragmentCompat {

	@Override
	public void onCreatePreferences(Bundle savedInstanceState, String rootKey) {
		setPreferencesFromResource(R.xml.configuration, rootKey);
		findPreference("commandthemeconfiguration").setOnPreferenceClickListener(preference -> {
			getActivity().startActivity(new Intent(getActivity(), CyaneaSettingsActivity.class));
			return false;
		});
		findPreference("commandexport").setOnPreferenceClickListener(preference -> {
			((MainActivity) requireActivity()).startExportProcess();
			return false;
		});
		findPreference("commandimport").setOnPreferenceClickListener(preference -> {
			((MainActivity) requireActivity()).startImportProcess();
			return false;
		});
	}
}