package io.github.saeeddev94.xray.helper

import androidx.recyclerview.widget.ItemTouchHelper
import androidx.recyclerview.widget.RecyclerView

class ProfileTouchHelper(private var adapter: ProfileTouchCallback) : ItemTouchHelper.Callback() {

    private var startPosition: Int = -1

    override fun getMovementFlags(
        recyclerView: RecyclerView,
        viewHolder: RecyclerView.ViewHolder
    ): Int = makeMovementFlags(ItemTouchHelper.UP or ItemTouchHelper.DOWN, 0)

    override fun onMove(
        recyclerView: RecyclerView,
        source: RecyclerView.ViewHolder,
        target: RecyclerView.ViewHolder
    ): Boolean = adapter.onItemMoved(source.adapterPosition, target.adapterPosition)

    override fun onSwiped(
        viewHolder: RecyclerView.ViewHolder,
        direction: Int
    ) {
    }

    override fun onSelectedChanged(
        viewHolder: RecyclerView.ViewHolder?,
        actionState: Int
    ) {
        if (actionState != ItemTouchHelper.ACTION_STATE_DRAG) return
        startPosition = viewHolder!!.adapterPosition
    }

    override fun clearView(
        recyclerView: RecyclerView,
        viewHolder: RecyclerView.ViewHolder
    ) {
        val endPosition = viewHolder.adapterPosition
        adapter.onItemMoveCompleted(startPosition, endPosition)
    }

    interface ProfileTouchCallback {
        fun onItemMoved(fromPosition: Int, toPosition: Int): Boolean
        fun onItemMoveCompleted(startPosition: Int, endPosition: Int)
    }
}
