# Configure Settings

## 1. Primary actor and goals
Who is the main interested party and what goal(s) this use case is designed to help them achieve.

__User__: wants to be able to change settings to customize their experience to their liking, like changing the theme or enabling automatic notifications.

## 2. Other stakeholders and their goals

No other stakeholders.

## 2. Preconditions

What must be true prior to the start of the use case.

Settings menu icon is opened

## 4. Postconditions

What must be true upon successful completion of the use case.

* Users changes are saved
* User is notified that changed have been saved
* Settings modifications are implemented at app refresh or immediately, if possible.


## 4. Workflow

The sequence of steps involved in the execution of the use case, in the form of one or more activity diagrams (please feel free to decompose into multiple diagrams for readability).

The workflow can be specified at different levels of detail:

* __Brief__: main success scenario only;
* __Casual__: most common scenarios and variations;
* __Fully-dressed__: all scenarios and variations.

Please be sure indicate what level of detail the workflow you include represents.



```plantuml
@startuml

skin rose

title Configure Settings (brief level)

'define the lanes
|#application|User|
|#technology|System|

|User|
start
:access Settings menu from browseNotes screen;

|System|
:display list of configurable settings (Change number of tags autogenerated, global notification  settings, etc.);

|User|
:Selects setting to change;

|System|
while (Change Settings?) is (true)
:correct prompts user with correct prompts, i.e. toggle, date select, number select;
endwhile (no)
|User|
if (attempts to exit settings) is (Save and Exit) then;

|System|
:user is notified that changes were saved;
else (Discard Changes)
|System|
:user is told changes were not saved;
endif
:user is returned to browseNotes screen;
stop
@enduml
```

## Sequence Diagram

```plantuml
@startuml
hide footbox
skin rose
actor User as user
participant "SearchNotesFragment" as searchUI
participant "ControllerActivity" as controller
participant "SettingsFragment" as settingsUI
participant "TagColorSettingsFragment" as tagColorUI
participant "PreferenceManager" as prefManager
participant "SharedPreferences" as sharedPrefs
participant "NoteLibrary" as noteLibrary
participant "File System" as fileSystem

== Opening Settings ==
user -> searchUI: clicks settings icon
searchUI -> controller: onOpenSettings()
controller -> settingsUI: creates and displays SettingsFragment
settingsUI -> prefManager: getDefaultSharedPreferences()
prefManager --> settingsUI: SharedPreferences instance
settingsUI -> settingsUI: loadPreferencesFromResource()
settingsUI -> settingsUI: setupPreferenceCallbacks()
settingsUI --> user: displays settings categories

== Configure Notification Settings ==
user -> settingsUI: toggles "Allow Notifications"
settingsUI -> sharedPrefs: putBoolean("pref_noti", true/false)
sharedPrefs --> settingsUI: success
settingsUI --> user: shows updated toggle state

== Configure Auto-Tagging Settings ==
user -> settingsUI: adjusts auto-tag limit slider
settingsUI -> settingsUI: onPreferenceChangeListener
settingsUI -> sharedPrefs: putInt("auto_tag_limit", value)
sharedPrefs --> settingsUI: success
settingsUI -> settingsUI: updates summary text
settingsUI --> user: shows updated value

user -> settingsUI: toggles "Use AI-powered Auto-Tagging"
settingsUI -> sharedPrefs: putBoolean("pref_ai_auto_tag", true/false)
sharedPrefs --> settingsUI: success
settingsUI --> user: shows updated toggle state with description

== Configure API Key ==
user -> settingsUI: taps "OpenAI API Key"
settingsUI --> user: displays API key dialog
user -> settingsUI: enters API key
settingsUI -> sharedPrefs: putString("user_api_key", value)
sharedPrefs --> settingsUI: success
settingsUI --> user: shows masked API key summary

== Configure Tag Colors ==
user -> settingsUI: taps "Edit Tag Colors"
settingsUI -> tagColorUI: navigates to TagColorSettingsFragment
tagColorUI -> controller: getNoteLibrary()
controller --> tagColorUI: noteLibrary instance
tagColorUI -> noteLibrary: getManageTags()
noteLibrary --> tagColorUI: manageTags instance
tagColorUI -> tagColorUI: createTagPreferences()
tagColorUI --> user: shows list of tags with colors

user -> tagColorUI: taps on a tag
tagColorUI --> user: displays color selection dialog
user -> tagColorUI: selects a color
tagColorUI -> manageTags: setTagColor(tagName, colorResId)
manageTags -> sharedPrefs: saves tag color mapping
sharedPrefs --> manageTags: success
tagColorUI -> tagColorUI: updates tag color display
tagColorUI --> user: shows toast confirmation

== Danger Zone - Delete All Notes ==
user -> settingsUI: taps "Delete All Notes"
settingsUI --> user: displays confirmation dialog
user -> settingsUI: confirms deletion
settingsUI -> fileSystem: deletes notes.json file
fileSystem --> settingsUI: success
settingsUI --> user: shows completion dialog
user -> settingsUI: acknowledges dialog
settingsUI -> controller: finishAffinity()
controller -> user: closes app

== Return to Main Screen ==
user -> settingsUI: presses back button
controller -> searchUI: returns to SearchNotesFragment
searchUI -> controller: onResume() triggers onGetNotes()
controller -> noteLibrary: getNotes()
noteLibrary --> controller: notes list
controller -> searchUI: updateView(notes)
searchUI -> searchUI: refreshes UI with current settings
searchUI --> user: shows notes with updated settings applied
@enduml
```

