Contributing to FreePaint
===============================

First off, thanks for choosing to contribute to FreePaint! Here's what you can do:

## Getting Started
The first thing you should do when contributing to FreePaint is to check out the issues. It's an Android app, so there's bound to be a lot of bugs!
Bug testing and fixing is probably going to be the most important thing to creating a better experience for everyone!

## Issues, Bug Reports, and Feature Requests
### Titles
Please give each issue a descriptive title so they can be easy to identify and then work on.
### Descriptions
For bug reports, please ensure you have included the following:
* Your phone and operating system/version, and FreePaint version
* A detailed (if possible) description of the bug you are facing
* Logs and screenshots, if possible.
* The branch you found the error in (leave this as empty if it's the main branch/you downloaded this from an app store)

### Labels
Lastly, make sure you have the right labels for your issue. (You should see the option to your right when making your issue.) This will help to make issues more identifiable and easier to track, again speeding up processes to complete them.

## Branches
FreePaint is split into branches depending on versions. The `stable` branch is for current, stable versions of FreePaint that should only receive bug fixes, while the `dev` branch is for feature additions.

## Cool, but I want to write some code!
### Adding new features
1. Create a feature request for the code you would like to add.
2. Fork FreePaint and add your code.
3. It wold be best if there is some discussion on your issue and the general consensus is that your changes should be merged into the `dev` branch, but it isn't necessary (unless your change is fundamental).
4. Your changes will be merged! Thanks for adding a feature to FreePaint!
### Fixing bugs
1. Create a bug report for the bug you are fixing, or find an already-created bug report.
2. Fork FreePaint and add your code.
3. Make sure people test it on different devices/with cleared app data to make sure the issue is fixed and new ones aren't silently introduced.
4. Done! Thanks for making FreePaint more stable.

## Naming scheme
Semantic versioning!
