package com.fluttercandies.photo_manager.core.utils

import android.provider.MediaStore

object RequestTypeUtils {
    private const val TYPE_IMAGE = 1
    private const val TYPE_VIDEO = 1.shl(1)
    private const val TYPE_AUDIO = 1.shl(2)

    fun containsImage(type: Int): Boolean = checkType(type, TYPE_IMAGE)

    fun containsVideo(type: Int): Boolean = checkType(type, TYPE_VIDEO)

    fun containsAudio(type: Int): Boolean = checkType(type, TYPE_AUDIO)

    private fun checkType(type: Int, targetType: Int): Boolean {
        return type and targetType == targetType
    }

    fun toWhere(requestType: Int): String {
        val typeInt = arrayListOf<Int>()
        if (containsImage(requestType)) {
            typeInt.add(MediaStore.Files.FileColumns.MEDIA_TYPE_IMAGE)
        }
        if (containsAudio(requestType)) {
            typeInt.add(MediaStore.Files.FileColumns.MEDIA_TYPE_AUDIO)
        }
        if (containsVideo(requestType)) {
            typeInt.add(MediaStore.Files.FileColumns.MEDIA_TYPE_VIDEO)
        }

        val where = typeInt.joinToString(" OR ") {
            "${MediaStore.Files.FileColumns.MEDIA_TYPE} = $it"
        }

        return "( $where )"
    }
}
