package io.github.micw.openphotoframe

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.SharedPreferences
import android.util.Log

/**
 * BroadcastReceiver that starts the app when the device boots.
 * Only starts if autostart is enabled in app settings.
 */
class BootReceiver : BroadcastReceiver() {
    companion object {
        private const val TAG = "BootReceiver"
        private const val PREFS_NAME = "FlutterSharedPreferences"
        private const val AUTOSTART_KEY = "flutter.autostart_on_boot"
    }

    override fun onReceive(context: Context, intent: Intent) {
        if (intent.action == Intent.ACTION_BOOT_COMPLETED || 
            intent.action == "android.intent.action.QUICKBOOT_POWERON") {
            
            Log.d(TAG, "Boot completed received")
            
            // Check if autostart is enabled in shared preferences
            val prefs: SharedPreferences = context.getSharedPreferences(PREFS_NAME, Context.MODE_PRIVATE)
            val autostartEnabled = prefs.getBoolean(AUTOSTART_KEY, false)
            
            Log.d(TAG, "Autostart enabled: $autostartEnabled")
            
            if (autostartEnabled) {
                Log.d(TAG, "Starting MainActivity")
                val startIntent = Intent(context, MainActivity::class.java).apply {
                    addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                    addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP)
                }
                context.startActivity(startIntent)
            }
        }
    }
}
