// Copyright 2013 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import 'package:pigeon/pigeon.dart';

@ConfigurePigeon(
  PigeonOptions(
    input: 'pigeons/messages.dart',
    swiftOut:
        'darwin/path_provider_foundation/Sources/path_provider_foundation/messages.g.swift',
    dartOut: 'lib/messages.g.dart',
    copyrightHeader: 'pigeons/copyright.txt',
  ),
)
enum DirectoryType {
  applicationDocuments,
  applicationSupport,
  downloads,
  library,
  temp,
  applicationCache,
}

@HostApi()
abstract class PathProviderApi {
  String? getDirectoryPath(DirectoryType type);
  String? getContainerPath(String appGroupIdentifier);
}
