package io.github.landwarderer.futon.core.ui.list.decor

import android.graphics.Rect
import android.view.View
import androidx.annotation.Px
import androidx.recyclerview.widget.RecyclerView

class SpacingItemDecoration(
    @Px private val spacing: Int,
    private val withBottomPadding: Boolean,
) : RecyclerView.ItemDecoration() {

	override fun getItemOffsets(
		outRect: Rect,
		view: View,
		parent: RecyclerView,
		state: RecyclerView.State,
	) {
		outRect.set(spacing, spacing, spacing, if (withBottomPadding) spacing else 0)
	}
}
