import 'package:flutter/widgets.dart';
import 'line_icons.dart';

/// Class for a single `Icon` (not `IconData`), based on constructors.
///
/// For instance:
/// `final Icon icon = LineIcon.mobilePhone();`
///
/// If you're looking for `IconData` instead of `Icon` objects, please see
/// `LineIcons` class.
class LineIcon extends Icon {
  /// General constructor
  /// Not intended to be used widely, but who knows. It may come at hand sometime
  const LineIcon(
    IconData icon, {
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          icon,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for building_1 icon
  /// Name building_1 turns into flutterish buildingAlt
  const LineIcon.buildingAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.buildingAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for map_1 icon
  /// Name map_1 turns into flutterish mapAlt
  const LineIcon.mapAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mapAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for neutral_face_1 icon
  /// Name neutral_face_1 turns into flutterish neutralFaceAlt
  const LineIcon.neutralFaceAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.neutralFaceAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for eye_slash_1 icon
  /// Name eye_slash_1 turns into flutterish eyeSlashAlt
  const LineIcon.eyeSlashAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.eyeSlashAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for caret_square_up_1 icon
  /// Name caret_square_up_1 turns into flutterish caretSquareUpAlt
  const LineIcon.caretSquareUpAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.caretSquareUpAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for copy_1 icon
  /// Name copy_1 turns into flutterish copyAlt
  const LineIcon.copyAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.copyAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dot_circle_1 icon
  /// Name dot_circle_1 turns into flutterish dotCircleAlt
  const LineIcon.dotCircleAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dotCircleAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for grinning_face_with_big_eyes_1 icon
  /// Name grinning_face_with_big_eyes_1 turns into flutterish grinningFaceWithBigEyesAlt
  const LineIcon.grinningFaceWithBigEyesAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.grinningFaceWithBigEyesAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for save_1 icon
  /// Name save_1 turns into flutterish saveAlt
  const LineIcon.saveAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.saveAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for face_with_tears_of_joy_1 icon
  /// Name face_with_tears_of_joy_1 turns into flutterish faceWithTearsOfJoyAlt
  const LineIcon.faceWithTearsOfJoyAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.faceWithTearsOfJoyAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for star_half_1 icon
  /// Name star_half_1 turns into flutterish starHalfAlt
  const LineIcon.starHalfAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.starHalfAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for smiling_face_1 icon
  /// Name smiling_face_1 turns into flutterish smilingFaceAlt
  const LineIcon.smilingFaceAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.smilingFaceAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for grinning_face_with_smiling_eyes_1 icon
  /// Name grinning_face_with_smiling_eyes_1 turns into flutterish grinningFaceWithSmilingEyesAlt
  const LineIcon.grinningFaceWithSmilingEyesAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.grinningFaceWithSmilingEyesAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for audio_file_1 icon
  /// Name audio_file_1 turns into flutterish audioFileAlt
  const LineIcon.audioFileAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.audioFileAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for window_maximize_1 icon
  /// Name window_maximize_1 turns into flutterish windowMaximizeAlt
  const LineIcon.windowMaximizeAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.windowMaximizeAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for loudly_crying_face_1 icon
  /// Name loudly_crying_face_1 turns into flutterish loudlyCryingFaceAlt
  const LineIcon.loudlyCryingFaceAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.loudlyCryingFaceAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sticky_note_1 icon
  /// Name sticky_note_1 turns into flutterish stickyNoteAlt
  const LineIcon.stickyNoteAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.stickyNoteAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for angry_face_1 icon
  /// Name angry_face_1 turns into flutterish angryFaceAlt
  const LineIcon.angryFaceAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.angryFaceAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for window_restore_1 icon
  /// Name window_restore_1 turns into flutterish windowRestoreAlt
  const LineIcon.windowRestoreAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.windowRestoreAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for star_1 icon
  /// Name star_1 turns into flutterish starAlt
  const LineIcon.starAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.starAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for address_card_1 icon
  /// Name address_card_1 turns into flutterish addressCardAlt
  const LineIcon.addressCardAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.addressCardAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for comment_1 icon
  /// Name comment_1 turns into flutterish commentAlt
  const LineIcon.commentAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.commentAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for object_ungroup_1 icon
  /// Name object_ungroup_1 turns into flutterish objectUngroupAlt
  const LineIcon.objectUngroupAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.objectUngroupAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for winking_face_1 icon
  /// Name winking_face_1 turns into flutterish winkingFaceAlt
  const LineIcon.winkingFaceAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.winkingFaceAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for window_close_1 icon
  /// Name window_close_1 turns into flutterish windowCloseAlt
  const LineIcon.windowCloseAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.windowCloseAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for video_file_1 icon
  /// Name video_file_1 turns into flutterish videoFileAlt
  const LineIcon.videoFileAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.videoFileAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hushed_face_1 icon
  /// Name hushed_face_1 turns into flutterish hushedFaceAlt
  const LineIcon.hushedFaceAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hushedFaceAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for envelope_1 icon
  /// Name envelope_1 turns into flutterish envelopeAlt
  const LineIcon.envelopeAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.envelopeAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for face_with_tongue_1 icon
  /// Name face_with_tongue_1 turns into flutterish faceWithTongueAlt
  const LineIcon.faceWithTongueAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.faceWithTongueAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for caret_square_down_1 icon
  /// Name caret_square_down_1 turns into flutterish caretSquareDownAlt
  const LineIcon.caretSquareDownAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.caretSquareDownAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pause_circle_1 icon
  /// Name pause_circle_1 turns into flutterish pauseCircleAlt
  const LineIcon.pauseCircleAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pauseCircleAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for folder_open_1 icon
  /// Name folder_open_1 turns into flutterish folderOpenAlt
  const LineIcon.folderOpenAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.folderOpenAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for folder_1 icon
  /// Name folder_1 turns into flutterish folderAlt
  const LineIcon.folderAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.folderAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for flag_1 icon
  /// Name flag_1 turns into flutterish flagAlt
  const LineIcon.flagAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.flagAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hand_pointing_right_1 icon
  /// Name hand_pointing_right_1 turns into flutterish handPointingRightAlt
  const LineIcon.handPointingRightAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.handPointingRightAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for minus_square_1 icon
  /// Name minus_square_1 turns into flutterish minusSquareAlt
  const LineIcon.minusSquareAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.minusSquareAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_arrow_circle_down_1 icon
  /// Name alternate_arrow_circle_down_1 turns into flutterish alternateArrowCircleDownAlt
  const LineIcon.alternateArrowCircleDownAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateArrowCircleDownAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for excel_file_1 icon
  /// Name excel_file_1 turns into flutterish excelFileAlt
  const LineIcon.excelFileAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.excelFileAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for caret_square_left_1 icon
  /// Name caret_square_left_1 turns into flutterish caretSquareLeftAlt
  const LineIcon.caretSquareLeftAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.caretSquareLeftAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pointer__hand__1 icon
  /// Name pointer__hand__1 turns into flutterish pointerHandAlt
  const LineIcon.pointerHandAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pointerHandAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for laugh_face_with_beaming_eyes_1 icon
  /// Name laugh_face_with_beaming_eyes_1 turns into flutterish laughFaceWithBeamingEyesAlt
  const LineIcon.laughFaceWithBeamingEyesAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.laughFaceWithBeamingEyesAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for snowflake_1 icon
  /// Name snowflake_1 turns into flutterish snowflakeAlt
  const LineIcon.snowflakeAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.snowflakeAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for star_struck_1 icon
  /// Name star_struck_1 turns into flutterish starStruckAlt
  const LineIcon.starStruckAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.starStruckAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for stop_circle_1 icon
  /// Name stop_circle_1 turns into flutterish stopCircleAlt
  const LineIcon.stopCircleAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.stopCircleAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for comments_1 icon
  /// Name comments_1 turns into flutterish commentsAlt
  const LineIcon.commentsAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.commentsAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for closed_captioning_1 icon
  /// Name closed_captioning_1 turns into flutterish closedCaptioningAlt
  const LineIcon.closedCaptioningAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.closedCaptioningAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for thumbs_down_1 icon
  /// Name thumbs_down_1 turns into flutterish thumbsDownAlt
  const LineIcon.thumbsDownAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.thumbsDownAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for grinning_winking_face_1 icon
  /// Name grinning_winking_face_1 turns into flutterish grinningWinkingFaceAlt
  const LineIcon.grinningWinkingFaceAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.grinningWinkingFaceAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for images_1 icon
  /// Name images_1 turns into flutterish imagesAlt
  const LineIcon.imagesAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.imagesAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for compass_1 icon
  /// Name compass_1 turns into flutterish compassAlt
  const LineIcon.compassAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.compassAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for code_file_1 icon
  /// Name code_file_1 turns into flutterish codeFileAlt
  const LineIcon.codeFileAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.codeFileAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for squinting_face_with_tongue_1 icon
  /// Name squinting_face_with_tongue_1 turns into flutterish squintingFaceWithTongueAlt
  const LineIcon.squintingFaceWithTongueAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.squintingFaceWithTongueAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for clipboard_1 icon
  /// Name clipboard_1 turns into flutterish clipboardAlt
  const LineIcon.clipboardAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.clipboardAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for newspaper_1 icon
  /// Name newspaper_1 turns into flutterish newspaperAlt
  const LineIcon.newspaperAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.newspaperAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hand_pointing_left_1 icon
  /// Name hand_pointing_left_1 turns into flutterish handPointingLeftAlt
  const LineIcon.handPointingLeftAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.handPointingLeftAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for object_group_1 icon
  /// Name object_group_1 turns into flutterish objectGroupAlt
  const LineIcon.objectGroupAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.objectGroupAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for image_1 icon
  /// Name image_1 turns into flutterish imageAlt
  const LineIcon.imageAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.imageAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for keyboard_1 icon
  /// Name keyboard_1 turns into flutterish keyboardAlt
  const LineIcon.keyboardAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.keyboardAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for grinning_squinting_face_1 icon
  /// Name grinning_squinting_face_1 turns into flutterish grinningSquintingFaceAlt
  const LineIcon.grinningSquintingFaceAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.grinningSquintingFaceAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hand_pointing_down_1 icon
  /// Name hand_pointing_down_1 turns into flutterish handPointingDownAlt
  const LineIcon.handPointingDownAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.handPointingDownAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for gem_1 icon
  /// Name gem_1 turns into flutterish gemAlt
  const LineIcon.gemAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.gemAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for kissing_face_with_smiling_eyes_1 icon
  /// Name kissing_face_with_smiling_eyes_1 turns into flutterish kissingFaceWithSmilingEyesAlt
  const LineIcon.kissingFaceWithSmilingEyesAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.kissingFaceWithSmilingEyesAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for address_book_1 icon
  /// Name address_book_1 turns into flutterish addressBookAlt
  const LineIcon.addressBookAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.addressBookAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for face_without_mouth_1 icon
  /// Name face_without_mouth_1 turns into flutterish faceWithoutMouthAlt
  const LineIcon.faceWithoutMouthAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.faceWithoutMouthAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for paper_plane_1 icon
  /// Name paper_plane_1 turns into flutterish paperPlaneAlt
  const LineIcon.paperPlaneAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.paperPlaneAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_arrow_circle_up_1 icon
  /// Name alternate_arrow_circle_up_1 turns into flutterish alternateArrowCircleUpAlt
  const LineIcon.alternateArrowCircleUpAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateArrowCircleUpAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for play_circle_1 icon
  /// Name play_circle_1 turns into flutterish playCircleAlt
  const LineIcon.playCircleAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.playCircleAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for image_file_1 icon
  /// Name image_file_1 turns into flutterish imageFileAlt
  const LineIcon.imageFileAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.imageFileAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dizzy_face_1 icon
  /// Name dizzy_face_1 turns into flutterish dizzyFaceAlt
  const LineIcon.dizzyFaceAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dizzyFaceAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for laughing_winking_face_1 icon
  /// Name laughing_winking_face_1 turns into flutterish laughingWinkingFaceAlt
  const LineIcon.laughingWinkingFaceAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.laughingWinkingFaceAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_money_bill_1 icon
  /// Name alternate_money_bill_1 turns into flutterish alternateMoneyBillAlt
  const LineIcon.alternateMoneyBillAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateMoneyBillAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for calendar_times_1 icon
  /// Name calendar_times_1 turns into flutterish calendarTimesAlt
  const LineIcon.calendarTimesAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.calendarTimesAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for rolling_on_the_floor_laughing_1 icon
  /// Name rolling_on_the_floor_laughing_1 turns into flutterish rollingOnTheFloorLaughingAlt
  const LineIcon.rollingOnTheFloorLaughingAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.rollingOnTheFloorLaughingAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for times_circle_1 icon
  /// Name times_circle_1 turns into flutterish timesCircleAlt
  const LineIcon.timesCircleAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.timesCircleAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for calendar_plus_1 icon
  /// Name calendar_plus_1 turns into flutterish calendarPlusAlt
  const LineIcon.calendarPlusAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.calendarPlusAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for crying_face_1 icon
  /// Name crying_face_1 turns into flutterish cryingFaceAlt
  const LineIcon.cryingFaceAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cryingFaceAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for powerpoint_file_1 icon
  /// Name powerpoint_file_1 turns into flutterish powerpointFileAlt
  const LineIcon.powerpointFileAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.powerpointFileAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hdd_1 icon
  /// Name hdd_1 turns into flutterish hddAlt
  const LineIcon.hddAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hddAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hourglass_1 icon
  /// Name hourglass_1 turns into flutterish hourglassAlt
  const LineIcon.hourglassAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hourglassAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for credit_card_1 icon
  /// Name credit_card_1 turns into flutterish creditCardAlt
  const LineIcon.creditCardAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.creditCardAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bell_slash_1 icon
  /// Name bell_slash_1 turns into flutterish bellSlashAlt
  const LineIcon.bellSlashAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bellSlashAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for lemon_1 icon
  /// Name lemon_1 turns into flutterish lemonAlt
  const LineIcon.lemonAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.lemonAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_grinning_face_1 icon
  /// Name alternate_grinning_face_1 turns into flutterish alternateGrinningFaceAlt
  const LineIcon.alternateGrinningFaceAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateGrinningFaceAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_arrow_circle_right_1 icon
  /// Name alternate_arrow_circle_right_1 turns into flutterish alternateArrowCircleRightAlt
  const LineIcon.alternateArrowCircleRightAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateArrowCircleRightAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for archive_file_1 icon
  /// Name archive_file_1 turns into flutterish archiveFileAlt
  const LineIcon.archiveFileAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.archiveFileAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for lizard__hand__1 icon
  /// Name lizard__hand__1 turns into flutterish lizardHandAlt
  const LineIcon.lizardHandAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.lizardHandAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for laughing_squinting_face_1 icon
  /// Name laughing_squinting_face_1 turns into flutterish laughingSquintingFaceAlt
  const LineIcon.laughingSquintingFaceAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.laughingSquintingFaceAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for grinning_face_1 icon
  /// Name grinning_face_1 turns into flutterish grinningFaceAlt
  const LineIcon.grinningFaceAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.grinningFaceAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for thumbs_up_1 icon
  /// Name thumbs_up_1 turns into flutterish thumbsUpAlt
  const LineIcon.thumbsUpAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.thumbsUpAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hospital_1 icon
  /// Name hospital_1 turns into flutterish hospitalAlt
  const LineIcon.hospitalAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hospitalAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for kissing_face_1 icon
  /// Name kissing_face_1 turns into flutterish kissingFaceAlt
  const LineIcon.kissingFaceAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.kissingFaceAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for face_blowing_a_kiss_1 icon
  /// Name face_blowing_a_kiss_1 turns into flutterish faceBlowingAKissAlt
  const LineIcon.faceBlowingAKissAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.faceBlowingAKissAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bar_chart_1 icon
  /// Name bar_chart_1 turns into flutterish barChartAlt
  const LineIcon.barChartAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.barChartAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for heart_1 icon
  /// Name heart_1 turns into flutterish heartAlt
  const LineIcon.heartAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.heartAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_comment_1 icon
  /// Name alternate_comment_1 turns into flutterish alternateCommentAlt
  const LineIcon.alternateCommentAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateCommentAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for plus_square_1 icon
  /// Name plus_square_1 turns into flutterish plusSquareAlt
  const LineIcon.plusSquareAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.plusSquareAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_list_1 icon
  /// Name alternate_list_1 turns into flutterish alternateListAlt
  const LineIcon.alternateListAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateListAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for smiling_face_with_heart_eyes_1 icon
  /// Name smiling_face_with_heart_eyes_1 turns into flutterish smilingFaceWithHeartEyesAlt
  const LineIcon.smilingFaceWithHeartEyesAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.smilingFaceWithHeartEyesAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_arrow_circle_left_1 icon
  /// Name alternate_arrow_circle_left_1 turns into flutterish alternateArrowCircleLeftAlt
  const LineIcon.alternateArrowCircleLeftAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateArrowCircleLeftAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for frowning_face_with_open_mouth_1 icon
  /// Name frowning_face_with_open_mouth_1 turns into flutterish frowningFaceWithOpenMouthAlt
  const LineIcon.frowningFaceWithOpenMouthAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.frowningFaceWithOpenMouthAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for tired_face_1 icon
  /// Name tired_face_1 turns into flutterish tiredFaceAlt
  const LineIcon.tiredFaceAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tiredFaceAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for peace__hand__1 icon
  /// Name peace__hand__1 turns into flutterish peaceHandAlt
  const LineIcon.peaceHandAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.peaceHandAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for calendar_minus_1 icon
  /// Name calendar_minus_1 turns into flutterish calendarMinusAlt
  const LineIcon.calendarMinusAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.calendarMinusAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for lightbulb_1 icon
  /// Name lightbulb_1 turns into flutterish lightbulbAlt
  const LineIcon.lightbulbAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.lightbulbAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for check_square_1 icon
  /// Name check_square_1 turns into flutterish checkSquareAlt
  const LineIcon.checkSquareAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.checkSquareAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for user_1 icon
  /// Name user_1 turns into flutterish userAlt
  const LineIcon.userAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.userAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for spock__hand__1 icon
  /// Name spock__hand__1 turns into flutterish spockHandAlt
  const LineIcon.spockHandAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.spockHandAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for identification_card_1 icon
  /// Name identification_card_1 turns into flutterish identificationCardAlt
  const LineIcon.identificationCardAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.identificationCardAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for calendar_check_1 icon
  /// Name calendar_check_1 turns into flutterish calendarCheckAlt
  const LineIcon.calendarCheckAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.calendarCheckAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for moon_1 icon
  /// Name moon_1 turns into flutterish moonAlt
  const LineIcon.moonAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.moonAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for calendar_1 icon
  /// Name calendar_1 turns into flutterish calendarAlt
  const LineIcon.calendarAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.calendarAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for file_1 icon
  /// Name file_1 turns into flutterish fileAlt
  const LineIcon.fileAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fileAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for clock_1 icon
  /// Name clock_1 turns into flutterish clockAlt
  const LineIcon.clockAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.clockAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sun_1 icon
  /// Name sun_1 turns into flutterish sunAlt
  const LineIcon.sunAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sunAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hand_pointing_up_1 icon
  /// Name hand_pointing_up_1 turns into flutterish handPointingUpAlt
  const LineIcon.handPointingUpAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.handPointingUpAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for user_circle_1 icon
  /// Name user_circle_1 turns into flutterish userCircleAlt
  const LineIcon.userCircleAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.userCircleAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for envelope_open_1 icon
  /// Name envelope_open_1 turns into flutterish envelopeOpenAlt
  const LineIcon.envelopeOpenAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.envelopeOpenAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for edit_1 icon
  /// Name edit_1 turns into flutterish editAlt
  const LineIcon.editAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.editAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for circle_1 icon
  /// Name circle_1 turns into flutterish circleAlt
  const LineIcon.circleAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.circleAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for word_file_1 icon
  /// Name word_file_1 turns into flutterish wordFileAlt
  const LineIcon.wordFileAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wordFileAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_file_1 icon
  /// Name alternate_file_1 turns into flutterish alternateFileAlt
  const LineIcon.alternateFileAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateFileAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for flushed_face_1 icon
  /// Name flushed_face_1 turns into flutterish flushedFaceAlt
  const LineIcon.flushedFaceAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.flushedFaceAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for life_ring_1 icon
  /// Name life_ring_1 turns into flutterish lifeRingAlt
  const LineIcon.lifeRingAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.lifeRingAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for caret_square_right_1 icon
  /// Name caret_square_right_1 turns into flutterish caretSquareRightAlt
  const LineIcon.caretSquareRightAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.caretSquareRightAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for beaming_face_with_smiling_eyes_1 icon
  /// Name beaming_face_with_smiling_eyes_1 turns into flutterish beamingFaceWithSmilingEyesAlt
  const LineIcon.beamingFaceWithSmilingEyesAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.beamingFaceWithSmilingEyesAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for square_1 icon
  /// Name square_1 turns into flutterish squareAlt
  const LineIcon.squareAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.squareAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for question_circle_1 icon
  /// Name question_circle_1 turns into flutterish questionCircleAlt
  const LineIcon.questionCircleAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.questionCircleAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for eye_1 icon
  /// Name eye_1 turns into flutterish eyeAlt
  const LineIcon.eyeAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.eyeAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pdf_file_1 icon
  /// Name pdf_file_1 turns into flutterish pdfFileAlt
  const LineIcon.pdfFileAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pdfFileAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for frowning_face_1 icon
  /// Name frowning_face_1 turns into flutterish frowningFaceAlt
  const LineIcon.frowningFaceAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.frowningFaceAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for window_minimize_1 icon
  /// Name window_minimize_1 turns into flutterish windowMinimizeAlt
  const LineIcon.windowMinimizeAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.windowMinimizeAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for registered_trademark_1 icon
  /// Name registered_trademark_1 turns into flutterish registeredTrademarkAlt
  const LineIcon.registeredTrademarkAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.registeredTrademarkAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for comment_dots_1 icon
  /// Name comment_dots_1 turns into flutterish commentDotsAlt
  const LineIcon.commentDotsAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.commentDotsAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for winking_face_with_tongue_1 icon
  /// Name winking_face_with_tongue_1 turns into flutterish winkingFaceWithTongueAlt
  const LineIcon.winkingFaceWithTongueAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.winkingFaceWithTongueAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for futbol_1 icon
  /// Name futbol_1 turns into flutterish futbolAlt
  const LineIcon.futbolAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.futbolAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for clone_1 icon
  /// Name clone_1 turns into flutterish cloneAlt
  const LineIcon.cloneAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cloneAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for share_square_1 icon
  /// Name share_square_1 turns into flutterish shareSquareAlt
  const LineIcon.shareSquareAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.shareSquareAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for copyright_1 icon
  /// Name copyright_1 turns into flutterish copyrightAlt
  const LineIcon.copyrightAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.copyrightAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bell_1 icon
  /// Name bell_1 turns into flutterish bellAlt
  const LineIcon.bellAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bellAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for paper__hand__1 icon
  /// Name paper__hand__1 turns into flutterish paperHandAlt
  const LineIcon.paperHandAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.paperHandAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for scissors__hand__1 icon
  /// Name scissors__hand__1 turns into flutterish scissorsHandAlt
  const LineIcon.scissorsHandAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.scissorsHandAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bookmark_1 icon
  /// Name bookmark_1 turns into flutterish bookmarkAlt
  const LineIcon.bookmarkAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bookmarkAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for grimacing_face_1 icon
  /// Name grimacing_face_1 turns into flutterish grimacingFaceAlt
  const LineIcon.grimacingFaceAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.grimacingFaceAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for check_circle_1 icon
  /// Name check_circle_1 turns into flutterish checkCircleAlt
  const LineIcon.checkCircleAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.checkCircleAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_calendar_1 icon
  /// Name alternate_calendar_1 turns into flutterish alternateCalendarAlt
  const LineIcon.alternateCalendarAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateCalendarAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for handshake_1 icon
  /// Name handshake_1 turns into flutterish handshakeAlt
  const LineIcon.handshakeAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.handshakeAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for grinning_face_with_sweat_1 icon
  /// Name grinning_face_with_sweat_1 turns into flutterish grinningFaceWithSweatAlt
  const LineIcon.grinningFaceWithSweatAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.grinningFaceWithSweatAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for identification_badge_1 icon
  /// Name identification_badge_1 turns into flutterish identificationBadgeAlt
  const LineIcon.identificationBadgeAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.identificationBadgeAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for rock__hand__1 icon
  /// Name rock__hand__1 turns into flutterish rockHandAlt
  const LineIcon.rockHandAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.rockHandAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for face_with_rolling_eyes_1 icon
  /// Name face_with_rolling_eyes_1 turns into flutterish faceWithRollingEyesAlt
  const LineIcon.faceWithRollingEyesAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.faceWithRollingEyesAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_trash_1 icon
  /// Name alternate_trash_1 turns into flutterish alternateTrashAlt
  const LineIcon.alternateTrashAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateTrashAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for martini_glass icon
  /// Name martini_glass turns into flutterish martiniGlass
  const LineIcon.martiniGlass({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.martiniGlass,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for music icon
  /// Name music turns into flutterish music
  const LineIcon.music({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.music,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for search icon
  /// Name search turns into flutterish search
  const LineIcon.search({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.search,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for heart icon
  /// Name heart turns into flutterish heart
  const LineIcon.heart({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.heart,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for star icon
  /// Name star turns into flutterish star
  const LineIcon.star({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.star,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for user icon
  /// Name user turns into flutterish user
  const LineIcon.user({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.user,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for film icon
  /// Name film turns into flutterish film
  const LineIcon.film({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.film,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for th_large icon
  /// Name th_large turns into flutterish thLarge
  const LineIcon.thLarge({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.thLarge,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for th icon
  /// Name th turns into flutterish th
  const LineIcon.th({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.th,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for th_list icon
  /// Name th_list turns into flutterish thList
  const LineIcon.thList({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.thList,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for check icon
  /// Name check turns into flutterish check
  const LineIcon.check({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.check,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for times icon
  /// Name times turns into flutterish times
  const LineIcon.times({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.times,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for search_plus icon
  /// Name search_plus turns into flutterish searchPlus
  const LineIcon.searchPlus({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.searchPlus,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for search_minus icon
  /// Name search_minus turns into flutterish searchMinus
  const LineIcon.searchMinus({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.searchMinus,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for power_off icon
  /// Name power_off turns into flutterish powerOff
  const LineIcon.powerOff({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.powerOff,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for signal icon
  /// Name signal turns into flutterish signal
  const LineIcon.signal({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.signal,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cog icon
  /// Name cog turns into flutterish cog
  const LineIcon.cog({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cog,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for home icon
  /// Name home turns into flutterish home
  const LineIcon.home({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.home,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for clock icon
  /// Name clock turns into flutterish clock
  const LineIcon.clock({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.clock,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for road icon
  /// Name road turns into flutterish road
  const LineIcon.road({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.road,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for download icon
  /// Name download turns into flutterish download
  const LineIcon.download({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.download,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for inbox icon
  /// Name inbox turns into flutterish inbox
  const LineIcon.inbox({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.inbox,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for redo icon
  /// Name redo turns into flutterish redo
  const LineIcon.redo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.redo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sync_icon icon
  /// Name sync_icon turns into flutterish syncIcon
  const LineIcon.syncIcon({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.syncIcon,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_list icon
  /// Name alternate_list turns into flutterish alternateList
  const LineIcon.alternateList({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateList,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for lock icon
  /// Name lock turns into flutterish lock
  const LineIcon.lock({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.lock,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for flag icon
  /// Name flag turns into flutterish flag
  const LineIcon.flag({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.flag,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for headphones icon
  /// Name headphones turns into flutterish headphones
  const LineIcon.headphones({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.headphones,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for volume_off icon
  /// Name volume_off turns into flutterish volumeOff
  const LineIcon.volumeOff({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.volumeOff,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for volume_down icon
  /// Name volume_down turns into flutterish volumeDown
  const LineIcon.volumeDown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.volumeDown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for volume_up icon
  /// Name volume_up turns into flutterish volumeUp
  const LineIcon.volumeUp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.volumeUp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for qrcode icon
  /// Name qrcode turns into flutterish qrcode
  const LineIcon.qrcode({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.qrcode,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for barcode icon
  /// Name barcode turns into flutterish barcode
  const LineIcon.barcode({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.barcode,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for tag icon
  /// Name tag turns into flutterish tag
  const LineIcon.tag({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tag,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for tags icon
  /// Name tags turns into flutterish tags
  const LineIcon.tags({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tags,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for book icon
  /// Name book turns into flutterish book
  const LineIcon.book({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.book,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bookmark icon
  /// Name bookmark turns into flutterish bookmark
  const LineIcon.bookmark({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bookmark,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for print icon
  /// Name print turns into flutterish print
  const LineIcon.print({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.print,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for camera icon
  /// Name camera turns into flutterish camera
  const LineIcon.camera({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.camera,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for font icon
  /// Name font turns into flutterish font
  const LineIcon.font({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.font,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bold icon
  /// Name bold turns into flutterish bold
  const LineIcon.bold({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bold,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for italic icon
  /// Name italic turns into flutterish italic
  const LineIcon.italic({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.italic,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for text_height icon
  /// Name text_height turns into flutterish textHeight
  const LineIcon.textHeight({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.textHeight,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for text_width icon
  /// Name text_width turns into flutterish textWidth
  const LineIcon.textWidth({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.textWidth,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for align_left icon
  /// Name align_left turns into flutterish alignLeft
  const LineIcon.alignLeft({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alignLeft,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for align_center icon
  /// Name align_center turns into flutterish alignCenter
  const LineIcon.alignCenter({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alignCenter,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for align_right icon
  /// Name align_right turns into flutterish alignRight
  const LineIcon.alignRight({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alignRight,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for align_justify icon
  /// Name align_justify turns into flutterish alignJustify
  const LineIcon.alignJustify({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alignJustify,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for list icon
  /// Name list turns into flutterish list
  const LineIcon.list({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.list,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for outdent icon
  /// Name outdent turns into flutterish outdent
  const LineIcon.outdent({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.outdent,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for indent icon
  /// Name indent turns into flutterish indent
  const LineIcon.indent({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.indent,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for video icon
  /// Name video turns into flutterish video
  const LineIcon.video({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.video,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for image icon
  /// Name image turns into flutterish image
  const LineIcon.image({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.image,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for map_marker icon
  /// Name map_marker turns into flutterish mapMarker
  const LineIcon.mapMarker({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mapMarker,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for adjust icon
  /// Name adjust turns into flutterish adjust
  const LineIcon.adjust({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.adjust,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for tint icon
  /// Name tint turns into flutterish tint
  const LineIcon.tint({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tint,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for edit icon
  /// Name edit turns into flutterish edit
  const LineIcon.edit({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.edit,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for step_backward icon
  /// Name step_backward turns into flutterish stepBackward
  const LineIcon.stepBackward({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.stepBackward,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for fast_backward icon
  /// Name fast_backward turns into flutterish fastBackward
  const LineIcon.fastBackward({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fastBackward,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for backward icon
  /// Name backward turns into flutterish backward
  const LineIcon.backward({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.backward,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for play icon
  /// Name play turns into flutterish play
  const LineIcon.play({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.play,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pause icon
  /// Name pause turns into flutterish pause
  const LineIcon.pause({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pause,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for stop icon
  /// Name stop turns into flutterish stop
  const LineIcon.stop({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.stop,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for forward icon
  /// Name forward turns into flutterish forward
  const LineIcon.forward({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.forward,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for fast_forward icon
  /// Name fast_forward turns into flutterish fastForward
  const LineIcon.fastForward({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fastForward,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for step_forward icon
  /// Name step_forward turns into flutterish stepForward
  const LineIcon.stepForward({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.stepForward,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for eject icon
  /// Name eject turns into flutterish eject
  const LineIcon.eject({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.eject,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for chevron_left icon
  /// Name chevron_left turns into flutterish chevronLeft
  const LineIcon.chevronLeft({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.chevronLeft,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for chevron_right icon
  /// Name chevron_right turns into flutterish chevronRight
  const LineIcon.chevronRight({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.chevronRight,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for plus_circle icon
  /// Name plus_circle turns into flutterish plusCircle
  const LineIcon.plusCircle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.plusCircle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for minus_circle icon
  /// Name minus_circle turns into flutterish minusCircle
  const LineIcon.minusCircle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.minusCircle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for times_circle icon
  /// Name times_circle turns into flutterish timesCircle
  const LineIcon.timesCircle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.timesCircle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for check_circle icon
  /// Name check_circle turns into flutterish checkCircle
  const LineIcon.checkCircle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.checkCircle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for question_circle icon
  /// Name question_circle turns into flutterish questionCircle
  const LineIcon.questionCircle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.questionCircle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for info_circle icon
  /// Name info_circle turns into flutterish infoCircle
  const LineIcon.infoCircle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.infoCircle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for crosshairs icon
  /// Name crosshairs turns into flutterish crosshairs
  const LineIcon.crosshairs({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.crosshairs,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ban icon
  /// Name ban turns into flutterish ban
  const LineIcon.ban({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.ban,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for arrow_left icon
  /// Name arrow_left turns into flutterish arrowLeft
  const LineIcon.arrowLeft({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.arrowLeft,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for arrow_right icon
  /// Name arrow_right turns into flutterish arrowRight
  const LineIcon.arrowRight({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.arrowRight,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for arrow_up icon
  /// Name arrow_up turns into flutterish arrowUp
  const LineIcon.arrowUp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.arrowUp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for arrow_down icon
  /// Name arrow_down turns into flutterish arrowDown
  const LineIcon.arrowDown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.arrowDown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for share icon
  /// Name share turns into flutterish share
  const LineIcon.share({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.share,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for expand icon
  /// Name expand turns into flutterish expand
  const LineIcon.expand({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.expand,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for compress icon
  /// Name compress turns into flutterish compress
  const LineIcon.compress({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.compress,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for plus icon
  /// Name plus turns into flutterish plus
  const LineIcon.plus({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.plus,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for minus icon
  /// Name minus turns into flutterish minus
  const LineIcon.minus({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.minus,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for asterisk icon
  /// Name asterisk turns into flutterish asterisk
  const LineIcon.asterisk({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.asterisk,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for exclamation_circle icon
  /// Name exclamation_circle turns into flutterish exclamationCircle
  const LineIcon.exclamationCircle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.exclamationCircle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for gift icon
  /// Name gift turns into flutterish gift
  const LineIcon.gift({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.gift,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for leaf icon
  /// Name leaf turns into flutterish leaf
  const LineIcon.leaf({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.leaf,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for fire icon
  /// Name fire turns into flutterish fire
  const LineIcon.fire({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fire,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for eye icon
  /// Name eye turns into flutterish eye
  const LineIcon.eye({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.eye,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for eye_slash icon
  /// Name eye_slash turns into flutterish eyeSlash
  const LineIcon.eyeSlash({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.eyeSlash,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for exclamation_triangle icon
  /// Name exclamation_triangle turns into flutterish exclamationTriangle
  const LineIcon.exclamationTriangle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.exclamationTriangle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for plane icon
  /// Name plane turns into flutterish plane
  const LineIcon.plane({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.plane,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_calendar icon
  /// Name alternate_calendar turns into flutterish alternateCalendar
  const LineIcon.alternateCalendar({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateCalendar,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for random icon
  /// Name random turns into flutterish random
  const LineIcon.random({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.random,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for comment icon
  /// Name comment turns into flutterish comment
  const LineIcon.comment({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.comment,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for magnet icon
  /// Name magnet turns into flutterish magnet
  const LineIcon.magnet({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.magnet,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for chevron_up icon
  /// Name chevron_up turns into flutterish chevronUp
  const LineIcon.chevronUp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.chevronUp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for chevron_down icon
  /// Name chevron_down turns into flutterish chevronDown
  const LineIcon.chevronDown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.chevronDown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for retweet icon
  /// Name retweet turns into flutterish retweet
  const LineIcon.retweet({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.retweet,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for shopping_cart icon
  /// Name shopping_cart turns into flutterish shoppingCart
  const LineIcon.shoppingCart({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.shoppingCart,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for folder icon
  /// Name folder turns into flutterish folder
  const LineIcon.folder({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.folder,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for folder_open icon
  /// Name folder_open turns into flutterish folderOpen
  const LineIcon.folderOpen({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.folderOpen,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bar_chart icon
  /// Name bar_chart turns into flutterish barChart
  const LineIcon.barChart({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.barChart,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for twitter_square icon
  /// Name twitter_square turns into flutterish twitterSquare
  const LineIcon.twitterSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.twitterSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for facebook_square icon
  /// Name facebook_square turns into flutterish facebookSquare
  const LineIcon.facebookSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.facebookSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for retro_camera icon
  /// Name retro_camera turns into flutterish retroCamera
  const LineIcon.retroCamera({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.retroCamera,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for key icon
  /// Name key turns into flutterish key
  const LineIcon.key({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.key,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cogs icon
  /// Name cogs turns into flutterish cogs
  const LineIcon.cogs({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cogs,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for comments icon
  /// Name comments turns into flutterish comments
  const LineIcon.comments({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.comments,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for star_half icon
  /// Name star_half turns into flutterish starHalf
  const LineIcon.starHalf({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.starHalf,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for linkedin icon
  /// Name linkedin turns into flutterish linkedin
  const LineIcon.linkedin({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.linkedin,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for thumbtack icon
  /// Name thumbtack turns into flutterish thumbtack
  const LineIcon.thumbtack({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.thumbtack,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for trophy icon
  /// Name trophy turns into flutterish trophy
  const LineIcon.trophy({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.trophy,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for github_square icon
  /// Name github_square turns into flutterish githubSquare
  const LineIcon.githubSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.githubSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for upload icon
  /// Name upload turns into flutterish upload
  const LineIcon.upload({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.upload,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for lemon icon
  /// Name lemon turns into flutterish lemon
  const LineIcon.lemon({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.lemon,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for phone icon
  /// Name phone turns into flutterish phone
  const LineIcon.phone({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.phone,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for phone_square icon
  /// Name phone_square turns into flutterish phoneSquare
  const LineIcon.phoneSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.phoneSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for twitter icon
  /// Name twitter turns into flutterish twitter
  const LineIcon.twitter({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.twitter,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for facebook icon
  /// Name facebook turns into flutterish facebook
  const LineIcon.facebook({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.facebook,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for github icon
  /// Name github turns into flutterish github
  const LineIcon.github({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.github,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for unlock icon
  /// Name unlock turns into flutterish unlock
  const LineIcon.unlock({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.unlock,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for credit_card icon
  /// Name credit_card turns into flutterish creditCard
  const LineIcon.creditCard({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.creditCard,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for rss icon
  /// Name rss turns into flutterish rss
  const LineIcon.rss({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.rss,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hdd icon
  /// Name hdd turns into flutterish hdd
  const LineIcon.hdd({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hdd,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bullhorn icon
  /// Name bullhorn turns into flutterish bullhorn
  const LineIcon.bullhorn({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bullhorn,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for certificate icon
  /// Name certificate turns into flutterish certificate
  const LineIcon.certificate({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.certificate,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hand_pointing_right icon
  /// Name hand_pointing_right turns into flutterish handPointingRight
  const LineIcon.handPointingRight({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.handPointingRight,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hand_pointing_left icon
  /// Name hand_pointing_left turns into flutterish handPointingLeft
  const LineIcon.handPointingLeft({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.handPointingLeft,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hand_pointing_up icon
  /// Name hand_pointing_up turns into flutterish handPointingUp
  const LineIcon.handPointingUp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.handPointingUp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hand_pointing_down icon
  /// Name hand_pointing_down turns into flutterish handPointingDown
  const LineIcon.handPointingDown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.handPointingDown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for arrow_circle_left icon
  /// Name arrow_circle_left turns into flutterish arrowCircleLeft
  const LineIcon.arrowCircleLeft({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.arrowCircleLeft,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for arrow_circle_right icon
  /// Name arrow_circle_right turns into flutterish arrowCircleRight
  const LineIcon.arrowCircleRight({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.arrowCircleRight,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for arrow_circle_up icon
  /// Name arrow_circle_up turns into flutterish arrowCircleUp
  const LineIcon.arrowCircleUp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.arrowCircleUp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for arrow_circle_down icon
  /// Name arrow_circle_down turns into flutterish arrowCircleDown
  const LineIcon.arrowCircleDown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.arrowCircleDown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for globe icon
  /// Name globe turns into flutterish globe
  const LineIcon.globe({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.globe,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for wrench icon
  /// Name wrench turns into flutterish wrench
  const LineIcon.wrench({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wrench,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for tasks icon
  /// Name tasks turns into flutterish tasks
  const LineIcon.tasks({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tasks,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for filter icon
  /// Name filter turns into flutterish filter
  const LineIcon.filter({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.filter,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for briefcase icon
  /// Name briefcase turns into flutterish briefcase
  const LineIcon.briefcase({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.briefcase,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_arrows icon
  /// Name alternate_arrows turns into flutterish alternateArrows
  const LineIcon.alternateArrows({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateArrows,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for users icon
  /// Name users turns into flutterish users
  const LineIcon.users({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.users,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for link icon
  /// Name link turns into flutterish link
  const LineIcon.link({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.link,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cloud icon
  /// Name cloud turns into flutterish cloud
  const LineIcon.cloud({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cloud,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for flask icon
  /// Name flask turns into flutterish flask
  const LineIcon.flask({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.flask,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cut icon
  /// Name cut turns into flutterish cut
  const LineIcon.cut({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cut,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for copy icon
  /// Name copy turns into flutterish copy
  const LineIcon.copy({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.copy,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for paperclip icon
  /// Name paperclip turns into flutterish paperclip
  const LineIcon.paperclip({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.paperclip,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for save icon
  /// Name save turns into flutterish save
  const LineIcon.save({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.save,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for square icon
  /// Name square turns into flutterish square
  const LineIcon.square({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.square,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bars icon
  /// Name bars turns into flutterish bars
  const LineIcon.bars({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bars,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for list_ul icon
  /// Name list_ul turns into flutterish listUl
  const LineIcon.listUl({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.listUl,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for list_ol icon
  /// Name list_ol turns into flutterish listOl
  const LineIcon.listOl({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.listOl,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for strikethrough icon
  /// Name strikethrough turns into flutterish strikethrough
  const LineIcon.strikethrough({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.strikethrough,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for underline icon
  /// Name underline turns into flutterish underline
  const LineIcon.underline({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.underline,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for table icon
  /// Name table turns into flutterish table
  const LineIcon.table({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.table,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for magic icon
  /// Name magic turns into flutterish magic
  const LineIcon.magic({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.magic,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for truck icon
  /// Name truck turns into flutterish truck
  const LineIcon.truck({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.truck,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pinterest icon
  /// Name pinterest turns into flutterish pinterest
  const LineIcon.pinterest({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pinterest,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pinterest_square icon
  /// Name pinterest_square turns into flutterish pinterestSquare
  const LineIcon.pinterestSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pinterestSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for google_plus_square icon
  /// Name google_plus_square turns into flutterish googlePlusSquare
  const LineIcon.googlePlusSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.googlePlusSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for google_plus_g icon
  /// Name google_plus_g turns into flutterish googlePlusG
  const LineIcon.googlePlusG({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.googlePlusG,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for money_bill icon
  /// Name money_bill turns into flutterish moneyBill
  const LineIcon.moneyBill({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.moneyBill,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for caret_down icon
  /// Name caret_down turns into flutterish caretDown
  const LineIcon.caretDown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.caretDown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for caret_up icon
  /// Name caret_up turns into flutterish caretUp
  const LineIcon.caretUp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.caretUp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for caret_left icon
  /// Name caret_left turns into flutterish caretLeft
  const LineIcon.caretLeft({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.caretLeft,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for caret_right icon
  /// Name caret_right turns into flutterish caretRight
  const LineIcon.caretRight({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.caretRight,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for columns icon
  /// Name columns turns into flutterish columns
  const LineIcon.columns({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.columns,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sort icon
  /// Name sort turns into flutterish sort
  const LineIcon.sort({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sort,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sort_down__descending_ icon
  /// Name sort_down__descending_ turns into flutterish sortDownDescending
  const LineIcon.sortDownDescending({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sortDownDescending,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sort_up__ascending_ icon
  /// Name sort_up__ascending_ turns into flutterish sortUpAscending
  const LineIcon.sortUpAscending({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sortUpAscending,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for envelope icon
  /// Name envelope turns into flutterish envelope
  const LineIcon.envelope({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.envelope,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for linkedin_in icon
  /// Name linkedin_in turns into flutterish linkedinIn
  const LineIcon.linkedinIn({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.linkedinIn,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for undo icon
  /// Name undo turns into flutterish undo
  const LineIcon.undo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.undo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for gavel icon
  /// Name gavel turns into flutterish gavel
  const LineIcon.gavel({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.gavel,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for lightning_bolt icon
  /// Name lightning_bolt turns into flutterish lightningBolt
  const LineIcon.lightningBolt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.lightningBolt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sitemap icon
  /// Name sitemap turns into flutterish sitemap
  const LineIcon.sitemap({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sitemap,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for umbrella icon
  /// Name umbrella turns into flutterish umbrella
  const LineIcon.umbrella({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.umbrella,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for paste icon
  /// Name paste turns into flutterish paste
  const LineIcon.paste({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.paste,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for lightbulb icon
  /// Name lightbulb turns into flutterish lightbulb
  const LineIcon.lightbulb({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.lightbulb,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for doctor icon
  /// Name doctor turns into flutterish doctor
  const LineIcon.doctor({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.doctor,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for stethoscope icon
  /// Name stethoscope turns into flutterish stethoscope
  const LineIcon.stethoscope({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.stethoscope,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for suitcase icon
  /// Name suitcase turns into flutterish suitcase
  const LineIcon.suitcase({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.suitcase,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bell icon
  /// Name bell turns into flutterish bell
  const LineIcon.bell({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bell,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for coffee icon
  /// Name coffee turns into flutterish coffee
  const LineIcon.coffee({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.coffee,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hospital icon
  /// Name hospital turns into flutterish hospital
  const LineIcon.hospital({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hospital,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ambulance icon
  /// Name ambulance turns into flutterish ambulance
  const LineIcon.ambulance({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.ambulance,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for medkit icon
  /// Name medkit turns into flutterish medkit
  const LineIcon.medkit({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.medkit,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for fighter_jet icon
  /// Name fighter_jet turns into flutterish fighterJet
  const LineIcon.fighterJet({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fighterJet,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for beer icon
  /// Name beer turns into flutterish beer
  const LineIcon.beer({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.beer,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for h_square icon
  /// Name h_square turns into flutterish hSquare
  const LineIcon.hSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for plus_square icon
  /// Name plus_square turns into flutterish plusSquare
  const LineIcon.plusSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.plusSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for angle_double_left icon
  /// Name angle_double_left turns into flutterish angleDoubleLeft
  const LineIcon.angleDoubleLeft({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.angleDoubleLeft,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for angle_double_right icon
  /// Name angle_double_right turns into flutterish angleDoubleRight
  const LineIcon.angleDoubleRight({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.angleDoubleRight,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for angle_double_up icon
  /// Name angle_double_up turns into flutterish angleDoubleUp
  const LineIcon.angleDoubleUp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.angleDoubleUp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for angle_double_down icon
  /// Name angle_double_down turns into flutterish angleDoubleDown
  const LineIcon.angleDoubleDown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.angleDoubleDown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for angle_left icon
  /// Name angle_left turns into flutterish angleLeft
  const LineIcon.angleLeft({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.angleLeft,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for angle_right icon
  /// Name angle_right turns into flutterish angleRight
  const LineIcon.angleRight({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.angleRight,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for angle_up icon
  /// Name angle_up turns into flutterish angleUp
  const LineIcon.angleUp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.angleUp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for angle_down icon
  /// Name angle_down turns into flutterish angleDown
  const LineIcon.angleDown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.angleDown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for desktop icon
  /// Name desktop turns into flutterish desktop
  const LineIcon.desktop({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.desktop,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for laptop icon
  /// Name laptop turns into flutterish laptop
  const LineIcon.laptop({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.laptop,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for tablet icon
  /// Name tablet turns into flutterish tablet
  const LineIcon.tablet({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tablet,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mobile_phone icon
  /// Name mobile_phone turns into flutterish mobilePhone
  const LineIcon.mobilePhone({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mobilePhone,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for quote_left icon
  /// Name quote_left turns into flutterish quoteLeft
  const LineIcon.quoteLeft({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.quoteLeft,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for quote_right icon
  /// Name quote_right turns into flutterish quoteRight
  const LineIcon.quoteRight({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.quoteRight,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for spinner icon
  /// Name spinner turns into flutterish spinner
  const LineIcon.spinner({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.spinner,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for circle icon
  /// Name circle turns into flutterish circle
  const LineIcon.circle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.circle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_github icon
  /// Name alternate_github turns into flutterish alternateGithub
  const LineIcon.alternateGithub({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateGithub,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for smiling_face icon
  /// Name smiling_face turns into flutterish smilingFace
  const LineIcon.smilingFace({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.smilingFace,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for frowning_face icon
  /// Name frowning_face turns into flutterish frowningFace
  const LineIcon.frowningFace({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.frowningFace,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for neutral_face icon
  /// Name neutral_face turns into flutterish neutralFace
  const LineIcon.neutralFace({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.neutralFace,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for gamepad icon
  /// Name gamepad turns into flutterish gamepad
  const LineIcon.gamepad({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.gamepad,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for keyboard icon
  /// Name keyboard turns into flutterish keyboard
  const LineIcon.keyboard({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.keyboard,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for flag_checkered icon
  /// Name flag_checkered turns into flutterish flagCheckered
  const LineIcon.flagCheckered({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.flagCheckered,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for terminal icon
  /// Name terminal turns into flutterish terminal
  const LineIcon.terminal({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.terminal,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for code icon
  /// Name code turns into flutterish code
  const LineIcon.code({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.code,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for reply_all icon
  /// Name reply_all turns into flutterish replyAll
  const LineIcon.replyAll({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.replyAll,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for location_arrow icon
  /// Name location_arrow turns into flutterish locationArrow
  const LineIcon.locationArrow({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.locationArrow,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for crop icon
  /// Name crop turns into flutterish crop
  const LineIcon.crop({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.crop,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for code_branch icon
  /// Name code_branch turns into flutterish codeBranch
  const LineIcon.codeBranch({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.codeBranch,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for unlink icon
  /// Name unlink turns into flutterish unlink
  const LineIcon.unlink({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.unlink,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for question icon
  /// Name question turns into flutterish question
  const LineIcon.question({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.question,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for info icon
  /// Name info turns into flutterish info
  const LineIcon.info({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.info,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for exclamation icon
  /// Name exclamation turns into flutterish exclamation
  const LineIcon.exclamation({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.exclamation,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for superscript icon
  /// Name superscript turns into flutterish superscript
  const LineIcon.superscript({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.superscript,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for subscript icon
  /// Name subscript turns into flutterish subscript
  const LineIcon.subscript({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.subscript,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for eraser icon
  /// Name eraser turns into flutterish eraser
  const LineIcon.eraser({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.eraser,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for puzzle_piece icon
  /// Name puzzle_piece turns into flutterish puzzlePiece
  const LineIcon.puzzlePiece({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.puzzlePiece,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for microphone icon
  /// Name microphone turns into flutterish microphone
  const LineIcon.microphone({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.microphone,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for microphone_slash icon
  /// Name microphone_slash turns into flutterish microphoneSlash
  const LineIcon.microphoneSlash({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.microphoneSlash,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for calendar icon
  /// Name calendar turns into flutterish calendar
  const LineIcon.calendar({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.calendar,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for fire_extinguisher icon
  /// Name fire_extinguisher turns into flutterish fireExtinguisher
  const LineIcon.fireExtinguisher({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fireExtinguisher,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for rocket icon
  /// Name rocket turns into flutterish rocket
  const LineIcon.rocket({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.rocket,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for maxcdn icon
  /// Name maxcdn turns into flutterish maxcdn
  const LineIcon.maxcdn({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.maxcdn,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for chevron_circle_left icon
  /// Name chevron_circle_left turns into flutterish chevronCircleLeft
  const LineIcon.chevronCircleLeft({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.chevronCircleLeft,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for chevron_circle_right icon
  /// Name chevron_circle_right turns into flutterish chevronCircleRight
  const LineIcon.chevronCircleRight({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.chevronCircleRight,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for chevron_circle_up icon
  /// Name chevron_circle_up turns into flutterish chevronCircleUp
  const LineIcon.chevronCircleUp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.chevronCircleUp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for chevron_circle_down icon
  /// Name chevron_circle_down turns into flutterish chevronCircleDown
  const LineIcon.chevronCircleDown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.chevronCircleDown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for html_5_logo icon
  /// Name html_5_logo turns into flutterish html5Logo
  const LineIcon.html5Logo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.html5Logo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for css_3_logo icon
  /// Name css_3_logo turns into flutterish css3Logo
  const LineIcon.css3Logo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.css3Logo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for anchor icon
  /// Name anchor turns into flutterish anchor
  const LineIcon.anchor({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.anchor,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_unlock icon
  /// Name alternate_unlock turns into flutterish alternateUnlock
  const LineIcon.alternateUnlock({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateUnlock,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bullseye icon
  /// Name bullseye turns into flutterish bullseye
  const LineIcon.bullseye({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bullseye,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for horizontal_ellipsis icon
  /// Name horizontal_ellipsis turns into flutterish horizontalEllipsis
  const LineIcon.horizontalEllipsis({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.horizontalEllipsis,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for vertical_ellipsis icon
  /// Name vertical_ellipsis turns into flutterish verticalEllipsis
  const LineIcon.verticalEllipsis({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.verticalEllipsis,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for rss_square icon
  /// Name rss_square turns into flutterish rssSquare
  const LineIcon.rssSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.rssSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for play_circle icon
  /// Name play_circle turns into flutterish playCircle
  const LineIcon.playCircle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.playCircle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for minus_square icon
  /// Name minus_square turns into flutterish minusSquare
  const LineIcon.minusSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.minusSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for check_square icon
  /// Name check_square turns into flutterish checkSquare
  const LineIcon.checkSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.checkSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pen_square icon
  /// Name pen_square turns into flutterish penSquare
  const LineIcon.penSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.penSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for share_square icon
  /// Name share_square turns into flutterish shareSquare
  const LineIcon.shareSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.shareSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for compass icon
  /// Name compass turns into flutterish compass
  const LineIcon.compass({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.compass,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for caret_square_down icon
  /// Name caret_square_down turns into flutterish caretSquareDown
  const LineIcon.caretSquareDown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.caretSquareDown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for caret_square_up icon
  /// Name caret_square_up turns into flutterish caretSquareUp
  const LineIcon.caretSquareUp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.caretSquareUp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for caret_square_right icon
  /// Name caret_square_right turns into flutterish caretSquareRight
  const LineIcon.caretSquareRight({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.caretSquareRight,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for euro_sign icon
  /// Name euro_sign turns into flutterish euroSign
  const LineIcon.euroSign({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.euroSign,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pound_sign icon
  /// Name pound_sign turns into flutterish poundSign
  const LineIcon.poundSign({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.poundSign,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dollar_sign icon
  /// Name dollar_sign turns into flutterish dollarSign
  const LineIcon.dollarSign({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dollarSign,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for indian_rupee_sign icon
  /// Name indian_rupee_sign turns into flutterish indianRupeeSign
  const LineIcon.indianRupeeSign({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.indianRupeeSign,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for yen_sign icon
  /// Name yen_sign turns into flutterish yenSign
  const LineIcon.yenSign({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.yenSign,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ruble_sign icon
  /// Name ruble_sign turns into flutterish rubleSign
  const LineIcon.rubleSign({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.rubleSign,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for won_sign icon
  /// Name won_sign turns into flutterish wonSign
  const LineIcon.wonSign({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wonSign,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for btc icon
  /// Name btc turns into flutterish btc
  const LineIcon.btc({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.btc,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for file icon
  /// Name file turns into flutterish file
  const LineIcon.file({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.file,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_file icon
  /// Name alternate_file turns into flutterish alternateFile
  const LineIcon.alternateFile({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateFile,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sort_alphabetical_down icon
  /// Name sort_alphabetical_down turns into flutterish sortAlphabeticalDown
  const LineIcon.sortAlphabeticalDown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sortAlphabeticalDown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sort_alphabetical_up icon
  /// Name sort_alphabetical_up turns into flutterish sortAlphabeticalUp
  const LineIcon.sortAlphabeticalUp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sortAlphabeticalUp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sort_amount_down icon
  /// Name sort_amount_down turns into flutterish sortAmountDown
  const LineIcon.sortAmountDown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sortAmountDown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sort_amount_up icon
  /// Name sort_amount_up turns into flutterish sortAmountUp
  const LineIcon.sortAmountUp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sortAmountUp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sort_numeric_down icon
  /// Name sort_numeric_down turns into flutterish sortNumericDown
  const LineIcon.sortNumericDown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sortNumericDown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sort_numeric_up icon
  /// Name sort_numeric_up turns into flutterish sortNumericUp
  const LineIcon.sortNumericUp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sortNumericUp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for thumbs_up icon
  /// Name thumbs_up turns into flutterish thumbsUp
  const LineIcon.thumbsUp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.thumbsUp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for thumbs_down icon
  /// Name thumbs_down turns into flutterish thumbsDown
  const LineIcon.thumbsDown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.thumbsDown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for youtube icon
  /// Name youtube turns into flutterish youtube
  const LineIcon.youtube({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.youtube,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for xing icon
  /// Name xing turns into flutterish xing
  const LineIcon.xing({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.xing,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for xing_square icon
  /// Name xing_square turns into flutterish xingSquare
  const LineIcon.xingSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.xingSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dropbox icon
  /// Name dropbox turns into flutterish dropbox
  const LineIcon.dropbox({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dropbox,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for stack_overflow icon
  /// Name stack_overflow turns into flutterish stackOverflow
  const LineIcon.stackOverflow({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.stackOverflow,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for instagram icon
  /// Name instagram turns into flutterish instagram
  const LineIcon.instagram({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.instagram,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for flickr icon
  /// Name flickr turns into flutterish flickr
  const LineIcon.flickr({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.flickr,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for app_net icon
  /// Name app_net turns into flutterish appNet
  const LineIcon.appNet({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.appNet,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bitbucket icon
  /// Name bitbucket turns into flutterish bitbucket
  const LineIcon.bitbucket({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bitbucket,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for tumblr icon
  /// Name tumblr turns into flutterish tumblr
  const LineIcon.tumblr({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tumblr,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for tumblr_square icon
  /// Name tumblr_square turns into flutterish tumblrSquare
  const LineIcon.tumblrSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tumblrSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for apple icon
  /// Name apple turns into flutterish apple
  const LineIcon.apple({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.apple,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for windows icon
  /// Name windows turns into flutterish windows
  const LineIcon.windows({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.windows,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for android icon
  /// Name android turns into flutterish android
  const LineIcon.android({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.android,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for linux icon
  /// Name linux turns into flutterish linux
  const LineIcon.linux({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.linux,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dribbble icon
  /// Name dribbble turns into flutterish dribbble
  const LineIcon.dribbble({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dribbble,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for skype icon
  /// Name skype turns into flutterish skype
  const LineIcon.skype({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.skype,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for foursquare icon
  /// Name foursquare turns into flutterish foursquare
  const LineIcon.foursquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.foursquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for trello icon
  /// Name trello turns into flutterish trello
  const LineIcon.trello({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.trello,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for female icon
  /// Name female turns into flutterish female
  const LineIcon.female({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.female,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for male icon
  /// Name male turns into flutterish male
  const LineIcon.male({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.male,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for gratipay__gittip_ icon
  /// Name gratipay__gittip_ turns into flutterish gratipayGittip
  const LineIcon.gratipayGittip({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.gratipayGittip,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sun icon
  /// Name sun turns into flutterish sun
  const LineIcon.sun({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sun,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for moon icon
  /// Name moon turns into flutterish moon
  const LineIcon.moon({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.moon,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for archive icon
  /// Name archive turns into flutterish archive
  const LineIcon.archive({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.archive,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bug icon
  /// Name bug turns into flutterish bug
  const LineIcon.bug({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bug,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for vk icon
  /// Name vk turns into flutterish vk
  const LineIcon.vk({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.vk,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for weibo icon
  /// Name weibo turns into flutterish weibo
  const LineIcon.weibo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.weibo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for renren icon
  /// Name renren turns into flutterish renren
  const LineIcon.renren({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.renren,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pagelines icon
  /// Name pagelines turns into flutterish pagelines
  const LineIcon.pagelines({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pagelines,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for stack_exchange icon
  /// Name stack_exchange turns into flutterish stackExchange
  const LineIcon.stackExchange({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.stackExchange,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for caret_square_left icon
  /// Name caret_square_left turns into flutterish caretSquareLeft
  const LineIcon.caretSquareLeft({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.caretSquareLeft,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dot_circle icon
  /// Name dot_circle turns into flutterish dotCircle
  const LineIcon.dotCircle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dotCircle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for wheelchair icon
  /// Name wheelchair turns into flutterish wheelchair
  const LineIcon.wheelchair({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wheelchair,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for vimeo_square icon
  /// Name vimeo_square turns into flutterish vimeoSquare
  const LineIcon.vimeoSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.vimeoSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for turkish_lira_sign icon
  /// Name turkish_lira_sign turns into flutterish turkishLiraSign
  const LineIcon.turkishLiraSign({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.turkishLiraSign,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for space_shuttle icon
  /// Name space_shuttle turns into flutterish spaceShuttle
  const LineIcon.spaceShuttle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.spaceShuttle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for slack_logo icon
  /// Name slack_logo turns into flutterish slackLogo
  const LineIcon.slackLogo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.slackLogo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for envelope_square icon
  /// Name envelope_square turns into flutterish envelopeSquare
  const LineIcon.envelopeSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.envelopeSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for wordpress_logo icon
  /// Name wordpress_logo turns into flutterish wordpressLogo
  const LineIcon.wordpressLogo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wordpressLogo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for openid icon
  /// Name openid turns into flutterish openid
  const LineIcon.openid({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.openid,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for university icon
  /// Name university turns into flutterish university
  const LineIcon.university({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.university,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for graduation_cap icon
  /// Name graduation_cap turns into flutterish graduationCap
  const LineIcon.graduationCap({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.graduationCap,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for yahoo_logo icon
  /// Name yahoo_logo turns into flutterish yahooLogo
  const LineIcon.yahooLogo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.yahooLogo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for google_logo icon
  /// Name google_logo turns into flutterish googleLogo
  const LineIcon.googleLogo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.googleLogo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for reddit_logo icon
  /// Name reddit_logo turns into flutterish redditLogo
  const LineIcon.redditLogo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.redditLogo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for reddit_square icon
  /// Name reddit_square turns into flutterish redditSquare
  const LineIcon.redditSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.redditSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for stumbleupon_circle icon
  /// Name stumbleupon_circle turns into flutterish stumbleuponCircle
  const LineIcon.stumbleuponCircle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.stumbleuponCircle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for stumbleupon_logo icon
  /// Name stumbleupon_logo turns into flutterish stumbleuponLogo
  const LineIcon.stumbleuponLogo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.stumbleuponLogo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for delicious icon
  /// Name delicious turns into flutterish delicious
  const LineIcon.delicious({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.delicious,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for digg_logo icon
  /// Name digg_logo turns into flutterish diggLogo
  const LineIcon.diggLogo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.diggLogo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pied_piper_pp_logo__old_ icon
  /// Name pied_piper_pp_logo__old_ turns into flutterish piedPiperPpLogoOld
  const LineIcon.piedPiperPpLogoOld({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.piedPiperPpLogoOld,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_pied_piper_logo icon
  /// Name alternate_pied_piper_logo turns into flutterish alternatePiedPiperLogo
  const LineIcon.alternatePiedPiperLogo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternatePiedPiperLogo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for drupal_logo icon
  /// Name drupal_logo turns into flutterish drupalLogo
  const LineIcon.drupalLogo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.drupalLogo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for joomla_logo icon
  /// Name joomla_logo turns into flutterish joomlaLogo
  const LineIcon.joomlaLogo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.joomlaLogo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for language icon
  /// Name language turns into flutterish language
  const LineIcon.language({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.language,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for fax icon
  /// Name fax turns into flutterish fax
  const LineIcon.fax({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fax,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for building icon
  /// Name building turns into flutterish building
  const LineIcon.building({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.building,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for child icon
  /// Name child turns into flutterish child
  const LineIcon.child({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.child,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for paw icon
  /// Name paw turns into flutterish paw
  const LineIcon.paw({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.paw,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cube icon
  /// Name cube turns into flutterish cube
  const LineIcon.cube({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cube,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cubes icon
  /// Name cubes turns into flutterish cubes
  const LineIcon.cubes({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cubes,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for behance icon
  /// Name behance turns into flutterish behance
  const LineIcon.behance({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.behance,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for behance_square icon
  /// Name behance_square turns into flutterish behanceSquare
  const LineIcon.behanceSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.behanceSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for steam icon
  /// Name steam turns into flutterish steam
  const LineIcon.steam({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.steam,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for steam_square icon
  /// Name steam_square turns into flutterish steamSquare
  const LineIcon.steamSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.steamSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for recycle icon
  /// Name recycle turns into flutterish recycle
  const LineIcon.recycle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.recycle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for car icon
  /// Name car turns into flutterish car
  const LineIcon.car({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.car,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for taxi icon
  /// Name taxi turns into flutterish taxi
  const LineIcon.taxi({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.taxi,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for tree icon
  /// Name tree turns into flutterish tree
  const LineIcon.tree({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tree,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for spotify icon
  /// Name spotify turns into flutterish spotify
  const LineIcon.spotify({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.spotify,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for deviantart icon
  /// Name deviantart turns into flutterish deviantart
  const LineIcon.deviantart({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.deviantart,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for soundcloud icon
  /// Name soundcloud turns into flutterish soundcloud
  const LineIcon.soundcloud({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.soundcloud,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for database icon
  /// Name database turns into flutterish database
  const LineIcon.database({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.database,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pdf_file icon
  /// Name pdf_file turns into flutterish pdfFile
  const LineIcon.pdfFile({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pdfFile,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for word_file icon
  /// Name word_file turns into flutterish wordFile
  const LineIcon.wordFile({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wordFile,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for excel_file icon
  /// Name excel_file turns into flutterish excelFile
  const LineIcon.excelFile({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.excelFile,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for powerpoint_file icon
  /// Name powerpoint_file turns into flutterish powerpointFile
  const LineIcon.powerpointFile({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.powerpointFile,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for image_file icon
  /// Name image_file turns into flutterish imageFile
  const LineIcon.imageFile({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.imageFile,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for archive_file icon
  /// Name archive_file turns into flutterish archiveFile
  const LineIcon.archiveFile({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.archiveFile,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for audio_file icon
  /// Name audio_file turns into flutterish audioFile
  const LineIcon.audioFile({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.audioFile,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for video_file icon
  /// Name video_file turns into flutterish videoFile
  const LineIcon.videoFile({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.videoFile,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for code_file icon
  /// Name code_file turns into flutterish codeFile
  const LineIcon.codeFile({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.codeFile,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for vine icon
  /// Name vine turns into flutterish vine
  const LineIcon.vine({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.vine,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for codepen icon
  /// Name codepen turns into flutterish codepen
  const LineIcon.codepen({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.codepen,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for jsfiddle icon
  /// Name jsfiddle turns into flutterish jsfiddle
  const LineIcon.jsfiddle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.jsfiddle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for life_ring icon
  /// Name life_ring turns into flutterish lifeRing
  const LineIcon.lifeRing({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.lifeRing,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for circle_notched icon
  /// Name circle_notched turns into flutterish circleNotched
  const LineIcon.circleNotched({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.circleNotched,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for rebel_alliance icon
  /// Name rebel_alliance turns into flutterish rebelAlliance
  const LineIcon.rebelAlliance({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.rebelAlliance,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for galactic_empire icon
  /// Name galactic_empire turns into flutterish galacticEmpire
  const LineIcon.galacticEmpire({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.galacticEmpire,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for git_square icon
  /// Name git_square turns into flutterish gitSquare
  const LineIcon.gitSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.gitSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for git icon
  /// Name git turns into flutterish git
  const LineIcon.git({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.git,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hacker_news icon
  /// Name hacker_news turns into flutterish hackerNews
  const LineIcon.hackerNews({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hackerNews,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for tencent_weibo icon
  /// Name tencent_weibo turns into flutterish tencentWeibo
  const LineIcon.tencentWeibo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tencentWeibo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for qq icon
  /// Name qq turns into flutterish qq
  const LineIcon.qq({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.qq,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for weixin__wechat_ icon
  /// Name weixin__wechat_ turns into flutterish weixinWechat
  const LineIcon.weixinWechat({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.weixinWechat,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for paper_plane icon
  /// Name paper_plane turns into flutterish paperPlane
  const LineIcon.paperPlane({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.paperPlane,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for history icon
  /// Name history turns into flutterish history
  const LineIcon.history({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.history,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for heading icon
  /// Name heading turns into flutterish heading
  const LineIcon.heading({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.heading,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for paragraph icon
  /// Name paragraph turns into flutterish paragraph
  const LineIcon.paragraph({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.paragraph,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for horizontal_sliders icon
  /// Name horizontal_sliders turns into flutterish horizontalSliders
  const LineIcon.horizontalSliders({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.horizontalSliders,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_share icon
  /// Name alternate_share turns into flutterish alternateShare
  const LineIcon.alternateShare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateShare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_share_square icon
  /// Name alternate_share_square turns into flutterish alternateShareSquare
  const LineIcon.alternateShareSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateShareSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bomb icon
  /// Name bomb turns into flutterish bomb
  const LineIcon.bomb({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bomb,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for futbol icon
  /// Name futbol turns into flutterish futbol
  const LineIcon.futbol({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.futbol,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for tty icon
  /// Name tty turns into flutterish tty
  const LineIcon.tty({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tty,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for binoculars icon
  /// Name binoculars turns into flutterish binoculars
  const LineIcon.binoculars({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.binoculars,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for plug icon
  /// Name plug turns into flutterish plug
  const LineIcon.plug({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.plug,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for slideshare icon
  /// Name slideshare turns into flutterish slideshare
  const LineIcon.slideshare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.slideshare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for twitch icon
  /// Name twitch turns into flutterish twitch
  const LineIcon.twitch({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.twitch,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for yelp icon
  /// Name yelp turns into flutterish yelp
  const LineIcon.yelp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.yelp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for newspaper icon
  /// Name newspaper turns into flutterish newspaper
  const LineIcon.newspaper({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.newspaper,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for wifi icon
  /// Name wifi turns into flutterish wifi
  const LineIcon.wifi({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wifi,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for calculator icon
  /// Name calculator turns into flutterish calculator
  const LineIcon.calculator({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.calculator,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for paypal icon
  /// Name paypal turns into flutterish paypal
  const LineIcon.paypal({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.paypal,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for google_wallet icon
  /// Name google_wallet turns into flutterish googleWallet
  const LineIcon.googleWallet({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.googleWallet,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for visa_credit_card icon
  /// Name visa_credit_card turns into flutterish visaCreditCard
  const LineIcon.visaCreditCard({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.visaCreditCard,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mastercard_credit_card icon
  /// Name mastercard_credit_card turns into flutterish mastercardCreditCard
  const LineIcon.mastercardCreditCard({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mastercardCreditCard,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for discover_credit_card icon
  /// Name discover_credit_card turns into flutterish discoverCreditCard
  const LineIcon.discoverCreditCard({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.discoverCreditCard,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for american_express_credit_card icon
  /// Name american_express_credit_card turns into flutterish americanExpressCreditCard
  const LineIcon.americanExpressCreditCard({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.americanExpressCreditCard,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for paypal_credit_card icon
  /// Name paypal_credit_card turns into flutterish paypalCreditCard
  const LineIcon.paypalCreditCard({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.paypalCreditCard,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for stripe_credit_card icon
  /// Name stripe_credit_card turns into flutterish stripeCreditCard
  const LineIcon.stripeCreditCard({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.stripeCreditCard,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bell_slash icon
  /// Name bell_slash turns into flutterish bellSlash
  const LineIcon.bellSlash({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bellSlash,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for trash icon
  /// Name trash turns into flutterish trash
  const LineIcon.trash({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.trash,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for copyright icon
  /// Name copyright turns into flutterish copyright
  const LineIcon.copyright({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.copyright,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for at icon
  /// Name at turns into flutterish at
  const LineIcon.at({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.at,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for eye_dropper icon
  /// Name eye_dropper turns into flutterish eyeDropper
  const LineIcon.eyeDropper({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.eyeDropper,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for paint_brush icon
  /// Name paint_brush turns into flutterish paintBrush
  const LineIcon.paintBrush({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.paintBrush,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for birthday_cake icon
  /// Name birthday_cake turns into flutterish birthdayCake
  const LineIcon.birthdayCake({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.birthdayCake,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for area_chart icon
  /// Name area_chart turns into flutterish areaChart
  const LineIcon.areaChart({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.areaChart,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pie_chart icon
  /// Name pie_chart turns into flutterish pieChart
  const LineIcon.pieChart({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pieChart,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for line_chart icon
  /// Name line_chart turns into flutterish lineChart
  const LineIcon.lineChart({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.lineChart,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for last_fm icon
  /// Name last_fm turns into flutterish lastFm
  const LineIcon.lastFm({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.lastFm,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for last_fm_square icon
  /// Name last_fm_square turns into flutterish lastFmSquare
  const LineIcon.lastFmSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.lastFmSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for toggle_off icon
  /// Name toggle_off turns into flutterish toggleOff
  const LineIcon.toggleOff({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.toggleOff,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for toggle_on icon
  /// Name toggle_on turns into flutterish toggleOn
  const LineIcon.toggleOn({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.toggleOn,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bicycle icon
  /// Name bicycle turns into flutterish bicycle
  const LineIcon.bicycle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bicycle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bus icon
  /// Name bus turns into flutterish bus
  const LineIcon.bus({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bus,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ioxhost icon
  /// Name ioxhost turns into flutterish ioxhost
  const LineIcon.ioxhost({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.ioxhost,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for angellist icon
  /// Name angellist turns into flutterish angellist
  const LineIcon.angellist({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.angellist,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for closed_captioning icon
  /// Name closed_captioning turns into flutterish closedCaptioning
  const LineIcon.closedCaptioning({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.closedCaptioning,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for shekel_sign icon
  /// Name shekel_sign turns into flutterish shekelSign
  const LineIcon.shekelSign({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.shekelSign,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for buysellads icon
  /// Name buysellads turns into flutterish buysellads
  const LineIcon.buysellads({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.buysellads,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for connect_develop icon
  /// Name connect_develop turns into flutterish connectDevelop
  const LineIcon.connectDevelop({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.connectDevelop,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dashcube icon
  /// Name dashcube turns into flutterish dashcube
  const LineIcon.dashcube({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dashcube,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for forumbee icon
  /// Name forumbee turns into flutterish forumbee
  const LineIcon.forumbee({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.forumbee,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for leanpub icon
  /// Name leanpub turns into flutterish leanpub
  const LineIcon.leanpub({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.leanpub,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sellsy icon
  /// Name sellsy turns into flutterish sellsy
  const LineIcon.sellsy({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sellsy,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for shirts_in_bulk icon
  /// Name shirts_in_bulk turns into flutterish shirtsInBulk
  const LineIcon.shirtsInBulk({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.shirtsInBulk,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for simplybuilt icon
  /// Name simplybuilt turns into flutterish simplybuilt
  const LineIcon.simplybuilt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.simplybuilt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for skyatlas icon
  /// Name skyatlas turns into flutterish skyatlas
  const LineIcon.skyatlas({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.skyatlas,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for add_to_shopping_cart icon
  /// Name add_to_shopping_cart turns into flutterish addToShoppingCart
  const LineIcon.addToShoppingCart({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.addToShoppingCart,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for shopping_cart_arrow_down icon
  /// Name shopping_cart_arrow_down turns into flutterish shoppingCartArrowDown
  const LineIcon.shoppingCartArrowDown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.shoppingCartArrowDown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ship icon
  /// Name ship turns into flutterish ship
  const LineIcon.ship({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.ship,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for user_secret icon
  /// Name user_secret turns into flutterish userSecret
  const LineIcon.userSecret({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.userSecret,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for motorcycle icon
  /// Name motorcycle turns into flutterish motorcycle
  const LineIcon.motorcycle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.motorcycle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for street_view icon
  /// Name street_view turns into flutterish streetView
  const LineIcon.streetView({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.streetView,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for heartbeat icon
  /// Name heartbeat turns into flutterish heartbeat
  const LineIcon.heartbeat({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.heartbeat,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for venus icon
  /// Name venus turns into flutterish venus
  const LineIcon.venus({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.venus,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mars icon
  /// Name mars turns into flutterish mars
  const LineIcon.mars({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mars,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mercury icon
  /// Name mercury turns into flutterish mercury
  const LineIcon.mercury({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mercury,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for transgender icon
  /// Name transgender turns into flutterish transgender
  const LineIcon.transgender({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.transgender,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_transgender icon
  /// Name alternate_transgender turns into flutterish alternateTransgender
  const LineIcon.alternateTransgender({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateTransgender,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for venus_double icon
  /// Name venus_double turns into flutterish venusDouble
  const LineIcon.venusDouble({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.venusDouble,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mars_double icon
  /// Name mars_double turns into flutterish marsDouble
  const LineIcon.marsDouble({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.marsDouble,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for venus_mars icon
  /// Name venus_mars turns into flutterish venusMars
  const LineIcon.venusMars({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.venusMars,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mars_stroke icon
  /// Name mars_stroke turns into flutterish marsStroke
  const LineIcon.marsStroke({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.marsStroke,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mars_stroke_vertical icon
  /// Name mars_stroke_vertical turns into flutterish marsStrokeVertical
  const LineIcon.marsStrokeVertical({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.marsStrokeVertical,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mars_stroke_horizontal icon
  /// Name mars_stroke_horizontal turns into flutterish marsStrokeHorizontal
  const LineIcon.marsStrokeHorizontal({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.marsStrokeHorizontal,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for neuter icon
  /// Name neuter turns into flutterish neuter
  const LineIcon.neuter({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.neuter,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for genderless icon
  /// Name genderless turns into flutterish genderless
  const LineIcon.genderless({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.genderless,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pinterest_p icon
  /// Name pinterest_p turns into flutterish pinterestP
  const LineIcon.pinterestP({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pinterestP,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for what_s_app icon
  /// Name what_s_app turns into flutterish whatSApp
  const LineIcon.whatSApp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.whatSApp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for server icon
  /// Name server turns into flutterish server
  const LineIcon.server({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.server,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for user_plus icon
  /// Name user_plus turns into flutterish userPlus
  const LineIcon.userPlus({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.userPlus,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for remove_user icon
  /// Name remove_user turns into flutterish removeUser
  const LineIcon.removeUser({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.removeUser,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bed icon
  /// Name bed turns into flutterish bed
  const LineIcon.bed({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bed,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for viacoin icon
  /// Name viacoin turns into flutterish viacoin
  const LineIcon.viacoin({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.viacoin,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for train icon
  /// Name train turns into flutterish train
  const LineIcon.train({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.train,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for subway icon
  /// Name subway turns into flutterish subway
  const LineIcon.subway({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.subway,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for medium icon
  /// Name medium turns into flutterish medium
  const LineIcon.medium({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.medium,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for y_combinator icon
  /// Name y_combinator turns into flutterish yCombinator
  const LineIcon.yCombinator({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.yCombinator,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for optin_monster icon
  /// Name optin_monster turns into flutterish optinMonster
  const LineIcon.optinMonster({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.optinMonster,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for opencart icon
  /// Name opencart turns into flutterish opencart
  const LineIcon.opencart({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.opencart,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for expeditedssl icon
  /// Name expeditedssl turns into flutterish expeditedssl
  const LineIcon.expeditedssl({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.expeditedssl,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for battery_full icon
  /// Name battery_full turns into flutterish batteryFull
  const LineIcon.batteryFull({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.batteryFull,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for battery_3_4_full icon
  /// Name battery_3_4_full turns into flutterish battery34Full
  const LineIcon.battery34Full({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.battery34Full,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for battery_1_2_full icon
  /// Name battery_1_2_full turns into flutterish batteryAlt2Full
  const LineIcon.batteryAlt2Full({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.batteryAlt2Full,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for battery_1_4_full icon
  /// Name battery_1_4_full turns into flutterish batteryAlt4Full
  const LineIcon.batteryAlt4Full({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.batteryAlt4Full,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for battery_empty icon
  /// Name battery_empty turns into flutterish batteryEmpty
  const LineIcon.batteryEmpty({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.batteryEmpty,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mouse_pointer icon
  /// Name mouse_pointer turns into flutterish mousePointer
  const LineIcon.mousePointer({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mousePointer,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for i_beam_cursor icon
  /// Name i_beam_cursor turns into flutterish iBeamCursor
  const LineIcon.iBeamCursor({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.iBeamCursor,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for object_group icon
  /// Name object_group turns into flutterish objectGroup
  const LineIcon.objectGroup({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.objectGroup,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for object_ungroup icon
  /// Name object_ungroup turns into flutterish objectUngroup
  const LineIcon.objectUngroup({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.objectUngroup,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sticky_note icon
  /// Name sticky_note turns into flutterish stickyNote
  const LineIcon.stickyNote({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.stickyNote,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for jcb_credit_card icon
  /// Name jcb_credit_card turns into flutterish jcbCreditCard
  const LineIcon.jcbCreditCard({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.jcbCreditCard,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for diner_s_club_credit_card icon
  /// Name diner_s_club_credit_card turns into flutterish dinerSClubCreditCard
  const LineIcon.dinerSClubCreditCard({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dinerSClubCreditCard,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for clone icon
  /// Name clone turns into flutterish clone
  const LineIcon.clone({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.clone,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for balance_scale icon
  /// Name balance_scale turns into flutterish balanceScale
  const LineIcon.balanceScale({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.balanceScale,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hourglass_start icon
  /// Name hourglass_start turns into flutterish hourglassStart
  const LineIcon.hourglassStart({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hourglassStart,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hourglass_half icon
  /// Name hourglass_half turns into flutterish hourglassHalf
  const LineIcon.hourglassHalf({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hourglassHalf,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hourglass_end icon
  /// Name hourglass_end turns into flutterish hourglassEnd
  const LineIcon.hourglassEnd({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hourglassEnd,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hourglass icon
  /// Name hourglass turns into flutterish hourglass
  const LineIcon.hourglass({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hourglass,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for rock__hand_ icon
  /// Name rock__hand_ turns into flutterish rockHand
  const LineIcon.rockHand({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.rockHand,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for paper__hand_ icon
  /// Name paper__hand_ turns into flutterish paperHand
  const LineIcon.paperHand({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.paperHand,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for scissors__hand_ icon
  /// Name scissors__hand_ turns into flutterish scissorsHand
  const LineIcon.scissorsHand({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.scissorsHand,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for lizard__hand_ icon
  /// Name lizard__hand_ turns into flutterish lizardHand
  const LineIcon.lizardHand({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.lizardHand,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for spock__hand_ icon
  /// Name spock__hand_ turns into flutterish spockHand
  const LineIcon.spockHand({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.spockHand,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pointer__hand_ icon
  /// Name pointer__hand_ turns into flutterish pointerHand
  const LineIcon.pointerHand({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pointerHand,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for peace__hand_ icon
  /// Name peace__hand_ turns into flutterish peaceHand
  const LineIcon.peaceHand({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.peaceHand,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for trademark icon
  /// Name trademark turns into flutterish trademark
  const LineIcon.trademark({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.trademark,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for registered_trademark icon
  /// Name registered_trademark turns into flutterish registeredTrademark
  const LineIcon.registeredTrademark({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.registeredTrademark,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for creative_commons icon
  /// Name creative_commons turns into flutterish creativeCommons
  const LineIcon.creativeCommons({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.creativeCommons,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for gg_currency icon
  /// Name gg_currency turns into flutterish ggCurrency
  const LineIcon.ggCurrency({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.ggCurrency,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for gg_currency_circle icon
  /// Name gg_currency_circle turns into flutterish ggCurrencyCircle
  const LineIcon.ggCurrencyCircle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.ggCurrencyCircle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for tripadvisor icon
  /// Name tripadvisor turns into flutterish tripadvisor
  const LineIcon.tripadvisor({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tripadvisor,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for odnoklassniki icon
  /// Name odnoklassniki turns into flutterish odnoklassniki
  const LineIcon.odnoklassniki({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.odnoklassniki,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for odnoklassniki_square icon
  /// Name odnoklassniki_square turns into flutterish odnoklassnikiSquare
  const LineIcon.odnoklassnikiSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.odnoklassnikiSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for get_pocket icon
  /// Name get_pocket turns into flutterish getPocket
  const LineIcon.getPocket({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.getPocket,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for wikipedia_w icon
  /// Name wikipedia_w turns into flutterish wikipediaW
  const LineIcon.wikipediaW({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wikipediaW,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for safari icon
  /// Name safari turns into flutterish safari
  const LineIcon.safari({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.safari,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for chrome icon
  /// Name chrome turns into flutterish chrome
  const LineIcon.chrome({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.chrome,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for firefox icon
  /// Name firefox turns into flutterish firefox
  const LineIcon.firefox({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.firefox,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for opera icon
  /// Name opera turns into flutterish opera
  const LineIcon.opera({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.opera,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for internet_explorer icon
  /// Name internet_explorer turns into flutterish internetExplorer
  const LineIcon.internetExplorer({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.internetExplorer,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for television icon
  /// Name television turns into flutterish television
  const LineIcon.television({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.television,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for contao icon
  /// Name contao turns into flutterish contao
  const LineIcon.contao({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.contao,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for 500px icon
  /// Name 500px turns into flutterish px500
  const LineIcon.px500({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.px500,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for amazon icon
  /// Name amazon turns into flutterish amazon
  const LineIcon.amazon({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.amazon,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for calendar_plus icon
  /// Name calendar_plus turns into flutterish calendarPlus
  const LineIcon.calendarPlus({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.calendarPlus,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for calendar_minus icon
  /// Name calendar_minus turns into flutterish calendarMinus
  const LineIcon.calendarMinus({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.calendarMinus,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for calendar_times icon
  /// Name calendar_times turns into flutterish calendarTimes
  const LineIcon.calendarTimes({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.calendarTimes,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for calendar_check icon
  /// Name calendar_check turns into flutterish calendarCheck
  const LineIcon.calendarCheck({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.calendarCheck,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for industry icon
  /// Name industry turns into flutterish industry
  const LineIcon.industry({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.industry,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for map_pin icon
  /// Name map_pin turns into flutterish mapPin
  const LineIcon.mapPin({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mapPin,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for map_signs icon
  /// Name map_signs turns into flutterish mapSigns
  const LineIcon.mapSigns({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mapSigns,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for map icon
  /// Name map turns into flutterish map
  const LineIcon.map({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.map,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_comment icon
  /// Name alternate_comment turns into flutterish alternateComment
  const LineIcon.alternateComment({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateComment,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for houzz icon
  /// Name houzz turns into flutterish houzz
  const LineIcon.houzz({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.houzz,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for vimeo icon
  /// Name vimeo turns into flutterish vimeo
  const LineIcon.vimeo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.vimeo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for font_awesome_black_tie icon
  /// Name font_awesome_black_tie turns into flutterish fontAwesomeBlackTie
  const LineIcon.fontAwesomeBlackTie({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fontAwesomeBlackTie,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for fonticons icon
  /// Name fonticons turns into flutterish fonticons
  const LineIcon.fonticons({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fonticons,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for reddit_alien icon
  /// Name reddit_alien turns into flutterish redditAlien
  const LineIcon.redditAlien({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.redditAlien,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for edge_browser icon
  /// Name edge_browser turns into flutterish edgeBrowser
  const LineIcon.edgeBrowser({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.edgeBrowser,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for codie_pie icon
  /// Name codie_pie turns into flutterish codiePie
  const LineIcon.codiePie({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.codiePie,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for modx icon
  /// Name modx turns into flutterish modx
  const LineIcon.modx({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.modx,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for fort_awesome icon
  /// Name fort_awesome turns into flutterish fortAwesome
  const LineIcon.fortAwesome({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fortAwesome,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for usb icon
  /// Name usb turns into flutterish usb
  const LineIcon.usb({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.usb,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for product_hunt icon
  /// Name product_hunt turns into flutterish productHunt
  const LineIcon.productHunt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.productHunt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mixcloud icon
  /// Name mixcloud turns into flutterish mixcloud
  const LineIcon.mixcloud({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mixcloud,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for scribd icon
  /// Name scribd turns into flutterish scribd
  const LineIcon.scribd({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.scribd,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pause_circle icon
  /// Name pause_circle turns into flutterish pauseCircle
  const LineIcon.pauseCircle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pauseCircle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for stop_circle icon
  /// Name stop_circle turns into flutterish stopCircle
  const LineIcon.stopCircle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.stopCircle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for shopping_bag icon
  /// Name shopping_bag turns into flutterish shoppingBag
  const LineIcon.shoppingBag({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.shoppingBag,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for shopping_basket icon
  /// Name shopping_basket turns into flutterish shoppingBasket
  const LineIcon.shoppingBasket({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.shoppingBasket,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hashtag icon
  /// Name hashtag turns into flutterish hashtag
  const LineIcon.hashtag({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hashtag,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bluetooth_2 icon
  /// Name bluetooth_2 turns into flutterish bluetooth2
  const LineIcon.bluetooth2({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bluetooth2,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bluetooth icon
  /// Name bluetooth turns into flutterish bluetooth
  const LineIcon.bluetooth({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bluetooth,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for percent icon
  /// Name percent turns into flutterish percent
  const LineIcon.percent({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.percent,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for gitlab icon
  /// Name gitlab turns into flutterish gitlab
  const LineIcon.gitlab({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.gitlab,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for wpbeginner icon
  /// Name wpbeginner turns into flutterish wpbeginner
  const LineIcon.wpbeginner({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wpbeginner,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for wpforms icon
  /// Name wpforms turns into flutterish wpforms
  const LineIcon.wpforms({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wpforms,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for envira_gallery icon
  /// Name envira_gallery turns into flutterish enviraGallery
  const LineIcon.enviraGallery({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.enviraGallery,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for universal_access icon
  /// Name universal_access turns into flutterish universalAccess
  const LineIcon.universalAccess({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.universalAccess,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for blind icon
  /// Name blind turns into flutterish blind
  const LineIcon.blind({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.blind,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for audio_description icon
  /// Name audio_description turns into flutterish audioDescription
  const LineIcon.audioDescription({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.audioDescription,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for phone_volume icon
  /// Name phone_volume turns into flutterish phoneVolume
  const LineIcon.phoneVolume({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.phoneVolume,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for braille icon
  /// Name braille turns into flutterish braille
  const LineIcon.braille({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.braille,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for assistive_listening_systems icon
  /// Name assistive_listening_systems turns into flutterish assistiveListeningSystems
  const LineIcon.assistiveListeningSystems({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.assistiveListeningSystems,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for american_sign_language_interpreting icon
  /// Name american_sign_language_interpreting turns into flutterish americanSignLanguageInterpreting
  const LineIcon.americanSignLanguageInterpreting({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.americanSignLanguageInterpreting,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for deaf icon
  /// Name deaf turns into flutterish deaf
  const LineIcon.deaf({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.deaf,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for glide icon
  /// Name glide turns into flutterish glide
  const LineIcon.glide({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.glide,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for glide_g icon
  /// Name glide_g turns into flutterish glideG
  const LineIcon.glideG({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.glideG,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sign_language icon
  /// Name sign_language turns into flutterish signLanguage
  const LineIcon.signLanguage({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.signLanguage,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for low_vision icon
  /// Name low_vision turns into flutterish lowVision
  const LineIcon.lowVision({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.lowVision,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for video_1 icon
  /// Name video_1 turns into flutterish videoAlt
  const LineIcon.videoAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.videoAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for video_square icon
  /// Name video_square turns into flutterish videoSquare
  const LineIcon.videoSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.videoSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for snapchat icon
  /// Name snapchat turns into flutterish snapchat
  const LineIcon.snapchat({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.snapchat,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for snapchat_ghost icon
  /// Name snapchat_ghost turns into flutterish snapchatGhost
  const LineIcon.snapchatGhost({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.snapchatGhost,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for snapchat_square icon
  /// Name snapchat_square turns into flutterish snapchatSquare
  const LineIcon.snapchatSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.snapchatSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pied_piper_logo icon
  /// Name pied_piper_logo turns into flutterish piedPiperLogo
  const LineIcon.piedPiperLogo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.piedPiperLogo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for first_order icon
  /// Name first_order turns into flutterish firstOrder
  const LineIcon.firstOrder({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.firstOrder,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for yoast icon
  /// Name yoast turns into flutterish yoast
  const LineIcon.yoast({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.yoast,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for themeisle icon
  /// Name themeisle turns into flutterish themeisle
  const LineIcon.themeisle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.themeisle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for google_plus icon
  /// Name google_plus turns into flutterish googlePlus
  const LineIcon.googlePlus({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.googlePlus,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for font_awesome icon
  /// Name font_awesome turns into flutterish fontAwesome
  const LineIcon.fontAwesome({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fontAwesome,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for handshake icon
  /// Name handshake turns into flutterish handshake
  const LineIcon.handshake({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.handshake,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for envelope_open icon
  /// Name envelope_open turns into flutterish envelopeOpen
  const LineIcon.envelopeOpen({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.envelopeOpen,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for linode icon
  /// Name linode turns into flutterish linode
  const LineIcon.linode({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.linode,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for address_book icon
  /// Name address_book turns into flutterish addressBook
  const LineIcon.addressBook({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.addressBook,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for address_card icon
  /// Name address_card turns into flutterish addressCard
  const LineIcon.addressCard({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.addressCard,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for user_circle icon
  /// Name user_circle turns into flutterish userCircle
  const LineIcon.userCircle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.userCircle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for identification_badge icon
  /// Name identification_badge turns into flutterish identificationBadge
  const LineIcon.identificationBadge({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.identificationBadge,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for identification_card icon
  /// Name identification_card turns into flutterish identificationCard
  const LineIcon.identificationCard({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.identificationCard,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for quora icon
  /// Name quora turns into flutterish quora
  const LineIcon.quora({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.quora,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for free_code_camp icon
  /// Name free_code_camp turns into flutterish freeCodeCamp
  const LineIcon.freeCodeCamp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.freeCodeCamp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for telegram icon
  /// Name telegram turns into flutterish telegram
  const LineIcon.telegram({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.telegram,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for thermometer_full icon
  /// Name thermometer_full turns into flutterish thermometerFull
  const LineIcon.thermometerFull({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.thermometerFull,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for thermometer_3_4_full icon
  /// Name thermometer_3_4_full turns into flutterish thermometer34Full
  const LineIcon.thermometer34Full({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.thermometer34Full,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for thermometer_1_2_full icon
  /// Name thermometer_1_2_full turns into flutterish thermometerAlt2Full
  const LineIcon.thermometerAlt2Full({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.thermometerAlt2Full,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for thermometer_1_4_full icon
  /// Name thermometer_1_4_full turns into flutterish thermometerAlt4Full
  const LineIcon.thermometerAlt4Full({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.thermometerAlt4Full,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for thermometer_empty icon
  /// Name thermometer_empty turns into flutterish thermometerEmpty
  const LineIcon.thermometerEmpty({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.thermometerEmpty,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for shower icon
  /// Name shower turns into flutterish shower
  const LineIcon.shower({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.shower,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bath icon
  /// Name bath turns into flutterish bath
  const LineIcon.bath({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bath,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for podcast icon
  /// Name podcast turns into flutterish podcast
  const LineIcon.podcast({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.podcast,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for window_maximize icon
  /// Name window_maximize turns into flutterish windowMaximize
  const LineIcon.windowMaximize({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.windowMaximize,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for window_minimize icon
  /// Name window_minimize turns into flutterish windowMinimize
  const LineIcon.windowMinimize({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.windowMinimize,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for window_restore icon
  /// Name window_restore turns into flutterish windowRestore
  const LineIcon.windowRestore({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.windowRestore,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bandcamp icon
  /// Name bandcamp turns into flutterish bandcamp
  const LineIcon.bandcamp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bandcamp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for grav icon
  /// Name grav turns into flutterish grav
  const LineIcon.grav({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.grav,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for etsy icon
  /// Name etsy turns into flutterish etsy
  const LineIcon.etsy({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.etsy,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for imdb icon
  /// Name imdb turns into flutterish imdb
  const LineIcon.imdb({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.imdb,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ravelry icon
  /// Name ravelry turns into flutterish ravelry
  const LineIcon.ravelry({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.ravelry,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sellcast icon
  /// Name sellcast turns into flutterish sellcast
  const LineIcon.sellcast({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sellcast,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for microchip icon
  /// Name microchip turns into flutterish microchip
  const LineIcon.microchip({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.microchip,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for snowflake icon
  /// Name snowflake turns into flutterish snowflake
  const LineIcon.snowflake({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.snowflake,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for superpowers icon
  /// Name superpowers turns into flutterish superpowers
  const LineIcon.superpowers({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.superpowers,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for wpexplorer icon
  /// Name wpexplorer turns into flutterish wpexplorer
  const LineIcon.wpexplorer({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wpexplorer,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for meetup icon
  /// Name meetup turns into flutterish meetup
  const LineIcon.meetup({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.meetup,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for utensil_spoon icon
  /// Name utensil_spoon turns into flutterish utensilSpoon
  const LineIcon.utensilSpoon({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.utensilSpoon,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for utensils icon
  /// Name utensils turns into flutterish utensils
  const LineIcon.utensils({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.utensils,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_undo icon
  /// Name alternate_undo turns into flutterish alternateUndo
  const LineIcon.alternateUndo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateUndo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_trash icon
  /// Name alternate_trash turns into flutterish alternateTrash
  const LineIcon.alternateTrash({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateTrash,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_sync icon
  /// Name alternate_sync turns into flutterish alternateSync
  const LineIcon.alternateSync({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateSync,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for stopwatch icon
  /// Name stopwatch turns into flutterish stopwatch
  const LineIcon.stopwatch({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.stopwatch,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_sign_out icon
  /// Name alternate_sign_out turns into flutterish alternateSignOut
  const LineIcon.alternateSignOut({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateSignOut,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_sign_in icon
  /// Name alternate_sign_in turns into flutterish alternateSignIn
  const LineIcon.alternateSignIn({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateSignIn,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_redo icon
  /// Name alternate_redo turns into flutterish alternateRedo
  const LineIcon.alternateRedo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateRedo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for poo icon
  /// Name poo turns into flutterish poo
  const LineIcon.poo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.poo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for images icon
  /// Name images turns into flutterish images
  const LineIcon.images({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.images,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_pencil icon
  /// Name alternate_pencil turns into flutterish alternatePencil
  const LineIcon.alternatePencil({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternatePencil,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pen icon
  /// Name pen turns into flutterish pen
  const LineIcon.pen({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pen,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_pen icon
  /// Name alternate_pen turns into flutterish alternatePen
  const LineIcon.alternatePen({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternatePen,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_long_arrow_down icon
  /// Name alternate_long_arrow_down turns into flutterish alternateLongArrowDown
  const LineIcon.alternateLongArrowDown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateLongArrowDown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_long_arrow_left icon
  /// Name alternate_long_arrow_left turns into flutterish alternateLongArrowLeft
  const LineIcon.alternateLongArrowLeft({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateLongArrowLeft,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_long_arrow_right icon
  /// Name alternate_long_arrow_right turns into flutterish alternateLongArrowRight
  const LineIcon.alternateLongArrowRight({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateLongArrowRight,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_long_arrow_up icon
  /// Name alternate_long_arrow_up turns into flutterish alternateLongArrowUp
  const LineIcon.alternateLongArrowUp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateLongArrowUp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_expand_arrows icon
  /// Name alternate_expand_arrows turns into flutterish alternateExpandArrows
  const LineIcon.alternateExpandArrows({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateExpandArrows,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for clipboard icon
  /// Name clipboard turns into flutterish clipboard
  const LineIcon.clipboard({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.clipboard,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_arrows_horizontal icon
  /// Name alternate_arrows_horizontal turns into flutterish alternateArrowsHorizontal
  const LineIcon.alternateArrowsHorizontal({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateArrowsHorizontal,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_arrows_vertical icon
  /// Name alternate_arrows_vertical turns into flutterish alternateArrowsVertical
  const LineIcon.alternateArrowsVertical({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateArrowsVertical,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_arrow_circle_down icon
  /// Name alternate_arrow_circle_down turns into flutterish alternateArrowCircleDown
  const LineIcon.alternateArrowCircleDown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateArrowCircleDown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_arrow_circle_left icon
  /// Name alternate_arrow_circle_left turns into flutterish alternateArrowCircleLeft
  const LineIcon.alternateArrowCircleLeft({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateArrowCircleLeft,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_arrow_circle_right icon
  /// Name alternate_arrow_circle_right turns into flutterish alternateArrowCircleRight
  const LineIcon.alternateArrowCircleRight({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateArrowCircleRight,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_arrow_circle_up icon
  /// Name alternate_arrow_circle_up turns into flutterish alternateArrowCircleUp
  const LineIcon.alternateArrowCircleUp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateArrowCircleUp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_font_awesome icon
  /// Name alternate_font_awesome turns into flutterish alternateFontAwesome
  const LineIcon.alternateFontAwesome({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateFontAwesome,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_external_link icon
  /// Name alternate_external_link turns into flutterish alternateExternalLink
  const LineIcon.alternateExternalLink({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateExternalLink,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_external_link_square icon
  /// Name alternate_external_link_square turns into flutterish alternateExternalLinkSquare
  const LineIcon.alternateExternalLinkSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateExternalLinkSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_exchange icon
  /// Name alternate_exchange turns into flutterish alternateExchange
  const LineIcon.alternateExchange({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateExchange,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for accessible_icon icon
  /// Name accessible_icon turns into flutterish accessibleIcon
  const LineIcon.accessibleIcon({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.accessibleIcon,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for accusoft icon
  /// Name accusoft turns into flutterish accusoft
  const LineIcon.accusoft({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.accusoft,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for adversal icon
  /// Name adversal turns into flutterish adversal
  const LineIcon.adversal({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.adversal,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for affiliatetheme icon
  /// Name affiliatetheme turns into flutterish affiliatetheme
  const LineIcon.affiliatetheme({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.affiliatetheme,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for algolia icon
  /// Name algolia turns into flutterish algolia
  const LineIcon.algolia({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.algolia,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for amilia icon
  /// Name amilia turns into flutterish amilia
  const LineIcon.amilia({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.amilia,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for angry_creative icon
  /// Name angry_creative turns into flutterish angryCreative
  const LineIcon.angryCreative({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.angryCreative,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for app_store icon
  /// Name app_store turns into flutterish appStore
  const LineIcon.appStore({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.appStore,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ios_app_store icon
  /// Name ios_app_store turns into flutterish iosAppStore
  const LineIcon.iosAppStore({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.iosAppStore,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for apper_systems_ab icon
  /// Name apper_systems_ab turns into flutterish apperSystemsAb
  const LineIcon.apperSystemsAb({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.apperSystemsAb,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for asymmetrik__ltd_ icon
  /// Name asymmetrik__ltd_ turns into flutterish asymmetrikLtd
  const LineIcon.asymmetrikLtd({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.asymmetrikLtd,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for audible icon
  /// Name audible turns into flutterish audible
  const LineIcon.audible({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.audible,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for avianex icon
  /// Name avianex turns into flutterish avianex
  const LineIcon.avianex({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.avianex,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for amazon_web_services__aws_ icon
  /// Name amazon_web_services__aws_ turns into flutterish amazonWebServicesAws
  const LineIcon.amazonWebServicesAws({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.amazonWebServicesAws,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bimobject icon
  /// Name bimobject turns into flutterish bimobject
  const LineIcon.bimobject({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bimobject,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bitcoin icon
  /// Name bitcoin turns into flutterish bitcoin
  const LineIcon.bitcoin({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bitcoin,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bity icon
  /// Name bity turns into flutterish bity
  const LineIcon.bity({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bity,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for blackberry icon
  /// Name blackberry turns into flutterish blackberry
  const LineIcon.blackberry({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.blackberry,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for blogger icon
  /// Name blogger turns into flutterish blogger
  const LineIcon.blogger({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.blogger,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for blogger_b icon
  /// Name blogger_b turns into flutterish bloggerB
  const LineIcon.bloggerB({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bloggerB,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for b_rom_bel_experte_gmbh___co__kg_ icon
  /// Name b_rom_bel_experte_gmbh___co__kg_ turns into flutterish bRomBelExperteGmbhCoKg
  const LineIcon.bRomBelExperteGmbhCoKg({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bRomBelExperteGmbhCoKg,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for centercode icon
  /// Name centercode turns into flutterish centercode
  const LineIcon.centercode({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.centercode,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_cloud_download icon
  /// Name alternate_cloud_download turns into flutterish alternateCloudDownload
  const LineIcon.alternateCloudDownload({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateCloudDownload,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_cloud_upload icon
  /// Name alternate_cloud_upload turns into flutterish alternateCloudUpload
  const LineIcon.alternateCloudUpload({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateCloudUpload,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cloudscale_ch icon
  /// Name cloudscale_ch turns into flutterish cloudscaleCh
  const LineIcon.cloudscaleCh({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cloudscaleCh,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cloudsmith icon
  /// Name cloudsmith turns into flutterish cloudsmith
  const LineIcon.cloudsmith({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cloudsmith,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cloudversify icon
  /// Name cloudversify turns into flutterish cloudversify
  const LineIcon.cloudversify({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cloudversify,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cpanel icon
  /// Name cpanel turns into flutterish cpanel
  const LineIcon.cpanel({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cpanel,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_css3_logo icon
  /// Name alternate_css3_logo turns into flutterish alternateCss3Logo
  const LineIcon.alternateCss3Logo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateCss3Logo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cuttlefish icon
  /// Name cuttlefish turns into flutterish cuttlefish
  const LineIcon.cuttlefish({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cuttlefish,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dungeons___dragons icon
  /// Name dungeons___dragons turns into flutterish dungeonsDragons
  const LineIcon.dungeonsDragons({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dungeonsDragons,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for deploy_dog icon
  /// Name deploy_dog turns into flutterish deployDog
  const LineIcon.deployDog({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.deployDog,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for deskpro icon
  /// Name deskpro turns into flutterish deskpro
  const LineIcon.deskpro({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.deskpro,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for digital_ocean icon
  /// Name digital_ocean turns into flutterish digitalOcean
  const LineIcon.digitalOcean({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.digitalOcean,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for discord icon
  /// Name discord turns into flutterish discord
  const LineIcon.discord({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.discord,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for discourse icon
  /// Name discourse turns into flutterish discourse
  const LineIcon.discourse({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.discourse,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dochub icon
  /// Name dochub turns into flutterish dochub
  const LineIcon.dochub({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dochub,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for docker icon
  /// Name docker turns into flutterish docker
  const LineIcon.docker({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.docker,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for draft2digital icon
  /// Name draft2digital turns into flutterish draft2Digital
  const LineIcon.draft2Digital({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.draft2Digital,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dribbble_square icon
  /// Name dribbble_square turns into flutterish dribbbleSquare
  const LineIcon.dribbbleSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dribbbleSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dyalog icon
  /// Name dyalog turns into flutterish dyalog
  const LineIcon.dyalog({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dyalog,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for earlybirds icon
  /// Name earlybirds turns into flutterish earlybirds
  const LineIcon.earlybirds({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.earlybirds,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for erlang icon
  /// Name erlang turns into flutterish erlang
  const LineIcon.erlang({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.erlang,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for facebook_f icon
  /// Name facebook_f turns into flutterish facebookF
  const LineIcon.facebookF({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.facebookF,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for facebook_messenger icon
  /// Name facebook_messenger turns into flutterish facebookMessenger
  const LineIcon.facebookMessenger({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.facebookMessenger,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for firstdraft icon
  /// Name firstdraft turns into flutterish firstdraft
  const LineIcon.firstdraft({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.firstdraft,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for fonticons_fi icon
  /// Name fonticons_fi turns into flutterish fonticonsFi
  const LineIcon.fonticonsFi({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fonticonsFi,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_fort_awesome icon
  /// Name alternate_fort_awesome turns into flutterish alternateFortAwesome
  const LineIcon.alternateFortAwesome({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateFortAwesome,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for freebsd icon
  /// Name freebsd turns into flutterish freebsd
  const LineIcon.freebsd({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.freebsd,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for gem icon
  /// Name gem turns into flutterish gem
  const LineIcon.gem({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.gem,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for gitkraken icon
  /// Name gitkraken turns into flutterish gitkraken
  const LineIcon.gitkraken({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.gitkraken,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for gofore icon
  /// Name gofore turns into flutterish gofore
  const LineIcon.gofore({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.gofore,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for goodreads icon
  /// Name goodreads turns into flutterish goodreads
  const LineIcon.goodreads({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.goodreads,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for goodreads_g icon
  /// Name goodreads_g turns into flutterish goodreadsG
  const LineIcon.goodreadsG({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.goodreadsG,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for google_drive icon
  /// Name google_drive turns into flutterish googleDrive
  const LineIcon.googleDrive({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.googleDrive,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for google_play icon
  /// Name google_play turns into flutterish googlePlay
  const LineIcon.googlePlay({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.googlePlay,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for gripfire__inc_ icon
  /// Name gripfire__inc_ turns into flutterish gripfireInc
  const LineIcon.gripfireInc({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.gripfireInc,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for grunt icon
  /// Name grunt turns into flutterish grunt
  const LineIcon.grunt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.grunt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for gulp icon
  /// Name gulp turns into flutterish gulp
  const LineIcon.gulp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.gulp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hacker_news_square icon
  /// Name hacker_news_square turns into flutterish hackerNewsSquare
  const LineIcon.hackerNewsSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hackerNewsSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hireahelper icon
  /// Name hireahelper turns into flutterish hireahelper
  const LineIcon.hireahelper({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hireahelper,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hotjar icon
  /// Name hotjar turns into flutterish hotjar
  const LineIcon.hotjar({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hotjar,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hubspot icon
  /// Name hubspot turns into flutterish hubspot
  const LineIcon.hubspot({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hubspot,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for itunes icon
  /// Name itunes turns into flutterish itunes
  const LineIcon.itunes({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.itunes,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for itunes_note icon
  /// Name itunes_note turns into flutterish itunesNote
  const LineIcon.itunesNote({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.itunesNote,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for jenkis icon
  /// Name jenkis turns into flutterish jenkis
  const LineIcon.jenkis({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.jenkis,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for joget icon
  /// Name joget turns into flutterish joget
  const LineIcon.joget({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.joget,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for javascript__js_ icon
  /// Name javascript__js_ turns into flutterish javascriptJs
  const LineIcon.javascriptJs({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.javascriptJs,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for javascript__js__square icon
  /// Name javascript__js__square turns into flutterish javascriptJsSquare
  const LineIcon.javascriptJsSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.javascriptJsSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for keycdn icon
  /// Name keycdn turns into flutterish keycdn
  const LineIcon.keycdn({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.keycdn,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for kickstarter icon
  /// Name kickstarter turns into flutterish kickstarter
  const LineIcon.kickstarter({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.kickstarter,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for kickstarter_k icon
  /// Name kickstarter_k turns into flutterish kickstarterK
  const LineIcon.kickstarterK({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.kickstarterK,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for laravel icon
  /// Name laravel turns into flutterish laravel
  const LineIcon.laravel({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.laravel,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_level_down icon
  /// Name alternate_level_down turns into flutterish alternateLevelDown
  const LineIcon.alternateLevelDown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateLevelDown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_level_up icon
  /// Name alternate_level_up turns into flutterish alternateLevelUp
  const LineIcon.alternateLevelUp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateLevelUp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for line icon
  /// Name line turns into flutterish line
  const LineIcon.line({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.line,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for lock_open icon
  /// Name lock_open turns into flutterish lockOpen
  const LineIcon.lockOpen({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.lockOpen,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for lyft icon
  /// Name lyft turns into flutterish lyft
  const LineIcon.lyft({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.lyft,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for magento icon
  /// Name magento turns into flutterish magento
  const LineIcon.magento({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.magento,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_map_marker icon
  /// Name alternate_map_marker turns into flutterish alternateMapMarker
  const LineIcon.alternateMapMarker({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateMapMarker,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for medapps icon
  /// Name medapps turns into flutterish medapps
  const LineIcon.medapps({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.medapps,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for medium_m icon
  /// Name medium_m turns into flutterish mediumM
  const LineIcon.mediumM({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mediumM,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mrt icon
  /// Name mrt turns into flutterish mrt
  const LineIcon.mrt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mrt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_microphone icon
  /// Name alternate_microphone turns into flutterish alternateMicrophone
  const LineIcon.alternateMicrophone({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateMicrophone,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for microsoft icon
  /// Name microsoft turns into flutterish microsoft
  const LineIcon.microsoft({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.microsoft,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mix icon
  /// Name mix turns into flutterish mix
  const LineIcon.mix({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mix,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mizuni icon
  /// Name mizuni turns into flutterish mizuni
  const LineIcon.mizuni({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mizuni,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_mobile icon
  /// Name alternate_mobile turns into flutterish alternateMobile
  const LineIcon.alternateMobile({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateMobile,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for monero icon
  /// Name monero turns into flutterish monero
  const LineIcon.monero({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.monero,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_money_bill icon
  /// Name alternate_money_bill turns into flutterish alternateMoneyBill
  const LineIcon.alternateMoneyBill({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateMoneyBill,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for napster icon
  /// Name napster turns into flutterish napster
  const LineIcon.napster({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.napster,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for node_js_js icon
  /// Name node_js_js turns into flutterish nodeJsJs
  const LineIcon.nodeJsJs({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.nodeJsJs,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for npm icon
  /// Name npm turns into flutterish npm
  const LineIcon.npm({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.npm,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ns8 icon
  /// Name ns8 turns into flutterish ns8
  const LineIcon.ns8({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.ns8,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for nutritionix icon
  /// Name nutritionix turns into flutterish nutritionix
  const LineIcon.nutritionix({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.nutritionix,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for page4_corporation icon
  /// Name page4_corporation turns into flutterish page4Corporation
  const LineIcon.page4Corporation({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.page4Corporation,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for palfed icon
  /// Name palfed turns into flutterish palfed
  const LineIcon.palfed({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.palfed,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for patreon icon
  /// Name patreon turns into flutterish patreon
  const LineIcon.patreon({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.patreon,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for periscope icon
  /// Name periscope turns into flutterish periscope
  const LineIcon.periscope({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.periscope,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for phabricator icon
  /// Name phabricator turns into flutterish phabricator
  const LineIcon.phabricator({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.phabricator,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for phoenix_framework icon
  /// Name phoenix_framework turns into flutterish phoenixFramework
  const LineIcon.phoenixFramework({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.phoenixFramework,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for phone_slash icon
  /// Name phone_slash turns into flutterish phoneSlash
  const LineIcon.phoneSlash({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.phoneSlash,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for playstation icon
  /// Name playstation turns into flutterish playstation
  const LineIcon.playstation({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.playstation,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for portrait icon
  /// Name portrait turns into flutterish portrait
  const LineIcon.portrait({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.portrait,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pushed icon
  /// Name pushed turns into flutterish pushed
  const LineIcon.pushed({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pushed,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for python icon
  /// Name python turns into flutterish python
  const LineIcon.python({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.python,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for red_river icon
  /// Name red_river turns into flutterish redRiver
  const LineIcon.redRiver({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.redRiver,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for wpressr icon
  /// Name wpressr turns into flutterish wpressr
  const LineIcon.wpressr({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wpressr,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for reply icon
  /// Name reply turns into flutterish reply
  const LineIcon.reply({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.reply,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for replyd icon
  /// Name replyd turns into flutterish replyd
  const LineIcon.replyd({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.replyd,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for resolving icon
  /// Name resolving turns into flutterish resolving
  const LineIcon.resolving({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.resolving,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for rocket_chat icon
  /// Name rocket_chat turns into flutterish rocketChat
  const LineIcon.rocketChat({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.rocketChat,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for rockrms icon
  /// Name rockrms turns into flutterish rockrms
  const LineIcon.rockrms({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.rockrms,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for schlix icon
  /// Name schlix turns into flutterish schlix
  const LineIcon.schlix({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.schlix,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for searchengin icon
  /// Name searchengin turns into flutterish searchengin
  const LineIcon.searchengin({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.searchengin,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for servicestack icon
  /// Name servicestack turns into flutterish servicestack
  const LineIcon.servicestack({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.servicestack,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_shield icon
  /// Name alternate_shield turns into flutterish alternateShield
  const LineIcon.alternateShield({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateShield,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sistrix icon
  /// Name sistrix turns into flutterish sistrix
  const LineIcon.sistrix({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sistrix,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for slack_hashtag icon
  /// Name slack_hashtag turns into flutterish slackHashtag
  const LineIcon.slackHashtag({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.slackHashtag,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for speakap icon
  /// Name speakap turns into flutterish speakap
  const LineIcon.speakap({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.speakap,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for staylinked icon
  /// Name staylinked turns into flutterish staylinked
  const LineIcon.staylinked({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.staylinked,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for steam_symbol icon
  /// Name steam_symbol turns into flutterish steamSymbol
  const LineIcon.steamSymbol({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.steamSymbol,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sticker_mule icon
  /// Name sticker_mule turns into flutterish stickerMule
  const LineIcon.stickerMule({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.stickerMule,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for studio_vinari icon
  /// Name studio_vinari turns into flutterish studioVinari
  const LineIcon.studioVinari({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.studioVinari,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for supple icon
  /// Name supple turns into flutterish supple
  const LineIcon.supple({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.supple,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_tablet icon
  /// Name alternate_tablet turns into flutterish alternateTablet
  const LineIcon.alternateTablet({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateTablet,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_tachometer icon
  /// Name alternate_tachometer turns into flutterish alternateTachometer
  const LineIcon.alternateTachometer({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateTachometer,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for telegram_plane icon
  /// Name telegram_plane turns into flutterish telegramPlane
  const LineIcon.telegramPlane({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.telegramPlane,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_ticket icon
  /// Name alternate_ticket turns into flutterish alternateTicket
  const LineIcon.alternateTicket({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateTicket,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for uber icon
  /// Name uber turns into flutterish uber
  const LineIcon.uber({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.uber,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for uikit icon
  /// Name uikit turns into flutterish uikit
  const LineIcon.uikit({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.uikit,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for uniregistry icon
  /// Name uniregistry turns into flutterish uniregistry
  const LineIcon.uniregistry({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.uniregistry,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for untappd icon
  /// Name untappd turns into flutterish untappd
  const LineIcon.untappd({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.untappd,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_user icon
  /// Name alternate_user turns into flutterish alternateUser
  const LineIcon.alternateUser({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateUser,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for us_sunnah_foundation icon
  /// Name us_sunnah_foundation turns into flutterish usSunnahFoundation
  const LineIcon.usSunnahFoundation({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.usSunnahFoundation,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for vaadin icon
  /// Name vaadin turns into flutterish vaadin
  const LineIcon.vaadin({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.vaadin,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for viber icon
  /// Name viber turns into flutterish viber
  const LineIcon.viber({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.viber,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for vimeo_2 icon
  /// Name vimeo_2 turns into flutterish vimeo2
  const LineIcon.vimeo2({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.vimeo2,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for vnv icon
  /// Name vnv turns into flutterish vnv
  const LineIcon.vnv({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.vnv,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for what_s_app_square icon
  /// Name what_s_app_square turns into flutterish whatSAppSquare
  const LineIcon.whatSAppSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.whatSAppSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for whmcs icon
  /// Name whmcs turns into flutterish whmcs
  const LineIcon.whmcs({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.whmcs,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for window_close icon
  /// Name window_close turns into flutterish windowClose
  const LineIcon.windowClose({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.windowClose,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for wordpress_simple icon
  /// Name wordpress_simple turns into flutterish wordpressSimple
  const LineIcon.wordpressSimple({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wordpressSimple,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for xbox icon
  /// Name xbox turns into flutterish xbox
  const LineIcon.xbox({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.xbox,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for yandex icon
  /// Name yandex turns into flutterish yandex
  const LineIcon.yandex({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.yandex,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for yandex_international icon
  /// Name yandex_international turns into flutterish yandexInternational
  const LineIcon.yandexInternational({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.yandexInternational,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for apple_pay icon
  /// Name apple_pay turns into flutterish applePay
  const LineIcon.applePay({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.applePay,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for apple_pay_credit_card icon
  /// Name apple_pay_credit_card turns into flutterish applePayCreditCard
  const LineIcon.applePayCreditCard({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.applePayCreditCard,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for fly icon
  /// Name fly turns into flutterish fly
  const LineIcon.fly({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fly,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for node_js icon
  /// Name node_js turns into flutterish nodeJs
  const LineIcon.nodeJs({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.nodeJs,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for open_source_initiative icon
  /// Name open_source_initiative turns into flutterish openSourceInitiative
  const LineIcon.openSourceInitiative({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.openSourceInitiative,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for react icon
  /// Name react turns into flutterish react
  const LineIcon.react({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.react,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for autoprefixer icon
  /// Name autoprefixer turns into flutterish autoprefixer
  const LineIcon.autoprefixer({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.autoprefixer,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for less icon
  /// Name less turns into flutterish less
  const LineIcon.less({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.less,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sass icon
  /// Name sass turns into flutterish sass
  const LineIcon.sass({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sass,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for vue_js icon
  /// Name vue_js turns into flutterish vueJs
  const LineIcon.vueJs({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.vueJs,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for angular icon
  /// Name angular turns into flutterish angular
  const LineIcon.angular({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.angular,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for aviato icon
  /// Name aviato turns into flutterish aviato
  const LineIcon.aviato({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.aviato,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ember icon
  /// Name ember turns into flutterish ember
  const LineIcon.ember({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.ember,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for font_awesome_flag icon
  /// Name font_awesome_flag turns into flutterish fontAwesomeFlag
  const LineIcon.fontAwesomeFlag({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fontAwesomeFlag,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for gitter icon
  /// Name gitter turns into flutterish gitter
  const LineIcon.gitter({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.gitter,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hooli icon
  /// Name hooli turns into flutterish hooli
  const LineIcon.hooli({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hooli,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for strava icon
  /// Name strava turns into flutterish strava
  const LineIcon.strava({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.strava,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for stripe icon
  /// Name stripe turns into flutterish stripe
  const LineIcon.stripe({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.stripe,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for stripe_s icon
  /// Name stripe_s turns into flutterish stripeS
  const LineIcon.stripeS({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.stripeS,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for typo3 icon
  /// Name typo3 turns into flutterish typo3
  const LineIcon.typo3({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.typo3,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for amazon_pay icon
  /// Name amazon_pay turns into flutterish amazonPay
  const LineIcon.amazonPay({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.amazonPay,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for amazon_pay_credit_card icon
  /// Name amazon_pay_credit_card turns into flutterish amazonPayCreditCard
  const LineIcon.amazonPayCreditCard({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.amazonPayCreditCard,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ethereum icon
  /// Name ethereum turns into flutterish ethereum
  const LineIcon.ethereum({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.ethereum,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for korvue icon
  /// Name korvue turns into flutterish korvue
  const LineIcon.korvue({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.korvue,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for elementor icon
  /// Name elementor turns into flutterish elementor
  const LineIcon.elementor({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.elementor,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for youtube_square icon
  /// Name youtube_square turns into flutterish youtubeSquare
  const LineIcon.youtubeSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.youtubeSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for baseball_ball icon
  /// Name baseball_ball turns into flutterish baseballBall
  const LineIcon.baseballBall({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.baseballBall,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for basketball_ball icon
  /// Name basketball_ball turns into flutterish basketballBall
  const LineIcon.basketballBall({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.basketballBall,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bowling_ball icon
  /// Name bowling_ball turns into flutterish bowlingBall
  const LineIcon.bowlingBall({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bowlingBall,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for chess icon
  /// Name chess turns into flutterish chess
  const LineIcon.chess({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.chess,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for chess_bishop icon
  /// Name chess_bishop turns into flutterish chessBishop
  const LineIcon.chessBishop({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.chessBishop,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for chess_board icon
  /// Name chess_board turns into flutterish chessBoard
  const LineIcon.chessBoard({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.chessBoard,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for chess_king icon
  /// Name chess_king turns into flutterish chessKing
  const LineIcon.chessKing({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.chessKing,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for chess_knight icon
  /// Name chess_knight turns into flutterish chessKnight
  const LineIcon.chessKnight({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.chessKnight,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for chess_pawn icon
  /// Name chess_pawn turns into flutterish chessPawn
  const LineIcon.chessPawn({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.chessPawn,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for chess_queen icon
  /// Name chess_queen turns into flutterish chessQueen
  const LineIcon.chessQueen({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.chessQueen,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for chess_rook icon
  /// Name chess_rook turns into flutterish chessRook
  const LineIcon.chessRook({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.chessRook,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dumbbell icon
  /// Name dumbbell turns into flutterish dumbbell
  const LineIcon.dumbbell({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dumbbell,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for flipboard icon
  /// Name flipboard turns into flutterish flipboard
  const LineIcon.flipboard({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.flipboard,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for football_ball icon
  /// Name football_ball turns into flutterish footballBall
  const LineIcon.footballBall({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.footballBall,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for golf_ball icon
  /// Name golf_ball turns into flutterish golfBall
  const LineIcon.golfBall({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.golfBall,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hips icon
  /// Name hips turns into flutterish hips
  const LineIcon.hips({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hips,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hockey_puck icon
  /// Name hockey_puck turns into flutterish hockeyPuck
  const LineIcon.hockeyPuck({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hockeyPuck,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for php icon
  /// Name php turns into flutterish php
  const LineIcon.php({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.php,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for quidditch icon
  /// Name quidditch turns into flutterish quidditch
  const LineIcon.quidditch({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.quidditch,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for quinscape icon
  /// Name quinscape turns into flutterish quinscape
  const LineIcon.quinscape({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.quinscape,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for square_full icon
  /// Name square_full turns into flutterish squareFull
  const LineIcon.squareFull({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.squareFull,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for table_tennis icon
  /// Name table_tennis turns into flutterish tableTennis
  const LineIcon.tableTennis({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tableTennis,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for volleyball_ball icon
  /// Name volleyball_ball turns into flutterish volleyballBall
  const LineIcon.volleyballBall({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.volleyballBall,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for allergies icon
  /// Name allergies turns into flutterish allergies
  const LineIcon.allergies({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.allergies,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for band_aid icon
  /// Name band_aid turns into flutterish bandAid
  const LineIcon.bandAid({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bandAid,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for box icon
  /// Name box turns into flutterish box
  const LineIcon.box({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.box,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for boxes icon
  /// Name boxes turns into flutterish boxes
  const LineIcon.boxes({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.boxes,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for medical_briefcase icon
  /// Name medical_briefcase turns into flutterish medicalBriefcase
  const LineIcon.medicalBriefcase({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.medicalBriefcase,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for burn icon
  /// Name burn turns into flutterish burn
  const LineIcon.burn({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.burn,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for capsules icon
  /// Name capsules turns into flutterish capsules
  const LineIcon.capsules({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.capsules,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for clipboard_with_check icon
  /// Name clipboard_with_check turns into flutterish clipboardWithCheck
  const LineIcon.clipboardWithCheck({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.clipboardWithCheck,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for clipboard_list icon
  /// Name clipboard_list turns into flutterish clipboardList
  const LineIcon.clipboardList({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.clipboardList,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for diagnoses icon
  /// Name diagnoses turns into flutterish diagnoses
  const LineIcon.diagnoses({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.diagnoses,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dna icon
  /// Name dna turns into flutterish dna
  const LineIcon.dna({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dna,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dolly icon
  /// Name dolly turns into flutterish dolly
  const LineIcon.dolly({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dolly,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dolly_flatbed icon
  /// Name dolly_flatbed turns into flutterish dollyFlatbed
  const LineIcon.dollyFlatbed({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dollyFlatbed,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for medical_file icon
  /// Name medical_file turns into flutterish medicalFile
  const LineIcon.medicalFile({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.medicalFile,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_medical_file icon
  /// Name alternate_medical_file turns into flutterish alternateMedicalFile
  const LineIcon.alternateMedicalFile({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateMedicalFile,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for first_aid icon
  /// Name first_aid turns into flutterish firstAid
  const LineIcon.firstAid({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.firstAid,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_hospital icon
  /// Name alternate_hospital turns into flutterish alternateHospital
  const LineIcon.alternateHospital({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateHospital,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hospital_symbol icon
  /// Name hospital_symbol turns into flutterish hospitalSymbol
  const LineIcon.hospitalSymbol({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hospitalSymbol,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_identification_card icon
  /// Name alternate_identification_card turns into flutterish alternateIdentificationCard
  const LineIcon.alternateIdentificationCard({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateIdentificationCard,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for medical_notes icon
  /// Name medical_notes turns into flutterish medicalNotes
  const LineIcon.medicalNotes({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.medicalNotes,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pallet icon
  /// Name pallet turns into flutterish pallet
  const LineIcon.pallet({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pallet,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pills icon
  /// Name pills turns into flutterish pills
  const LineIcon.pills({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pills,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for prescription_bottle icon
  /// Name prescription_bottle turns into flutterish prescriptionBottle
  const LineIcon.prescriptionBottle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.prescriptionBottle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_prescription_bottle icon
  /// Name alternate_prescription_bottle turns into flutterish alternatePrescriptionBottle
  const LineIcon.alternatePrescriptionBottle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternatePrescriptionBottle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for procedures icon
  /// Name procedures turns into flutterish procedures
  const LineIcon.procedures({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.procedures,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for shipping_fast icon
  /// Name shipping_fast turns into flutterish shippingFast
  const LineIcon.shippingFast({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.shippingFast,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for smoking icon
  /// Name smoking turns into flutterish smoking
  const LineIcon.smoking({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.smoking,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for syringe icon
  /// Name syringe turns into flutterish syringe
  const LineIcon.syringe({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.syringe,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for tablets icon
  /// Name tablets turns into flutterish tablets
  const LineIcon.tablets({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tablets,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for thermometer icon
  /// Name thermometer turns into flutterish thermometer
  const LineIcon.thermometer({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.thermometer,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for vial icon
  /// Name vial turns into flutterish vial
  const LineIcon.vial({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.vial,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for vials icon
  /// Name vials turns into flutterish vials
  const LineIcon.vials({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.vials,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for warehouse icon
  /// Name warehouse turns into flutterish warehouse
  const LineIcon.warehouse({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.warehouse,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for weight icon
  /// Name weight turns into flutterish weight
  const LineIcon.weight({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.weight,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for x_ray icon
  /// Name x_ray turns into flutterish xRay
  const LineIcon.xRay({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.xRay,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for box_open icon
  /// Name box_open turns into flutterish boxOpen
  const LineIcon.boxOpen({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.boxOpen,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for comment_dots icon
  /// Name comment_dots turns into flutterish commentDots
  const LineIcon.commentDots({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.commentDots,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for comment_slash icon
  /// Name comment_slash turns into flutterish commentSlash
  const LineIcon.commentSlash({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.commentSlash,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for couch icon
  /// Name couch turns into flutterish couch
  const LineIcon.couch({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.couch,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for donate icon
  /// Name donate turns into flutterish donate
  const LineIcon.donate({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.donate,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dove icon
  /// Name dove turns into flutterish dove
  const LineIcon.dove({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dove,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hand_holding icon
  /// Name hand_holding turns into flutterish handHolding
  const LineIcon.handHolding({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.handHolding,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hand_holding_heart icon
  /// Name hand_holding_heart turns into flutterish handHoldingHeart
  const LineIcon.handHoldingHeart({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.handHoldingHeart,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hand_holding_us_dollar icon
  /// Name hand_holding_us_dollar turns into flutterish handHoldingUsDollar
  const LineIcon.handHoldingUsDollar({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.handHoldingUsDollar,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hands icon
  /// Name hands turns into flutterish hands
  const LineIcon.hands({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hands,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for helping_hands icon
  /// Name helping_hands turns into flutterish helpingHands
  const LineIcon.helpingHands({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.helpingHands,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for parachute_box icon
  /// Name parachute_box turns into flutterish parachuteBox
  const LineIcon.parachuteBox({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.parachuteBox,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for people_carry icon
  /// Name people_carry turns into flutterish peopleCarry
  const LineIcon.peopleCarry({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.peopleCarry,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for piggy_bank icon
  /// Name piggy_bank turns into flutterish piggyBank
  const LineIcon.piggyBank({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.piggyBank,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for readme icon
  /// Name readme turns into flutterish readme
  const LineIcon.readme({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.readme,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ribbon icon
  /// Name ribbon turns into flutterish ribbon
  const LineIcon.ribbon({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.ribbon,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for route icon
  /// Name route turns into flutterish route
  const LineIcon.route({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.route,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for seedling icon
  /// Name seedling turns into flutterish seedling
  const LineIcon.seedling({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.seedling,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sign icon
  /// Name sign turns into flutterish sign
  const LineIcon.sign({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sign,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for winking_face icon
  /// Name winking_face turns into flutterish winkingFace
  const LineIcon.winkingFace({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.winkingFace,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for tape icon
  /// Name tape turns into flutterish tape
  const LineIcon.tape({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tape,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for truck_loading icon
  /// Name truck_loading turns into flutterish truckLoading
  const LineIcon.truckLoading({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.truckLoading,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for truck_moving icon
  /// Name truck_moving turns into flutterish truckMoving
  const LineIcon.truckMoving({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.truckMoving,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for video_slash icon
  /// Name video_slash turns into flutterish videoSlash
  const LineIcon.videoSlash({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.videoSlash,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for wine_glass icon
  /// Name wine_glass turns into flutterish wineGlass
  const LineIcon.wineGlass({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wineGlass,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for java icon
  /// Name java turns into flutterish java
  const LineIcon.java({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.java,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pied_piper_hat icon
  /// Name pied_piper_hat turns into flutterish piedPiperHat
  const LineIcon.piedPiperHat({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.piedPiperHat,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for creative_commons_attribution icon
  /// Name creative_commons_attribution turns into flutterish creativeCommonsAttribution
  const LineIcon.creativeCommonsAttribution({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.creativeCommonsAttribution,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for creative_commons_noncommercial icon
  /// Name creative_commons_noncommercial turns into flutterish creativeCommonsNoncommercial
  const LineIcon.creativeCommonsNoncommercial({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.creativeCommonsNoncommercial,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for creative_commons_noncommercial__euro_sign_ icon
  /// Name creative_commons_noncommercial__euro_sign_ turns into flutterish creativeCommonsNoncommercialEuroSign
  const LineIcon.creativeCommonsNoncommercialEuroSign({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.creativeCommonsNoncommercialEuroSign,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for creative_commons_noncommercial__yen_sign_ icon
  /// Name creative_commons_noncommercial__yen_sign_ turns into flutterish creativeCommonsNoncommercialYenSign
  const LineIcon.creativeCommonsNoncommercialYenSign({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.creativeCommonsNoncommercialYenSign,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for creative_commons_no_derivative_works icon
  /// Name creative_commons_no_derivative_works turns into flutterish creativeCommonsNoDerivativeWorks
  const LineIcon.creativeCommonsNoDerivativeWorks({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.creativeCommonsNoDerivativeWorks,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for creative_commons_public_domain icon
  /// Name creative_commons_public_domain turns into flutterish creativeCommonsPublicDomain
  const LineIcon.creativeCommonsPublicDomain({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.creativeCommonsPublicDomain,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_creative_commons_public_domain icon
  /// Name alternate_creative_commons_public_domain turns into flutterish alternateCreativeCommonsPublicDomain
  const LineIcon.alternateCreativeCommonsPublicDomain({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateCreativeCommonsPublicDomain,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for creative_commons_remix icon
  /// Name creative_commons_remix turns into flutterish creativeCommonsRemix
  const LineIcon.creativeCommonsRemix({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.creativeCommonsRemix,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for creative_commons_share_alike icon
  /// Name creative_commons_share_alike turns into flutterish creativeCommonsShareAlike
  const LineIcon.creativeCommonsShareAlike({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.creativeCommonsShareAlike,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for creative_commons_sampling icon
  /// Name creative_commons_sampling turns into flutterish creativeCommonsSampling
  const LineIcon.creativeCommonsSampling({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.creativeCommonsSampling,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for creative_commons_sampling__ icon
  /// Name creative_commons_sampling__ turns into flutterish creativeCommonsSamplingAlt
  const LineIcon.creativeCommonsSamplingAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.creativeCommonsSampling,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for creative_commons_share icon
  /// Name creative_commons_share turns into flutterish creativeCommonsShare
  const LineIcon.creativeCommonsShare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.creativeCommonsShare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for creative_commons_cc0 icon
  /// Name creative_commons_cc0 turns into flutterish creativeCommonsCc0
  const LineIcon.creativeCommonsCc0({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.creativeCommonsCc0,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ebay icon
  /// Name ebay turns into flutterish ebay
  const LineIcon.ebay({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.ebay,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for keybase icon
  /// Name keybase turns into flutterish keybase
  const LineIcon.keybase({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.keybase,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mastodon icon
  /// Name mastodon turns into flutterish mastodon
  const LineIcon.mastodon({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mastodon,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for r_project icon
  /// Name r_project turns into flutterish rProject
  const LineIcon.rProject({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.rProject,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for researchgate icon
  /// Name researchgate turns into flutterish researchgate
  const LineIcon.researchgate({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.researchgate,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for teamspeak icon
  /// Name teamspeak turns into flutterish teamspeak
  const LineIcon.teamspeak({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.teamspeak,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_user_slash icon
  /// Name alternate_user_slash turns into flutterish alternateUserSlash
  const LineIcon.alternateUserSlash({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateUserSlash,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for user_astronaut icon
  /// Name user_astronaut turns into flutterish userAstronaut
  const LineIcon.userAstronaut({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.userAstronaut,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for user_check icon
  /// Name user_check turns into flutterish userCheck
  const LineIcon.userCheck({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.userCheck,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for user_clock icon
  /// Name user_clock turns into flutterish userClock
  const LineIcon.userClock({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.userClock,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for user_cog icon
  /// Name user_cog turns into flutterish userCog
  const LineIcon.userCog({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.userCog,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for user_edit icon
  /// Name user_edit turns into flutterish userEdit
  const LineIcon.userEdit({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.userEdit,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for user_friends icon
  /// Name user_friends turns into flutterish userFriends
  const LineIcon.userFriends({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.userFriends,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for user_graduate icon
  /// Name user_graduate turns into flutterish userGraduate
  const LineIcon.userGraduate({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.userGraduate,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for user_lock icon
  /// Name user_lock turns into flutterish userLock
  const LineIcon.userLock({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.userLock,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for user_minus icon
  /// Name user_minus turns into flutterish userMinus
  const LineIcon.userMinus({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.userMinus,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for user_ninja icon
  /// Name user_ninja turns into flutterish userNinja
  const LineIcon.userNinja({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.userNinja,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for user_shield icon
  /// Name user_shield turns into flutterish userShield
  const LineIcon.userShield({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.userShield,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for user_slash icon
  /// Name user_slash turns into flutterish userSlash
  const LineIcon.userSlash({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.userSlash,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for user_tag icon
  /// Name user_tag turns into flutterish userTag
  const LineIcon.userTag({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.userTag,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for user_tie icon
  /// Name user_tie turns into flutterish userTie
  const LineIcon.userTie({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.userTie,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for users_cog icon
  /// Name users_cog turns into flutterish usersCog
  const LineIcon.usersCog({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.usersCog,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_first_order icon
  /// Name alternate_first_order turns into flutterish alternateFirstOrder
  const LineIcon.alternateFirstOrder({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateFirstOrder,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for fulcrum icon
  /// Name fulcrum turns into flutterish fulcrum
  const LineIcon.fulcrum({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fulcrum,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for galactic_republic icon
  /// Name galactic_republic turns into flutterish galacticRepublic
  const LineIcon.galacticRepublic({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.galacticRepublic,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for galactic_senate icon
  /// Name galactic_senate turns into flutterish galacticSenate
  const LineIcon.galacticSenate({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.galacticSenate,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for jedi_order icon
  /// Name jedi_order turns into flutterish jediOrder
  const LineIcon.jediOrder({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.jediOrder,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mandalorian icon
  /// Name mandalorian turns into flutterish mandalorian
  const LineIcon.mandalorian({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mandalorian,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for old_republic icon
  /// Name old_republic turns into flutterish oldRepublic
  const LineIcon.oldRepublic({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.oldRepublic,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for phoenix_squadron icon
  /// Name phoenix_squadron turns into flutterish phoenixSquadron
  const LineIcon.phoenixSquadron({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.phoenixSquadron,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sith icon
  /// Name sith turns into flutterish sith
  const LineIcon.sith({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sith,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for trade_federation icon
  /// Name trade_federation turns into flutterish tradeFederation
  const LineIcon.tradeFederation({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tradeFederation,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for wolf_pack_battalion icon
  /// Name wolf_pack_battalion turns into flutterish wolfPackBattalion
  const LineIcon.wolfPackBattalion({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wolfPackBattalion,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for balance_scale__left_weighted_ icon
  /// Name balance_scale__left_weighted_ turns into flutterish balanceScaleLeftWeighted
  const LineIcon.balanceScaleLeftWeighted({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.balanceScaleLeftWeighted,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for balance_scale__right_weighted_ icon
  /// Name balance_scale__right_weighted_ turns into flutterish balanceScaleRightWeighted
  const LineIcon.balanceScaleRightWeighted({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.balanceScaleRightWeighted,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for blender icon
  /// Name blender turns into flutterish blender
  const LineIcon.blender({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.blender,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for book_open icon
  /// Name book_open turns into flutterish bookOpen
  const LineIcon.bookOpen({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bookOpen,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for broadcast_tower icon
  /// Name broadcast_tower turns into flutterish broadcastTower
  const LineIcon.broadcastTower({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.broadcastTower,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for broom icon
  /// Name broom turns into flutterish broom
  const LineIcon.broom({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.broom,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for chalkboard icon
  /// Name chalkboard turns into flutterish chalkboard
  const LineIcon.chalkboard({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.chalkboard,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for chalkboard_teacher icon
  /// Name chalkboard_teacher turns into flutterish chalkboardTeacher
  const LineIcon.chalkboardTeacher({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.chalkboardTeacher,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for church icon
  /// Name church turns into flutterish church
  const LineIcon.church({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.church,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for coins icon
  /// Name coins turns into flutterish coins
  const LineIcon.coins({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.coins,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for compact_disc icon
  /// Name compact_disc turns into flutterish compactDisc
  const LineIcon.compactDisc({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.compactDisc,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for crow icon
  /// Name crow turns into flutterish crow
  const LineIcon.crow({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.crow,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for crown icon
  /// Name crown turns into flutterish crown
  const LineIcon.crown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.crown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dice icon
  /// Name dice turns into flutterish dice
  const LineIcon.dice({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dice,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dice_five icon
  /// Name dice_five turns into flutterish diceFive
  const LineIcon.diceFive({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.diceFive,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dice_four icon
  /// Name dice_four turns into flutterish diceFour
  const LineIcon.diceFour({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.diceFour,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dice_one icon
  /// Name dice_one turns into flutterish diceOne
  const LineIcon.diceOne({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.diceOne,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dice_six icon
  /// Name dice_six turns into flutterish diceSix
  const LineIcon.diceSix({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.diceSix,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dice_three icon
  /// Name dice_three turns into flutterish diceThree
  const LineIcon.diceThree({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.diceThree,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dice_two icon
  /// Name dice_two turns into flutterish diceTwo
  const LineIcon.diceTwo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.diceTwo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for divide icon
  /// Name divide turns into flutterish divide
  const LineIcon.divide({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.divide,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for door_closed icon
  /// Name door_closed turns into flutterish doorClosed
  const LineIcon.doorClosed({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.doorClosed,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for door_open icon
  /// Name door_open turns into flutterish doorOpen
  const LineIcon.doorOpen({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.doorOpen,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for equals icon
  /// Name equals turns into flutterish equals
  const LineIcon.equals({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.equals,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for feather icon
  /// Name feather turns into flutterish feather
  const LineIcon.feather({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.feather,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for frog icon
  /// Name frog turns into flutterish frog
  const LineIcon.frog({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.frog,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for gas_pump icon
  /// Name gas_pump turns into flutterish gasPump
  const LineIcon.gasPump({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.gasPump,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for glasses icon
  /// Name glasses turns into flutterish glasses
  const LineIcon.glasses({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.glasses,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for greater_than icon
  /// Name greater_than turns into flutterish greaterThan
  const LineIcon.greaterThan({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.greaterThan,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for greater_than_equal_to icon
  /// Name greater_than_equal_to turns into flutterish greaterThanEqualTo
  const LineIcon.greaterThanEqualTo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.greaterThanEqualTo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for helicopter icon
  /// Name helicopter turns into flutterish helicopter
  const LineIcon.helicopter({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.helicopter,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for infinity icon
  /// Name infinity turns into flutterish infinity
  const LineIcon.infinity({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.infinity,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for kiwi_bird icon
  /// Name kiwi_bird turns into flutterish kiwiBird
  const LineIcon.kiwiBird({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.kiwiBird,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for less_than icon
  /// Name less_than turns into flutterish lessThan
  const LineIcon.lessThan({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.lessThan,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for less_than_equal_to icon
  /// Name less_than_equal_to turns into flutterish lessThanEqualTo
  const LineIcon.lessThanEqualTo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.lessThanEqualTo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for memory icon
  /// Name memory turns into flutterish memory
  const LineIcon.memory({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.memory,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_microphone_slash icon
  /// Name alternate_microphone_slash turns into flutterish alternateMicrophoneSlash
  const LineIcon.alternateMicrophoneSlash({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateMicrophoneSlash,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for wavy_money_bill icon
  /// Name wavy_money_bill turns into flutterish wavyMoneyBill
  const LineIcon.wavyMoneyBill({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wavyMoneyBill,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_wavy_money_bill icon
  /// Name alternate_wavy_money_bill turns into flutterish alternateWavyMoneyBill
  const LineIcon.alternateWavyMoneyBill({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateWavyMoneyBill,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for money_check icon
  /// Name money_check turns into flutterish moneyCheck
  const LineIcon.moneyCheck({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.moneyCheck,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_money_check icon
  /// Name alternate_money_check turns into flutterish alternateMoneyCheck
  const LineIcon.alternateMoneyCheck({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateMoneyCheck,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for not_equal icon
  /// Name not_equal turns into flutterish notEqual
  const LineIcon.notEqual({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.notEqual,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for palette icon
  /// Name palette turns into flutterish palette
  const LineIcon.palette({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.palette,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for parking icon
  /// Name parking turns into flutterish parking
  const LineIcon.parking({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.parking,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for percentage icon
  /// Name percentage turns into flutterish percentage
  const LineIcon.percentage({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.percentage,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for project_diagram icon
  /// Name project_diagram turns into flutterish projectDiagram
  const LineIcon.projectDiagram({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.projectDiagram,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for receipt icon
  /// Name receipt turns into flutterish receipt
  const LineIcon.receipt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.receipt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for robot icon
  /// Name robot turns into flutterish robot
  const LineIcon.robot({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.robot,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ruler icon
  /// Name ruler turns into flutterish ruler
  const LineIcon.ruler({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.ruler,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ruler_combined icon
  /// Name ruler_combined turns into flutterish rulerCombined
  const LineIcon.rulerCombined({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.rulerCombined,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ruler_horizontal icon
  /// Name ruler_horizontal turns into flutterish rulerHorizontal
  const LineIcon.rulerHorizontal({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.rulerHorizontal,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ruler_vertical icon
  /// Name ruler_vertical turns into flutterish rulerVertical
  const LineIcon.rulerVertical({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.rulerVertical,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for school icon
  /// Name school turns into flutterish school
  const LineIcon.school({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.school,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for screwdriver icon
  /// Name screwdriver turns into flutterish screwdriver
  const LineIcon.screwdriver({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.screwdriver,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for shoe_prints icon
  /// Name shoe_prints turns into flutterish shoePrints
  const LineIcon.shoePrints({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.shoePrints,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for skull icon
  /// Name skull turns into flutterish skull
  const LineIcon.skull({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.skull,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for smoking_ban icon
  /// Name smoking_ban turns into flutterish smokingBan
  const LineIcon.smokingBan({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.smokingBan,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for store icon
  /// Name store turns into flutterish store
  const LineIcon.store({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.store,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_store icon
  /// Name alternate_store turns into flutterish alternateStore
  const LineIcon.alternateStore({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateStore,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for stream icon
  /// Name stream turns into flutterish stream
  const LineIcon.stream({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.stream,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for stroopwafel icon
  /// Name stroopwafel turns into flutterish stroopwafel
  const LineIcon.stroopwafel({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.stroopwafel,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for toolbox icon
  /// Name toolbox turns into flutterish toolbox
  const LineIcon.toolbox({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.toolbox,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for t_shirt icon
  /// Name t_shirt turns into flutterish tShirt
  const LineIcon.tShirt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tShirt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for walking icon
  /// Name walking turns into flutterish walking
  const LineIcon.walking({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.walking,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for wallet icon
  /// Name wallet turns into flutterish wallet
  const LineIcon.wallet({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wallet,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for angry_face icon
  /// Name angry_face turns into flutterish angryFace
  const LineIcon.angryFace({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.angryFace,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for archway icon
  /// Name archway turns into flutterish archway
  const LineIcon.archway({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.archway,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for atlas icon
  /// Name atlas turns into flutterish atlas
  const LineIcon.atlas({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.atlas,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for award icon
  /// Name award turns into flutterish award
  const LineIcon.award({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.award,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for backspace icon
  /// Name backspace turns into flutterish backspace
  const LineIcon.backspace({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.backspace,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bezier_curve icon
  /// Name bezier_curve turns into flutterish bezierCurve
  const LineIcon.bezierCurve({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bezierCurve,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bong icon
  /// Name bong turns into flutterish bong
  const LineIcon.bong({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bong,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for brush icon
  /// Name brush turns into flutterish brush
  const LineIcon.brush({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.brush,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bus_alt icon
  /// Name bus_alt turns into flutterish busAlt
  const LineIcon.busAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.busAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cannabis icon
  /// Name cannabis turns into flutterish cannabis
  const LineIcon.cannabis({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cannabis,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for double_check icon
  /// Name double_check turns into flutterish doubleCheck
  const LineIcon.doubleCheck({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.doubleCheck,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cocktail icon
  /// Name cocktail turns into flutterish cocktail
  const LineIcon.cocktail({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cocktail,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for concierge_bell icon
  /// Name concierge_bell turns into flutterish conciergeBell
  const LineIcon.conciergeBell({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.conciergeBell,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cookie icon
  /// Name cookie turns into flutterish cookie
  const LineIcon.cookie({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cookie,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cookie_bite icon
  /// Name cookie_bite turns into flutterish cookieBite
  const LineIcon.cookieBite({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cookieBite,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_crop icon
  /// Name alternate_crop turns into flutterish alternateCrop
  const LineIcon.alternateCrop({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateCrop,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for digital_tachograph icon
  /// Name digital_tachograph turns into flutterish digitalTachograph
  const LineIcon.digitalTachograph({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.digitalTachograph,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dizzy_face icon
  /// Name dizzy_face turns into flutterish dizzyFace
  const LineIcon.dizzyFace({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dizzyFace,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for drafting_compass icon
  /// Name drafting_compass turns into flutterish draftingCompass
  const LineIcon.draftingCompass({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.draftingCompass,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for drum icon
  /// Name drum turns into flutterish drum
  const LineIcon.drum({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.drum,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for drum_steelpan icon
  /// Name drum_steelpan turns into flutterish drumSteelpan
  const LineIcon.drumSteelpan({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.drumSteelpan,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_feather icon
  /// Name alternate_feather turns into flutterish alternateFeather
  const LineIcon.alternateFeather({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateFeather,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for file_contract icon
  /// Name file_contract turns into flutterish fileContract
  const LineIcon.fileContract({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fileContract,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for file_download icon
  /// Name file_download turns into flutterish fileDownload
  const LineIcon.fileDownload({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fileDownload,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for file_export icon
  /// Name file_export turns into flutterish fileExport
  const LineIcon.fileExport({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fileExport,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for file_import icon
  /// Name file_import turns into flutterish fileImport
  const LineIcon.fileImport({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fileImport,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for file_invoice icon
  /// Name file_invoice turns into flutterish fileInvoice
  const LineIcon.fileInvoice({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fileInvoice,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for file_invoice_with_us_dollar icon
  /// Name file_invoice_with_us_dollar turns into flutterish fileInvoiceWithUsDollar
  const LineIcon.fileInvoiceWithUsDollar({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fileInvoiceWithUsDollar,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for file_prescription icon
  /// Name file_prescription turns into flutterish filePrescription
  const LineIcon.filePrescription({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.filePrescription,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for file_signature icon
  /// Name file_signature turns into flutterish fileSignature
  const LineIcon.fileSignature({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fileSignature,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for file_upload icon
  /// Name file_upload turns into flutterish fileUpload
  const LineIcon.fileUpload({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fileUpload,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for fill icon
  /// Name fill turns into flutterish fill
  const LineIcon.fill({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fill,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for fill_drip icon
  /// Name fill_drip turns into flutterish fillDrip
  const LineIcon.fillDrip({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fillDrip,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for fingerprint icon
  /// Name fingerprint turns into flutterish fingerprint
  const LineIcon.fingerprint({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fingerprint,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for fish icon
  /// Name fish turns into flutterish fish
  const LineIcon.fish({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fish,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for flushed_face icon
  /// Name flushed_face turns into flutterish flushedFace
  const LineIcon.flushedFace({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.flushedFace,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for frowning_face_with_open_mouth icon
  /// Name frowning_face_with_open_mouth turns into flutterish frowningFaceWithOpenMouth
  const LineIcon.frowningFaceWithOpenMouth({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.frowningFaceWithOpenMouth,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_glass_martini icon
  /// Name alternate_glass_martini turns into flutterish alternateGlassMartini
  const LineIcon.alternateGlassMartini({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateGlassMartini,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for globe_with_africa_shown icon
  /// Name globe_with_africa_shown turns into flutterish globeWithAfricaShown
  const LineIcon.globeWithAfricaShown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.globeWithAfricaShown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for globe_with_americas_shown icon
  /// Name globe_with_americas_shown turns into flutterish globeWithAmericasShown
  const LineIcon.globeWithAmericasShown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.globeWithAmericasShown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for globe_with_asia_shown icon
  /// Name globe_with_asia_shown turns into flutterish globeWithAsiaShown
  const LineIcon.globeWithAsiaShown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.globeWithAsiaShown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for grimacing_face icon
  /// Name grimacing_face turns into flutterish grimacingFace
  const LineIcon.grimacingFace({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.grimacingFace,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for grinning_face icon
  /// Name grinning_face turns into flutterish grinningFace
  const LineIcon.grinningFace({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.grinningFace,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_grinning_face icon
  /// Name alternate_grinning_face turns into flutterish alternateGrinningFace
  const LineIcon.alternateGrinningFace({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateGrinningFace,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for grinning_face_with_smiling_eyes icon
  /// Name grinning_face_with_smiling_eyes turns into flutterish grinningFaceWithSmilingEyes
  const LineIcon.grinningFaceWithSmilingEyes({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.grinningFaceWithSmilingEyes,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for grinning_face_with_sweat icon
  /// Name grinning_face_with_sweat turns into flutterish grinningFaceWithSweat
  const LineIcon.grinningFaceWithSweat({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.grinningFaceWithSweat,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for smiling_face_with_heart_eyes icon
  /// Name smiling_face_with_heart_eyes turns into flutterish smilingFaceWithHeartEyes
  const LineIcon.smilingFaceWithHeartEyes({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.smilingFaceWithHeartEyes,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for grinning_squinting_face icon
  /// Name grinning_squinting_face turns into flutterish grinningSquintingFace
  const LineIcon.grinningSquintingFace({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.grinningSquintingFace,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for rolling_on_the_floor_laughing icon
  /// Name rolling_on_the_floor_laughing turns into flutterish rollingOnTheFloorLaughing
  const LineIcon.rollingOnTheFloorLaughing({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.rollingOnTheFloorLaughing,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for star_struck icon
  /// Name star_struck turns into flutterish starStruck
  const LineIcon.starStruck({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.starStruck,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for face_with_tears_of_joy icon
  /// Name face_with_tears_of_joy turns into flutterish faceWithTearsOfJoy
  const LineIcon.faceWithTearsOfJoy({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.faceWithTearsOfJoy,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for face_with_tongue icon
  /// Name face_with_tongue turns into flutterish faceWithTongue
  const LineIcon.faceWithTongue({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.faceWithTongue,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for squinting_face_with_tongue icon
  /// Name squinting_face_with_tongue turns into flutterish squintingFaceWithTongue
  const LineIcon.squintingFaceWithTongue({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.squintingFaceWithTongue,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for winking_face_with_tongue icon
  /// Name winking_face_with_tongue turns into flutterish winkingFaceWithTongue
  const LineIcon.winkingFaceWithTongue({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.winkingFaceWithTongue,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for grinning_winking_face icon
  /// Name grinning_winking_face turns into flutterish grinningWinkingFace
  const LineIcon.grinningWinkingFace({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.grinningWinkingFace,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for grip_horizontal icon
  /// Name grip_horizontal turns into flutterish gripHorizontal
  const LineIcon.gripHorizontal({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.gripHorizontal,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for grip_vertical icon
  /// Name grip_vertical turns into flutterish gripVertical
  const LineIcon.gripVertical({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.gripVertical,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_headphones icon
  /// Name alternate_headphones turns into flutterish alternateHeadphones
  const LineIcon.alternateHeadphones({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateHeadphones,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for headset icon
  /// Name headset turns into flutterish headset
  const LineIcon.headset({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.headset,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for highlighter icon
  /// Name highlighter turns into flutterish highlighter
  const LineIcon.highlighter({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.highlighter,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hornbill icon
  /// Name hornbill turns into flutterish hornbill
  const LineIcon.hornbill({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hornbill,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hot_tub icon
  /// Name hot_tub turns into flutterish hotTub
  const LineIcon.hotTub({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hotTub,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hotel icon
  /// Name hotel turns into flutterish hotel
  const LineIcon.hotel({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hotel,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for joint icon
  /// Name joint turns into flutterish joint
  const LineIcon.joint({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.joint,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for kissing_face icon
  /// Name kissing_face turns into flutterish kissingFace
  const LineIcon.kissingFace({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.kissingFace,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for kissing_face_with_smiling_eyes icon
  /// Name kissing_face_with_smiling_eyes turns into flutterish kissingFaceWithSmilingEyes
  const LineIcon.kissingFaceWithSmilingEyes({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.kissingFaceWithSmilingEyes,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for face_blowing_a_kiss icon
  /// Name face_blowing_a_kiss turns into flutterish faceBlowingAKiss
  const LineIcon.faceBlowingAKiss({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.faceBlowingAKiss,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for grinning_face_with_big_eyes icon
  /// Name grinning_face_with_big_eyes turns into flutterish grinningFaceWithBigEyes
  const LineIcon.grinningFaceWithBigEyes({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.grinningFaceWithBigEyes,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for laugh_face_with_beaming_eyes icon
  /// Name laugh_face_with_beaming_eyes turns into flutterish laughFaceWithBeamingEyes
  const LineIcon.laughFaceWithBeamingEyes({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.laughFaceWithBeamingEyes,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for laughing_squinting_face icon
  /// Name laughing_squinting_face turns into flutterish laughingSquintingFace
  const LineIcon.laughingSquintingFace({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.laughingSquintingFace,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for laughing_winking_face icon
  /// Name laughing_winking_face turns into flutterish laughingWinkingFace
  const LineIcon.laughingWinkingFace({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.laughingWinkingFace,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for luggage_cart icon
  /// Name luggage_cart turns into flutterish luggageCart
  const LineIcon.luggageCart({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.luggageCart,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mailchimp icon
  /// Name mailchimp turns into flutterish mailchimp
  const LineIcon.mailchimp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mailchimp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for map_marked icon
  /// Name map_marked turns into flutterish mapMarked
  const LineIcon.mapMarked({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mapMarked,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_map_marked icon
  /// Name alternate_map_marked turns into flutterish alternateMapMarked
  const LineIcon.alternateMapMarked({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateMapMarked,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for marker icon
  /// Name marker turns into flutterish marker
  const LineIcon.marker({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.marker,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for medal icon
  /// Name medal turns into flutterish medal
  const LineIcon.medal({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.medal,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for megaport icon
  /// Name megaport turns into flutterish megaport
  const LineIcon.megaport({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.megaport,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for face_without_mouth icon
  /// Name face_without_mouth turns into flutterish faceWithoutMouth
  const LineIcon.faceWithoutMouth({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.faceWithoutMouth,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for face_with_rolling_eyes icon
  /// Name face_with_rolling_eyes turns into flutterish faceWithRollingEyes
  const LineIcon.faceWithRollingEyes({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.faceWithRollingEyes,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for monument icon
  /// Name monument turns into flutterish monument
  const LineIcon.monument({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.monument,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mortar_pestle icon
  /// Name mortar_pestle turns into flutterish mortarPestle
  const LineIcon.mortarPestle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mortarPestle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for nimblr icon
  /// Name nimblr turns into flutterish nimblr
  const LineIcon.nimblr({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.nimblr,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for paint_roller icon
  /// Name paint_roller turns into flutterish paintRoller
  const LineIcon.paintRoller({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.paintRoller,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for passport icon
  /// Name passport turns into flutterish passport
  const LineIcon.passport({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.passport,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pen_fancy icon
  /// Name pen_fancy turns into flutterish penFancy
  const LineIcon.penFancy({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.penFancy,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pen_nib icon
  /// Name pen_nib turns into flutterish penNib
  const LineIcon.penNib({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.penNib,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pencil_ruler icon
  /// Name pencil_ruler turns into flutterish pencilRuler
  const LineIcon.pencilRuler({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pencilRuler,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for plane_arrival icon
  /// Name plane_arrival turns into flutterish planeArrival
  const LineIcon.planeArrival({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.planeArrival,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for plane_departure icon
  /// Name plane_departure turns into flutterish planeDeparture
  const LineIcon.planeDeparture({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.planeDeparture,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for prescription icon
  /// Name prescription turns into flutterish prescription
  const LineIcon.prescription({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.prescription,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for rev_io icon
  /// Name rev_io turns into flutterish revIo
  const LineIcon.revIo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.revIo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for crying_face icon
  /// Name crying_face turns into flutterish cryingFace
  const LineIcon.cryingFace({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cryingFace,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for loudly_crying_face icon
  /// Name loudly_crying_face turns into flutterish loudlyCryingFace
  const LineIcon.loudlyCryingFace({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.loudlyCryingFace,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for shopware icon
  /// Name shopware turns into flutterish shopware
  const LineIcon.shopware({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.shopware,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for shuttle_van icon
  /// Name shuttle_van turns into flutterish shuttleVan
  const LineIcon.shuttleVan({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.shuttleVan,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for signature icon
  /// Name signature turns into flutterish signature
  const LineIcon.signature({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.signature,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for beaming_face_with_smiling_eyes icon
  /// Name beaming_face_with_smiling_eyes turns into flutterish beamingFaceWithSmilingEyes
  const LineIcon.beamingFaceWithSmilingEyes({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.beamingFaceWithSmilingEyes,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for solar_panel icon
  /// Name solar_panel turns into flutterish solarPanel
  const LineIcon.solarPanel({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.solarPanel,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for spa icon
  /// Name spa turns into flutterish spa
  const LineIcon.spa({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.spa,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for splotch icon
  /// Name splotch turns into flutterish splotch
  const LineIcon.splotch({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.splotch,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for spray_can icon
  /// Name spray_can turns into flutterish sprayCan
  const LineIcon.sprayCan({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sprayCan,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for squarespace icon
  /// Name squarespace turns into flutterish squarespace
  const LineIcon.squarespace({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.squarespace,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for stamp icon
  /// Name stamp turns into flutterish stamp
  const LineIcon.stamp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.stamp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_star_half icon
  /// Name alternate_star_half turns into flutterish alternateStarHalf
  const LineIcon.alternateStarHalf({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateStarHalf,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for suitcase_rolling icon
  /// Name suitcase_rolling turns into flutterish suitcaseRolling
  const LineIcon.suitcaseRolling({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.suitcaseRolling,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hushed_face icon
  /// Name hushed_face turns into flutterish hushedFace
  const LineIcon.hushedFace({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hushedFace,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for swatchbook icon
  /// Name swatchbook turns into flutterish swatchbook
  const LineIcon.swatchbook({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.swatchbook,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for swimmer icon
  /// Name swimmer turns into flutterish swimmer
  const LineIcon.swimmer({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.swimmer,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for swimming_pool icon
  /// Name swimming_pool turns into flutterish swimmingPool
  const LineIcon.swimmingPool({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.swimmingPool,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for themeco icon
  /// Name themeco turns into flutterish themeco
  const LineIcon.themeco({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.themeco,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for tint_slash icon
  /// Name tint_slash turns into flutterish tintSlash
  const LineIcon.tintSlash({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tintSlash,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for tired_face icon
  /// Name tired_face turns into flutterish tiredFace
  const LineIcon.tiredFace({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tiredFace,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for tooth icon
  /// Name tooth turns into flutterish tooth
  const LineIcon.tooth({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tooth,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for umbrella_beach icon
  /// Name umbrella_beach turns into flutterish umbrellaBeach
  const LineIcon.umbrellaBeach({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.umbrellaBeach,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for vector_square icon
  /// Name vector_square turns into flutterish vectorSquare
  const LineIcon.vectorSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.vectorSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for weebly icon
  /// Name weebly turns into flutterish weebly
  const LineIcon.weebly({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.weebly,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hanging_weight icon
  /// Name hanging_weight turns into flutterish hangingWeight
  const LineIcon.hangingWeight({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hangingWeight,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_wine_glass icon
  /// Name alternate_wine_glas turns into flutterish alternateWineGlass
  const LineIcon.alternateWineGlass({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateWineGlass,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_wine_glas icon
  /// Name alternate_wine_glas turns into flutterish alternateWineGlas
  const LineIcon.alternateWineGlas({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateWineGlas,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for wix icon
  /// Name wix turns into flutterish wix
  const LineIcon.wix({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wix,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for air_freshener icon
  /// Name air_freshener turns into flutterish airFreshener
  const LineIcon.airFreshener({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.airFreshener,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for fruit_apple icon
  /// Name fruit_apple turns into flutterish fruitApple
  const LineIcon.fruitApple({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fruitApple,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for atom icon
  /// Name atom turns into flutterish atom
  const LineIcon.atom({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.atom,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bone icon
  /// Name bone turns into flutterish bone
  const LineIcon.bone({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bone,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for book_reader icon
  /// Name book_reader turns into flutterish bookReader
  const LineIcon.bookReader({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bookReader,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for brain icon
  /// Name brain turns into flutterish brain
  const LineIcon.brain({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.brain,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_car icon
  /// Name alternate_car turns into flutterish alternateCar
  const LineIcon.alternateCar({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateCar,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for car_battery icon
  /// Name car_battery turns into flutterish carBattery
  const LineIcon.carBattery({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.carBattery,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for car_crash icon
  /// Name car_crash turns into flutterish carCrash
  const LineIcon.carCrash({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.carCrash,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for car_side icon
  /// Name car_side turns into flutterish carSide
  const LineIcon.carSide({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.carSide,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for charging_station icon
  /// Name charging_station turns into flutterish chargingStation
  const LineIcon.chargingStation({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.chargingStation,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for directions icon
  /// Name directions turns into flutterish directions
  const LineIcon.directions({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.directions,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for draw_polygon icon
  /// Name draw_polygon turns into flutterish drawPolygon
  const LineIcon.drawPolygon({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.drawPolygon,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ello icon
  /// Name ello turns into flutterish ello
  const LineIcon.ello({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.ello,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hackerrank icon
  /// Name hackerrank turns into flutterish hackerrank
  const LineIcon.hackerrank({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hackerrank,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for kaggle icon
  /// Name kaggle turns into flutterish kaggle
  const LineIcon.kaggle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.kaggle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for laptop_code icon
  /// Name laptop_code turns into flutterish laptopCode
  const LineIcon.laptopCode({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.laptopCode,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for layer_group icon
  /// Name layer_group turns into flutterish layerGroup
  const LineIcon.layerGroup({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.layerGroup,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for markdown icon
  /// Name markdown turns into flutterish markdown
  const LineIcon.markdown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.markdown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for microscope icon
  /// Name microscope turns into flutterish microscope
  const LineIcon.microscope({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.microscope,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for neos icon
  /// Name neos turns into flutterish neos
  const LineIcon.neos({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.neos,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for oil_can icon
  /// Name oil_can turns into flutterish oilCan
  const LineIcon.oilCan({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.oilCan,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for poop icon
  /// Name poop turns into flutterish poop
  const LineIcon.poop({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.poop,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for shapes icon
  /// Name shapes turns into flutterish shapes
  const LineIcon.shapes({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.shapes,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for star_of_life icon
  /// Name star_of_life turns into flutterish starOfLife
  const LineIcon.starOfLife({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.starOfLife,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for teeth icon
  /// Name teeth turns into flutterish teeth
  const LineIcon.teeth({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.teeth,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for teeth_open icon
  /// Name teeth_open turns into flutterish teethOpen
  const LineIcon.teethOpen({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.teethOpen,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for theater_masks icon
  /// Name theater_masks turns into flutterish theaterMasks
  const LineIcon.theaterMasks({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.theaterMasks,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for traffic_light icon
  /// Name traffic_light turns into flutterish trafficLight
  const LineIcon.trafficLight({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.trafficLight,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for truck_monster icon
  /// Name truck_monster turns into flutterish truckMonster
  const LineIcon.truckMonster({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.truckMonster,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for truck_side icon
  /// Name truck_side turns into flutterish truckSide
  const LineIcon.truckSide({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.truckSide,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for zhihu icon
  /// Name zhihu turns into flutterish zhihu
  const LineIcon.zhihu({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.zhihu,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ad icon
  /// Name ad turns into flutterish ad
  const LineIcon.ad({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.ad,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alipay icon
  /// Name alipay turns into flutterish alipay
  const LineIcon.alipay({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alipay,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ankh icon
  /// Name ankh turns into flutterish ankh
  const LineIcon.ankh({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.ankh,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bible icon
  /// Name bible turns into flutterish bible
  const LineIcon.bible({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bible,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for business_time icon
  /// Name business_time turns into flutterish businessTime
  const LineIcon.businessTime({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.businessTime,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for city icon
  /// Name city turns into flutterish city
  const LineIcon.city({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.city,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for comment_dollar icon
  /// Name comment_dollar turns into flutterish commentDollar
  const LineIcon.commentDollar({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.commentDollar,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for comments_dollar icon
  /// Name comments_dollar turns into flutterish commentsDollar
  const LineIcon.commentsDollar({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.commentsDollar,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cross icon
  /// Name cross turns into flutterish cross
  const LineIcon.cross({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cross,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dharmachakra icon
  /// Name dharmachakra turns into flutterish dharmachakra
  const LineIcon.dharmachakra({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dharmachakra,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for envelope_open_text icon
  /// Name envelope_open_text turns into flutterish envelopeOpenText
  const LineIcon.envelopeOpenText({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.envelopeOpenText,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for folder_minus icon
  /// Name folder_minus turns into flutterish folderMinus
  const LineIcon.folderMinus({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.folderMinus,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for folder_plus icon
  /// Name folder_plus turns into flutterish folderPlus
  const LineIcon.folderPlus({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.folderPlus,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for funnel_dollar icon
  /// Name funnel_dollar turns into flutterish funnelDollar
  const LineIcon.funnelDollar({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.funnelDollar,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for gopuram icon
  /// Name gopuram turns into flutterish gopuram
  const LineIcon.gopuram({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.gopuram,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hamsa icon
  /// Name hamsa turns into flutterish hamsa
  const LineIcon.hamsa({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hamsa,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for haykal icon
  /// Name haykal turns into flutterish haykal
  const LineIcon.haykal({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.haykal,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for jedi icon
  /// Name jedi turns into flutterish jedi
  const LineIcon.jedi({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.jedi,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for journal_of_the_whills icon
  /// Name journal_of_the_whills turns into flutterish journalOfTheWhills
  const LineIcon.journalOfTheWhills({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.journalOfTheWhills,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for kaaba icon
  /// Name kaaba turns into flutterish kaaba
  const LineIcon.kaaba({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.kaaba,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for khanda icon
  /// Name khanda turns into flutterish khanda
  const LineIcon.khanda({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.khanda,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for landmark icon
  /// Name landmark turns into flutterish landmark
  const LineIcon.landmark({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.landmark,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mail_bulk icon
  /// Name mail_bulk turns into flutterish mailBulk
  const LineIcon.mailBulk({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mailBulk,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for menorah icon
  /// Name menorah turns into flutterish menorah
  const LineIcon.menorah({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.menorah,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mosque icon
  /// Name mosque turns into flutterish mosque
  const LineIcon.mosque({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mosque,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for om icon
  /// Name om turns into flutterish om
  const LineIcon.om({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.om,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pastafarianism icon
  /// Name pastafarianism turns into flutterish pastafarianism
  const LineIcon.pastafarianism({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pastafarianism,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for peace icon
  /// Name peace turns into flutterish peace
  const LineIcon.peace({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.peace,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for place_of_worship icon
  /// Name place_of_worship turns into flutterish placeOfWorship
  const LineIcon.placeOfWorship({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.placeOfWorship,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for poll icon
  /// Name poll turns into flutterish poll
  const LineIcon.poll({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.poll,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for poll_h icon
  /// Name poll_h turns into flutterish pollH
  const LineIcon.pollH({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pollH,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pray icon
  /// Name pray turns into flutterish pray
  const LineIcon.pray({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pray,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for praying_hands icon
  /// Name praying_hands turns into flutterish prayingHands
  const LineIcon.prayingHands({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.prayingHands,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for quran icon
  /// Name quran turns into flutterish quran
  const LineIcon.quran({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.quran,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for search_dollar icon
  /// Name search_dollar turns into flutterish searchDollar
  const LineIcon.searchDollar({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.searchDollar,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for search_location icon
  /// Name search_location turns into flutterish searchLocation
  const LineIcon.searchLocation({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.searchLocation,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for socks icon
  /// Name socks turns into flutterish socks
  const LineIcon.socks({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.socks,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_square_root icon
  /// Name alternate_square_root turns into flutterish alternateSquareRoot
  const LineIcon.alternateSquareRoot({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateSquareRoot,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for star_and_crescent icon
  /// Name star_and_crescent turns into flutterish starAndCrescent
  const LineIcon.starAndCrescent({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.starAndCrescent,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for star_of_david icon
  /// Name star_of_david turns into flutterish starOfDavid
  const LineIcon.starOfDavid({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.starOfDavid,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for synagogue icon
  /// Name synagogue turns into flutterish synagogue
  const LineIcon.synagogue({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.synagogue,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for the_red_yeti icon
  /// Name the_red_yeti turns into flutterish theRedYeti
  const LineIcon.theRedYeti({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.theRedYeti,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for torah icon
  /// Name torah turns into flutterish torah
  const LineIcon.torah({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.torah,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for torii_gate icon
  /// Name torii_gate turns into flutterish toriiGate
  const LineIcon.toriiGate({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.toriiGate,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for vihara icon
  /// Name vihara turns into flutterish vihara
  const LineIcon.vihara({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.vihara,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for volume_mute icon
  /// Name volume_mute turns into flutterish volumeMute
  const LineIcon.volumeMute({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.volumeMute,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for yin_yang icon
  /// Name yin_yang turns into flutterish yinYang
  const LineIcon.yinYang({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.yinYang,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for acquisitions_incorporated icon
  /// Name acquisitions_incorporated turns into flutterish acquisitionsIncorporated
  const LineIcon.acquisitionsIncorporated({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.acquisitionsIncorporated,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for blender_phone icon
  /// Name blender_phone turns into flutterish blenderPhone
  const LineIcon.blenderPhone({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.blenderPhone,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for book_of_the_dead icon
  /// Name book_of_the_dead turns into flutterish bookOfTheDead
  const LineIcon.bookOfTheDead({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bookOfTheDead,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for campground icon
  /// Name campground turns into flutterish campground
  const LineIcon.campground({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.campground,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cat icon
  /// Name cat turns into flutterish cat
  const LineIcon.cat({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cat,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for chair icon
  /// Name chair turns into flutterish chair
  const LineIcon.chair({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.chair,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cloud_with_moon icon
  /// Name cloud_with_moon turns into flutterish cloudWithMoon
  const LineIcon.cloudWithMoon({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cloudWithMoon,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cloud_with_sun icon
  /// Name cloud_with_sun turns into flutterish cloudWithSun
  const LineIcon.cloudWithSun({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cloudWithSun,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for critical_role icon
  /// Name critical_role turns into flutterish criticalRole
  const LineIcon.criticalRole({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.criticalRole,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for d_d_beyond icon
  /// Name d_d_beyond turns into flutterish dDBeyond
  const LineIcon.dDBeyond({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dDBeyond,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dev icon
  /// Name dev turns into flutterish dev
  const LineIcon.dev({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dev,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dice_d20 icon
  /// Name dice_d20 turns into flutterish diceD20
  const LineIcon.diceD20({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.diceD20,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dice_d6 icon
  /// Name dice_d6 turns into flutterish diceD6
  const LineIcon.diceD6({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.diceD6,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dog icon
  /// Name dog turns into flutterish dog
  const LineIcon.dog({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dog,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dragon icon
  /// Name dragon turns into flutterish dragon
  const LineIcon.dragon({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dragon,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for drumstick_with_bite_taken_out icon
  /// Name drumstick_with_bite_taken_out turns into flutterish drumstickWithBiteTakenOut
  const LineIcon.drumstickWithBiteTakenOut({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.drumstickWithBiteTakenOut,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dungeon icon
  /// Name dungeon turns into flutterish dungeon
  const LineIcon.dungeon({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dungeon,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for fantasy_flight_games icon
  /// Name fantasy_flight_games turns into flutterish fantasyFlightGames
  const LineIcon.fantasyFlightGames({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fantasyFlightGames,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for file_csv icon
  /// Name file_csv turns into flutterish fileCsv
  const LineIcon.fileCsv({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fileCsv,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for raised_fist icon
  /// Name raised_fist turns into flutterish raisedFist
  const LineIcon.raisedFist({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.raisedFist,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ghost icon
  /// Name ghost turns into flutterish ghost
  const LineIcon.ghost({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.ghost,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hammer icon
  /// Name hammer turns into flutterish hammer
  const LineIcon.hammer({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hammer,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hanukiah icon
  /// Name hanukiah turns into flutterish hanukiah
  const LineIcon.hanukiah({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hanukiah,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for wizard_s_hat icon
  /// Name wizard_s_hat turns into flutterish wizardSHat
  const LineIcon.wizardSHat({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wizardSHat,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hiking icon
  /// Name hiking turns into flutterish hiking
  const LineIcon.hiking({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hiking,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hippo icon
  /// Name hippo turns into flutterish hippo
  const LineIcon.hippo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hippo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for horse icon
  /// Name horse turns into flutterish horse
  const LineIcon.horse({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.horse,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for damaged_house icon
  /// Name damaged_house turns into flutterish damagedHouse
  const LineIcon.damagedHouse({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.damagedHouse,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hryvnia icon
  /// Name hryvnia turns into flutterish hryvnia
  const LineIcon.hryvnia({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hryvnia,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mask icon
  /// Name mask turns into flutterish mask
  const LineIcon.mask({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mask,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mountain icon
  /// Name mountain turns into flutterish mountain
  const LineIcon.mountain({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mountain,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for wired_network icon
  /// Name wired_network turns into flutterish wiredNetwork
  const LineIcon.wiredNetwork({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wiredNetwork,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for otter icon
  /// Name otter turns into flutterish otter
  const LineIcon.otter({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.otter,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for penny_arcade icon
  /// Name penny_arcade turns into flutterish pennyArcade
  const LineIcon.pennyArcade({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pennyArcade,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ring icon
  /// Name ring turns into flutterish ring
  const LineIcon.ring({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.ring,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for running icon
  /// Name running turns into flutterish running
  const LineIcon.running({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.running,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for scroll icon
  /// Name scroll turns into flutterish scroll
  const LineIcon.scroll({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.scroll,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for skull___crossbones icon
  /// Name skull___crossbones turns into flutterish skullCrossbones
  const LineIcon.skullCrossbones({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.skullCrossbones,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for slash icon
  /// Name slash turns into flutterish slash
  const LineIcon.slash({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.slash,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for spider icon
  /// Name spider turns into flutterish spider
  const LineIcon.spider({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.spider,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for toilet_paper icon
  /// Name toilet_paper turns into flutterish toiletPaper
  const LineIcon.toiletPaper({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.toiletPaper,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for tractor icon
  /// Name tractor turns into flutterish tractor
  const LineIcon.tractor({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tractor,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for user_injured icon
  /// Name user_injured turns into flutterish userInjured
  const LineIcon.userInjured({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.userInjured,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cardboard_vr icon
  /// Name cardboard_vr turns into flutterish cardboardVr
  const LineIcon.cardboardVr({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cardboardVr,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for wind icon
  /// Name wind turns into flutterish wind
  const LineIcon.wind({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wind,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for wine_bottle icon
  /// Name wine_bottle turns into flutterish wineBottle
  const LineIcon.wineBottle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wineBottle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for wizards_of_the_coast icon
  /// Name wizards_of_the_coast turns into flutterish wizardsOfTheCoast
  const LineIcon.wizardsOfTheCoast({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.wizardsOfTheCoast,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for think_peaks icon
  /// Name think_peaks turns into flutterish thinkPeaks
  const LineIcon.thinkPeaks({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.thinkPeaks,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cloud_with__a_chance_of__meatball icon
  /// Name cloud_with__a_chance_of__meatball turns into flutterish cloudWithAChanceOfMeatball
  const LineIcon.cloudWithAChanceOfMeatball({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cloudWithAChanceOfMeatball,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cloud_with_moon_and_rain icon
  /// Name cloud_with_moon_and_rain turns into flutterish cloudWithMoonAndRain
  const LineIcon.cloudWithMoonAndRain({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cloudWithMoonAndRain,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cloud_with_rain icon
  /// Name cloud_with_rain turns into flutterish cloudWithRain
  const LineIcon.cloudWithRain({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cloudWithRain,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cloud_with_heavy_showers icon
  /// Name cloud_with_heavy_showers turns into flutterish cloudWithHeavyShowers
  const LineIcon.cloudWithHeavyShowers({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cloudWithHeavyShowers,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cloud_with_sun_and_rain icon
  /// Name cloud_with_sun_and_rain turns into flutterish cloudWithSunAndRain
  const LineIcon.cloudWithSunAndRain({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cloudWithSunAndRain,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for democrat icon
  /// Name democrat turns into flutterish democrat
  const LineIcon.democrat({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.democrat,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for united_states_of_america_flag icon
  /// Name united_states_of_america_flag turns into flutterish unitedStatesOfAmericaFlag
  const LineIcon.unitedStatesOfAmericaFlag({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.unitedStatesOfAmericaFlag,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for meteor icon
  /// Name meteor turns into flutterish meteor
  const LineIcon.meteor({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.meteor,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for person_entering_booth icon
  /// Name person_entering_booth turns into flutterish personEnteringBooth
  const LineIcon.personEnteringBooth({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.personEnteringBooth,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for poo_storm icon
  /// Name poo_storm turns into flutterish pooStorm
  const LineIcon.pooStorm({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pooStorm,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for rainbow icon
  /// Name rainbow turns into flutterish rainbow
  const LineIcon.rainbow({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.rainbow,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for reacteurope icon
  /// Name reacteurope turns into flutterish reacteurope
  const LineIcon.reacteurope({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.reacteurope,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for republican icon
  /// Name republican turns into flutterish republican
  const LineIcon.republican({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.republican,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for smog icon
  /// Name smog turns into flutterish smog
  const LineIcon.smog({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.smog,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for high_temperature icon
  /// Name high_temperature turns into flutterish highTemperature
  const LineIcon.highTemperature({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.highTemperature,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for low_temperature icon
  /// Name low_temperature turns into flutterish lowTemperature
  const LineIcon.lowTemperature({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.lowTemperature,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for vote_yea icon
  /// Name vote_yea turns into flutterish voteYea
  const LineIcon.voteYea({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.voteYea,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for water icon
  /// Name water turns into flutterish water
  const LineIcon.water({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.water,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for adobe icon
  /// Name adobe turns into flutterish adobe
  const LineIcon.adobe({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.adobe,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for artstation icon
  /// Name artstation turns into flutterish artstation
  const LineIcon.artstation({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.artstation,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for atlassian icon
  /// Name atlassian turns into flutterish atlassian
  const LineIcon.atlassian({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.atlassian,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for baby icon
  /// Name baby turns into flutterish baby
  const LineIcon.baby({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.baby,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for baby_carriage icon
  /// Name baby_carriage turns into flutterish babyCarriage
  const LineIcon.babyCarriage({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.babyCarriage,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for biohazard icon
  /// Name biohazard turns into flutterish biohazard
  const LineIcon.biohazard({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.biohazard,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for blog icon
  /// Name blog turns into flutterish blog
  const LineIcon.blog({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.blog,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for calendar_with_day_focus icon
  /// Name calendar_with_day_focus turns into flutterish calendarWithDayFocus
  const LineIcon.calendarWithDayFocus({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.calendarWithDayFocus,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for calendar_with_week_focus icon
  /// Name calendar_with_week_focus turns into flutterish calendarWithWeekFocus
  const LineIcon.calendarWithWeekFocus({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.calendarWithWeekFocus,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for canadian_maple_leaf icon
  /// Name canadian_maple_leaf turns into flutterish canadianMapleLeaf
  const LineIcon.canadianMapleLeaf({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.canadianMapleLeaf,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for candy_cane icon
  /// Name candy_cane turns into flutterish candyCane
  const LineIcon.candyCane({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.candyCane,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for carrot icon
  /// Name carrot turns into flutterish carrot
  const LineIcon.carrot({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.carrot,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cash_register icon
  /// Name cash_register turns into flutterish cashRegister
  const LineIcon.cashRegister({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cashRegister,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for centos icon
  /// Name centos turns into flutterish centos
  const LineIcon.centos({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.centos,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_compress_arrows icon
  /// Name alternate_compress_arrows turns into flutterish alternateCompressArrows
  const LineIcon.alternateCompressArrows({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateCompressArrows,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for confluence icon
  /// Name confluence turns into flutterish confluence
  const LineIcon.confluence({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.confluence,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dhl icon
  /// Name dhl turns into flutterish dhl
  const LineIcon.dhl({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dhl,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for diaspora icon
  /// Name diaspora turns into flutterish diaspora
  const LineIcon.diaspora({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.diaspora,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dumpster icon
  /// Name dumpster turns into flutterish dumpster
  const LineIcon.dumpster({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dumpster,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for dumpster_fire icon
  /// Name dumpster_fire turns into flutterish dumpsterFire
  const LineIcon.dumpsterFire({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.dumpsterFire,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ethernet icon
  /// Name ethernet turns into flutterish ethernet
  const LineIcon.ethernet({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.ethernet,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for fedex icon
  /// Name fedex turns into flutterish fedex
  const LineIcon.fedex({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fedex,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for fedora icon
  /// Name fedora turns into flutterish fedora
  const LineIcon.fedora({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fedora,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for figma icon
  /// Name figma turns into flutterish figma
  const LineIcon.figma({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.figma,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for gifts icon
  /// Name gifts turns into flutterish gifts
  const LineIcon.gifts({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.gifts,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for glass_cheers icon
  /// Name glass_cheers turns into flutterish glassCheers
  const LineIcon.glassCheers({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.glassCheers,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for glass_whiskey icon
  /// Name glass_whiskey turns into flutterish glassWhiskey
  const LineIcon.glassWhiskey({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.glassWhiskey,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for globe_with_europe_shown icon
  /// Name globe_with_europe_shown turns into flutterish globeWithEuropeShown
  const LineIcon.globeWithEuropeShown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.globeWithEuropeShown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for grip_lines icon
  /// Name grip_lines turns into flutterish gripLines
  const LineIcon.gripLines({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.gripLines,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for grip_lines_vertical icon
  /// Name grip_lines_vertical turns into flutterish gripLinesVertical
  const LineIcon.gripLinesVertical({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.gripLinesVertical,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for guitar icon
  /// Name guitar turns into flutterish guitar
  const LineIcon.guitar({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.guitar,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for heart_broken icon
  /// Name heart_broken turns into flutterish heartBroken
  const LineIcon.heartBroken({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.heartBroken,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for holly_berry icon
  /// Name holly_berry turns into flutterish hollyBerry
  const LineIcon.hollyBerry({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hollyBerry,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for horse_head icon
  /// Name horse_head turns into flutterish horseHead
  const LineIcon.horseHead({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.horseHead,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for icicles icon
  /// Name icicles turns into flutterish icicles
  const LineIcon.icicles({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.icicles,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for igloo icon
  /// Name igloo turns into flutterish igloo
  const LineIcon.igloo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.igloo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for intercom icon
  /// Name intercom turns into flutterish intercom
  const LineIcon.intercom({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.intercom,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for invision icon
  /// Name invision turns into flutterish invision
  const LineIcon.invision({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.invision,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for jira icon
  /// Name jira turns into flutterish jira
  const LineIcon.jira({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.jira,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mendeley icon
  /// Name mendeley turns into flutterish mendeley
  const LineIcon.mendeley({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mendeley,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mitten icon
  /// Name mitten turns into flutterish mitten
  const LineIcon.mitten({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mitten,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mug_hot icon
  /// Name mug_hot turns into flutterish mugHot
  const LineIcon.mugHot({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mugHot,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for radiation icon
  /// Name radiation turns into flutterish radiation
  const LineIcon.radiation({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.radiation,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_radiation icon
  /// Name alternate_radiation turns into flutterish alternateRadiation
  const LineIcon.alternateRadiation({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateRadiation,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for raspberry_pi icon
  /// Name raspberry_pi turns into flutterish raspberryPi
  const LineIcon.raspberryPi({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.raspberryPi,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for redhat icon
  /// Name redhat turns into flutterish redhat
  const LineIcon.redhat({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.redhat,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for restroom icon
  /// Name restroom turns into flutterish restroom
  const LineIcon.restroom({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.restroom,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for satellite icon
  /// Name satellite turns into flutterish satellite
  const LineIcon.satellite({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.satellite,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for satellite_dish icon
  /// Name satellite_dish turns into flutterish satelliteDish
  const LineIcon.satelliteDish({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.satelliteDish,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sd_card icon
  /// Name sd_card turns into flutterish sdCard
  const LineIcon.sdCard({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sdCard,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sim_card icon
  /// Name sim_card turns into flutterish simCard
  const LineIcon.simCard({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.simCard,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for skating icon
  /// Name skating turns into flutterish skating
  const LineIcon.skating({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.skating,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sketch icon
  /// Name sketch turns into flutterish sketch
  const LineIcon.sketch({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sketch,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for skiing icon
  /// Name skiing turns into flutterish skiing
  const LineIcon.skiing({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.skiing,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for skiing_nordic icon
  /// Name skiing_nordic turns into flutterish skiingNordic
  const LineIcon.skiingNordic({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.skiingNordic,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sleigh icon
  /// Name sleigh turns into flutterish sleigh
  const LineIcon.sleigh({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sleigh,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sms icon
  /// Name sms turns into flutterish sms
  const LineIcon.sms({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sms,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for snowboarding icon
  /// Name snowboarding turns into flutterish snowboarding
  const LineIcon.snowboarding({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.snowboarding,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for snowman icon
  /// Name snowman turns into flutterish snowman
  const LineIcon.snowman({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.snowman,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for snowplow icon
  /// Name snowplow turns into flutterish snowplow
  const LineIcon.snowplow({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.snowplow,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for sourcetree icon
  /// Name sourcetree turns into flutterish sourcetree
  const LineIcon.sourcetree({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.sourcetree,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for suse icon
  /// Name suse turns into flutterish suse
  const LineIcon.suse({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.suse,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for tenge icon
  /// Name tenge turns into flutterish tenge
  const LineIcon.tenge({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tenge,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for toilet icon
  /// Name toilet turns into flutterish toilet
  const LineIcon.toilet({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.toilet,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for tools icon
  /// Name tools turns into flutterish tools
  const LineIcon.tools({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tools,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for tram icon
  /// Name tram turns into flutterish tram
  const LineIcon.tram({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.tram,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ubuntu icon
  /// Name ubuntu turns into flutterish ubuntu
  const LineIcon.ubuntu({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.ubuntu,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ups icon
  /// Name ups turns into flutterish ups
  const LineIcon.ups({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.ups,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for united_states_postal_service icon
  /// Name united_states_postal_service turns into flutterish unitedStatesPostalService
  const LineIcon.unitedStatesPostalService({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.unitedStatesPostalService,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for yarn icon
  /// Name yarn turns into flutterish yarn
  const LineIcon.yarn({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.yarn,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_fire icon
  /// Name alternate_fire turns into flutterish alternateFire
  const LineIcon.alternateFire({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateFire,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bacon icon
  /// Name bacon turns into flutterish bacon
  const LineIcon.bacon({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bacon,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for medical_book icon
  /// Name medical_book turns into flutterish medicalBook
  const LineIcon.medicalBook({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.medicalBook,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bread_slice icon
  /// Name bread_slice turns into flutterish breadSlice
  const LineIcon.breadSlice({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.breadSlice,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cheese icon
  /// Name cheese turns into flutterish cheese
  const LineIcon.cheese({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cheese,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for medical_clinic icon
  /// Name medical_clinic turns into flutterish medicalClinic
  const LineIcon.medicalClinic({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.medicalClinic,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_medical_chat icon
  /// Name alternate_medical_chat turns into flutterish alternateMedicalChat
  const LineIcon.alternateMedicalChat({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateMedicalChat,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for crutch icon
  /// Name crutch turns into flutterish crutch
  const LineIcon.crutch({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.crutch,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for egg icon
  /// Name egg turns into flutterish egg
  const LineIcon.egg({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.egg,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hamburger icon
  /// Name hamburger turns into flutterish hamburger
  const LineIcon.hamburger({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hamburger,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hand_with_middle_finger_raised icon
  /// Name hand_with_middle_finger_raised turns into flutterish handWithMiddleFingerRaised
  const LineIcon.handWithMiddleFingerRaised({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.handWithMiddleFingerRaised,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hard_hat icon
  /// Name hard_hat turns into flutterish hardHat
  const LineIcon.hardHat({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hardHat,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hot_dog icon
  /// Name hot_dog turns into flutterish hotDog
  const LineIcon.hotDog({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hotDog,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for ice_cream icon
  /// Name ice_cream turns into flutterish iceCream
  const LineIcon.iceCream({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.iceCream,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for laptop_medical icon
  /// Name laptop_medical turns into flutterish laptopMedical
  const LineIcon.laptopMedical({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.laptopMedical,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pager icon
  /// Name pager turns into flutterish pager
  const LineIcon.pager({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pager,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for hot_pepper icon
  /// Name hot_pepper turns into flutterish hotPepper
  const LineIcon.hotPepper({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.hotPepper,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for pizza_slice icon
  /// Name pizza_slice turns into flutterish pizzaSlice
  const LineIcon.pizzaSlice({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.pizzaSlice,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for trash_restore icon
  /// Name trash_restore turns into flutterish trashRestore
  const LineIcon.trashRestore({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.trashRestore,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternative_trash_restore icon
  /// Name alternative_trash_restore turns into flutterish alternativeTrashRestore
  const LineIcon.alternativeTrashRestore({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternativeTrashRestore,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for nurse icon
  /// Name nurse turns into flutterish nurse
  const LineIcon.nurse({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.nurse,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for airbnb icon
  /// Name airbnb turns into flutterish airbnb
  const LineIcon.airbnb({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.airbnb,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for battle_net icon
  /// Name battle_net turns into flutterish battleNet
  const LineIcon.battleNet({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.battleNet,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for bootstrap icon
  /// Name bootstrap turns into flutterish bootstrap
  const LineIcon.bootstrap({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.bootstrap,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for buffer icon
  /// Name buffer turns into flutterish buffer
  const LineIcon.buffer({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.buffer,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for chromecast icon
  /// Name chromecast turns into flutterish chromecast
  const LineIcon.chromecast({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.chromecast,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for evernote icon
  /// Name evernote turns into flutterish evernote
  const LineIcon.evernote({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.evernote,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for itch_io icon
  /// Name itch_io turns into flutterish itchIo
  const LineIcon.itchIo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.itchIo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for salesforce icon
  /// Name salesforce turns into flutterish salesforce
  const LineIcon.salesforce({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.salesforce,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for speaker_deck icon
  /// Name speaker_deck turns into flutterish speakerDeck
  const LineIcon.speakerDeck({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.speakerDeck,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for symfony icon
  /// Name symfony turns into flutterish symfony
  const LineIcon.symfony({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.symfony,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for square_wave icon
  /// Name square_wave turns into flutterish squareWave
  const LineIcon.squareWave({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.squareWave,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for waze icon
  /// Name waze turns into flutterish waze
  const LineIcon.waze({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.waze,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for yammer icon
  /// Name yammer turns into flutterish yammer
  const LineIcon.yammer({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.yammer,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for git_alt icon
  /// Name git_alt turns into flutterish gitAlt
  const LineIcon.gitAlt({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.gitAlt,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for stackpath icon
  /// Name stackpath turns into flutterish stackpath
  const LineIcon.stackpath({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.stackpath,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for biking icon
  /// Name biking turns into flutterish biking
  const LineIcon.biking({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.biking,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for border_all icon
  /// Name border_all turns into flutterish borderAll
  const LineIcon.borderAll({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.borderAll,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for border_none icon
  /// Name border_none turns into flutterish borderNone
  const LineIcon.borderNone({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.borderNone,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for border_style icon
  /// Name border_style turns into flutterish borderStyle
  const LineIcon.borderStyle({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.borderStyle,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for fan icon
  /// Name fan turns into flutterish fan
  const LineIcon.fan({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.fan,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for icons icon
  /// Name icons turns into flutterish icons
  const LineIcon.icons({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.icons,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_phone icon
  /// Name alternate_phone turns into flutterish alternatePhone
  const LineIcon.alternatePhone({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternatePhone,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_phone_square icon
  /// Name alternate_phone_square turns into flutterish alternatePhoneSquare
  const LineIcon.alternatePhoneSquare({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternatePhoneSquare,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for photo_video icon
  /// Name photo_video turns into flutterish photoVideo
  const LineIcon.photoVideo({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.photoVideo,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for remove_format icon
  /// Name remove_format turns into flutterish removeFormat
  const LineIcon.removeFormat({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.removeFormat,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_sort_alphabetical_down icon
  /// Name alternate_sort_alphabetical_down turns into flutterish alternateSortAlphabeticalDown
  const LineIcon.alternateSortAlphabeticalDown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateSortAlphabeticalDown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_sort_alphabetical_up icon
  /// Name alternate_sort_alphabetical_up turns into flutterish alternateSortAlphabeticalUp
  const LineIcon.alternateSortAlphabeticalUp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateSortAlphabeticalUp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_sort_amount_down icon
  /// Name alternate_sort_amount_down turns into flutterish alternateSortAmountDown
  const LineIcon.alternateSortAmountDown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateSortAmountDown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_sort_amount_up icon
  /// Name alternate_sort_amount_up turns into flutterish alternateSortAmountUp
  const LineIcon.alternateSortAmountUp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateSortAmountUp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_sort_numeric_down icon
  /// Name alternate_sort_numeric_down turns into flutterish alternateSortNumericDown
  const LineIcon.alternateSortNumericDown({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateSortNumericDown,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for alternate_sort_numeric_up icon
  /// Name alternate_sort_numeric_up turns into flutterish alternateSortNumericUp
  const LineIcon.alternateSortNumericUp({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.alternateSortNumericUp,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for spell_check icon
  /// Name spell_check turns into flutterish spellCheck
  const LineIcon.spellCheck({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.spellCheck,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for voicemail icon
  /// Name voicemail turns into flutterish voicemail
  const LineIcon.voicemail({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.voicemail,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cotton_bureau icon
  /// Name cotton_bureau turns into flutterish cottonBureau
  const LineIcon.cottonBureau({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cottonBureau,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for buy_n_large icon
  /// Name buy_n_large turns into flutterish buyNLarge
  const LineIcon.buyNLarge({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.buyNLarge,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cowboy_hat icon
  /// Name cowboy_hat turns into flutterish cowboyHat
  const LineIcon.cowboyHat({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cowboyHat,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for cowboy_hat_side icon
  /// Name cowboy_hat_side turns into flutterish cowboyHatSide
  const LineIcon.cowboyHatSide({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.cowboyHatSide,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for material_design_for_bootstrap icon
  /// Name material_design_for_bootstrap turns into flutterish materialDesignForBootstrap
  const LineIcon.materialDesignForBootstrap({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.materialDesignForBootstrap,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for mouse icon
  /// Name mouse turns into flutterish mouse
  const LineIcon.mouse({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.mouse,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for orcid icon
  /// Name orcid turns into flutterish orcid
  const LineIcon.orcid({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.orcid,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for record_vinyl icon
  /// Name record_vinyl turns into flutterish recordVinyl
  const LineIcon.recordVinyl({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.recordVinyl,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for swift icon
  /// Name swift turns into flutterish swift
  const LineIcon.swift({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.swift,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );

  /// Constructor for umbraco icon
  /// Name umbraco turns into flutterish umbraco
  const LineIcon.umbraco({
    Key? key,
    double? size,
    Color? color,
    String? semanticLabel,
    TextDirection? textDirection,
  }) : super(
          LineIcons.umbraco,
          key: key,
          size: size,
          color: color,
          semanticLabel: semanticLabel,
          textDirection: textDirection,
        );
}
