// Autogenerated from Pigeon (v17.1.1), do not edit directly.
// See also: https://pub.dev/packages/pigeon

import Foundation

#if os(iOS)
  import Flutter
#elseif os(macOS)
  import FlutterMacOS
#else
  #error("Unsupported platform.")
#endif

private func wrapResult(_ result: Any?) -> [Any?] {
  return [result]
}

private func wrapError(_ error: Any) -> [Any?] {
  if let flutterError = error as? FlutterError {
    return [
      flutterError.code,
      flutterError.message,
      flutterError.details,
    ]
  }
  return [
    "\(error)",
    "\(type(of: error))",
    "Stacktrace: \(Thread.callStackSymbols)",
  ]
}

private func isNullish(_ value: Any?) -> Bool {
  return value is NSNull || value == nil
}

private func nilOrValue<T>(_ value: Any?) -> T? {
  if value is NSNull { return nil }
  return value as! T?
}

/// Generated class from Pigeon that represents data sent in messages.
struct SFSafariViewControllerOptions {
  var preferredBarTintColor: Int64? = nil
  var preferredControlTintColor: Int64? = nil
  var barCollapsingEnabled: Bool? = nil
  var entersReaderIfAvailable: Bool? = nil
  var dismissButtonStyle: Int64? = nil
  var modalPresentationStyle: Int64? = nil
  var pageSheet: UISheetPresentationControllerConfiguration? = nil

  static func fromList(_ list: [Any?]) -> SFSafariViewControllerOptions? {
    let preferredBarTintColor: Int64? = isNullish(list[0]) ? nil : (list[0] is Int64? ? list[0] as! Int64? : Int64(list[0] as! Int32))
    let preferredControlTintColor: Int64? = isNullish(list[1]) ? nil : (list[1] is Int64? ? list[1] as! Int64? : Int64(list[1] as! Int32))
    let barCollapsingEnabled: Bool? = nilOrValue(list[2])
    let entersReaderIfAvailable: Bool? = nilOrValue(list[3])
    let dismissButtonStyle: Int64? = isNullish(list[4]) ? nil : (list[4] is Int64? ? list[4] as! Int64? : Int64(list[4] as! Int32))
    let modalPresentationStyle: Int64? = isNullish(list[5]) ? nil : (list[5] is Int64? ? list[5] as! Int64? : Int64(list[5] as! Int32))
    var pageSheet: UISheetPresentationControllerConfiguration? = nil
    if let pageSheetList: [Any?] = nilOrValue(list[6]) {
      pageSheet = UISheetPresentationControllerConfiguration.fromList(pageSheetList)
    }

    return SFSafariViewControllerOptions(
      preferredBarTintColor: preferredBarTintColor,
      preferredControlTintColor: preferredControlTintColor,
      barCollapsingEnabled: barCollapsingEnabled,
      entersReaderIfAvailable: entersReaderIfAvailable,
      dismissButtonStyle: dismissButtonStyle,
      modalPresentationStyle: modalPresentationStyle,
      pageSheet: pageSheet
    )
  }
  func toList() -> [Any?] {
    return [
      preferredBarTintColor,
      preferredControlTintColor,
      barCollapsingEnabled,
      entersReaderIfAvailable,
      dismissButtonStyle,
      modalPresentationStyle,
      pageSheet?.toList(),
    ]
  }
}

/// Generated class from Pigeon that represents data sent in messages.
struct UISheetPresentationControllerConfiguration {
  var detents: [String?]
  var largestUndimmedDetentIdentifier: String? = nil
  var prefersScrollingExpandsWhenScrolledToEdge: Bool? = nil
  var prefersGrabberVisible: Bool? = nil
  var prefersEdgeAttachedInCompactHeight: Bool? = nil
  var preferredCornerRadius: Double? = nil

  static func fromList(_ list: [Any?]) -> UISheetPresentationControllerConfiguration? {
    let detents = list[0] as! [String?]
    let largestUndimmedDetentIdentifier: String? = nilOrValue(list[1])
    let prefersScrollingExpandsWhenScrolledToEdge: Bool? = nilOrValue(list[2])
    let prefersGrabberVisible: Bool? = nilOrValue(list[3])
    let prefersEdgeAttachedInCompactHeight: Bool? = nilOrValue(list[4])
    let preferredCornerRadius: Double? = nilOrValue(list[5])

    return UISheetPresentationControllerConfiguration(
      detents: detents,
      largestUndimmedDetentIdentifier: largestUndimmedDetentIdentifier,
      prefersScrollingExpandsWhenScrolledToEdge: prefersScrollingExpandsWhenScrolledToEdge,
      prefersGrabberVisible: prefersGrabberVisible,
      prefersEdgeAttachedInCompactHeight: prefersEdgeAttachedInCompactHeight,
      preferredCornerRadius: preferredCornerRadius
    )
  }
  func toList() -> [Any?] {
    return [
      detents,
      largestUndimmedDetentIdentifier,
      prefersScrollingExpandsWhenScrolledToEdge,
      prefersGrabberVisible,
      prefersEdgeAttachedInCompactHeight,
      preferredCornerRadius,
    ]
  }
}

private class CustomTabsApiCodecReader: FlutterStandardReader {
  override func readValue(ofType type: UInt8) -> Any? {
    switch type {
    case 128:
      return SFSafariViewControllerOptions.fromList(self.readValue() as! [Any?])
    case 129:
      return UISheetPresentationControllerConfiguration.fromList(self.readValue() as! [Any?])
    default:
      return super.readValue(ofType: type)
    }
  }
}

private class CustomTabsApiCodecWriter: FlutterStandardWriter {
  override func writeValue(_ value: Any) {
    if let value = value as? SFSafariViewControllerOptions {
      super.writeByte(128)
      super.writeValue(value.toList())
    } else if let value = value as? UISheetPresentationControllerConfiguration {
      super.writeByte(129)
      super.writeValue(value.toList())
    } else {
      super.writeValue(value)
    }
  }
}

private class CustomTabsApiCodecReaderWriter: FlutterStandardReaderWriter {
  override func reader(with data: Data) -> FlutterStandardReader {
    return CustomTabsApiCodecReader(data: data)
  }

  override func writer(with data: NSMutableData) -> FlutterStandardWriter {
    return CustomTabsApiCodecWriter(data: data)
  }
}

class CustomTabsApiCodec: FlutterStandardMessageCodec {
  static let shared = CustomTabsApiCodec(readerWriter: CustomTabsApiCodecReaderWriter())
}

/// Generated protocol from Pigeon that represents a handler of messages from Flutter.
protocol CustomTabsApi {
  func launchURL(_ urlString: String, prefersDeepLink: Bool, options: SFSafariViewControllerOptions?, completion: @escaping (Result<Void, Error>) -> Void)
  func closeAllIfPossible(completion: @escaping (Result<Void, Error>) -> Void)
}

/// Generated setup class from Pigeon to handle messages through the `binaryMessenger`.
class CustomTabsApiSetup {
  /// The codec used by CustomTabsApi.
  static var codec: FlutterStandardMessageCodec { CustomTabsApiCodec.shared }
  /// Sets up an instance of `CustomTabsApi` to handle messages through the `binaryMessenger`.
  static func setUp(binaryMessenger: FlutterBinaryMessenger, api: CustomTabsApi?) {
    let launchChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.flutter_custom_tabs_ios.CustomTabsApi.launch", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      launchChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let urlStringArg = args[0] as! String
        let prefersDeepLinkArg = args[1] as! Bool
        let optionsArg: SFSafariViewControllerOptions? = nilOrValue(args[2])
        api.launchURL(urlStringArg, prefersDeepLink: prefersDeepLinkArg, options: optionsArg) { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      launchChannel.setMessageHandler(nil)
    }
    let closeAllIfPossibleChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.flutter_custom_tabs_ios.CustomTabsApi.closeAllIfPossible", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      closeAllIfPossibleChannel.setMessageHandler { _, reply in
        api.closeAllIfPossible { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      closeAllIfPossibleChannel.setMessageHandler(nil)
    }
  }
}
