// Autogenerated from Pigeon (v17.1.1), do not edit directly.
// See also: https://pub.dev/packages/pigeon

package com.github.droibit.flutter.plugins.customtabs;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.CLASS;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import java.io.ByteArrayOutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** Generated class from Pigeon. */
@SuppressWarnings({"unused", "unchecked", "CodeBlock2Expr", "RedundantSuppression", "serial"})
public class Messages {

  /** Error class for passing custom error details to Flutter via a thrown PlatformException. */
  public static class FlutterError extends RuntimeException {

    /** The error code. */
    public final String code;

    /** The error details. Must be a datatype supported by the api codec. */
    public final Object details;

    public FlutterError(@NonNull String code, @Nullable String message, @Nullable Object details) 
    {
      super(message);
      this.code = code;
      this.details = details;
    }
  }

  @NonNull
  protected static ArrayList<Object> wrapError(@NonNull Throwable exception) {
    ArrayList<Object> errorList = new ArrayList<Object>(3);
    if (exception instanceof FlutterError) {
      FlutterError error = (FlutterError) exception;
      errorList.add(error.code);
      errorList.add(error.getMessage());
      errorList.add(error.details);
    } else {
      errorList.add(exception.toString());
      errorList.add(exception.getClass().getSimpleName());
      errorList.add(
        "Cause: " + exception.getCause() + ", Stacktrace: " + Log.getStackTraceString(exception));
    }
    return errorList;
  }

  @Target(METHOD)
  @Retention(CLASS)
  @interface CanIgnoreReturnValue {}

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class CustomTabsIntentOptions {
    private @Nullable ColorSchemes colorSchemes;

    public @Nullable ColorSchemes getColorSchemes() {
      return colorSchemes;
    }

    public void setColorSchemes(@Nullable ColorSchemes setterArg) {
      this.colorSchemes = setterArg;
    }

    private @Nullable Boolean urlBarHidingEnabled;

    public @Nullable Boolean getUrlBarHidingEnabled() {
      return urlBarHidingEnabled;
    }

    public void setUrlBarHidingEnabled(@Nullable Boolean setterArg) {
      this.urlBarHidingEnabled = setterArg;
    }

    private @Nullable Long shareState;

    public @Nullable Long getShareState() {
      return shareState;
    }

    public void setShareState(@Nullable Long setterArg) {
      this.shareState = setterArg;
    }

    private @Nullable Boolean showTitle;

    public @Nullable Boolean getShowTitle() {
      return showTitle;
    }

    public void setShowTitle(@Nullable Boolean setterArg) {
      this.showTitle = setterArg;
    }

    private @Nullable Boolean instantAppsEnabled;

    public @Nullable Boolean getInstantAppsEnabled() {
      return instantAppsEnabled;
    }

    public void setInstantAppsEnabled(@Nullable Boolean setterArg) {
      this.instantAppsEnabled = setterArg;
    }

    private @Nullable CloseButton closeButton;

    public @Nullable CloseButton getCloseButton() {
      return closeButton;
    }

    public void setCloseButton(@Nullable CloseButton setterArg) {
      this.closeButton = setterArg;
    }

    private @Nullable Animations animations;

    public @Nullable Animations getAnimations() {
      return animations;
    }

    public void setAnimations(@Nullable Animations setterArg) {
      this.animations = setterArg;
    }

    private @Nullable BrowserConfiguration browser;

    public @Nullable BrowserConfiguration getBrowser() {
      return browser;
    }

    public void setBrowser(@Nullable BrowserConfiguration setterArg) {
      this.browser = setterArg;
    }

    private @Nullable PartialConfiguration partial;

    public @Nullable PartialConfiguration getPartial() {
      return partial;
    }

    public void setPartial(@Nullable PartialConfiguration setterArg) {
      this.partial = setterArg;
    }

    public static final class Builder {

      private @Nullable ColorSchemes colorSchemes;

      @CanIgnoreReturnValue
      public @NonNull Builder setColorSchemes(@Nullable ColorSchemes setterArg) {
        this.colorSchemes = setterArg;
        return this;
      }

      private @Nullable Boolean urlBarHidingEnabled;

      @CanIgnoreReturnValue
      public @NonNull Builder setUrlBarHidingEnabled(@Nullable Boolean setterArg) {
        this.urlBarHidingEnabled = setterArg;
        return this;
      }

      private @Nullable Long shareState;

      @CanIgnoreReturnValue
      public @NonNull Builder setShareState(@Nullable Long setterArg) {
        this.shareState = setterArg;
        return this;
      }

      private @Nullable Boolean showTitle;

      @CanIgnoreReturnValue
      public @NonNull Builder setShowTitle(@Nullable Boolean setterArg) {
        this.showTitle = setterArg;
        return this;
      }

      private @Nullable Boolean instantAppsEnabled;

      @CanIgnoreReturnValue
      public @NonNull Builder setInstantAppsEnabled(@Nullable Boolean setterArg) {
        this.instantAppsEnabled = setterArg;
        return this;
      }

      private @Nullable CloseButton closeButton;

      @CanIgnoreReturnValue
      public @NonNull Builder setCloseButton(@Nullable CloseButton setterArg) {
        this.closeButton = setterArg;
        return this;
      }

      private @Nullable Animations animations;

      @CanIgnoreReturnValue
      public @NonNull Builder setAnimations(@Nullable Animations setterArg) {
        this.animations = setterArg;
        return this;
      }

      private @Nullable BrowserConfiguration browser;

      @CanIgnoreReturnValue
      public @NonNull Builder setBrowser(@Nullable BrowserConfiguration setterArg) {
        this.browser = setterArg;
        return this;
      }

      private @Nullable PartialConfiguration partial;

      @CanIgnoreReturnValue
      public @NonNull Builder setPartial(@Nullable PartialConfiguration setterArg) {
        this.partial = setterArg;
        return this;
      }

      public @NonNull CustomTabsIntentOptions build() {
        CustomTabsIntentOptions pigeonReturn = new CustomTabsIntentOptions();
        pigeonReturn.setColorSchemes(colorSchemes);
        pigeonReturn.setUrlBarHidingEnabled(urlBarHidingEnabled);
        pigeonReturn.setShareState(shareState);
        pigeonReturn.setShowTitle(showTitle);
        pigeonReturn.setInstantAppsEnabled(instantAppsEnabled);
        pigeonReturn.setCloseButton(closeButton);
        pigeonReturn.setAnimations(animations);
        pigeonReturn.setBrowser(browser);
        pigeonReturn.setPartial(partial);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(9);
      toListResult.add((colorSchemes == null) ? null : colorSchemes.toList());
      toListResult.add(urlBarHidingEnabled);
      toListResult.add(shareState);
      toListResult.add(showTitle);
      toListResult.add(instantAppsEnabled);
      toListResult.add((closeButton == null) ? null : closeButton.toList());
      toListResult.add((animations == null) ? null : animations.toList());
      toListResult.add((browser == null) ? null : browser.toList());
      toListResult.add((partial == null) ? null : partial.toList());
      return toListResult;
    }

    static @NonNull CustomTabsIntentOptions fromList(@NonNull ArrayList<Object> list) {
      CustomTabsIntentOptions pigeonResult = new CustomTabsIntentOptions();
      Object colorSchemes = list.get(0);
      pigeonResult.setColorSchemes((colorSchemes == null) ? null : ColorSchemes.fromList((ArrayList<Object>) colorSchemes));
      Object urlBarHidingEnabled = list.get(1);
      pigeonResult.setUrlBarHidingEnabled((Boolean) urlBarHidingEnabled);
      Object shareState = list.get(2);
      pigeonResult.setShareState((shareState == null) ? null : ((shareState instanceof Integer) ? (Integer) shareState : (Long) shareState));
      Object showTitle = list.get(3);
      pigeonResult.setShowTitle((Boolean) showTitle);
      Object instantAppsEnabled = list.get(4);
      pigeonResult.setInstantAppsEnabled((Boolean) instantAppsEnabled);
      Object closeButton = list.get(5);
      pigeonResult.setCloseButton((closeButton == null) ? null : CloseButton.fromList((ArrayList<Object>) closeButton));
      Object animations = list.get(6);
      pigeonResult.setAnimations((animations == null) ? null : Animations.fromList((ArrayList<Object>) animations));
      Object browser = list.get(7);
      pigeonResult.setBrowser((browser == null) ? null : BrowserConfiguration.fromList((ArrayList<Object>) browser));
      Object partial = list.get(8);
      pigeonResult.setPartial((partial == null) ? null : PartialConfiguration.fromList((ArrayList<Object>) partial));
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class Animations {
    private @Nullable String startEnter;

    public @Nullable String getStartEnter() {
      return startEnter;
    }

    public void setStartEnter(@Nullable String setterArg) {
      this.startEnter = setterArg;
    }

    private @Nullable String startExit;

    public @Nullable String getStartExit() {
      return startExit;
    }

    public void setStartExit(@Nullable String setterArg) {
      this.startExit = setterArg;
    }

    private @Nullable String endEnter;

    public @Nullable String getEndEnter() {
      return endEnter;
    }

    public void setEndEnter(@Nullable String setterArg) {
      this.endEnter = setterArg;
    }

    private @Nullable String endExit;

    public @Nullable String getEndExit() {
      return endExit;
    }

    public void setEndExit(@Nullable String setterArg) {
      this.endExit = setterArg;
    }

    public static final class Builder {

      private @Nullable String startEnter;

      @CanIgnoreReturnValue
      public @NonNull Builder setStartEnter(@Nullable String setterArg) {
        this.startEnter = setterArg;
        return this;
      }

      private @Nullable String startExit;

      @CanIgnoreReturnValue
      public @NonNull Builder setStartExit(@Nullable String setterArg) {
        this.startExit = setterArg;
        return this;
      }

      private @Nullable String endEnter;

      @CanIgnoreReturnValue
      public @NonNull Builder setEndEnter(@Nullable String setterArg) {
        this.endEnter = setterArg;
        return this;
      }

      private @Nullable String endExit;

      @CanIgnoreReturnValue
      public @NonNull Builder setEndExit(@Nullable String setterArg) {
        this.endExit = setterArg;
        return this;
      }

      public @NonNull Animations build() {
        Animations pigeonReturn = new Animations();
        pigeonReturn.setStartEnter(startEnter);
        pigeonReturn.setStartExit(startExit);
        pigeonReturn.setEndEnter(endEnter);
        pigeonReturn.setEndExit(endExit);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(4);
      toListResult.add(startEnter);
      toListResult.add(startExit);
      toListResult.add(endEnter);
      toListResult.add(endExit);
      return toListResult;
    }

    static @NonNull Animations fromList(@NonNull ArrayList<Object> list) {
      Animations pigeonResult = new Animations();
      Object startEnter = list.get(0);
      pigeonResult.setStartEnter((String) startEnter);
      Object startExit = list.get(1);
      pigeonResult.setStartExit((String) startExit);
      Object endEnter = list.get(2);
      pigeonResult.setEndEnter((String) endEnter);
      Object endExit = list.get(3);
      pigeonResult.setEndExit((String) endExit);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class BrowserConfiguration {
    private @NonNull Boolean prefersExternalBrowser;

    public @NonNull Boolean getPrefersExternalBrowser() {
      return prefersExternalBrowser;
    }

    public void setPrefersExternalBrowser(@NonNull Boolean setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"prefersExternalBrowser\" is null.");
      }
      this.prefersExternalBrowser = setterArg;
    }

    private @Nullable Boolean prefersDefaultBrowser;

    public @Nullable Boolean getPrefersDefaultBrowser() {
      return prefersDefaultBrowser;
    }

    public void setPrefersDefaultBrowser(@Nullable Boolean setterArg) {
      this.prefersDefaultBrowser = setterArg;
    }

    private @Nullable List<String> fallbackCustomTabs;

    public @Nullable List<String> getFallbackCustomTabs() {
      return fallbackCustomTabs;
    }

    public void setFallbackCustomTabs(@Nullable List<String> setterArg) {
      this.fallbackCustomTabs = setterArg;
    }

    private @Nullable Map<String, String> headers;

    public @Nullable Map<String, String> getHeaders() {
      return headers;
    }

    public void setHeaders(@Nullable Map<String, String> setterArg) {
      this.headers = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    BrowserConfiguration() {}

    public static final class Builder {

      private @Nullable Boolean prefersExternalBrowser;

      @CanIgnoreReturnValue
      public @NonNull Builder setPrefersExternalBrowser(@NonNull Boolean setterArg) {
        this.prefersExternalBrowser = setterArg;
        return this;
      }

      private @Nullable Boolean prefersDefaultBrowser;

      @CanIgnoreReturnValue
      public @NonNull Builder setPrefersDefaultBrowser(@Nullable Boolean setterArg) {
        this.prefersDefaultBrowser = setterArg;
        return this;
      }

      private @Nullable List<String> fallbackCustomTabs;

      @CanIgnoreReturnValue
      public @NonNull Builder setFallbackCustomTabs(@Nullable List<String> setterArg) {
        this.fallbackCustomTabs = setterArg;
        return this;
      }

      private @Nullable Map<String, String> headers;

      @CanIgnoreReturnValue
      public @NonNull Builder setHeaders(@Nullable Map<String, String> setterArg) {
        this.headers = setterArg;
        return this;
      }

      public @NonNull BrowserConfiguration build() {
        BrowserConfiguration pigeonReturn = new BrowserConfiguration();
        pigeonReturn.setPrefersExternalBrowser(prefersExternalBrowser);
        pigeonReturn.setPrefersDefaultBrowser(prefersDefaultBrowser);
        pigeonReturn.setFallbackCustomTabs(fallbackCustomTabs);
        pigeonReturn.setHeaders(headers);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(4);
      toListResult.add(prefersExternalBrowser);
      toListResult.add(prefersDefaultBrowser);
      toListResult.add(fallbackCustomTabs);
      toListResult.add(headers);
      return toListResult;
    }

    static @NonNull BrowserConfiguration fromList(@NonNull ArrayList<Object> list) {
      BrowserConfiguration pigeonResult = new BrowserConfiguration();
      Object prefersExternalBrowser = list.get(0);
      pigeonResult.setPrefersExternalBrowser((Boolean) prefersExternalBrowser);
      Object prefersDefaultBrowser = list.get(1);
      pigeonResult.setPrefersDefaultBrowser((Boolean) prefersDefaultBrowser);
      Object fallbackCustomTabs = list.get(2);
      pigeonResult.setFallbackCustomTabs((List<String>) fallbackCustomTabs);
      Object headers = list.get(3);
      pigeonResult.setHeaders((Map<String, String>) headers);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class CloseButton {
    private @Nullable String icon;

    public @Nullable String getIcon() {
      return icon;
    }

    public void setIcon(@Nullable String setterArg) {
      this.icon = setterArg;
    }

    private @Nullable Long position;

    public @Nullable Long getPosition() {
      return position;
    }

    public void setPosition(@Nullable Long setterArg) {
      this.position = setterArg;
    }

    public static final class Builder {

      private @Nullable String icon;

      @CanIgnoreReturnValue
      public @NonNull Builder setIcon(@Nullable String setterArg) {
        this.icon = setterArg;
        return this;
      }

      private @Nullable Long position;

      @CanIgnoreReturnValue
      public @NonNull Builder setPosition(@Nullable Long setterArg) {
        this.position = setterArg;
        return this;
      }

      public @NonNull CloseButton build() {
        CloseButton pigeonReturn = new CloseButton();
        pigeonReturn.setIcon(icon);
        pigeonReturn.setPosition(position);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(2);
      toListResult.add(icon);
      toListResult.add(position);
      return toListResult;
    }

    static @NonNull CloseButton fromList(@NonNull ArrayList<Object> list) {
      CloseButton pigeonResult = new CloseButton();
      Object icon = list.get(0);
      pigeonResult.setIcon((String) icon);
      Object position = list.get(1);
      pigeonResult.setPosition((position == null) ? null : ((position instanceof Integer) ? (Integer) position : (Long) position));
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class ColorSchemes {
    private @Nullable Long colorScheme;

    public @Nullable Long getColorScheme() {
      return colorScheme;
    }

    public void setColorScheme(@Nullable Long setterArg) {
      this.colorScheme = setterArg;
    }

    private @Nullable ColorSchemeParams lightParams;

    public @Nullable ColorSchemeParams getLightParams() {
      return lightParams;
    }

    public void setLightParams(@Nullable ColorSchemeParams setterArg) {
      this.lightParams = setterArg;
    }

    private @Nullable ColorSchemeParams darkParams;

    public @Nullable ColorSchemeParams getDarkParams() {
      return darkParams;
    }

    public void setDarkParams(@Nullable ColorSchemeParams setterArg) {
      this.darkParams = setterArg;
    }

    private @Nullable ColorSchemeParams defaultPrams;

    public @Nullable ColorSchemeParams getDefaultPrams() {
      return defaultPrams;
    }

    public void setDefaultPrams(@Nullable ColorSchemeParams setterArg) {
      this.defaultPrams = setterArg;
    }

    public static final class Builder {

      private @Nullable Long colorScheme;

      @CanIgnoreReturnValue
      public @NonNull Builder setColorScheme(@Nullable Long setterArg) {
        this.colorScheme = setterArg;
        return this;
      }

      private @Nullable ColorSchemeParams lightParams;

      @CanIgnoreReturnValue
      public @NonNull Builder setLightParams(@Nullable ColorSchemeParams setterArg) {
        this.lightParams = setterArg;
        return this;
      }

      private @Nullable ColorSchemeParams darkParams;

      @CanIgnoreReturnValue
      public @NonNull Builder setDarkParams(@Nullable ColorSchemeParams setterArg) {
        this.darkParams = setterArg;
        return this;
      }

      private @Nullable ColorSchemeParams defaultPrams;

      @CanIgnoreReturnValue
      public @NonNull Builder setDefaultPrams(@Nullable ColorSchemeParams setterArg) {
        this.defaultPrams = setterArg;
        return this;
      }

      public @NonNull ColorSchemes build() {
        ColorSchemes pigeonReturn = new ColorSchemes();
        pigeonReturn.setColorScheme(colorScheme);
        pigeonReturn.setLightParams(lightParams);
        pigeonReturn.setDarkParams(darkParams);
        pigeonReturn.setDefaultPrams(defaultPrams);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(4);
      toListResult.add(colorScheme);
      toListResult.add((lightParams == null) ? null : lightParams.toList());
      toListResult.add((darkParams == null) ? null : darkParams.toList());
      toListResult.add((defaultPrams == null) ? null : defaultPrams.toList());
      return toListResult;
    }

    static @NonNull ColorSchemes fromList(@NonNull ArrayList<Object> list) {
      ColorSchemes pigeonResult = new ColorSchemes();
      Object colorScheme = list.get(0);
      pigeonResult.setColorScheme((colorScheme == null) ? null : ((colorScheme instanceof Integer) ? (Integer) colorScheme : (Long) colorScheme));
      Object lightParams = list.get(1);
      pigeonResult.setLightParams((lightParams == null) ? null : ColorSchemeParams.fromList((ArrayList<Object>) lightParams));
      Object darkParams = list.get(2);
      pigeonResult.setDarkParams((darkParams == null) ? null : ColorSchemeParams.fromList((ArrayList<Object>) darkParams));
      Object defaultPrams = list.get(3);
      pigeonResult.setDefaultPrams((defaultPrams == null) ? null : ColorSchemeParams.fromList((ArrayList<Object>) defaultPrams));
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class ColorSchemeParams {
    private @Nullable Long toolbarColor;

    public @Nullable Long getToolbarColor() {
      return toolbarColor;
    }

    public void setToolbarColor(@Nullable Long setterArg) {
      this.toolbarColor = setterArg;
    }

    private @Nullable Long navigationBarColor;

    public @Nullable Long getNavigationBarColor() {
      return navigationBarColor;
    }

    public void setNavigationBarColor(@Nullable Long setterArg) {
      this.navigationBarColor = setterArg;
    }

    private @Nullable Long navigationBarDividerColor;

    public @Nullable Long getNavigationBarDividerColor() {
      return navigationBarDividerColor;
    }

    public void setNavigationBarDividerColor(@Nullable Long setterArg) {
      this.navigationBarDividerColor = setterArg;
    }

    public static final class Builder {

      private @Nullable Long toolbarColor;

      @CanIgnoreReturnValue
      public @NonNull Builder setToolbarColor(@Nullable Long setterArg) {
        this.toolbarColor = setterArg;
        return this;
      }

      private @Nullable Long navigationBarColor;

      @CanIgnoreReturnValue
      public @NonNull Builder setNavigationBarColor(@Nullable Long setterArg) {
        this.navigationBarColor = setterArg;
        return this;
      }

      private @Nullable Long navigationBarDividerColor;

      @CanIgnoreReturnValue
      public @NonNull Builder setNavigationBarDividerColor(@Nullable Long setterArg) {
        this.navigationBarDividerColor = setterArg;
        return this;
      }

      public @NonNull ColorSchemeParams build() {
        ColorSchemeParams pigeonReturn = new ColorSchemeParams();
        pigeonReturn.setToolbarColor(toolbarColor);
        pigeonReturn.setNavigationBarColor(navigationBarColor);
        pigeonReturn.setNavigationBarDividerColor(navigationBarDividerColor);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(3);
      toListResult.add(toolbarColor);
      toListResult.add(navigationBarColor);
      toListResult.add(navigationBarDividerColor);
      return toListResult;
    }

    static @NonNull ColorSchemeParams fromList(@NonNull ArrayList<Object> list) {
      ColorSchemeParams pigeonResult = new ColorSchemeParams();
      Object toolbarColor = list.get(0);
      pigeonResult.setToolbarColor((toolbarColor == null) ? null : ((toolbarColor instanceof Integer) ? (Integer) toolbarColor : (Long) toolbarColor));
      Object navigationBarColor = list.get(1);
      pigeonResult.setNavigationBarColor((navigationBarColor == null) ? null : ((navigationBarColor instanceof Integer) ? (Integer) navigationBarColor : (Long) navigationBarColor));
      Object navigationBarDividerColor = list.get(2);
      pigeonResult.setNavigationBarDividerColor((navigationBarDividerColor == null) ? null : ((navigationBarDividerColor instanceof Integer) ? (Integer) navigationBarDividerColor : (Long) navigationBarDividerColor));
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class PartialConfiguration {
    private @NonNull Double initialHeight;

    public @NonNull Double getInitialHeight() {
      return initialHeight;
    }

    public void setInitialHeight(@NonNull Double setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"initialHeight\" is null.");
      }
      this.initialHeight = setterArg;
    }

    private @NonNull Long activityHeightResizeBehavior;

    public @NonNull Long getActivityHeightResizeBehavior() {
      return activityHeightResizeBehavior;
    }

    public void setActivityHeightResizeBehavior(@NonNull Long setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"activityHeightResizeBehavior\" is null.");
      }
      this.activityHeightResizeBehavior = setterArg;
    }

    private @Nullable Long cornerRadius;

    public @Nullable Long getCornerRadius() {
      return cornerRadius;
    }

    public void setCornerRadius(@Nullable Long setterArg) {
      this.cornerRadius = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    PartialConfiguration() {}

    public static final class Builder {

      private @Nullable Double initialHeight;

      @CanIgnoreReturnValue
      public @NonNull Builder setInitialHeight(@NonNull Double setterArg) {
        this.initialHeight = setterArg;
        return this;
      }

      private @Nullable Long activityHeightResizeBehavior;

      @CanIgnoreReturnValue
      public @NonNull Builder setActivityHeightResizeBehavior(@NonNull Long setterArg) {
        this.activityHeightResizeBehavior = setterArg;
        return this;
      }

      private @Nullable Long cornerRadius;

      @CanIgnoreReturnValue
      public @NonNull Builder setCornerRadius(@Nullable Long setterArg) {
        this.cornerRadius = setterArg;
        return this;
      }

      public @NonNull PartialConfiguration build() {
        PartialConfiguration pigeonReturn = new PartialConfiguration();
        pigeonReturn.setInitialHeight(initialHeight);
        pigeonReturn.setActivityHeightResizeBehavior(activityHeightResizeBehavior);
        pigeonReturn.setCornerRadius(cornerRadius);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(3);
      toListResult.add(initialHeight);
      toListResult.add(activityHeightResizeBehavior);
      toListResult.add(cornerRadius);
      return toListResult;
    }

    static @NonNull PartialConfiguration fromList(@NonNull ArrayList<Object> list) {
      PartialConfiguration pigeonResult = new PartialConfiguration();
      Object initialHeight = list.get(0);
      pigeonResult.setInitialHeight((Double) initialHeight);
      Object activityHeightResizeBehavior = list.get(1);
      pigeonResult.setActivityHeightResizeBehavior((activityHeightResizeBehavior == null) ? null : ((activityHeightResizeBehavior instanceof Integer) ? (Integer) activityHeightResizeBehavior : (Long) activityHeightResizeBehavior));
      Object cornerRadius = list.get(2);
      pigeonResult.setCornerRadius((cornerRadius == null) ? null : ((cornerRadius instanceof Integer) ? (Integer) cornerRadius : (Long) cornerRadius));
      return pigeonResult;
    }
  }

  private static class CustomTabsApiCodec extends StandardMessageCodec {
    public static final CustomTabsApiCodec INSTANCE = new CustomTabsApiCodec();

    private CustomTabsApiCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 128:
          return Animations.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 129:
          return BrowserConfiguration.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 130:
          return CloseButton.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 131:
          return ColorSchemeParams.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 132:
          return ColorSchemes.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 133:
          return CustomTabsIntentOptions.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 134:
          return PartialConfiguration.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof Animations) {
        stream.write(128);
        writeValue(stream, ((Animations) value).toList());
      } else if (value instanceof BrowserConfiguration) {
        stream.write(129);
        writeValue(stream, ((BrowserConfiguration) value).toList());
      } else if (value instanceof CloseButton) {
        stream.write(130);
        writeValue(stream, ((CloseButton) value).toList());
      } else if (value instanceof ColorSchemeParams) {
        stream.write(131);
        writeValue(stream, ((ColorSchemeParams) value).toList());
      } else if (value instanceof ColorSchemes) {
        stream.write(132);
        writeValue(stream, ((ColorSchemes) value).toList());
      } else if (value instanceof CustomTabsIntentOptions) {
        stream.write(133);
        writeValue(stream, ((CustomTabsIntentOptions) value).toList());
      } else if (value instanceof PartialConfiguration) {
        stream.write(134);
        writeValue(stream, ((PartialConfiguration) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface CustomTabsApi {

    void launch(@NonNull String urlString, @NonNull Boolean prefersDeepLink, @Nullable CustomTabsIntentOptions options);

    void closeAllIfPossible();

    /** The codec used by CustomTabsApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return CustomTabsApiCodec.INSTANCE;
    }
    /**Sets up an instance of `CustomTabsApi` to handle messages through the `binaryMessenger`. */
    static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable CustomTabsApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.flutter_custom_tabs_android.CustomTabsApi.launch", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                String urlStringArg = (String) args.get(0);
                Boolean prefersDeepLinkArg = (Boolean) args.get(1);
                CustomTabsIntentOptions optionsArg = (CustomTabsIntentOptions) args.get(2);
                try {
                  api.launch(urlStringArg, prefersDeepLinkArg, optionsArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.flutter_custom_tabs_android.CustomTabsApi.closeAllIfPossible", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  api.closeAllIfPossible();
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
}
