[![GitHub releases](https://img.shields.io/github/tag/gsantner/memetastic.svg)](https://github.com/gsantner/memetastic/releases)
[![GitHub downloads](https://img.shields.io/github/downloads/gsantner/memetastic/total.svg?logo=github&logoColor=lime)](https://github.com/gsantner/memetastic/releases)
[![Chat on Matrix](https://img.shields.io/badge/chat-matrix-blue.svg)](https://matrix.to/#/#memetastic:matrix.org)
[![GitHub CI](https://github.com/gsantner/memetastic/workflows/CI/badge.svg)](https://github.com/gsantner/memetastic/actions)

# MemeTastic
<img src="/app/src/main/ic_launcher-web.png" align="left" width="100" hspace="10" vspace="10">
<b>Simple Meme Creator</b>. Completely ad-free, and adds no watermarks.
Memes can be created from image templates in MemeTastic pictures folder,
from pictures shared into the app and pictures from gallery & camera.
No internet connection required or used.

<div style="display:flex;" >
<a href="https://f-droid.org/repository/browse/?fdid=io.github.gsantner.memetastic">
    <img src="https://f-droid.org/badge/get-it-on.png" alt="Get it on F-Droid" height="80">
</a>
<a href="https://play.google.com/store/apps/details?id=io.github.gsantner.memetastic">
    <img alt="Get it on Google Play" height="80" src="https://play.google.com/intl/en_us/badges/images/generic/en_badge_web_generic.png" />
</a>
</div></br>


## Description
* Ad-Free and no watermarks
* Allows you to create memes from
  * Templates from MemeTastic picture folder
  * Camera pictures
  * Gallery pictures
  * Pictures shared into the app
* Customize meme
  * Top & bottom caption
  * Font & border text color
  * Text size and capitalization
  * Font
* Show saved memes
* Create favorites
* Share into any app accepting pictures
* Share any picture into MemeTastic to create meme
* Change amount of displayed pictures per row

### Privacy<a name="privacy"></a>
The app doesn't share any personal information with other apps or any web-server.
Custom images can be added via camera and gallery. If the user decides to save a meme image it will be stored locally in the device public pictures folder.

## Contributions
The project is always open for contributions and accepts pull requests.
The project uses [AOSP Java Code Style](https://source.android.com/source/code-style#follow-field-naming-conventions), with one exception: private members are `_camelCase` instead of `mBigCamel`. You may use Android Studios _auto reformat feature_ before sending a PR.

Translations can be contributed on Git merge request. You can use Stringlate ([![Translate - with Stringlate](https://img.shields.io/badge/stringlate-translate-green.svg)](https://lonamiwebs.github.io/stringlate/translate?git=https%3A%2F%2Fgithub.com%2Fgsantner%2Fmemetastic.git&name=MemeTastic&web=https%3A%2F%2Fgithub.com%2Fgsantner%2Fmemetastic)) to translate the project directly on your Android phone. It allows you to export as E-Mail attachment and to post on GitHub.

Join our Matrix channel & say hello! Don't be afraid to start talking. [![Chat - Matrix](https://img.shields.io/badge/chat-on%20matrix-blue.svg)](https://matrix.to/#/#memetastic:matrix.org)  

For inclusion of new fonts or memes visit [issue #1](https://github.com/gsantner/memetastic/issues/1).
Please only post stuff under free license (/or created yourself) and is allowed to be freely redistributed.
Meme templates will only get added if there are no existing watermarks (of e.g. other meme creators)
and if they are in a good image quality (do a quick search before).

You can maybe find something suitable here:
* Fonts: [1001fonts](http://www.1001fonts.com) | [Font Squirell](https://www.fontsquirrel.com/fonts/list/find_fonts?filter%5Blicense%5D%5B0%5D=app&filter%5Blicense%5D%5B1%5D=open&sort=hot) | [fontspace](http://www.fontspace.com/) | [Google Fonts](https://fonts.google.com) | [FontMeme](https://fontmeme.com/) | [Identify font](https://www.fontsquirrel.com/matcherator)
* Meme Templates: [knowyourmeme.com](http://knowyourmeme.com) | [/r/MemeTemplatesOfficial](https://www.reddit.com/r/MemeTemplatesOfficial)  | [memes.at](http://www.memes.at/) | [ragemaker.net](https://ragemaker.net/images)


#### Resources
* Project: [Changelog](/CHANGELOG.md) | [Issues level/beginner](https://github.com/gsantner/memetastic/issues?q=is%3Aissue+is%3Aopen+label%3Alevel%2Fbeginner) | [License](/LICENSE.txt) | [CoC](/CODE_OF_CONDUCT.md)
* App on F-Droid: [Metadata](https://gitlab.com/fdroid/fdroiddata/blob/master/metadata/io.github.gsantner.memetastic.txt) | [Page](https://f-droid.org/packages/io.github.gsantner.memetastic/) | [Wiki](https://f-droid.org/wiki/page/io.github.gsantner.memetastic) | [Build log](https://f-droid.org/wiki/page/io.github.gsantner.memetastic/lastbuild)

## Licensing
Copyright (C) 2016-2023 Gregor Santner \<gsantner AT mailbox DOT org \>
The app is licensed GPL v3. Localization files (strings\*.xml) are licensed CC0 1.0.
For more licensing informations, see [`3rd party licenses`](/app/src/main/res/raw/licenses_3rd_party.md).

If you publish an app based on MemeTastic you MUST
* Comply with the terms of [GNU General Public License Version 3](https://www.gnu.org/licenses/gpl-3.0.html)
* Keep existing copyright notices in the app and hand out full source code on anybody's request
* Show that the app is `based on MemeTastic`. Include a link to https://github.com/gsantner/memetastic
* Show that the app is not MemeTastic but a modified/custom version, MemeTastic developers are not related to modified versions and do not endorse your product

## Screenshots
<div style="display:flex;" >
	<img src="https://raw.githubusercontent.com/gsantner/memetastic-metadata-latest/master/en-US/phoneScreenshots/01.png" width="19%" >
	<img src="https://raw.githubusercontent.com/gsantner/memetastic-metadata-latest/master/en-US/phoneScreenshots/02.png" width="19%" style="margin-left:10px;" >
	<img src="https://raw.githubusercontent.com/gsantner/memetastic-metadata-latest/master/en-US/phoneScreenshots/03.png" width="19%" style="margin-left:10px;" >
	<img src="https://raw.githubusercontent.com/gsantner/memetastic-metadata-latest/master/en-US/phoneScreenshots/04.png" width="19%" style="margin-left:10px;" >
	<img src="https://raw.githubusercontent.com/gsantner/memetastic-metadata-latest/master/en-US/phoneScreenshots/05.png" width="19%" style="margin-left:10px;" >
</div>

<div style="display:flex;" >
	<img src="https://raw.githubusercontent.com/gsantner/memetastic-metadata-latest/master/en-US/phoneScreenshots/06.png" width="19%" >
	<img src="https://raw.githubusercontent.com/gsantner/memetastic-metadata-latest/master/en-US/phoneScreenshots/07.png" width="19%" style="margin-left:10px;" >
	<img src="https://raw.githubusercontent.com/gsantner/memetastic-metadata-latest/master/en-US/phoneScreenshots/08.png" width="19%" style="margin-left:10px;" >
	<img src="https://raw.githubusercontent.com/gsantner/memetastic-metadata-latest/master/en-US/phoneScreenshots/09.png" width="19%" style="margin-left:10px;" >
</div>

## FAQ

### General

#### Where are Memes saved?
MemeTastic creates a folder »Pictures»memetastic»memes in your device storage for you. All memes will be saved to this location. The advantage is that you can view images with any other gallery or file manager app too. Also, if you uninstall MemeTastic images don't get deleted.

#### How to view created Memes?
After creating & saving a meme you can use the built in image viewer. You can find the image viewer on MemeTastic's main screen at the "Saved" tab. There you can view all created memes. As memes ares saved to your storage Pictures folder, you can view images with any other gallery or file manager app too.

#### How to suggest fonts and templates for addition to MemeTastic?
Please leave a comment here or on the [GitHub discussion](https://github.com/gsantner/memetastic/issues/126) with the respective font(s) and image(s).

Notice: Assets are only accepeted if they are under a free license (or public domain). Pictures from movies, series and most of those you see on sites like 9GAG are very likely not free.

#### What does "free" refer to?
Both, free as in beer and free as in freedom. For more information, see [Open Source Definition](https://opensource.org/osd) (software) and [Creative Commons licenses](https://creativecommons.org/licenses) (media).


### Meme Templates

#### Which templates are preinstalled?
When you install MemeTastic you will only find assets that are under a free license or under public domain. Images that get memes or meme templates are usually under copyright and fair use is a legal gray area. For that reason, MemeTastic does not bundle non-free images.

#### How do I add templates?
MemeTastic creates a folder »Pictures»memetastic»templates in your device storage for you. Copy images (.jpg/.png) to this folder and they will appear in the list of templates.

#### Does MemeTastic download templates?
No, MemeTastic is a complete offline app. It has no internet access and can neither upload nor download data on its own.  

The MemeTastic project instead collected a list of sites for you where may get meme templates from. You can find links [on this site](#meme-template-sources).

#### Where can I find Meme Templates?
See [Meme Template Sources](#meme-template-sources) section.


### Fonts

#### Which fonts are preinstalled?
MemeTastic only bundles fonts under free license or public domain. The default font for Memes is [Pressuru](https://web.archive.org/web/20140302041243/http://www.abstrkt.ru/index.php?p=freefonts). You can find the current list of bundled fonts at [GitHub](https://github.com/gsantner/memetastic/tree/master/app/src/main/assets/bundled).

#### How do I add fonts?
Just like for meme templates, MemeTastic creates a folder »Pictures»memetastic»templates in your device storage for you. Copy fonts (.ttf/.otf) to this folder and they will appear in the list of fonts in the editor.

#### Where can I find fonts?
You can find and identify fonts here:<br/>
[1001fonts](http://www.1001fonts.com) | [Font Squirell](https://www.fontsquirrel.com/fonts/list/find_fonts?filter%5Blicense%5D%5B0%5D=app&filter%5Blicense%5D%5B1%5D=open&sort=hot) | [fontspace](http://www.fontspace.com/) | [Google Fonts](https://fonts.google.com) | [FontMeme](https://fontmeme.com/) | [Identify font](https://www.fontsquirrel.com/matcherator) 


</div> <!-- h4 bullet -->

## Meme Template Sources

### imgflip
Website: <https://imgflip.com/memetemplates>

* Select and click a template out of the list
* Press the "Blank" image below the "Caption this Meme" button
* Long press the image and click download/save


### Reddit
Website: <https://www.reddit.com/r/MemeTemplatesOfficial/.compact>

* Click and open a entry
* Long press the image and click download/save


## Memes and funny images
* [9GAG](https://9gag.com)

### Reddit
* [/r/memes](https://www.reddit.com/r/memes/.compact)
* [/r/funny](https://www.reddit.com/r/funny/.compact)
* [/r/gifs](https://www.reddit.com/r/gifs/.compact)
* [/r/AdviceAnimals](https://www.reddit.com/r/AdviceAnimals/.compact)
* [/r/BikiniBottomTwitter](https://www.reddit.com/r/BikiniBottomTwitter/.compact)
* [/r/wowmemes](https://www.reddit.com/r/wowmemes/.compact)
* [/r/de](https://www.reddit.com/r/de/.compact)

