[![GitHub releases](https://img.shields.io/github/tag/gsantner/memetastic.svg)](https://github.com/gsantner/memetastic/releases)
[![GitHub downloads](https://img.shields.io/github/downloads/gsantner/memetastic/total.svg?logo=github&logoColor=lime)](https://github.com/gsantner/memetastic/releases)
[![Donate - say thanks](https://img.shields.io/badge/donate-say%20thanks-red.svg)](https://gsantner.net/page/supportme.html?project=memetastic&source=readme)
[![Chat on Matrix](https://img.shields.io/badge/chat-matrix-blue.svg)](https://matrix.to/#/#memetastic:matrix.org)
[![GitHub CI](https://github.com/gsantner/memetastic/workflows/CI/badge.svg)](https://github.com/gsantner/memetastic/actions)

# MemeTastic
<img src="/app/src/main/ic_launcher-web.png" align="left" width="100" hspace="10" vspace="10">
<b>Simple Meme Creator</b>. Completely ad-free, and adds no watermarks.
Memes can be created from image templates in MemeTastic pictures folder,
from pictures shared into the app and pictures from gallery & camera.
No internet connection required or used.

<div style="display:flex;" >
<a href="https://f-droid.org/repository/browse/?fdid=io.github.gsantner.memetastic">
    <img src="https://f-droid.org/badge/get-it-on.png" alt="Get it on F-Droid" height="80">
</a>
<a href="https://play.google.com/store/apps/details?id=io.github.gsantner.memetastic">
    <img alt="Get it on Google Play" height="80" src="https://play.google.com/intl/en_us/badges/images/generic/en_badge_web_generic.png" />
</a>
</div></br>


## Description
* Ad-Free and no watermarks
* Allows you to create memes from
  * Templates from MemeTastic picture folder
  * Camera pictures
  * Gallery pictures
  * Pictures shared into the app
* Customize meme
  * Top & bottom caption
  * Font & border text color
  * Text size and capitalization
  * Font
* Show saved memes
* Create favorites
* Share into any app accepting pictures
* Share any picture into MemeTastic to create meme
* Change amount of displayed pictures per row

### Privacy<a name="privacy"></a>
The app doesn't share any personal information with other apps or any web-server.
Custom images can be added via camera and gallery. If the user decides to save a meme image it will be stored locally in the device public pictures folder.

## Contributions
The project is always open for contributions and accepts pull requests.
The project uses [AOSP Java Code Style](https://source.android.com/source/code-style#follow-field-naming-conventions), with one exception: private members are `_camelCase` instead of `mBigCamel`. You may use Android Studios _auto reformat feature_ before sending a PR.

Translations can be contributed on GitHub or via [E-Mail](http://gsantner.net/#contact). You can use Stringlate ([![Translate - with Stringlate](https://img.shields.io/badge/stringlate-translate-green.svg)](https://lonamiwebs.github.io/stringlate/translate?git=https%3A%2F%2Fgithub.com%2Fgsantner%2Fmemetastic.git&name=MemeTastic&web=https%3A%2F%2Fgithub.com%2Fgsantner%2Fmemetastic)) to translate the project directly on your Android phone. It allows you to export as E-Mail attachment and to post on GitHub.

Join our Matrix channel & say hello! Don't be afraid to start talking. [![Chat - Matrix](https://img.shields.io/badge/chat-on%20matrix-blue.svg)](https://matrix.to/#/#memetastic:matrix.org)  

For inclusion of new fonts or memes visit [issue #1](https://github.com/gsantner/memetastic/issues/1).
Please only post stuff under free license (/or created yourself) and is allowed to be freely redistributed.
Meme templates will only get added if there are no existing watermarks (of e.g. other meme creators)
and if they are in a good image quality (do a quick search before).

You can maybe find something suitable here:
* Fonts: [1001fonts](http://www.1001fonts.com) | [Font Squirell](https://www.fontsquirrel.com/fonts/list/find_fonts?filter%5Blicense%5D%5B0%5D=app&filter%5Blicense%5D%5B1%5D=open&sort=hot) | [fontspace](http://www.fontspace.com/) | [Google Fonts](https://fonts.google.com) | [FontMeme](https://fontmeme.com/) | [Identify font](https://www.fontsquirrel.com/matcherator)
* Meme Templates: [knowyourmeme.com](http://knowyourmeme.com) | [/r/MemeTemplatesOfficial](https://www.reddit.com/r/MemeTemplatesOfficial)  | [memes.at](http://www.memes.at/) | [ragemaker.net](https://ragemaker.net/images)


If you like @gsantner's work on <b>MemeTastic</b> and many other Open Source projects, consider [supporting him](https://gsantner.net/page/supportme.html?project=memetastic&source=gh_readme)


#### Resources
* Project: [Changelog](/CHANGELOG.md) | [Issues level/beginner](https://github.com/gsantner/memetastic/issues?q=is%3Aissue+is%3Aopen+label%3Alevel%2Fbeginner) | [License](/LICENSE.txt) | [CoC](/CODE_OF_CONDUCT.md)
* App on F-Droid: [Metadata](https://gitlab.com/fdroid/fdroiddata/blob/master/metadata/io.github.gsantner.memetastic.txt) | [Page](https://f-droid.org/packages/io.github.gsantner.memetastic/) | [Wiki](https://f-droid.org/wiki/page/io.github.gsantner.memetastic) | [Build log](https://f-droid.org/wiki/page/io.github.gsantner.memetastic/lastbuild)

## Licensing
Copyright (C) 2016-2021 Gregor Santner \<[http://gsantner.net](http://gsantner.net?ref=memetastic&source=license)\>
The app is licensed GPL v3. Localization files (strings\*.xml) are licensed CC0 1.0.
For more licensing informations, see [`3rd party licenses`](/app/src/main/res/raw/licenses_3rd_party.md).

If you publish an app based on MemeTastic you MUST
* Comply with the terms of [GNU General Public License Version 3](https://www.gnu.org/licenses/gpl-3.0.html)
* Keep existing copyright notices in the app and hand out full source code on anybody's request
* Show that the app is `based on MemeTastic by Gregor Santner`. Include a link to https://github.com/gsantner/memetastic
* Show that the app is not MemeTastic but a modified/custom version, MemeTastic developers are not responsible for modified versions and do not endorse your product


## Screenshots
<div style="display:flex;" >
	<img src="https://raw.githubusercontent.com/gsantner/memetastic-metadata-latest/master/en-US/phoneScreenshots/01.png" width="19%" >
	<img src="https://raw.githubusercontent.com/gsantner/memetastic-metadata-latest/master/en-US/phoneScreenshots/02.png" width="19%" style="margin-left:10px;" >
	<img src="https://raw.githubusercontent.com/gsantner/memetastic-metadata-latest/master/en-US/phoneScreenshots/03.png" width="19%" style="margin-left:10px;" >
	<img src="https://raw.githubusercontent.com/gsantner/memetastic-metadata-latest/master/en-US/phoneScreenshots/04.png" width="19%" style="margin-left:10px;" >
	<img src="https://raw.githubusercontent.com/gsantner/memetastic-metadata-latest/master/en-US/phoneScreenshots/05.png" width="19%" style="margin-left:10px;" >
</div>

<div style="display:flex;" >
	<img src="https://raw.githubusercontent.com/gsantner/memetastic-metadata-latest/master/en-US/phoneScreenshots/06.png" width="19%" >
	<img src="https://raw.githubusercontent.com/gsantner/memetastic-metadata-latest/master/en-US/phoneScreenshots/07.png" width="19%" style="margin-left:10px;" >
	<img src="https://raw.githubusercontent.com/gsantner/memetastic-metadata-latest/master/en-US/phoneScreenshots/08.png" width="19%" style="margin-left:10px;" >
	<img src="https://raw.githubusercontent.com/gsantner/memetastic-metadata-latest/master/en-US/phoneScreenshots/09.png" width="19%" style="margin-left:10px;" >
</div>

