package io.github.gonbei774.calisthenicsmemory.data

import androidx.room.*
import kotlinx.coroutines.flow.Flow

@Dao
interface ExerciseDao {

    @Query("SELECT * FROM exercises ORDER BY name ASC")
    fun getAllExercises(): Flow<List<Exercise>>

    @Query("SELECT * FROM exercises WHERE id = :id")
    suspend fun getExerciseById(id: Long): Exercise?

    @Query("SELECT * FROM exercises WHERE name = :name AND type = :type LIMIT 1")
    suspend fun getExerciseByNameAndType(name: String, type: String): Exercise?

    @Query("SELECT * FROM exercises WHERE `group` = :groupName ORDER BY displayOrder ASC")
    suspend fun getExercisesByGroup(groupName: String): List<Exercise>

    @Query("SELECT * FROM exercises WHERE `group` IS NULL ORDER BY displayOrder ASC")
    suspend fun getUngroupedExercises(): List<Exercise>

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insertExercise(exercise: Exercise): Long

    @Update
    suspend fun updateExercise(exercise: Exercise)

    @Delete
    suspend fun deleteExercise(exercise: Exercise)

    @Query("DELETE FROM exercises WHERE id = :id")
    suspend fun deleteExerciseById(id: Long)

    @Query("DELETE FROM exercises")
    suspend fun deleteAll()

    @Query("SELECT COALESCE(MAX(displayOrder), -1) FROM exercises")
    suspend fun getMaxDisplayOrder(): Int
}