// Copyright 2023 Fries_I23
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import 'package:flutter/material.dart';

import '../../../l10n/localizations.dart';
import '../../../models/habit_freq.dart';

class HabitEditFrequencyTile extends StatelessWidget {
  final HabitFrequency frequency;
  final void Function(BuildContext context, HabitFrequency frequency)?
  onPressed;

  const HabitEditFrequencyTile({
    super.key,
    required this.frequency,
    this.onPressed,
  });

  @override
  Widget build(BuildContext context) {
    final themeData = Theme.of(context);
    final l10n = L10n.of(context);

    return ListTile(
      leading: Icon(Icons.repeat, color: themeData.colorScheme.outline),
      title: Text(
        l10n != null ? frequency.toLocalString(l10n) : frequency.toString(),
      ),
      onTap: () => onPressed?.call(context, frequency),
    );
  }
}
