// Copyright 2024 Fries_I23
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import 'package:logger/logger.dart';

import '../../common/global.dart';
import '../logger_message.dart';

class AppLogFilter implements LogFilter {
  const AppLogFilter();

  @override
  Future<void> destroy() async {}

  @override
  Future<void> init() async {}

  @override
  Level get level => kAppLogLevel.toLoggerLevel();

  @override
  set level(Level? value) {}

  @override
  bool shouldLog(LogEvent event) =>
      (event.message is AppLoggerMessage && event.message.forceLogging) ||
      event.level.value >= level.value;
}
