// Copyright 2023 Fries_I23
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import 'dart:math';

import '../common/math.dart';

extension NumExtension on num {
  String toStringAsFixedMixExp(int fixedDigit, {int? expDigit}) {
    if (abs() >= pow(10, -fixedDigit)) {
      return toStringAsFixed(fixedDigit);
    } else {
      return toStringAsExponential(expDigit);
    }
  }

  String toStringAsFixedWithMin(int fixedDigit) {
    if (this == 0) return toStringAsFixed(fixedDigit);
    final minNum = pow(10, -fixedDigit);
    if (abs() >= minNum) {
      return toStringAsFixed(fixedDigit);
    } else {
      return (this >= 0 ? minNum : -minNum).toStringAsFixed(fixedDigit);
    }
  }

  String toSimpleString({int? fixedDigit}) {
    return isInteger(this)
        ? toStringAsFixed(0)
        : fixedDigit != null
        ? toStringAsFixed(fixedDigit)
        : toString();
  }
}
