/// A Dart library for accessing and managing the Windows Registry, providing
/// easy-to-use classes and collections to read, write, and monitor registry
/// values.
///
/// The Windows Registry stores configuration data for applications and system
/// components. This library allows applications to interact with the registry,
/// supporting data retrieval, modification, deletion, and monitoring of
/// registry changes to react to updates made by other processes or system
/// components.
library;

export 'src/access_rights.dart';
export 'src/registry.dart';
export 'src/registry_hive.dart';
export 'src/registry_key.dart';
export 'src/registry_key_info.dart';
export 'src/registry_value.dart';
export 'src/registry_value_type.dart';
