// Copyright (C) 2024 Fries_I23
//
// tz_converter is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// tz_converter is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with tz_converter. If not, see <https://www.gnu.org/licenses/>.

typedef DataBase = Map<String, dynamic>;

/// Default data, source
/// [here](https://github.com/unicode-org/cldr-json/blob/2b8ca7d92dd68d06c60bbd74f8ad8436c5e8bddc/cldr-json/cldr-core/supplemental/windowsZones.json)
const DataBase database = {
  "supplemental": {
    "version": {"_unicodeVersion": "15.1.0", "_cldrVersion": "45"},
    "windowsZones": {
      "mapTimezones": [
        {
          "mapZone": {
            "_other": "Afghanistan Standard Time",
            "_type": "Asia/Kabul",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Afghanistan Standard Time",
            "_type": "Asia/Kabul",
            "_territory": "AF"
          }
        },
        {
          "mapZone": {
            "_other": "Alaskan Standard Time",
            "_type": "America/Anchorage",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Alaskan Standard Time",
            "_type":
                "America/Anchorage America/Juneau America/Metlakatla America/Nome America/Sitka America/Yakutat",
            "_territory": "US"
          }
        },
        {
          "mapZone": {
            "_other": "Aleutian Standard Time",
            "_type": "America/Adak",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Aleutian Standard Time",
            "_type": "America/Adak",
            "_territory": "US"
          }
        },
        {
          "mapZone": {
            "_other": "Altai Standard Time",
            "_type": "Asia/Barnaul",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Altai Standard Time",
            "_type": "Asia/Barnaul",
            "_territory": "RU"
          }
        },
        {
          "mapZone": {
            "_other": "Arab Standard Time",
            "_type": "Asia/Riyadh",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Arab Standard Time",
            "_type": "Asia/Bahrain",
            "_territory": "BH"
          }
        },
        {
          "mapZone": {
            "_other": "Arab Standard Time",
            "_type": "Asia/Kuwait",
            "_territory": "KW"
          }
        },
        {
          "mapZone": {
            "_other": "Arab Standard Time",
            "_type": "Asia/Qatar",
            "_territory": "QA"
          }
        },
        {
          "mapZone": {
            "_other": "Arab Standard Time",
            "_type": "Asia/Riyadh",
            "_territory": "SA"
          }
        },
        {
          "mapZone": {
            "_other": "Arab Standard Time",
            "_type": "Asia/Aden",
            "_territory": "YE"
          }
        },
        {
          "mapZone": {
            "_other": "Arabian Standard Time",
            "_type": "Asia/Dubai",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Arabian Standard Time",
            "_type": "Asia/Dubai",
            "_territory": "AE"
          }
        },
        {
          "mapZone": {
            "_other": "Arabian Standard Time",
            "_type": "Asia/Muscat",
            "_territory": "OM"
          }
        },
        {
          "mapZone": {
            "_other": "Arabian Standard Time",
            "_type": "Etc/GMT-4",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "Arabic Standard Time",
            "_type": "Asia/Baghdad",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Arabic Standard Time",
            "_type": "Asia/Baghdad",
            "_territory": "IQ"
          }
        },
        {
          "mapZone": {
            "_other": "Argentina Standard Time",
            "_type": "America/Buenos_Aires",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Argentina Standard Time",
            "_type":
                "America/Buenos_Aires America/Argentina/La_Rioja America/Argentina/Rio_Gallegos America/Argentina/Salta America/Argentina/San_Juan America/Argentina/San_Luis America/Argentina/Tucuman America/Argentina/Ushuaia America/Catamarca America/Cordoba America/Jujuy America/Mendoza",
            "_territory": "AR"
          }
        },
        {
          "mapZone": {
            "_other": "Astrakhan Standard Time",
            "_type": "Europe/Astrakhan",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Astrakhan Standard Time",
            "_type": "Europe/Astrakhan Europe/Ulyanovsk",
            "_territory": "RU"
          }
        },
        {
          "mapZone": {
            "_other": "Atlantic Standard Time",
            "_type": "America/Halifax",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Atlantic Standard Time",
            "_type": "Atlantic/Bermuda",
            "_territory": "BM"
          }
        },
        {
          "mapZone": {
            "_other": "Atlantic Standard Time",
            "_type":
                "America/Halifax America/Glace_Bay America/Goose_Bay America/Moncton",
            "_territory": "CA"
          }
        },
        {
          "mapZone": {
            "_other": "Atlantic Standard Time",
            "_type": "America/Thule",
            "_territory": "GL"
          }
        },
        {
          "mapZone": {
            "_other": "AUS Central Standard Time",
            "_type": "Australia/Darwin",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "AUS Central Standard Time",
            "_type": "Australia/Darwin",
            "_territory": "AU"
          }
        },
        {
          "mapZone": {
            "_other": "Aus Central W. Standard Time",
            "_type": "Australia/Eucla",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Aus Central W. Standard Time",
            "_type": "Australia/Eucla",
            "_territory": "AU"
          }
        },
        {
          "mapZone": {
            "_other": "AUS Eastern Standard Time",
            "_type": "Australia/Sydney",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "AUS Eastern Standard Time",
            "_type": "Australia/Sydney Australia/Melbourne",
            "_territory": "AU"
          }
        },
        {
          "mapZone": {
            "_other": "Azerbaijan Standard Time",
            "_type": "Asia/Baku",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Azerbaijan Standard Time",
            "_type": "Asia/Baku",
            "_territory": "AZ"
          }
        },
        {
          "mapZone": {
            "_other": "Azores Standard Time",
            "_type": "Atlantic/Azores",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Azores Standard Time",
            "_type": "America/Scoresbysund",
            "_territory": "GL"
          }
        },
        {
          "mapZone": {
            "_other": "Azores Standard Time",
            "_type": "Atlantic/Azores",
            "_territory": "PT"
          }
        },
        {
          "mapZone": {
            "_other": "Bahia Standard Time",
            "_type": "America/Bahia",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Bahia Standard Time",
            "_type": "America/Bahia",
            "_territory": "BR"
          }
        },
        {
          "mapZone": {
            "_other": "Bangladesh Standard Time",
            "_type": "Asia/Dhaka",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Bangladesh Standard Time",
            "_type": "Asia/Dhaka",
            "_territory": "BD"
          }
        },
        {
          "mapZone": {
            "_other": "Bangladesh Standard Time",
            "_type": "Asia/Thimphu",
            "_territory": "BT"
          }
        },
        {
          "mapZone": {
            "_other": "Belarus Standard Time",
            "_type": "Europe/Minsk",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Belarus Standard Time",
            "_type": "Europe/Minsk",
            "_territory": "BY"
          }
        },
        {
          "mapZone": {
            "_other": "Bougainville Standard Time",
            "_type": "Pacific/Bougainville",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Bougainville Standard Time",
            "_type": "Pacific/Bougainville",
            "_territory": "PG"
          }
        },
        {
          "mapZone": {
            "_other": "Canada Central Standard Time",
            "_type": "America/Regina",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Canada Central Standard Time",
            "_type": "America/Regina America/Swift_Current",
            "_territory": "CA"
          }
        },
        {
          "mapZone": {
            "_other": "Cape Verde Standard Time",
            "_type": "Atlantic/Cape_Verde",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Cape Verde Standard Time",
            "_type": "Atlantic/Cape_Verde",
            "_territory": "CV"
          }
        },
        {
          "mapZone": {
            "_other": "Cape Verde Standard Time",
            "_type": "Etc/GMT+1",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "Caucasus Standard Time",
            "_type": "Asia/Yerevan",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Caucasus Standard Time",
            "_type": "Asia/Yerevan",
            "_territory": "AM"
          }
        },
        {
          "mapZone": {
            "_other": "Cen. Australia Standard Time",
            "_type": "Australia/Adelaide",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Cen. Australia Standard Time",
            "_type": "Australia/Adelaide Australia/Broken_Hill",
            "_territory": "AU"
          }
        },
        {
          "mapZone": {
            "_other": "Central America Standard Time",
            "_type": "America/Guatemala",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Central America Standard Time",
            "_type": "America/Belize",
            "_territory": "BZ"
          }
        },
        {
          "mapZone": {
            "_other": "Central America Standard Time",
            "_type": "America/Costa_Rica",
            "_territory": "CR"
          }
        },
        {
          "mapZone": {
            "_other": "Central America Standard Time",
            "_type": "Pacific/Galapagos",
            "_territory": "EC"
          }
        },
        {
          "mapZone": {
            "_other": "Central America Standard Time",
            "_type": "America/Guatemala",
            "_territory": "GT"
          }
        },
        {
          "mapZone": {
            "_other": "Central America Standard Time",
            "_type": "America/Tegucigalpa",
            "_territory": "HN"
          }
        },
        {
          "mapZone": {
            "_other": "Central America Standard Time",
            "_type": "America/Managua",
            "_territory": "NI"
          }
        },
        {
          "mapZone": {
            "_other": "Central America Standard Time",
            "_type": "America/El_Salvador",
            "_territory": "SV"
          }
        },
        {
          "mapZone": {
            "_other": "Central America Standard Time",
            "_type": "Etc/GMT+6",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "Central Asia Standard Time",
            "_type": "Asia/Bishkek",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Central Asia Standard Time",
            "_type": "Antarctica/Vostok",
            "_territory": "AQ"
          }
        },
        {
          "mapZone": {
            "_other": "Central Asia Standard Time",
            "_type": "Asia/Urumqi",
            "_territory": "CN"
          }
        },
        {
          "mapZone": {
            "_other": "Central Asia Standard Time",
            "_type": "Indian/Chagos",
            "_territory": "IO"
          }
        },
        {
          "mapZone": {
            "_other": "Central Asia Standard Time",
            "_type": "Asia/Bishkek",
            "_territory": "KG"
          }
        },
        {
          "mapZone": {
            "_other": "Central Asia Standard Time",
            "_type": "Etc/GMT-6",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "Central Brazilian Standard Time",
            "_type": "America/Cuiaba",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Central Brazilian Standard Time",
            "_type": "America/Cuiaba America/Campo_Grande",
            "_territory": "BR"
          }
        },
        {
          "mapZone": {
            "_other": "Central Europe Standard Time",
            "_type": "Europe/Budapest",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Central Europe Standard Time",
            "_type": "Europe/Tirane",
            "_territory": "AL"
          }
        },
        {
          "mapZone": {
            "_other": "Central Europe Standard Time",
            "_type": "Europe/Prague",
            "_territory": "CZ"
          }
        },
        {
          "mapZone": {
            "_other": "Central Europe Standard Time",
            "_type": "Europe/Budapest",
            "_territory": "HU"
          }
        },
        {
          "mapZone": {
            "_other": "Central Europe Standard Time",
            "_type": "Europe/Podgorica",
            "_territory": "ME"
          }
        },
        {
          "mapZone": {
            "_other": "Central Europe Standard Time",
            "_type": "Europe/Belgrade",
            "_territory": "RS"
          }
        },
        {
          "mapZone": {
            "_other": "Central Europe Standard Time",
            "_type": "Europe/Ljubljana",
            "_territory": "SI"
          }
        },
        {
          "mapZone": {
            "_other": "Central Europe Standard Time",
            "_type": "Europe/Bratislava",
            "_territory": "SK"
          }
        },
        {
          "mapZone": {
            "_other": "Central European Standard Time",
            "_type": "Europe/Warsaw",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Central European Standard Time",
            "_type": "Europe/Sarajevo",
            "_territory": "BA"
          }
        },
        {
          "mapZone": {
            "_other": "Central European Standard Time",
            "_type": "Europe/Zagreb",
            "_territory": "HR"
          }
        },
        {
          "mapZone": {
            "_other": "Central European Standard Time",
            "_type": "Europe/Skopje",
            "_territory": "MK"
          }
        },
        {
          "mapZone": {
            "_other": "Central European Standard Time",
            "_type": "Europe/Warsaw",
            "_territory": "PL"
          }
        },
        {
          "mapZone": {
            "_other": "Central Pacific Standard Time",
            "_type": "Pacific/Guadalcanal",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Central Pacific Standard Time",
            "_type": "Antarctica/Casey",
            "_territory": "AQ"
          }
        },
        {
          "mapZone": {
            "_other": "Central Pacific Standard Time",
            "_type": "Pacific/Ponape Pacific/Kosrae",
            "_territory": "FM"
          }
        },
        {
          "mapZone": {
            "_other": "Central Pacific Standard Time",
            "_type": "Pacific/Noumea",
            "_territory": "NC"
          }
        },
        {
          "mapZone": {
            "_other": "Central Pacific Standard Time",
            "_type": "Pacific/Guadalcanal",
            "_territory": "SB"
          }
        },
        {
          "mapZone": {
            "_other": "Central Pacific Standard Time",
            "_type": "Pacific/Efate",
            "_territory": "VU"
          }
        },
        {
          "mapZone": {
            "_other": "Central Pacific Standard Time",
            "_type": "Etc/GMT-11",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "Central Standard Time",
            "_type": "America/Chicago",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Central Standard Time",
            "_type": "America/Winnipeg America/Rankin_Inlet America/Resolute",
            "_territory": "CA"
          }
        },
        {
          "mapZone": {
            "_other": "Central Standard Time",
            "_type": "America/Matamoros America/Ojinaga",
            "_territory": "MX"
          }
        },
        {
          "mapZone": {
            "_other": "Central Standard Time",
            "_type":
                "America/Chicago America/Indiana/Knox America/Indiana/Tell_City America/Menominee America/North_Dakota/Beulah America/North_Dakota/Center America/North_Dakota/New_Salem",
            "_territory": "US"
          }
        },
        {
          "mapZone": {
            "_other": "Central Standard Time",
            "_type": "CST6CDT",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "Central Standard Time (Mexico)",
            "_type": "America/Mexico_City",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Central Standard Time (Mexico)",
            "_type":
                "America/Mexico_City America/Bahia_Banderas America/Merida America/Monterrey America/Chihuahua ",
            "_territory": "MX"
          }
        },
        {
          "mapZone": {
            "_other": "Chatham Islands Standard Time",
            "_type": "Pacific/Chatham",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Chatham Islands Standard Time",
            "_type": "Pacific/Chatham",
            "_territory": "NZ"
          }
        },
        {
          "mapZone": {
            "_other": "China Standard Time",
            "_type": "Asia/Shanghai",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "China Standard Time",
            "_type": "Asia/Shanghai",
            "_territory": "CN"
          }
        },
        {
          "mapZone": {
            "_other": "China Standard Time",
            "_type": "Asia/Hong_Kong",
            "_territory": "HK"
          }
        },
        {
          "mapZone": {
            "_other": "China Standard Time",
            "_type": "Asia/Macau",
            "_territory": "MO"
          }
        },
        {
          "mapZone": {
            "_other": "Cuba Standard Time",
            "_type": "America/Havana",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Cuba Standard Time",
            "_type": "America/Havana",
            "_territory": "CU"
          }
        },
        {
          "mapZone": {
            "_other": "Dateline Standard Time",
            "_type": "Etc/GMT+12",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Dateline Standard Time",
            "_type": "Etc/GMT+12",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "E. Africa Standard Time",
            "_type": "Africa/Nairobi",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "E. Africa Standard Time",
            "_type": "Antarctica/Syowa",
            "_territory": "AQ"
          }
        },
        {
          "mapZone": {
            "_other": "E. Africa Standard Time",
            "_type": "Africa/Djibouti",
            "_territory": "DJ"
          }
        },
        {
          "mapZone": {
            "_other": "E. Africa Standard Time",
            "_type": "Africa/Asmera",
            "_territory": "ER"
          }
        },
        {
          "mapZone": {
            "_other": "E. Africa Standard Time",
            "_type": "Africa/Addis_Ababa",
            "_territory": "ET"
          }
        },
        {
          "mapZone": {
            "_other": "E. Africa Standard Time",
            "_type": "Africa/Nairobi",
            "_territory": "KE"
          }
        },
        {
          "mapZone": {
            "_other": "E. Africa Standard Time",
            "_type": "Indian/Comoro",
            "_territory": "KM"
          }
        },
        {
          "mapZone": {
            "_other": "E. Africa Standard Time",
            "_type": "Indian/Antananarivo",
            "_territory": "MG"
          }
        },
        {
          "mapZone": {
            "_other": "E. Africa Standard Time",
            "_type": "Africa/Mogadishu",
            "_territory": "SO"
          }
        },
        {
          "mapZone": {
            "_other": "E. Africa Standard Time",
            "_type": "Africa/Dar_es_Salaam",
            "_territory": "TZ"
          }
        },
        {
          "mapZone": {
            "_other": "E. Africa Standard Time",
            "_type": "Africa/Kampala",
            "_territory": "UG"
          }
        },
        {
          "mapZone": {
            "_other": "E. Africa Standard Time",
            "_type": "Indian/Mayotte",
            "_territory": "YT"
          }
        },
        {
          "mapZone": {
            "_other": "E. Africa Standard Time",
            "_type": "Etc/GMT-3",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "E. Australia Standard Time",
            "_type": "Australia/Brisbane",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "E. Australia Standard Time",
            "_type": "Australia/Brisbane Australia/Lindeman",
            "_territory": "AU"
          }
        },
        {
          "mapZone": {
            "_other": "E. Europe Standard Time",
            "_type": "Europe/Chisinau",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "E. Europe Standard Time",
            "_type": "Europe/Chisinau",
            "_territory": "MD"
          }
        },
        {
          "mapZone": {
            "_other": "E. South America Standard Time",
            "_type": "America/Sao_Paulo",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "E. South America Standard Time",
            "_type": "America/Sao_Paulo",
            "_territory": "BR"
          }
        },
        {
          "mapZone": {
            "_other": "Easter Island Standard Time",
            "_type": "Pacific/Easter",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Easter Island Standard Time",
            "_type": "Pacific/Easter",
            "_territory": "CL"
          }
        },
        {
          "mapZone": {
            "_other": "Eastern Standard Time",
            "_type": "America/New_York",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Eastern Standard Time",
            "_type": "America/Nassau",
            "_territory": "BS"
          }
        },
        {
          "mapZone": {
            "_other": "Eastern Standard Time",
            "_type": "America/Toronto America/Iqaluit",
            "_territory": "CA"
          }
        },
        {
          "mapZone": {
            "_other": "Eastern Standard Time",
            "_type":
                "America/New_York America/Detroit America/Indiana/Petersburg America/Indiana/Vincennes America/Indiana/Winamac America/Kentucky/Monticello America/Louisville",
            "_territory": "US"
          }
        },
        {
          "mapZone": {
            "_other": "Eastern Standard Time",
            "_type": "EST5EDT",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "Eastern Standard Time (Mexico)",
            "_type": "America/Cancun",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Eastern Standard Time (Mexico)",
            "_type": "America/Cancun",
            "_territory": "MX"
          }
        },
        {
          "mapZone": {
            "_other": "Egypt Standard Time",
            "_type": "Africa/Cairo",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Egypt Standard Time",
            "_type": "Africa/Cairo",
            "_territory": "EG"
          }
        },
        {
          "mapZone": {
            "_other": "Ekaterinburg Standard Time",
            "_type": "Asia/Yekaterinburg",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Ekaterinburg Standard Time",
            "_type": "Asia/Yekaterinburg",
            "_territory": "RU"
          }
        },
        {
          "mapZone": {
            "_other": "Fiji Standard Time",
            "_type": "Pacific/Fiji",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Fiji Standard Time",
            "_type": "Pacific/Fiji",
            "_territory": "FJ"
          }
        },
        {
          "mapZone": {
            "_other": "FLE Standard Time",
            "_type": "Europe/Kiev",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "FLE Standard Time",
            "_type": "Europe/Mariehamn",
            "_territory": "AX"
          }
        },
        {
          "mapZone": {
            "_other": "FLE Standard Time",
            "_type": "Europe/Sofia",
            "_territory": "BG"
          }
        },
        {
          "mapZone": {
            "_other": "FLE Standard Time",
            "_type": "Europe/Tallinn",
            "_territory": "EE"
          }
        },
        {
          "mapZone": {
            "_other": "FLE Standard Time",
            "_type": "Europe/Helsinki",
            "_territory": "FI"
          }
        },
        {
          "mapZone": {
            "_other": "FLE Standard Time",
            "_type": "Europe/Vilnius",
            "_territory": "LT"
          }
        },
        {
          "mapZone": {
            "_other": "FLE Standard Time",
            "_type": "Europe/Riga",
            "_territory": "LV"
          }
        },
        {
          "mapZone": {
            "_other": "FLE Standard Time",
            "_type": "Europe/Kiev",
            "_territory": "UA"
          }
        },
        {
          "mapZone": {
            "_other": "Georgian Standard Time",
            "_type": "Asia/Tbilisi",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Georgian Standard Time",
            "_type": "Asia/Tbilisi",
            "_territory": "GE"
          }
        },
        {
          "mapZone": {
            "_other": "GMT Standard Time",
            "_type": "Europe/London",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "GMT Standard Time",
            "_type": "Atlantic/Canary",
            "_territory": "ES"
          }
        },
        {
          "mapZone": {
            "_other": "GMT Standard Time",
            "_type": "Atlantic/Faeroe",
            "_territory": "FO"
          }
        },
        {
          "mapZone": {
            "_other": "GMT Standard Time",
            "_type": "Europe/London",
            "_territory": "GB"
          }
        },
        {
          "mapZone": {
            "_other": "GMT Standard Time",
            "_type": "Europe/Guernsey",
            "_territory": "GG"
          }
        },
        {
          "mapZone": {
            "_other": "GMT Standard Time",
            "_type": "Europe/Dublin",
            "_territory": "IE"
          }
        },
        {
          "mapZone": {
            "_other": "GMT Standard Time",
            "_type": "Europe/Isle_of_Man",
            "_territory": "IM"
          }
        },
        {
          "mapZone": {
            "_other": "GMT Standard Time",
            "_type": "Europe/Jersey",
            "_territory": "JE"
          }
        },
        {
          "mapZone": {
            "_other": "GMT Standard Time",
            "_type": "Europe/Lisbon Atlantic/Madeira",
            "_territory": "PT"
          }
        },
        {
          "mapZone": {
            "_other": "Greenland Standard Time",
            "_type": "America/Godthab",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Greenland Standard Time",
            "_type": "America/Godthab",
            "_territory": "GL"
          }
        },
        {
          "mapZone": {
            "_other": "Greenwich Standard Time",
            "_type": "Atlantic/Reykjavik",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Greenwich Standard Time",
            "_type": "Africa/Ouagadougou",
            "_territory": "BF"
          }
        },
        {
          "mapZone": {
            "_other": "Greenwich Standard Time",
            "_type": "Africa/Abidjan",
            "_territory": "CI"
          }
        },
        {
          "mapZone": {
            "_other": "Greenwich Standard Time",
            "_type": "Africa/Accra",
            "_territory": "GH"
          }
        },
        {
          "mapZone": {
            "_other": "Greenwich Standard Time",
            "_type": "America/Danmarkshavn",
            "_territory": "GL"
          }
        },
        {
          "mapZone": {
            "_other": "Greenwich Standard Time",
            "_type": "Africa/Banjul",
            "_territory": "GM"
          }
        },
        {
          "mapZone": {
            "_other": "Greenwich Standard Time",
            "_type": "Africa/Conakry",
            "_territory": "GN"
          }
        },
        {
          "mapZone": {
            "_other": "Greenwich Standard Time",
            "_type": "Africa/Bissau",
            "_territory": "GW"
          }
        },
        {
          "mapZone": {
            "_other": "Greenwich Standard Time",
            "_type": "Atlantic/Reykjavik",
            "_territory": "IS"
          }
        },
        {
          "mapZone": {
            "_other": "Greenwich Standard Time",
            "_type": "Africa/Monrovia",
            "_territory": "LR"
          }
        },
        {
          "mapZone": {
            "_other": "Greenwich Standard Time",
            "_type": "Africa/Bamako",
            "_territory": "ML"
          }
        },
        {
          "mapZone": {
            "_other": "Greenwich Standard Time",
            "_type": "Africa/Nouakchott",
            "_territory": "MR"
          }
        },
        {
          "mapZone": {
            "_other": "Greenwich Standard Time",
            "_type": "Atlantic/St_Helena",
            "_territory": "SH"
          }
        },
        {
          "mapZone": {
            "_other": "Greenwich Standard Time",
            "_type": "Africa/Freetown",
            "_territory": "SL"
          }
        },
        {
          "mapZone": {
            "_other": "Greenwich Standard Time",
            "_type": "Africa/Dakar",
            "_territory": "SN"
          }
        },
        {
          "mapZone": {
            "_other": "Greenwich Standard Time",
            "_type": "Africa/Lome",
            "_territory": "TG"
          }
        },
        {
          "mapZone": {
            "_other": "GTB Standard Time",
            "_type": "Europe/Bucharest",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "GTB Standard Time",
            "_type": "Asia/Nicosia Asia/Famagusta",
            "_territory": "CY"
          }
        },
        {
          "mapZone": {
            "_other": "GTB Standard Time",
            "_type": "Europe/Athens",
            "_territory": "GR"
          }
        },
        {
          "mapZone": {
            "_other": "GTB Standard Time",
            "_type": "Europe/Bucharest",
            "_territory": "RO"
          }
        },
        {
          "mapZone": {
            "_other": "Haiti Standard Time",
            "_type": "America/Port-au-Prince",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Haiti Standard Time",
            "_type": "America/Port-au-Prince",
            "_territory": "HT"
          }
        },
        {
          "mapZone": {
            "_other": "Hawaiian Standard Time",
            "_type": "Pacific/Honolulu",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Hawaiian Standard Time",
            "_type": "Pacific/Rarotonga",
            "_territory": "CK"
          }
        },
        {
          "mapZone": {
            "_other": "Hawaiian Standard Time",
            "_type": "Pacific/Tahiti",
            "_territory": "PF"
          }
        },
        {
          "mapZone": {
            "_other": "Hawaiian Standard Time",
            "_type": "Pacific/Honolulu",
            "_territory": "US"
          }
        },
        {
          "mapZone": {
            "_other": "Hawaiian Standard Time",
            "_type": "Etc/GMT+10",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "India Standard Time",
            "_type": "Asia/Calcutta",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "India Standard Time",
            "_type": "Asia/Calcutta",
            "_territory": "IN"
          }
        },
        {
          "mapZone": {
            "_other": "Iran Standard Time",
            "_type": "Asia/Tehran",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Iran Standard Time",
            "_type": "Asia/Tehran",
            "_territory": "IR"
          }
        },
        {
          "mapZone": {
            "_other": "Israel Standard Time",
            "_type": "Asia/Jerusalem",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Israel Standard Time",
            "_type": "Asia/Jerusalem",
            "_territory": "IL"
          }
        },
        {
          "mapZone": {
            "_other": "Jordan Standard Time",
            "_type": "Asia/Amman",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Jordan Standard Time",
            "_type": "Asia/Amman",
            "_territory": "JO"
          }
        },
        {
          "mapZone": {
            "_other": "Kaliningrad Standard Time",
            "_type": "Europe/Kaliningrad",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Kaliningrad Standard Time",
            "_type": "Europe/Kaliningrad",
            "_territory": "RU"
          }
        },
        {
          "mapZone": {
            "_other": "Korea Standard Time",
            "_type": "Asia/Seoul",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Korea Standard Time",
            "_type": "Asia/Seoul",
            "_territory": "KR"
          }
        },
        {
          "mapZone": {
            "_other": "Libya Standard Time",
            "_type": "Africa/Tripoli",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Libya Standard Time",
            "_type": "Africa/Tripoli",
            "_territory": "LY"
          }
        },
        {
          "mapZone": {
            "_other": "Line Islands Standard Time",
            "_type": "Pacific/Kiritimati",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Line Islands Standard Time",
            "_type": "Pacific/Kiritimati",
            "_territory": "KI"
          }
        },
        {
          "mapZone": {
            "_other": "Line Islands Standard Time",
            "_type": "Etc/GMT-14",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "Lord Howe Standard Time",
            "_type": "Australia/Lord_Howe",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Lord Howe Standard Time",
            "_type": "Australia/Lord_Howe",
            "_territory": "AU"
          }
        },
        {
          "mapZone": {
            "_other": "Magadan Standard Time",
            "_type": "Asia/Magadan",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Magadan Standard Time",
            "_type": "Asia/Magadan",
            "_territory": "RU"
          }
        },
        {
          "mapZone": {
            "_other": "Magallanes Standard Time",
            "_type": "America/Punta_Arenas",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Magallanes Standard Time",
            "_type": "America/Punta_Arenas",
            "_territory": "CL"
          }
        },
        {
          "mapZone": {
            "_other": "Marquesas Standard Time",
            "_type": "Pacific/Marquesas",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Marquesas Standard Time",
            "_type": "Pacific/Marquesas",
            "_territory": "PF"
          }
        },
        {
          "mapZone": {
            "_other": "Mauritius Standard Time",
            "_type": "Indian/Mauritius",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Mauritius Standard Time",
            "_type": "Indian/Mauritius",
            "_territory": "MU"
          }
        },
        {
          "mapZone": {
            "_other": "Mauritius Standard Time",
            "_type": "Indian/Reunion",
            "_territory": "RE"
          }
        },
        {
          "mapZone": {
            "_other": "Mauritius Standard Time",
            "_type": "Indian/Mahe",
            "_territory": "SC"
          }
        },
        {
          "mapZone": {
            "_other": "Middle East Standard Time",
            "_type": "Asia/Beirut",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Middle East Standard Time",
            "_type": "Asia/Beirut",
            "_territory": "LB"
          }
        },
        {
          "mapZone": {
            "_other": "Montevideo Standard Time",
            "_type": "America/Montevideo",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Montevideo Standard Time",
            "_type": "America/Montevideo",
            "_territory": "UY"
          }
        },
        {
          "mapZone": {
            "_other": "Morocco Standard Time",
            "_type": "Africa/Casablanca",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Morocco Standard Time",
            "_type": "Africa/El_Aaiun",
            "_territory": "EH"
          }
        },
        {
          "mapZone": {
            "_other": "Morocco Standard Time",
            "_type": "Africa/Casablanca",
            "_territory": "MA"
          }
        },
        {
          "mapZone": {
            "_other": "Mountain Standard Time",
            "_type": "America/Denver",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Mountain Standard Time",
            "_type": "America/Edmonton America/Cambridge_Bay America/Inuvik",
            "_territory": "CA"
          }
        },
        {
          "mapZone": {
            "_other": "Mountain Standard Time",
            "_type": "America/Ciudad_Juarez",
            "_territory": "MX"
          }
        },
        {
          "mapZone": {
            "_other": "Mountain Standard Time",
            "_type": "America/Denver America/Boise",
            "_territory": "US"
          }
        },
        {
          "mapZone": {
            "_other": "Mountain Standard Time",
            "_type": "MST7MDT",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "Mountain Standard Time (Mexico)",
            "_type": "America/Mazatlan",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Mountain Standard Time (Mexico)",
            "_type": "America/Mazatlan",
            "_territory": "MX"
          }
        },
        {
          "mapZone": {
            "_other": "Myanmar Standard Time",
            "_type": "Asia/Rangoon",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Myanmar Standard Time",
            "_type": "Indian/Cocos",
            "_territory": "CC"
          }
        },
        {
          "mapZone": {
            "_other": "Myanmar Standard Time",
            "_type": "Asia/Rangoon",
            "_territory": "MM"
          }
        },
        {
          "mapZone": {
            "_other": "N. Central Asia Standard Time",
            "_type": "Asia/Novosibirsk",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "N. Central Asia Standard Time",
            "_type": "Asia/Novosibirsk",
            "_territory": "RU"
          }
        },
        {
          "mapZone": {
            "_other": "Namibia Standard Time",
            "_type": "Africa/Windhoek",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Namibia Standard Time",
            "_type": "Africa/Windhoek",
            "_territory": "NA"
          }
        },
        {
          "mapZone": {
            "_other": "Nepal Standard Time",
            "_type": "Asia/Katmandu",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Nepal Standard Time",
            "_type": "Asia/Katmandu",
            "_territory": "NP"
          }
        },
        {
          "mapZone": {
            "_other": "New Zealand Standard Time",
            "_type": "Pacific/Auckland",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "New Zealand Standard Time",
            "_type": "Antarctica/McMurdo",
            "_territory": "AQ"
          }
        },
        {
          "mapZone": {
            "_other": "New Zealand Standard Time",
            "_type": "Pacific/Auckland",
            "_territory": "NZ"
          }
        },
        {
          "mapZone": {
            "_other": "Newfoundland Standard Time",
            "_type": "America/St_Johns",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Newfoundland Standard Time",
            "_type": "America/St_Johns",
            "_territory": "CA"
          }
        },
        {
          "mapZone": {
            "_other": "Norfolk Standard Time",
            "_type": "Pacific/Norfolk",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Norfolk Standard Time",
            "_type": "Pacific/Norfolk",
            "_territory": "NF"
          }
        },
        {
          "mapZone": {
            "_other": "North Asia East Standard Time",
            "_type": "Asia/Irkutsk",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "North Asia East Standard Time",
            "_type": "Asia/Irkutsk",
            "_territory": "RU"
          }
        },
        {
          "mapZone": {
            "_other": "North Asia Standard Time",
            "_type": "Asia/Krasnoyarsk",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "North Asia Standard Time",
            "_type": "Asia/Krasnoyarsk Asia/Novokuznetsk",
            "_territory": "RU"
          }
        },
        {
          "mapZone": {
            "_other": "North Korea Standard Time",
            "_type": "Asia/Pyongyang",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "North Korea Standard Time",
            "_type": "Asia/Pyongyang",
            "_territory": "KP"
          }
        },
        {
          "mapZone": {
            "_other": "Omsk Standard Time",
            "_type": "Asia/Omsk",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Omsk Standard Time",
            "_type": "Asia/Omsk",
            "_territory": "RU"
          }
        },
        {
          "mapZone": {
            "_other": "Pacific SA Standard Time",
            "_type": "America/Santiago",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Pacific SA Standard Time",
            "_type": "America/Santiago",
            "_territory": "CL"
          }
        },
        {
          "mapZone": {
            "_other": "Pacific Standard Time",
            "_type": "America/Los_Angeles",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Pacific Standard Time",
            "_type": "America/Vancouver",
            "_territory": "CA"
          }
        },
        {
          "mapZone": {
            "_other": "Pacific Standard Time",
            "_type": "America/Los_Angeles",
            "_territory": "US"
          }
        },
        {
          "mapZone": {
            "_other": "Pacific Standard Time",
            "_type": "PST8PDT",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "Pacific Standard Time (Mexico)",
            "_type": "America/Tijuana",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Pacific Standard Time (Mexico)",
            "_type": "America/Tijuana",
            "_territory": "MX"
          }
        },
        {
          "mapZone": {
            "_other": "Pakistan Standard Time",
            "_type": "Asia/Karachi",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Pakistan Standard Time",
            "_type": "Asia/Karachi",
            "_territory": "PK"
          }
        },
        {
          "mapZone": {
            "_other": "Paraguay Standard Time",
            "_type": "America/Asuncion",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Paraguay Standard Time",
            "_type": "America/Asuncion",
            "_territory": "PY"
          }
        },
        {
          "mapZone": {
            "_other": "Qyzylorda Standard Time",
            "_type": "Asia/Qyzylorda",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Qyzylorda Standard Time",
            "_type": "Asia/Qyzylorda",
            "_territory": "KZ"
          }
        },
        {
          "mapZone": {
            "_other": "Romance Standard Time",
            "_type": "Europe/Paris",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Romance Standard Time",
            "_type": "Europe/Brussels",
            "_territory": "BE"
          }
        },
        {
          "mapZone": {
            "_other": "Romance Standard Time",
            "_type": "Europe/Copenhagen",
            "_territory": "DK"
          }
        },
        {
          "mapZone": {
            "_other": "Romance Standard Time",
            "_type": "Europe/Madrid Africa/Ceuta",
            "_territory": "ES"
          }
        },
        {
          "mapZone": {
            "_other": "Romance Standard Time",
            "_type": "Europe/Paris",
            "_territory": "FR"
          }
        },
        {
          "mapZone": {
            "_other": "Russia Time Zone 3",
            "_type": "Europe/Samara",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Russia Time Zone 3",
            "_type": "Europe/Samara",
            "_territory": "RU"
          }
        },
        {
          "mapZone": {
            "_other": "Russia Time Zone 10",
            "_type": "Asia/Srednekolymsk",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Russia Time Zone 10",
            "_type": "Asia/Srednekolymsk",
            "_territory": "RU"
          }
        },
        {
          "mapZone": {
            "_other": "Russia Time Zone 11",
            "_type": "Asia/Kamchatka",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Russia Time Zone 11",
            "_type": "Asia/Kamchatka Asia/Anadyr",
            "_territory": "RU"
          }
        },
        {
          "mapZone": {
            "_other": "Russian Standard Time",
            "_type": "Europe/Moscow",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Russian Standard Time",
            "_type": "Europe/Moscow Europe/Kirov",
            "_territory": "RU"
          }
        },
        {
          "mapZone": {
            "_other": "Russian Standard Time",
            "_type": "Europe/Simferopol",
            "_territory": "UA"
          }
        },
        {
          "mapZone": {
            "_other": "SA Eastern Standard Time",
            "_type": "America/Cayenne",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "SA Eastern Standard Time",
            "_type": "Antarctica/Rothera Antarctica/Palmer",
            "_territory": "AQ"
          }
        },
        {
          "mapZone": {
            "_other": "SA Eastern Standard Time",
            "_type":
                "America/Fortaleza America/Belem America/Maceio America/Recife America/Santarem",
            "_territory": "BR"
          }
        },
        {
          "mapZone": {
            "_other": "SA Eastern Standard Time",
            "_type": "Atlantic/Stanley",
            "_territory": "FK"
          }
        },
        {
          "mapZone": {
            "_other": "SA Eastern Standard Time",
            "_type": "America/Cayenne",
            "_territory": "GF"
          }
        },
        {
          "mapZone": {
            "_other": "SA Eastern Standard Time",
            "_type": "America/Paramaribo",
            "_territory": "SR"
          }
        },
        {
          "mapZone": {
            "_other": "SA Eastern Standard Time",
            "_type": "Etc/GMT+3",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "SA Pacific Standard Time",
            "_type": "America/Bogota",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "SA Pacific Standard Time",
            "_type": "America/Rio_Branco America/Eirunepe",
            "_territory": "BR"
          }
        },
        {
          "mapZone": {
            "_other": "SA Pacific Standard Time",
            "_type": "America/Coral_Harbour",
            "_territory": "CA"
          }
        },
        {
          "mapZone": {
            "_other": "SA Pacific Standard Time",
            "_type": "America/Bogota",
            "_territory": "CO"
          }
        },
        {
          "mapZone": {
            "_other": "SA Pacific Standard Time",
            "_type": "America/Guayaquil",
            "_territory": "EC"
          }
        },
        {
          "mapZone": {
            "_other": "SA Pacific Standard Time",
            "_type": "America/Jamaica",
            "_territory": "JM"
          }
        },
        {
          "mapZone": {
            "_other": "SA Pacific Standard Time",
            "_type": "America/Cayman",
            "_territory": "KY"
          }
        },
        {
          "mapZone": {
            "_other": "SA Pacific Standard Time",
            "_type": "America/Panama",
            "_territory": "PA"
          }
        },
        {
          "mapZone": {
            "_other": "SA Pacific Standard Time",
            "_type": "America/Lima",
            "_territory": "PE"
          }
        },
        {
          "mapZone": {
            "_other": "SA Pacific Standard Time",
            "_type": "Etc/GMT+5",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/La_Paz",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/Antigua",
            "_territory": "AG"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/Anguilla",
            "_territory": "AI"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/Aruba",
            "_territory": "AW"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/Barbados",
            "_territory": "BB"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/St_Barthelemy",
            "_territory": "BL"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/La_Paz",
            "_territory": "BO"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/Kralendijk",
            "_territory": "BQ"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/Manaus America/Boa_Vista America/Porto_Velho",
            "_territory": "BR"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/Blanc-Sablon",
            "_territory": "CA"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/Curacao",
            "_territory": "CW"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/Dominica",
            "_territory": "DM"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/Santo_Domingo",
            "_territory": "DO"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/Grenada",
            "_territory": "GD"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/Guadeloupe",
            "_territory": "GP"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/Guyana",
            "_territory": "GY"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/St_Kitts",
            "_territory": "KN"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/St_Lucia",
            "_territory": "LC"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/Marigot",
            "_territory": "MF"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/Martinique",
            "_territory": "MQ"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/Montserrat",
            "_territory": "MS"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/Puerto_Rico",
            "_territory": "PR"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/Lower_Princes",
            "_territory": "SX"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/Port_of_Spain",
            "_territory": "TT"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/St_Vincent",
            "_territory": "VC"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/Tortola",
            "_territory": "VG"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "America/St_Thomas",
            "_territory": "VI"
          }
        },
        {
          "mapZone": {
            "_other": "SA Western Standard Time",
            "_type": "Etc/GMT+4",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "Saint Pierre Standard Time",
            "_type": "America/Miquelon",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Saint Pierre Standard Time",
            "_type": "America/Miquelon",
            "_territory": "PM"
          }
        },
        {
          "mapZone": {
            "_other": "Sakhalin Standard Time",
            "_type": "Asia/Sakhalin",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Sakhalin Standard Time",
            "_type": "Asia/Sakhalin",
            "_territory": "RU"
          }
        },
        {
          "mapZone": {
            "_other": "Samoa Standard Time",
            "_type": "Pacific/Apia",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Samoa Standard Time",
            "_type": "Pacific/Apia",
            "_territory": "WS"
          }
        },
        {
          "mapZone": {
            "_other": "Sao Tome Standard Time",
            "_type": "Africa/Sao_Tome",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Sao Tome Standard Time",
            "_type": "Africa/Sao_Tome",
            "_territory": "ST"
          }
        },
        {
          "mapZone": {
            "_other": "Saratov Standard Time",
            "_type": "Europe/Saratov",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Saratov Standard Time",
            "_type": "Europe/Saratov",
            "_territory": "RU"
          }
        },
        {
          "mapZone": {
            "_other": "SE Asia Standard Time",
            "_type": "Asia/Bangkok",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "SE Asia Standard Time",
            "_type": "Antarctica/Davis",
            "_territory": "AQ"
          }
        },
        {
          "mapZone": {
            "_other": "SE Asia Standard Time",
            "_type": "Indian/Christmas",
            "_territory": "CX"
          }
        },
        {
          "mapZone": {
            "_other": "SE Asia Standard Time",
            "_type": "Asia/Jakarta Asia/Pontianak",
            "_territory": "ID"
          }
        },
        {
          "mapZone": {
            "_other": "SE Asia Standard Time",
            "_type": "Asia/Phnom_Penh",
            "_territory": "KH"
          }
        },
        {
          "mapZone": {
            "_other": "SE Asia Standard Time",
            "_type": "Asia/Vientiane",
            "_territory": "LA"
          }
        },
        {
          "mapZone": {
            "_other": "SE Asia Standard Time",
            "_type": "Asia/Bangkok",
            "_territory": "TH"
          }
        },
        {
          "mapZone": {
            "_other": "SE Asia Standard Time",
            "_type": "Asia/Saigon",
            "_territory": "VN"
          }
        },
        {
          "mapZone": {
            "_other": "SE Asia Standard Time",
            "_type": "Etc/GMT-7",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "Singapore Standard Time",
            "_type": "Asia/Singapore",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Singapore Standard Time",
            "_type": "Asia/Brunei",
            "_territory": "BN"
          }
        },
        {
          "mapZone": {
            "_other": "Singapore Standard Time",
            "_type": "Asia/Makassar",
            "_territory": "ID"
          }
        },
        {
          "mapZone": {
            "_other": "Singapore Standard Time",
            "_type": "Asia/Kuala_Lumpur Asia/Kuching",
            "_territory": "MY"
          }
        },
        {
          "mapZone": {
            "_other": "Singapore Standard Time",
            "_type": "Asia/Manila",
            "_territory": "PH"
          }
        },
        {
          "mapZone": {
            "_other": "Singapore Standard Time",
            "_type": "Asia/Singapore",
            "_territory": "SG"
          }
        },
        {
          "mapZone": {
            "_other": "Singapore Standard Time",
            "_type": "Etc/GMT-8",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "South Africa Standard Time",
            "_type": "Africa/Johannesburg",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "South Africa Standard Time",
            "_type": "Africa/Bujumbura",
            "_territory": "BI"
          }
        },
        {
          "mapZone": {
            "_other": "South Africa Standard Time",
            "_type": "Africa/Gaborone",
            "_territory": "BW"
          }
        },
        {
          "mapZone": {
            "_other": "South Africa Standard Time",
            "_type": "Africa/Lubumbashi",
            "_territory": "CD"
          }
        },
        {
          "mapZone": {
            "_other": "South Africa Standard Time",
            "_type": "Africa/Maseru",
            "_territory": "LS"
          }
        },
        {
          "mapZone": {
            "_other": "South Africa Standard Time",
            "_type": "Africa/Blantyre",
            "_territory": "MW"
          }
        },
        {
          "mapZone": {
            "_other": "South Africa Standard Time",
            "_type": "Africa/Maputo",
            "_territory": "MZ"
          }
        },
        {
          "mapZone": {
            "_other": "South Africa Standard Time",
            "_type": "Africa/Kigali",
            "_territory": "RW"
          }
        },
        {
          "mapZone": {
            "_other": "South Africa Standard Time",
            "_type": "Africa/Mbabane",
            "_territory": "SZ"
          }
        },
        {
          "mapZone": {
            "_other": "South Africa Standard Time",
            "_type": "Africa/Johannesburg",
            "_territory": "ZA"
          }
        },
        {
          "mapZone": {
            "_other": "South Africa Standard Time",
            "_type": "Africa/Lusaka",
            "_territory": "ZM"
          }
        },
        {
          "mapZone": {
            "_other": "South Africa Standard Time",
            "_type": "Africa/Harare",
            "_territory": "ZW"
          }
        },
        {
          "mapZone": {
            "_other": "South Africa Standard Time",
            "_type": "Etc/GMT-2",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "South Sudan Standard Time",
            "_type": "Africa/Juba",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "South Sudan Standard Time",
            "_type": "Africa/Juba",
            "_territory": "SS"
          }
        },
        {
          "mapZone": {
            "_other": "Sri Lanka Standard Time",
            "_type": "Asia/Colombo",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Sri Lanka Standard Time",
            "_type": "Asia/Colombo",
            "_territory": "LK"
          }
        },
        {
          "mapZone": {
            "_other": "Sudan Standard Time",
            "_type": "Africa/Khartoum",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Sudan Standard Time",
            "_type": "Africa/Khartoum",
            "_territory": "SD"
          }
        },
        {
          "mapZone": {
            "_other": "Syria Standard Time",
            "_type": "Asia/Damascus",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Syria Standard Time",
            "_type": "Asia/Damascus",
            "_territory": "SY"
          }
        },
        {
          "mapZone": {
            "_other": "Taipei Standard Time",
            "_type": "Asia/Taipei",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Taipei Standard Time",
            "_type": "Asia/Taipei",
            "_territory": "TW"
          }
        },
        {
          "mapZone": {
            "_other": "Tasmania Standard Time",
            "_type": "Australia/Hobart",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Tasmania Standard Time",
            "_type": "Australia/Hobart Antarctica/Macquarie",
            "_territory": "AU"
          }
        },
        {
          "mapZone": {
            "_other": "Tocantins Standard Time",
            "_type": "America/Araguaina",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Tocantins Standard Time",
            "_type": "America/Araguaina",
            "_territory": "BR"
          }
        },
        {
          "mapZone": {
            "_other": "Tokyo Standard Time",
            "_type": "Asia/Tokyo",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Tokyo Standard Time",
            "_type": "Asia/Jayapura",
            "_territory": "ID"
          }
        },
        {
          "mapZone": {
            "_other": "Tokyo Standard Time",
            "_type": "Asia/Tokyo",
            "_territory": "JP"
          }
        },
        {
          "mapZone": {
            "_other": "Tokyo Standard Time",
            "_type": "Pacific/Palau",
            "_territory": "PW"
          }
        },
        {
          "mapZone": {
            "_other": "Tokyo Standard Time",
            "_type": "Asia/Dili",
            "_territory": "TL"
          }
        },
        {
          "mapZone": {
            "_other": "Tokyo Standard Time",
            "_type": "Etc/GMT-9",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "Tomsk Standard Time",
            "_type": "Asia/Tomsk",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Tomsk Standard Time",
            "_type": "Asia/Tomsk",
            "_territory": "RU"
          }
        },
        {
          "mapZone": {
            "_other": "Tonga Standard Time",
            "_type": "Pacific/Tongatapu",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Tonga Standard Time",
            "_type": "Pacific/Tongatapu",
            "_territory": "TO"
          }
        },
        {
          "mapZone": {
            "_other": "Transbaikal Standard Time",
            "_type": "Asia/Chita",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Transbaikal Standard Time",
            "_type": "Asia/Chita",
            "_territory": "RU"
          }
        },
        {
          "mapZone": {
            "_other": "Turkey Standard Time",
            "_type": "Europe/Istanbul",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Turkey Standard Time",
            "_type": "Europe/Istanbul",
            "_territory": "TR"
          }
        },
        {
          "mapZone": {
            "_other": "Turks And Caicos Standard Time",
            "_type": "America/Grand_Turk",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Turks And Caicos Standard Time",
            "_type": "America/Grand_Turk",
            "_territory": "TC"
          }
        },
        {
          "mapZone": {
            "_other": "Ulaanbaatar Standard Time",
            "_type": "Asia/Ulaanbaatar",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Ulaanbaatar Standard Time",
            "_type": "Asia/Ulaanbaatar Asia/Choibalsan",
            "_territory": "MN"
          }
        },
        {
          "mapZone": {
            "_other": "US Eastern Standard Time",
            "_type": "America/Indianapolis",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "US Eastern Standard Time",
            "_type":
                "America/Indianapolis America/Indiana/Marengo America/Indiana/Vevay",
            "_territory": "US"
          }
        },
        {
          "mapZone": {
            "_other": "US Mountain Standard Time",
            "_type": "America/Phoenix",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "US Mountain Standard Time",
            "_type": "America/Creston America/Dawson_Creek America/Fort_Nelson",
            "_territory": "CA"
          }
        },
        {
          "mapZone": {
            "_other": "US Mountain Standard Time",
            "_type": "America/Hermosillo",
            "_territory": "MX"
          }
        },
        {
          "mapZone": {
            "_other": "US Mountain Standard Time",
            "_type": "America/Phoenix",
            "_territory": "US"
          }
        },
        {
          "mapZone": {
            "_other": "US Mountain Standard Time",
            "_type": "Etc/GMT+7",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {"_other": "UTC", "_type": "Etc/UTC", "_territory": "001"}
        },
        {
          "mapZone": {
            "_other": "UTC",
            "_type": "Etc/UTC Etc/GMT",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "UTC-02",
            "_type": "Etc/GMT+2",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "UTC-02",
            "_type": "America/Noronha",
            "_territory": "BR"
          }
        },
        {
          "mapZone": {
            "_other": "UTC-02",
            "_type": "Atlantic/South_Georgia",
            "_territory": "GS"
          }
        },
        {
          "mapZone": {
            "_other": "UTC-02",
            "_type": "Etc/GMT+2",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "UTC-08",
            "_type": "Etc/GMT+8",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "UTC-08",
            "_type": "Pacific/Pitcairn",
            "_territory": "PN"
          }
        },
        {
          "mapZone": {
            "_other": "UTC-08",
            "_type": "Etc/GMT+8",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "UTC-09",
            "_type": "Etc/GMT+9",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "UTC-09",
            "_type": "Pacific/Gambier",
            "_territory": "PF"
          }
        },
        {
          "mapZone": {
            "_other": "UTC-09",
            "_type": "Etc/GMT+9",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "UTC-11",
            "_type": "Etc/GMT+11",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "UTC-11",
            "_type": "Pacific/Pago_Pago",
            "_territory": "AS"
          }
        },
        {
          "mapZone": {
            "_other": "UTC-11",
            "_type": "Pacific/Niue",
            "_territory": "NU"
          }
        },
        {
          "mapZone": {
            "_other": "UTC-11",
            "_type": "Pacific/Midway",
            "_territory": "UM"
          }
        },
        {
          "mapZone": {
            "_other": "UTC-11",
            "_type": "Etc/GMT+11",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "UTC+12",
            "_type": "Etc/GMT-12",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "UTC+12",
            "_type": "Pacific/Tarawa",
            "_territory": "KI"
          }
        },
        {
          "mapZone": {
            "_other": "UTC+12",
            "_type": "Pacific/Majuro Pacific/Kwajalein",
            "_territory": "MH"
          }
        },
        {
          "mapZone": {
            "_other": "UTC+12",
            "_type": "Pacific/Nauru",
            "_territory": "NR"
          }
        },
        {
          "mapZone": {
            "_other": "UTC+12",
            "_type": "Pacific/Funafuti",
            "_territory": "TV"
          }
        },
        {
          "mapZone": {
            "_other": "UTC+12",
            "_type": "Pacific/Wake",
            "_territory": "UM"
          }
        },
        {
          "mapZone": {
            "_other": "UTC+12",
            "_type": "Pacific/Wallis",
            "_territory": "WF"
          }
        },
        {
          "mapZone": {
            "_other": "UTC+12",
            "_type": "Etc/GMT-12",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "UTC+13",
            "_type": "Etc/GMT-13",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "UTC+13",
            "_type": "Pacific/Enderbury",
            "_territory": "KI"
          }
        },
        {
          "mapZone": {
            "_other": "UTC+13",
            "_type": "Pacific/Fakaofo",
            "_territory": "TK"
          }
        },
        {
          "mapZone": {
            "_other": "UTC+13",
            "_type": "Etc/GMT-13",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "Venezuela Standard Time",
            "_type": "America/Caracas",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Venezuela Standard Time",
            "_type": "America/Caracas",
            "_territory": "VE"
          }
        },
        {
          "mapZone": {
            "_other": "Vladivostok Standard Time",
            "_type": "Asia/Vladivostok",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Vladivostok Standard Time",
            "_type": "Asia/Vladivostok Asia/Ust-Nera",
            "_territory": "RU"
          }
        },
        {
          "mapZone": {
            "_other": "Volgograd Standard Time",
            "_type": "Europe/Volgograd",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Volgograd Standard Time",
            "_type": "Europe/Volgograd",
            "_territory": "RU"
          }
        },
        {
          "mapZone": {
            "_other": "W. Australia Standard Time",
            "_type": "Australia/Perth",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "W. Australia Standard Time",
            "_type": "Australia/Perth",
            "_territory": "AU"
          }
        },
        {
          "mapZone": {
            "_other": "W. Central Africa Standard Time",
            "_type": "Africa/Lagos",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "W. Central Africa Standard Time",
            "_type": "Africa/Luanda",
            "_territory": "AO"
          }
        },
        {
          "mapZone": {
            "_other": "W. Central Africa Standard Time",
            "_type": "Africa/Porto-Novo",
            "_territory": "BJ"
          }
        },
        {
          "mapZone": {
            "_other": "W. Central Africa Standard Time",
            "_type": "Africa/Kinshasa",
            "_territory": "CD"
          }
        },
        {
          "mapZone": {
            "_other": "W. Central Africa Standard Time",
            "_type": "Africa/Bangui",
            "_territory": "CF"
          }
        },
        {
          "mapZone": {
            "_other": "W. Central Africa Standard Time",
            "_type": "Africa/Brazzaville",
            "_territory": "CG"
          }
        },
        {
          "mapZone": {
            "_other": "W. Central Africa Standard Time",
            "_type": "Africa/Douala",
            "_territory": "CM"
          }
        },
        {
          "mapZone": {
            "_other": "W. Central Africa Standard Time",
            "_type": "Africa/Algiers",
            "_territory": "DZ"
          }
        },
        {
          "mapZone": {
            "_other": "W. Central Africa Standard Time",
            "_type": "Africa/Libreville",
            "_territory": "GA"
          }
        },
        {
          "mapZone": {
            "_other": "W. Central Africa Standard Time",
            "_type": "Africa/Malabo",
            "_territory": "GQ"
          }
        },
        {
          "mapZone": {
            "_other": "W. Central Africa Standard Time",
            "_type": "Africa/Niamey",
            "_territory": "NE"
          }
        },
        {
          "mapZone": {
            "_other": "W. Central Africa Standard Time",
            "_type": "Africa/Lagos",
            "_territory": "NG"
          }
        },
        {
          "mapZone": {
            "_other": "W. Central Africa Standard Time",
            "_type": "Africa/Ndjamena",
            "_territory": "TD"
          }
        },
        {
          "mapZone": {
            "_other": "W. Central Africa Standard Time",
            "_type": "Africa/Tunis",
            "_territory": "TN"
          }
        },
        {
          "mapZone": {
            "_other": "W. Central Africa Standard Time",
            "_type": "Etc/GMT-1",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "W. Europe Standard Time",
            "_type": "Europe/Berlin",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "W. Europe Standard Time",
            "_type": "Europe/Andorra",
            "_territory": "AD"
          }
        },
        {
          "mapZone": {
            "_other": "W. Europe Standard Time",
            "_type": "Europe/Vienna",
            "_territory": "AT"
          }
        },
        {
          "mapZone": {
            "_other": "W. Europe Standard Time",
            "_type": "Europe/Zurich",
            "_territory": "CH"
          }
        },
        {
          "mapZone": {
            "_other": "W. Europe Standard Time",
            "_type": "Europe/Berlin Europe/Busingen",
            "_territory": "DE"
          }
        },
        {
          "mapZone": {
            "_other": "W. Europe Standard Time",
            "_type": "Europe/Gibraltar",
            "_territory": "GI"
          }
        },
        {
          "mapZone": {
            "_other": "W. Europe Standard Time",
            "_type": "Europe/Rome",
            "_territory": "IT"
          }
        },
        {
          "mapZone": {
            "_other": "W. Europe Standard Time",
            "_type": "Europe/Vaduz",
            "_territory": "LI"
          }
        },
        {
          "mapZone": {
            "_other": "W. Europe Standard Time",
            "_type": "Europe/Luxembourg",
            "_territory": "LU"
          }
        },
        {
          "mapZone": {
            "_other": "W. Europe Standard Time",
            "_type": "Europe/Monaco",
            "_territory": "MC"
          }
        },
        {
          "mapZone": {
            "_other": "W. Europe Standard Time",
            "_type": "Europe/Malta",
            "_territory": "MT"
          }
        },
        {
          "mapZone": {
            "_other": "W. Europe Standard Time",
            "_type": "Europe/Amsterdam",
            "_territory": "NL"
          }
        },
        {
          "mapZone": {
            "_other": "W. Europe Standard Time",
            "_type": "Europe/Oslo",
            "_territory": "NO"
          }
        },
        {
          "mapZone": {
            "_other": "W. Europe Standard Time",
            "_type": "Europe/Stockholm",
            "_territory": "SE"
          }
        },
        {
          "mapZone": {
            "_other": "W. Europe Standard Time",
            "_type": "Arctic/Longyearbyen",
            "_territory": "SJ"
          }
        },
        {
          "mapZone": {
            "_other": "W. Europe Standard Time",
            "_type": "Europe/San_Marino",
            "_territory": "SM"
          }
        },
        {
          "mapZone": {
            "_other": "W. Europe Standard Time",
            "_type": "Europe/Vatican",
            "_territory": "VA"
          }
        },
        {
          "mapZone": {
            "_other": "W. Mongolia Standard Time",
            "_type": "Asia/Hovd",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "W. Mongolia Standard Time",
            "_type": "Asia/Hovd",
            "_territory": "MN"
          }
        },
        {
          "mapZone": {
            "_other": "West Asia Standard Time",
            "_type": "Asia/Tashkent",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "West Asia Standard Time",
            "_type": "Antarctica/Mawson",
            "_territory": "AQ"
          }
        },
        {
          "mapZone": {
            "_other": "West Asia Standard Time",
            "_type":
                "Asia/Oral Asia/Almaty Asia/Aqtau Asia/Aqtobe Asia/Atyrau Asia/Qostanay",
            "_territory": "KZ"
          }
        },
        {
          "mapZone": {
            "_other": "West Asia Standard Time",
            "_type": "Indian/Maldives",
            "_territory": "MV"
          }
        },
        {
          "mapZone": {
            "_other": "West Asia Standard Time",
            "_type": "Indian/Kerguelen",
            "_territory": "TF"
          }
        },
        {
          "mapZone": {
            "_other": "West Asia Standard Time",
            "_type": "Asia/Dushanbe",
            "_territory": "TJ"
          }
        },
        {
          "mapZone": {
            "_other": "West Asia Standard Time",
            "_type": "Asia/Ashgabat",
            "_territory": "TM"
          }
        },
        {
          "mapZone": {
            "_other": "West Asia Standard Time",
            "_type": "Asia/Tashkent Asia/Samarkand",
            "_territory": "UZ"
          }
        },
        {
          "mapZone": {
            "_other": "West Asia Standard Time",
            "_type": "Etc/GMT-5",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "West Bank Standard Time",
            "_type": "Asia/Hebron",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "West Bank Standard Time",
            "_type": "Asia/Hebron Asia/Gaza",
            "_territory": "PS"
          }
        },
        {
          "mapZone": {
            "_other": "West Pacific Standard Time",
            "_type": "Pacific/Port_Moresby",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "West Pacific Standard Time",
            "_type": "Antarctica/DumontDUrville",
            "_territory": "AQ"
          }
        },
        {
          "mapZone": {
            "_other": "West Pacific Standard Time",
            "_type": "Pacific/Truk",
            "_territory": "FM"
          }
        },
        {
          "mapZone": {
            "_other": "West Pacific Standard Time",
            "_type": "Pacific/Guam",
            "_territory": "GU"
          }
        },
        {
          "mapZone": {
            "_other": "West Pacific Standard Time",
            "_type": "Pacific/Saipan",
            "_territory": "MP"
          }
        },
        {
          "mapZone": {
            "_other": "West Pacific Standard Time",
            "_type": "Pacific/Port_Moresby",
            "_territory": "PG"
          }
        },
        {
          "mapZone": {
            "_other": "West Pacific Standard Time",
            "_type": "Etc/GMT-10",
            "_territory": "ZZ"
          }
        },
        {
          "mapZone": {
            "_other": "Yakutsk Standard Time",
            "_type": "Asia/Yakutsk",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Yakutsk Standard Time",
            "_type": "Asia/Yakutsk Asia/Khandyga",
            "_territory": "RU"
          }
        },
        {
          "mapZone": {
            "_other": "Yukon Standard Time",
            "_type": "America/Whitehorse",
            "_territory": "001"
          }
        },
        {
          "mapZone": {
            "_other": "Yukon Standard Time",
            "_type": "America/Whitehorse America/Dawson",
            "_territory": "CA"
          }
        }
      ]
    }
  },

  /// These timezone alias mappings are generated from source code
  /// [here](https://raw.githubusercontent.com/unicode-org/cldr-json/2b8ca7d92dd68d06c60bbd74f8ad8436c5e8bddc/cldr-json/cldr-bcp47/bcp47/timezone.json)
  "ianaAlias": {
    "America/Argentina/Buenos_Aires": "America/Buenos_Aires",
    "America/Argentina/Cordoba": "America/Cordoba",
    "America/Rosario": "America/Cordoba",
    "America/Argentina/Catamarca": "America/Catamarca",
    "America/Argentina/ComodRivadavia": "America/Catamarca",
    "America/Argentina/Jujuy": "America/Jujuy",
    "America/Argentina/Mendoza": "America/Mendoza",
    "Pacific/Samoa": "Pacific/Pago_Pago",
    "US/Samoa": "Pacific/Pago_Pago",
    "Australia/South": "Australia/Adelaide",
    "Australia/Yancowinna": "Australia/Broken_Hill",
    "Australia/Queensland": "Australia/Brisbane",
    "Australia/North": "Australia/Darwin",
    "Australia/Tasmania": "Australia/Hobart",
    "Australia/Currie": "Australia/Hobart",
    "Australia/LHI": "Australia/Lord_Howe",
    "Australia/Victoria": "Australia/Melbourne",
    "Australia/West": "Australia/Perth",
    "Australia/ACT": "Australia/Sydney",
    "Australia/Canberra": "Australia/Sydney",
    "Australia/NSW": "Australia/Sydney",
    "Asia/Dacca": "Asia/Dhaka",
    "Brazil/DeNoronha": "America/Noronha",
    "Brazil/West": "America/Manaus",
    "America/Porto_Acre": "America/Rio_Branco",
    "Brazil/Acre": "America/Rio_Branco",
    "Brazil/East": "America/Sao_Paulo",
    "Asia/Thimbu": "Asia/Thimphu",
    "Canada/Mountain": "America/Edmonton",
    "America/Yellowknife": "America/Edmonton",
    "Canada/Atlantic": "America/Halifax",
    "America/Pangnirtung": "America/Iqaluit",
    "Canada/East-Saskatchewan": "America/Regina",
    "Canada/Saskatchewan": "America/Regina",
    "Canada/Newfoundland": "America/St_Johns",
    "America/Montreal": "America/Toronto",
    "Canada/Eastern": "America/Toronto",
    "America/Nipigon": "America/Toronto",
    "America/Thunder_Bay": "America/Toronto",
    "Canada/Pacific": "America/Vancouver",
    "Canada/Central": "America/Winnipeg",
    "America/Rainy_River": "America/Winnipeg",
    "Canada/Yukon": "America/Whitehorse",
    "America/Atikokan": "America/Coral_Harbour",
    "Chile/EasterIsland": "Pacific/Easter",
    "Chile/Continental": "America/Santiago",
    "Asia/Chongqing": "Asia/Shanghai",
    "Asia/Chungking": "Asia/Shanghai",
    "Asia/Harbin": "Asia/Shanghai",
    "PRC": "Asia/Shanghai",
    "Asia/Kashgar": "Asia/Urumqi",
    "Cuba": "America/Havana",
    "Europe/Nicosia": "Asia/Nicosia",
    "Egypt": "Africa/Cairo",
    "Africa/Asmara": "Africa/Asmera",
    "Pacific/Pohnpei": "Pacific/Ponape",
    "Pacific/Chuuk": "Pacific/Truk",
    "Pacific/Yap": "Pacific/Truk",
    "Atlantic/Faroe": "Atlantic/Faeroe",
    "Europe/Belfast": "Europe/London",
    "GB": "Europe/London",
    "GB-Eire": "Europe/London",
    "America/Nuuk": "America/Godthab",
    "Etc/GMT+0": "Etc/GMT",
    "Etc/GMT-0": "Etc/GMT",
    "Etc/GMT0": "Etc/GMT",
    "Etc/Greenwich": "Etc/GMT",
    "GMT": "Etc/GMT",
    "GMT+0": "Etc/GMT",
    "GMT-0": "Etc/GMT",
    "GMT0": "Etc/GMT",
    "Greenwich": "Etc/GMT",
    "Hongkong": "Asia/Hong_Kong",
    "Asia/Ujung_Pandang": "Asia/Makassar",
    "Eire": "Europe/Dublin",
    "Asia/Kolkata": "Asia/Calcutta",
    "Iran": "Asia/Tehran",
    "Iceland": "Atlantic/Reykjavik",
    "Asia/Tel_Aviv": "Asia/Jerusalem",
    "Israel": "Asia/Jerusalem",
    "Jamaica": "America/Jamaica",
    "Japan": "Asia/Tokyo",
    "Pacific/Kanton": "Pacific/Enderbury",
    "ROK": "Asia/Seoul",
    "Libya": "Africa/Tripoli",
    "Europe/Tiraspol": "Europe/Chisinau",
    "Kwajalein": "Pacific/Kwajalein",
    "Africa/Timbuktu": "Africa/Bamako",
    "Asia/Yangon": "Asia/Rangoon",
    "Asia/Ulan_Bator": "Asia/Ulaanbaatar",
    "Asia/Macao": "Asia/Macau",
    "Mexico/General": "America/Mexico_City",
    "Mexico/BajaSur": "America/Mazatlan",
    "America/Ensenada": "America/Tijuana",
    "Mexico/BajaNorte": "America/Tijuana",
    "America/Santa_Isabel": "America/Tijuana",
    "Asia/Kathmandu": "Asia/Katmandu",
    "Antarctica/South_Pole": "Pacific/Auckland",
    "NZ": "Pacific/Auckland",
    "NZ-CHAT": "Pacific/Chatham",
    "Poland": "Europe/Warsaw",
    "Portugal": "Europe/Lisbon",
    "W-SU": "Europe/Moscow",
    "Singapore": "Asia/Singapore",
    "Atlantic/Jan_Mayen": "Arctic/Longyearbyen",
    "Asia/Ashkhabad": "Asia/Ashgabat",
    "Asia/Istanbul": "Europe/Istanbul",
    "Turkey": "Europe/Istanbul",
    "ROC": "Asia/Taipei",
    "Europe/Kyiv": "Europe/Kiev",
    "Europe/Zaporozhye": "Europe/Kiev",
    "Europe/Uzhgorod": "Europe/Kiev",
    "America/Atka": "America/Adak",
    "US/Aleutian": "America/Adak",
    "US/Alaska": "America/Anchorage",
    "US/Central": "America/Chicago",
    "America/Shiprock": "America/Denver",
    "Navajo": "America/Denver",
    "US/Mountain": "America/Denver",
    "US/Michigan": "America/Detroit",
    "US/Hawaii": "Pacific/Honolulu",
    "Pacific/Johnston": "Pacific/Honolulu",
    "America/Fort_Wayne": "America/Indianapolis",
    "America/Indiana/Indianapolis": "America/Indianapolis",
    "US/East-Indiana": "America/Indianapolis",
    "America/Knox_IN": "America/Indiana/Knox",
    "US/Indiana-Starke": "America/Indiana/Knox",
    "US/Pacific": "America/Los_Angeles",
    "US/Pacific-New": "America/Los_Angeles",
    "America/Kentucky/Louisville": "America/Louisville",
    "US/Eastern": "America/New_York",
    "US/Arizona": "America/Phoenix",
    "Etc/UCT": "Etc/UTC",
    "Etc/Universal": "Etc/UTC",
    "Etc/Zulu": "Etc/UTC",
    "UCT": "Etc/UTC",
    "UTC": "Etc/UTC",
    "Universal": "Etc/UTC",
    "Zulu": "Etc/UTC",
    "EST": "Etc/GMT+5",
    "MST": "Etc/GMT+7",
    "HST": "Etc/GMT+10",
    "America/Virgin": "America/St_Thomas",
    "Asia/Ho_Chi_Minh": "Asia/Saigon",
  }
};
