import 'package:flutter/services.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:open_file_android/open_file_android.dart';
import 'package:open_file_platform_interface/src/platform_interface/open_file_platform.dart';

void main() {
  TestWidgetsFlutterBinding.ensureInitialized();

  late OpenFileAndroid openFile;
  late List<MethodCall> log;
  late dynamic returnValue;

  setUp(() {
    returnValue = '';
    openFile = OpenFileAndroid();
    log = <MethodCall>[];
    log.clear();
  });

  test('registers instance', () async {
    OpenFileAndroid.registerWith();
    expect(OpenFilePlatform.platform, isA<OpenFileAndroid>());
  });

  test('open', () async {
    const String fakePath = '/foo.jpg';
    final openResult = await openFile.open(fakePath);
    expect(openResult.type, fakePath);
  });
}
