package io.github.drumber.kitsune.ui.adapter.paging

import androidx.recyclerview.widget.DiffUtil
import com.bumptech.glide.RequestManager
import io.github.drumber.kitsune.data.presentation.model.media.Anime
import io.github.drumber.kitsune.ui.adapter.OnItemClickListener

class AnimeAdapter(glide: RequestManager, listener: OnItemClickListener<Anime>? = null) :
    MediaPagingAdapter<Anime>(AnimeComparator, glide, listener) {

    object AnimeComparator: DiffUtil.ItemCallback<Anime>() {
        override fun areItemsTheSame(oldItem: Anime, newItem: Anime) = oldItem.id == newItem.id

        override fun areContentsTheSame(oldItem: Anime, newItem: Anime) = oldItem == newItem
    }

}