# Contributing to Kitsune
Thank you for your interest in contributing to Kitsune! Any support is greatly appreciated.

## Ways to Contribute
Any contributions are welcomed, including but not limited to:

### 1. Code Contributions
  - Check out the [open issues](https://github.com/Drumber/Kitsune/issues) or the [project board](https://github.com/users/Drumber/projects/2) and pick one to work on.
  - See [How to Contribute Code Changes](#how-to-contribute-code-changes) to get started.
  - Submit a pull request with your changes.

### 2. Image assets and Logos
Interested in making Kitsune more visually appealing?
Don't hesitate to open a [new issue](https://github.com/Drumber/Kitsune/issues/new/choose) or [discussion](https://github.com/Drumber/Kitsune/discussions/new/choose) if you want to create:
  - custom placeholder images for media and user banners, posters or character photos
  - a new app icon
  - or any other design contribution.

### 3. Translation
  - Contribute translations for different languages to make the app accessible globally.
  - Copy the [string.xml](app/src/main/res/values/strings.xml) file to a new folder named `values-LANG` (e.g. `values-fr` for French) inside the [res](app/src/main/res) directory.
    - Remove strings with `translatable="false"`.
    - Keep placeholders like `%s` or `%d` in the strings.
  - Submit a pull request with your changes.

### 4. Documentation and Repository Files
  - Improve the documentation or contribute to other repository files, like issue templates.

## How to Contribute Code Changes
To start developing, follow these simple steps:

1. **Set Up Your Environment:**
  - Make sure you have [Android Studio](https://developer.android.com/studio) installed.
  - Familiarize yourself with [Kotlin](https://kotlinlang.org/) as it's the primary language used in the app.

2. **Clone the Repository**

3. **Build and Run:**
  - Open the project in Android Studio.
  - Build and run the app to ensure everything is set up correctly.
