package xyz.aprildown.timer.component.key

import android.content.Context
import android.text.InputType
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import android.view.inputmethod.EditorInfo
import android.widget.EditText
import android.widget.TextView
import androidx.annotation.StringRes
import androidx.appcompat.app.AlertDialog
import androidx.core.view.updateLayoutParams
import com.github.deweyreed.tools.anko.dp
import com.github.deweyreed.tools.helper.gone
import com.github.deweyreed.tools.helper.onImeActionClick
import com.google.android.material.dialog.MaterialAlertDialogBuilder
import xyz.aprildown.timer.app.base.R as RBase

class SimpleInputDialog(
    private val context: Context
) {
    fun show(
        title: CharSequence? = null,
        @StringRes titleRes: Int = 0,

        preFill: CharSequence? = null,
        inputType: Int = InputType.TYPE_CLASS_TEXT,
        hint: String? = null,

        message: CharSequence? = null,
        @StringRes messageRes: Int = 0,

        onInput: (String) -> Unit
    ) {
        val builder = MaterialAlertDialogBuilder(context)
            .setPositiveButton(RBase.string.ok, null)
            .setNegativeButton(RBase.string.cancel, null)

        var topSpace = 0
        when {
            title != null -> {
                builder.setTitle(title)
            }
            titleRes != 0 -> {
                builder.setTitle(titleRes)
            }
            else -> {
                topSpace = context.dp(16).toInt()
            }
        }

        val view = View.inflate(context, R.layout.dialog_simple_input, null) as ViewGroup
        val edit = view.getChildAt(0) as EditText
        val textView = view.getChildAt(1) as TextView
        edit.requestFocus()

        builder.setView(view)

        val dialog = builder.create()
        dialog.window?.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_VISIBLE)
        dialog.show()
        dialog.setOnDismissListener {
            dialog.window?.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN)
        }

        val positiveButton = dialog.getButton(AlertDialog.BUTTON_POSITIVE)
        edit.onImeActionClick(EditorInfo.IME_ACTION_DONE) {
            positiveButton.performClick()
        }

        if (!preFill.isNullOrBlank()) {
            edit.setText(preFill)
            edit.post { edit.selectAll() }
        }
        if (hint != null) {
            edit.hint = hint
        }
        edit.inputType = edit.inputType or inputType
        if (topSpace > 0) {
            edit.updateLayoutParams<ViewGroup.MarginLayoutParams> {
                topMargin = topSpace
            }
        }

        if (message == null && messageRes == 0) {
            textView.gone()
        } else {
            textView.text = message ?: context.getString(messageRes)
        }

        positiveButton.setOnClickListener {
            onInput.invoke(edit.text.toString())
            dialog.dismiss()
        }
    }
}
