package io.github.chrisimx.scanbridge

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val BaselineHelp24: ImageVector
    get() {
        if (_BaselineHelp24 != null) {
            return _BaselineHelp24!!
        }
        _BaselineHelp24 = ImageVector.Builder(
            name = "BaselineHelp24",
            defaultWidth = 24.dp,
            defaultHeight = 24.dp,
            viewportWidth = 24f,
            viewportHeight = 24f,
            autoMirror = true
        ).apply {
            path(fill = SolidColor(Color.Black)) {
                moveTo(12f, 2f)
                curveTo(6.48f, 2f, 2f, 6.48f, 2f, 12f)
                reflectiveCurveToRelative(4.48f, 10f, 10f, 10f)
                reflectiveCurveToRelative(10f, -4.48f, 10f, -10f)
                reflectiveCurveTo(17.52f, 2f, 12f, 2f)
                close()
                moveTo(13f, 19f)
                horizontalLineToRelative(-2f)
                verticalLineToRelative(-2f)
                horizontalLineToRelative(2f)
                verticalLineToRelative(2f)
                close()
                moveTo(15.07f, 11.25f)
                lineToRelative(-0.9f, 0.92f)
                curveTo(13.45f, 12.9f, 13f, 13.5f, 13f, 15f)
                horizontalLineToRelative(-2f)
                verticalLineToRelative(-0.5f)
                curveToRelative(0f, -1.1f, 0.45f, -2.1f, 1.17f, -2.83f)
                lineToRelative(1.24f, -1.26f)
                curveToRelative(0.37f, -0.36f, 0.59f, -0.86f, 0.59f, -1.41f)
                curveToRelative(0f, -1.1f, -0.9f, -2f, -2f, -2f)
                reflectiveCurveToRelative(-2f, 0.9f, -2f, 2f)
                lineTo(8f, 9f)
                curveToRelative(0f, -2.21f, 1.79f, -4f, 4f, -4f)
                reflectiveCurveToRelative(4f, 1.79f, 4f, 4f)
                curveToRelative(0f, 0.88f, -0.36f, 1.68f, -0.93f, 2.25f)
                close()
            }
        }.build()

        return _BaselineHelp24!!
    }

val OutlineHelp24: ImageVector
    get() {
        if (_OutlineHelp24 != null) {
            return _OutlineHelp24!!
        }
        _OutlineHelp24 = ImageVector.Builder(
            name = "OutlineHelp24",
            defaultWidth = 24.dp,
            defaultHeight = 24.dp,
            viewportWidth = 960f,
            viewportHeight = 960f,
            autoMirror = true
        ).apply {
            path(fill = SolidColor(Color.Black)) {
                moveTo(478f, 720f)
                quadTo(499f, 720f, 513.5f, 705.5f)
                quadTo(528f, 691f, 528f, 670f)
                quadTo(528f, 649f, 513.5f, 634.5f)
                quadTo(499f, 620f, 478f, 620f)
                quadTo(457f, 620f, 442.5f, 634.5f)
                quadTo(428f, 649f, 428f, 670f)
                quadTo(428f, 691f, 442.5f, 705.5f)
                quadTo(457f, 720f, 478f, 720f)
                close()
                moveTo(442f, 566f)
                lineTo(516f, 566f)
                quadTo(516f, 533f, 523.5f, 514f)
                quadTo(531f, 495f, 566f, 462f)
                quadTo(592f, 436f, 607f, 412.5f)
                quadTo(622f, 389f, 622f, 356f)
                quadTo(622f, 300f, 581f, 270f)
                quadTo(540f, 240f, 484f, 240f)
                quadTo(427f, 240f, 391.5f, 270f)
                quadTo(356f, 300f, 342f, 342f)
                lineTo(408f, 368f)
                quadTo(413f, 350f, 430.5f, 329f)
                quadTo(448f, 308f, 484f, 308f)
                quadTo(516f, 308f, 532f, 325.5f)
                quadTo(548f, 343f, 548f, 364f)
                quadTo(548f, 384f, 536f, 401.5f)
                quadTo(524f, 419f, 506f, 434f)
                quadTo(462f, 473f, 452f, 493f)
                quadTo(442f, 513f, 442f, 566f)
                close()
                moveTo(480f, 880f)
                quadTo(397f, 880f, 324f, 848.5f)
                quadTo(251f, 817f, 197f, 763f)
                quadTo(143f, 709f, 111.5f, 636f)
                quadTo(80f, 563f, 80f, 480f)
                quadTo(80f, 397f, 111.5f, 324f)
                quadTo(143f, 251f, 197f, 197f)
                quadTo(251f, 143f, 324f, 111.5f)
                quadTo(397f, 80f, 480f, 80f)
                quadTo(563f, 80f, 636f, 111.5f)
                quadTo(709f, 143f, 763f, 197f)
                quadTo(817f, 251f, 848.5f, 324f)
                quadTo(880f, 397f, 880f, 480f)
                quadTo(880f, 563f, 848.5f, 636f)
                quadTo(817f, 709f, 763f, 763f)
                quadTo(709f, 817f, 636f, 848.5f)
                quadTo(563f, 880f, 480f, 880f)
                close()
                moveTo(480f, 800f)
                quadTo(614f, 800f, 707f, 707f)
                quadTo(800f, 614f, 800f, 480f)
                quadTo(800f, 346f, 707f, 253f)
                quadTo(614f, 160f, 480f, 160f)
                quadTo(346f, 160f, 253f, 253f)
                quadTo(160f, 346f, 160f, 480f)
                quadTo(160f, 614f, 253f, 707f)
                quadTo(346f, 800f, 480f, 800f)
                close()
                moveTo(480f, 480f)
                quadTo(480f, 480f, 480f, 480f)
                quadTo(480f, 480f, 480f, 480f)
                quadTo(480f, 480f, 480f, 480f)
                quadTo(480f, 480f, 480f, 480f)
                quadTo(480f, 480f, 480f, 480f)
                quadTo(480f, 480f, 480f, 480f)
                quadTo(480f, 480f, 480f, 480f)
                quadTo(480f, 480f, 480f, 480f)
                close()
            }
        }.build()

        return _OutlineHelp24!!
    }

@Suppress("ObjectPropertyName")
private var _OutlineHelp24: ImageVector? = null

@Suppress("ObjectPropertyName")
private var _BaselineHelp24: ImageVector? = null
