/**
 * @license
 * Copyright Akveo. All Rights Reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 */
import React from 'react';
import { ViewProps } from 'react-native';
import { EvaProp, StyleType } from '../../theme';
import { CalendarPickerCellProps } from './components/picker/calendarPickerCell.component';
import { CalendarDateInfo, CalendarViewMode, CalendarViewModeId } from './type';
import { DateService } from './service/date.service';
import { CalendarDataService, DateBatch } from './service/calendarData.service';
export interface BaseCalendarProps<D = Date> extends ViewProps {
    min?: D;
    max?: D;
    initialVisibleDate?: D;
    dateService?: DateService<D>;
    boundingMonth?: boolean;
    startView?: CalendarViewMode;
    title?: (datePickerDate: D, monthYearPickerDate: D, viewMode: CalendarViewMode) => string;
    filter?: (date: D) => boolean;
    renderFooter?: () => React.ReactElement;
    renderDay?: (info: CalendarDateInfo<D>, style: StyleType) => React.ReactElement;
    renderMonth?: (info: CalendarDateInfo<D>, style: StyleType) => React.ReactElement;
    renderYear?: (info: CalendarDateInfo<D>, style: StyleType) => React.ReactElement;
    renderArrowLeft?: React.ComponentType<{
        onPress: () => void;
    }> | null;
    renderArrowRight?: React.ComponentType<{
        onPress: () => void;
    }> | null;
    onVisibleDateChange?: (date: D, viewModeId: CalendarViewModeId) => void;
    eva?: EvaProp;
}
export type BaseCalendarElement<D> = React.ReactElement<BaseCalendarProps<D>>;
interface State<D> {
    viewMode: CalendarViewMode;
    visibleDate: D;
    pickerDate: D;
}
export declare abstract class BaseCalendarComponent<P, D = Date> extends React.Component<BaseCalendarProps<D> & P, State<D>> {
    static defaultProps: Partial<BaseCalendarProps>;
    state: State<D>;
    protected dataService: CalendarDataService<D>;
    protected get dateService(): DateService<D>;
    private get min();
    private get max();
    scrollToToday: () => void;
    scrollToDate: (date: D) => void;
    getCalendarStyle: (source: StyleType) => StyleType;
    isDayDisabled: ({ date }: CalendarDateInfo<D>) => boolean;
    isDayToday: ({ date }: CalendarDateInfo<D>) => boolean;
    protected abstract createDates(date: D): DateBatch<D>;
    protected abstract selectedDate(): D | undefined;
    protected abstract onDateSelect(item: D): void;
    protected abstract isDateSelected(date: D): boolean;
    protected abstract shouldUpdateDate(props: CalendarPickerCellProps<D>, nextProps: CalendarPickerCellProps<D>): boolean;
    private initialVisibleDate;
    private onDaySelect;
    private onMonthSelect;
    private onYearSelect;
    private onPickerNavigationPress;
    private onHeaderNavigationLeftPress;
    private onHeaderNavigationRightPress;
    private getWeekdayStyle;
    private isDaySelected;
    private isMonthSelected;
    private isYearSelected;
    private isMonthDisabled;
    private isYearDisabled;
    private isMonthToday;
    private isYearToday;
    private isHeaderNavigationAllowed;
    private createViewModeVisibleDate;
    private createViewModeHeaderTitle;
    private renderDayIfNeeded;
    private renderWeekdayElement;
    private renderDayElement;
    private renderMonthElement;
    private renderYearElement;
    private renderDayPickerElement;
    private renderMonthPickerElement;
    private renderYearPickerElement;
    private renderPickerElement;
    private renderFooterElement;
    private renderHeaderElement;
    render(): React.ReactElement<ViewProps>;
}
export {};
