"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const service_1 = require("../../service");
class MetaProcessor {
    process(params) {
        const { mapping, meta, theme } = params;
        const strictTheme = this.processStrictTheme(theme || {});
        const entries = meta.reduce((acc, controlMeta) => {
            const { name, appearance, variants, states } = controlMeta;
            const nextAppearanceEntries = service_1.createAllStyles(mapping, name, appearance, variants, states, strictTheme);
            const prevAppearanceStyles = acc[name];
            const nextAppearanceStyles = service_1.toObject(nextAppearanceEntries);
            return Object.assign(Object.assign({}, acc), { [name]: Object.assign(Object.assign({}, prevAppearanceStyles), nextAppearanceStyles) });
        }, {});
        return this.withControlMeta(mapping, entries);
    }
    processStrictTheme(theme) {
        return Object.keys(theme).reduce((acc, key) => {
            return Object.assign(Object.assign({}, acc), { [key]: this.getStrictThemeValue(key, theme, key) });
        }, {});
    }
    getStrictThemeValue(name, theme, fallback) {
        const key = this.isReference(name) ? this.createKeyFromReference(name) : name;
        const value = this.findValue(key, theme);
        return service_1.isNil(value) ? fallback : value;
    }
    findValue(name, theme) {
        const value = theme[name];
        if (this.isReference(value)) {
            const themeKey = this.createKeyFromReference(value);
            return this.findValue(themeKey, theme);
        }
        return value;
    }
    isReference(value) {
        return `${value}`.startsWith('$');
    }
    createKeyFromReference(value) {
        return `${value}`.substring(1);
    }
    withControlMeta(mapping, style) {
        return Object.keys(style).reduce((acc, control) => {
            const controlEntry = {
                meta: mapping[control].meta,
                styles: style[control],
            };
            return Object.assign(Object.assign({}, acc), { [control]: controlEntry });
        }, {});
    }
}
exports.MetaProcessor = MetaProcessor;
//# sourceMappingURL=metaProcessor.js.map