"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = __importDefault(require("path"));
const ajv_1 = __importDefault(require("ajv"));
const lodash_merge_1 = __importDefault(require("lodash.merge"));
const fs_1 = require("fs");
const rimraf_1 = __importDefault(require("rimraf"));
const generate_1 = require("./generate");
const packages = process.argv.splice(2);
if (packages.length !== 2) {
    console.error(`
    Invalid arguments.
    Please specify source mapping name and customization mapping path.
  `);
    process.exit(1);
}
const currentDir = process.cwd();
const packagesDir = path_1.default.resolve(currentDir, 'packages');
const dssDir = path_1.default.resolve(currentDir, 'packages/dss');
function customize(source, destination) {
    return lodash_merge_1.default(source, destination);
}
exports.customize = customize;
const json = (input) => JSON.stringify(input, null, 2);
const { [0]: sourcePackageName, [1]: customMappingDerivedPath, } = packages;
const sourcePackagePath = path_1.default.resolve(packagesDir, sourcePackageName);
const customMappingPath = path_1.default.resolve(customMappingDerivedPath);
const customMappingName = path_1.default.basename(customMappingDerivedPath);
const customizedPackagePath = path_1.default.resolve(packagesDir, `${sourcePackageName}-${customMappingName}`);
const { mapping: sourceMapping } = require(sourcePackagePath);
// TODO: resolve custom mapping
const customMapping = require(customMappingPath);
const customizationSchema = require(path_1.default.resolve(dssDir, 'schema/schema-customization.json'));
const validationOptions = {
    allErrors: true,
};
const ajv = new ajv_1.default(validationOptions);
const validate = ajv.compile(customizationSchema);
const fitsSchema = validate(customMapping);
if (!fitsSchema) {
    const errors = validate.errors.map((error) => {
        return error.message;
    });
    const errorMessage = errors.join('\n*');
    console.error(`Please be advised to fix following errors:\n ${errorMessage}\n`);
    process.exit(1);
}
const mapping = customize(sourceMapping, customMapping);
const customizedPackageIndexPath = path_1.default.resolve(customizedPackagePath, 'index.ts');
const customizedPackageMappingPath = path_1.default.resolve(customizedPackagePath, 'mapping.json');
if (!fs_1.existsSync(customizedPackagePath)) {
    fs_1.mkdirSync(customizedPackagePath);
}
const indexOutput = [
    'export const mapping = require(\'./mapping.json\');',
].join('\n\n');
const mappingOutput = json(mapping);
fs_1.writeFileSync(customizedPackageIndexPath, indexOutput);
fs_1.writeFileSync(customizedPackageMappingPath, mappingOutput);
generate_1.generateMappingPackage(customizedPackageIndexPath);
rimraf_1.default.sync(customizedPackagePath);
//# sourceMappingURL=customize.js.map