/*
 * Decompiled with CFR 0.152.
 */
package org.jared.commons.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import info.staticfree.android.utils.MotionEventWrapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WorkspaceView
extends ViewGroup {
    private static final String TAG = WorkspaceView.class.getSimpleName();
    private static final int INVALID_SCREEN = -1;
    private static final int SNAP_VELOCITY = 600;
    private int mDefaultScreen = 0;
    private boolean mFirstLayout = true;
    private int mCurrentScreen;
    private int mNextScreen = -1;
    private Scroller mScroller;
    private VelocityTracker mVelocityTracker;
    private float mLastMotionX;
    private float mLastMotionY;
    private static final int TOUCH_STATE_REST = 0;
    private static final int TOUCH_STATE_SCROLLING = 1;
    private int mTouchState = 0;
    private View.OnLongClickListener mLongClickListener;
    private boolean mAllowLongPress = true;
    private int mTouchSlop;
    private int mMaximumVelocity;
    private static final int INVALID_POINTER = -1;
    private int mActivePointerId = -1;
    private static final float NANOTIME_DIV = 1.0E9f;
    private static final float SMOOTHING_SPEED = 0.75f;
    private static final float SMOOTHING_CONSTANT = (float)(0.016 / Math.log(0.75));
    private float mSmoothingTime;
    private float mTouchX;
    private WorkspaceOvershootInterpolator mScrollInterpolator;
    private static final float BASELINE_FLING_VELOCITY = 2500.0f;
    private static final float FLING_VELOCITY_INFLUENCE = 0.4f;

    public WorkspaceView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WorkspaceView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setHapticFeedbackEnabled(false);
        this.initWorkspace();
    }

    private void initWorkspace() {
        Context context = this.getContext();
        this.mScrollInterpolator = new WorkspaceOvershootInterpolator();
        this.mScroller = new Scroller(context, (Interpolator)this.mScrollInterpolator);
        this.mCurrentScreen = this.mDefaultScreen;
        ViewConfiguration configuration = ViewConfiguration.get((Context)this.getContext());
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
    }

    public void setTouchSlop(int touchSlopP) {
        this.mTouchSlop = touchSlopP;
    }

    boolean isDefaultScreenShowing() {
        return this.mCurrentScreen == this.mDefaultScreen;
    }

    int getCurrentScreen() {
        return this.mCurrentScreen;
    }

    void setCurrentScreen(int currentScreen) {
        if (!this.mScroller.isFinished()) {
            this.mScroller.abortAnimation();
        }
        this.mCurrentScreen = Math.max(0, Math.min(currentScreen, this.getChildCount() - 1));
        this.scrollTo(this.mCurrentScreen * this.getWidth(), 0);
        this.invalidate();
    }

    public void setOnLongClickListener(View.OnLongClickListener l) {
        this.mLongClickListener = l;
        int count = this.getChildCount();
        int i = 0;
        while (i < count) {
            this.getChildAt(i).setOnLongClickListener(l);
            ++i;
        }
    }

    public void scrollTo(int x, int y) {
        super.scrollTo(x, y);
        this.mTouchX = x;
        this.mSmoothingTime = (float)System.nanoTime() / 1.0E9f;
    }

    public void computeScroll() {
        int mScrollX = this.getScrollX();
        int mScrollY = this.getScrollY();
        if (this.mScroller.computeScrollOffset()) {
            mScrollX = this.mScroller.getCurrX();
            this.mTouchX = mScrollX;
            this.mSmoothingTime = (float)System.nanoTime() / 1.0E9f;
            mScrollY = this.mScroller.getCurrY();
            this.scrollTo(mScrollX, mScrollY);
            this.postInvalidate();
        } else if (this.mNextScreen != -1) {
            this.mCurrentScreen = Math.max(0, Math.min(this.mNextScreen, this.getChildCount() - 1));
            this.mNextScreen = -1;
            this.clearChildrenCache();
        } else if (this.mTouchState == 1) {
            float now = (float)System.nanoTime() / 1.0E9f;
            float e = (float)Math.exp((now - this.mSmoothingTime) / SMOOTHING_CONSTANT);
            float dx = this.mTouchX - (float)mScrollX;
            mScrollX = (int)((float)mScrollX + dx * e);
            this.mSmoothingTime = now;
            if (dx > 1.0f || dx < -1.0f) {
                this.postInvalidate();
            }
            this.scrollTo(mScrollX, mScrollY);
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        boolean fastDraw;
        boolean restore = false;
        int restoreCount = 0;
        boolean bl = fastDraw = this.mTouchState != 1 && this.mNextScreen == -1;
        if (fastDraw) {
            this.drawChild(canvas, this.getChildAt(this.mCurrentScreen), this.getDrawingTime());
        } else {
            long drawingTime = this.getDrawingTime();
            float scrollPos = (float)this.getScrollX() / (float)this.getWidth();
            int leftScreen = (int)scrollPos;
            int rightScreen = leftScreen + 1;
            if (leftScreen >= 0) {
                this.drawChild(canvas, this.getChildAt(leftScreen), drawingTime);
            }
            if (scrollPos != (float)leftScreen && rightScreen < this.getChildCount()) {
                this.drawChild(canvas, this.getChildAt(rightScreen), drawingTime);
            }
        }
        if (restore) {
            canvas.restoreToCount(restoreCount);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.computeScroll();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        if (widthMode != 0x40000000) {
            throw new IllegalStateException("Workspace can only be used in EXACTLY mode.");
        }
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (heightMode != 0x40000000) {
            throw new IllegalStateException("Workspace can only be used in EXACTLY mode.");
        }
        int count = this.getChildCount();
        int i = 0;
        while (i < count) {
            this.getChildAt(i).measure(widthMeasureSpec, heightMeasureSpec);
            ++i;
        }
        if (this.mFirstLayout) {
            this.setHorizontalScrollBarEnabled(false);
            this.scrollTo(this.mCurrentScreen * width, 0);
            this.setHorizontalScrollBarEnabled(true);
            this.mFirstLayout = false;
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int childLeft = 0;
        int count = this.getChildCount();
        int i = 0;
        while (i < count) {
            View child = this.getChildAt(i);
            if (child.getVisibility() != 8) {
                int childWidth = child.getMeasuredWidth();
                child.layout(childLeft, 0, childLeft + childWidth, child.getMeasuredHeight());
                childLeft += childWidth;
            }
            ++i;
        }
    }

    public boolean requestChildRectangleOnScreen(View child, Rect rectangle, boolean immediate) {
        int screen = this.indexOfChild(child);
        if (screen != this.mCurrentScreen || !this.mScroller.isFinished()) {
            this.snapToScreen(screen);
            return true;
        }
        return false;
    }

    public boolean dispatchUnhandledMove(View focused, int direction) {
        if (direction == 17) {
            if (this.getCurrentScreen() > 0) {
                this.snapToScreen(this.getCurrentScreen() - 1);
                return true;
            }
        } else if (direction == 66 && this.getCurrentScreen() < this.getChildCount() - 1) {
            this.snapToScreen(this.getCurrentScreen() + 1);
            return true;
        }
        return super.dispatchUnhandledMove(focused, direction);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (action == 2 && this.mTouchState != 0) {
            return true;
        }
        this.acquireVelocityTrackerAndAddMovement(ev);
        switch (action & 0xFF) {
            case 2: {
                boolean yMoved;
                int pointerIndex = MotionEventWrapper.findPointerIndex(ev, this.mActivePointerId);
                float x = MotionEventWrapper.getX(ev, pointerIndex);
                float y = MotionEventWrapper.getY(ev, pointerIndex);
                int xDiff = (int)Math.abs(x - this.mLastMotionX);
                int yDiff = (int)Math.abs(y - this.mLastMotionY);
                int touchSlop = this.mTouchSlop;
                boolean xMoved = xDiff > touchSlop;
                boolean bl = yMoved = yDiff > touchSlop;
                if (!xMoved && !yMoved) break;
                if (xMoved) {
                    this.mTouchState = 1;
                    this.mLastMotionX = x;
                    this.mTouchX = this.getScrollX();
                    this.mSmoothingTime = (float)System.nanoTime() / 1.0E9f;
                    this.enableChildrenCache(this.mCurrentScreen - 1, this.mCurrentScreen + 1);
                }
                if (!this.mAllowLongPress) break;
                this.mAllowLongPress = false;
                View currentScreen = this.getChildAt(this.mCurrentScreen);
                currentScreen.cancelLongPress();
                break;
            }
            case 0: {
                float x = ev.getX();
                float y = ev.getY();
                this.mLastMotionX = x;
                this.mLastMotionY = y;
                this.mActivePointerId = MotionEventWrapper.getPointerId(ev, 0);
                this.mAllowLongPress = true;
                this.mTouchState = this.mScroller.isFinished() ? 0 : 1;
                break;
            }
            case 1: 
            case 3: {
                this.clearChildrenCache();
                this.mTouchState = 0;
                this.mActivePointerId = -1;
                this.mAllowLongPress = false;
                this.releaseVelocityTracker();
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        return this.mTouchState != 0;
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = (ev.getAction() & 0xFF00) >> 8;
        int pointerId = MotionEventWrapper.getPointerId(ev, pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mLastMotionX = MotionEventWrapper.getX(ev, newPointerIndex);
            this.mLastMotionY = MotionEventWrapper.getY(ev, newPointerIndex);
            this.mActivePointerId = MotionEventWrapper.getPointerId(ev, newPointerIndex);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    public void focusableViewAvailable(View focused) {
        View current = this.getChildAt(this.mCurrentScreen);
        View v = focused;
        while (true) {
            if (v == current) {
                super.focusableViewAvailable(focused);
                return;
            }
            if (v == this) {
                return;
            }
            ViewParent parent = v.getParent();
            if (!(parent instanceof View)) break;
            v = (View)v.getParent();
        }
    }

    void enableChildrenCache(int fromScreen, int toScreen) {
        if (fromScreen > toScreen) {
            int temp = fromScreen;
            fromScreen = toScreen;
            toScreen = temp;
        }
        int count = this.getChildCount();
        fromScreen = Math.max(fromScreen, 0);
        toScreen = Math.min(toScreen, count - 1);
        int i = fromScreen;
        while (i <= toScreen) {
            View layout = this.getChildAt(i);
            layout.setDrawingCacheEnabled(true);
            ++i;
        }
    }

    void clearChildrenCache() {
        int count = this.getChildCount();
        int i = 0;
        while (i < count) {
            View layout = this.getChildAt(i);
            layout.setDrawingCacheEnabled(false);
            ++i;
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        int mScrollX = this.getScrollX();
        this.acquireVelocityTrackerAndAddMovement(ev);
        int action = ev.getAction();
        switch (action & 0xFF) {
            case 0: {
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                }
                this.mLastMotionX = ev.getX();
                this.mActivePointerId = MotionEventWrapper.getPointerId(ev, 0);
                if (this.mTouchState != 1) break;
                this.enableChildrenCache(this.mCurrentScreen - 1, this.mCurrentScreen + 1);
                break;
            }
            case 2: {
                if (this.mTouchState != 1) break;
                int pointerIndex = MotionEventWrapper.findPointerIndex(ev, this.mActivePointerId);
                float x = MotionEventWrapper.getX(ev, pointerIndex);
                float deltaX = this.mLastMotionX - x;
                this.mLastMotionX = x;
                if (deltaX < 0.0f) {
                    if (!(this.mTouchX > 0.0f)) break;
                    this.mTouchX += Math.max(-this.mTouchX, deltaX);
                    this.mSmoothingTime = (float)System.nanoTime() / 1.0E9f;
                    this.invalidate();
                    break;
                }
                if (deltaX > 0.0f) {
                    float availableToScroll = (float)this.getChildAt(this.getChildCount() - 1).getRight() - this.mTouchX - (float)this.getWidth();
                    if (!(availableToScroll > 0.0f)) break;
                    this.mTouchX += Math.min(availableToScroll, deltaX);
                    this.mSmoothingTime = (float)System.nanoTime() / 1.0E9f;
                    this.invalidate();
                    break;
                }
                this.awakenScrollBars();
                break;
            }
            case 1: {
                if (this.mTouchState == 1) {
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                    int velocityX = (int)velocityTracker.getXVelocity();
                    int screenWidth = this.getWidth();
                    int whichScreen = (mScrollX + screenWidth / 2) / screenWidth;
                    float scrolledPos = (float)mScrollX / (float)screenWidth;
                    if (velocityX > 600 && this.mCurrentScreen > 0) {
                        int bound = scrolledPos < (float)whichScreen ? this.mCurrentScreen - 1 : this.mCurrentScreen;
                        this.snapToScreen(Math.min(whichScreen, bound), velocityX, true);
                    } else if (velocityX < -600 && this.mCurrentScreen < this.getChildCount() - 1) {
                        int bound = scrolledPos > (float)whichScreen ? this.mCurrentScreen + 1 : this.mCurrentScreen;
                        this.snapToScreen(Math.max(whichScreen, bound), velocityX, true);
                    } else {
                        this.snapToScreen(whichScreen, 0, true);
                    }
                }
                this.mTouchState = 0;
                this.mActivePointerId = -1;
                this.releaseVelocityTracker();
                break;
            }
            case 3: {
                if (this.mTouchState == 1) {
                    int screenWidth = this.getWidth();
                    int whichScreen = (mScrollX + screenWidth / 2) / screenWidth;
                    this.snapToScreen(whichScreen, 0, true);
                }
                this.mTouchState = 0;
                this.mActivePointerId = -1;
                this.releaseVelocityTracker();
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        return true;
    }

    private void acquireVelocityTrackerAndAddMovement(MotionEvent ev) {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
    }

    private void releaseVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    void snapToScreen(int whichScreen) {
        this.snapToScreen(whichScreen, 0, false);
    }

    private void snapToScreen(int whichScreen, int velocity, boolean settle) {
        int mScrollX = this.getScrollX();
        if (this.mCurrentScreen == whichScreen && mScrollX == this.getLeft()) {
            return;
        }
        whichScreen = Math.max(0, Math.min(whichScreen, this.getChildCount() - 1));
        this.enableChildrenCache(this.mCurrentScreen, whichScreen);
        this.mNextScreen = whichScreen;
        View focusedChild = this.getFocusedChild();
        if (focusedChild != null && whichScreen != this.mCurrentScreen && focusedChild == this.getChildAt(this.mCurrentScreen)) {
            focusedChild.clearFocus();
        }
        int screenDelta = Math.max(1, Math.abs(whichScreen - this.mCurrentScreen));
        int newX = whichScreen * this.getWidth();
        int delta = newX - mScrollX;
        int duration = (screenDelta + 1) * 100;
        if (!this.mScroller.isFinished()) {
            this.mScroller.abortAnimation();
        }
        if (settle) {
            this.mScrollInterpolator.setDistance(screenDelta);
        } else {
            this.mScrollInterpolator.disableSettle();
        }
        velocity = Math.abs(velocity);
        duration = velocity > 0 ? (int)((float)duration + (float)duration / ((float)velocity / 2500.0f) * 0.4f) : (duration += 100);
        this.awakenScrollBars(duration);
        this.mScroller.startScroll(mScrollX, 0, delta, 0, duration);
        this.invalidate();
    }

    protected Parcelable onSaveInstanceState() {
        SavedState state = new SavedState(super.onSaveInstanceState());
        state.currentScreen = this.mCurrentScreen;
        return state;
    }

    public boolean awakenScrollBars() {
        try {
            Method awakenScrollBars = ViewGroup.class.getMethod("awakenScrollBars", new Class[0]);
            return (Boolean)awakenScrollBars.invoke((Object)this, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return true;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean awakenScrollBars(int duration) {
        try {
            Method awakenScrollBars = View.class.getMethod("awakenScrollBars", Integer.TYPE);
            return (Boolean)awakenScrollBars.invoke((Object)this, duration);
        }
        catch (NoSuchMethodException e) {
            return true;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        if (savedState.currentScreen != -1) {
            this.mCurrentScreen = savedState.currentScreen;
        }
    }

    public void scrollLeft() {
        if (this.mScroller.isFinished()) {
            if (this.mCurrentScreen > 0) {
                this.snapToScreen(this.mCurrentScreen - 1);
            }
        } else if (this.mNextScreen > 0) {
            this.snapToScreen(this.mNextScreen - 1);
        }
    }

    public void scrollRight() {
        if (this.mScroller.isFinished()) {
            if (this.mCurrentScreen < this.getChildCount() - 1) {
                this.snapToScreen(this.mCurrentScreen + 1);
            }
        } else if (this.mNextScreen < this.getChildCount() - 1) {
            this.snapToScreen(this.mNextScreen + 1);
        }
    }

    public int getScreenForView(View v) {
        int result = -1;
        if (v != null) {
            ViewParent vp = v.getParent();
            int count = this.getChildCount();
            int i = 0;
            while (i < count) {
                if (vp == this.getChildAt(i)) {
                    return i;
                }
                ++i;
            }
        }
        return result;
    }

    public boolean allowLongPress() {
        return this.mAllowLongPress;
    }

    public void setAllowLongPress(boolean allowLongPress) {
        this.mAllowLongPress = allowLongPress;
    }

    public void moveToDefaultScreen() {
        this.moveToDefaultScreen(true);
    }

    void moveToDefaultScreen(boolean animate) {
        if (animate) {
            this.snapToScreen(this.mDefaultScreen);
        } else {
            this.setCurrentScreen(this.mDefaultScreen);
        }
        this.getChildAt(this.mDefaultScreen).requestFocus();
    }

    public static class SavedState
    extends View.BaseSavedState {
        int currentScreen = -1;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.currentScreen = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.currentScreen);
        }
    }

    private static class WorkspaceOvershootInterpolator
    implements Interpolator {
        private static final float DEFAULT_TENSION = 1.3f;
        private float mTension = 1.3f;

        public void setDistance(int distance) {
            this.mTension = distance > 0 ? 1.3f / (float)distance : 1.3f;
        }

        public void disableSettle() {
            this.mTension = 0.0f;
        }

        public float getInterpolation(float t) {
            return (t -= 1.0f) * t * ((this.mTension + 1.0f) * t + this.mTension) + 1.0f;
        }
    }
}

