/*
 * Decompiled with CFR 0.152.
 */
package info.staticfree.android.utils;

import android.os.Build;
import android.view.MotionEvent;
import java.lang.reflect.Method;

public class MotionEventWrapper {
    public static final String TAG = MotionEventWrapper.class.getSimpleName();
    private static Method getX;
    private static Method getY;
    private static Method getPointerId;
    private static Method findPointerIndex;
    private static final boolean IS_OLD;

    static {
        IS_OLD = Build.VERSION.SDK_INT <= 4;
        MotionEventWrapper.initCompatibility();
    }

    private static void initCompatibility() {
        if (!IS_OLD) {
            try {
                getX = MotionEvent.class.getMethod("getX", Integer.TYPE);
                getY = MotionEvent.class.getMethod("getY", Integer.TYPE);
                getPointerId = MotionEvent.class.getMethod("getPointerId", Integer.TYPE);
                findPointerIndex = MotionEvent.class.getMethod("findPointerIndex", Integer.TYPE);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static float getX(MotionEvent ev, int optPointerIndex) {
        if (IS_OLD) {
            return ev.getX();
        }
        try {
            return ((Float)getX.invoke((Object)ev, optPointerIndex)).floatValue();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static float getY(MotionEvent ev, int optPointerIndex) {
        if (IS_OLD) {
            return ev.getY();
        }
        try {
            return ((Float)getY.invoke((Object)ev, optPointerIndex)).floatValue();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static int getPointerId(MotionEvent ev, int optPointerIndex) {
        if (IS_OLD) {
            return 0;
        }
        try {
            return (Integer)getPointerId.invoke((Object)ev, optPointerIndex);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static int findPointerIndex(MotionEvent ev, int activePointerId) {
        if (IS_OLD) {
            return 0;
        }
        try {
            return (Integer)findPointerIndex.invoke((Object)ev, activePointerId);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

