/*
 * Decompiled with CFR 0.152.
 */
package uk.me.jstott.sun;

public class Time {
    private int hours;
    private int minutes;
    private double seconds;
    private boolean roundedSeconds = true;

    public Time(int h, int m, double s) {
        if (h < 0 || h > 23) {
            throw new IllegalArgumentException("Hours (" + h + ") must be an integer from 0 through 23");
        }
        if (m < 0 || m > 59) {
            throw new IllegalArgumentException("Minutes (" + m + ") must be an integer from 0 through 59");
        }
        if (s < 0.0 || s >= 60.0) {
            throw new IllegalArgumentException("Seconds (" + s + ") must be from 0 to 60");
        }
        this.hours = h;
        this.minutes = m;
        this.seconds = s;
    }

    public void setRoundedSeconds(boolean r) {
        this.roundedSeconds = r;
    }

    public String toString() {
        String h = "";
        String m = "";
        String s = "";
        int hrs = this.hours;
        int mins = this.minutes;
        if (this.roundedSeconds) {
            int secs = (int)Math.round(this.seconds);
            if (secs < 10) {
                s = "0";
            }
            s = String.valueOf(s) + Integer.toString(secs);
            if (secs >= 60) {
                s = "00";
                ++mins;
            }
        } else {
            if (this.seconds < 10.0) {
                s = "0";
            }
            s = String.valueOf(s) + Double.toString(this.seconds);
        }
        if (mins >= 60) {
            mins = 0;
            ++hrs;
        }
        if (mins < 10) {
            m = "0";
        }
        m = String.valueOf(m) + Integer.toString(mins);
        if (hrs >= 24) {
            hrs = 0;
        }
        if (hrs < 10) {
            h = "0";
        }
        h = String.valueOf(h) + Integer.toString(hrs);
        return String.valueOf(h) + ":" + m + ":" + s;
    }

    public int getHours() {
        return this.hours;
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public double getSeconds() {
        return this.seconds;
    }

    public void setSeconds(double seconds) {
        this.seconds = seconds;
    }
}

