/*
 * Decompiled with CFR 0.152.
 */
package uk.me.jstott.sun;

import java.util.Calendar;
import java.util.TimeZone;
import uk.me.jstott.coordconv.LatitudeLongitude;
import uk.me.jstott.sun.Time;
import uk.me.jstott.util.JulianDateConverter;

public class Sun {
    private static final double SUNRISE_SUNSET_ZENITH_DISTANCE = 90.83333;
    private static final double CIVIL_TWILIGHT_ZENITH_DISTANCE = 96.0;
    private static final double NAUTICAL_TWILIGHT_ZENTITH_DISTANCE = 102.0;
    private static final double ASTRONOMICAL_TWILIGHT_ZENITH_DISTANCE = 108.0;

    private static double morningPhenomenon(double julian, double latitude, double longitude, double zenithDistance) {
        double t = Sun.julianDayToJulianCenturies(julian);
        double eqtime = Sun.equationOfTime(t);
        double solarDec = Sun.sunDeclination(t);
        double hourangle = Sun.hourAngleMorning(latitude, solarDec, zenithDistance);
        double delta = longitude - Sun.deg(hourangle);
        double timeDiff = 4.0 * delta;
        double timeUTC = 720.0 + timeDiff - eqtime;
        double newt = Sun.julianDayToJulianCenturies(Sun.julianCenturiesToJulianDay(t) + timeUTC / 1440.0);
        eqtime = Sun.equationOfTime(newt);
        solarDec = Sun.sunDeclination(newt);
        hourangle = Sun.hourAngleMorning(latitude, solarDec, zenithDistance);
        delta = longitude - Sun.deg(hourangle);
        timeDiff = 4.0 * delta;
        return 720.0 + timeDiff - eqtime;
    }

    public static Time sunriseTime(Calendar cal, LatitudeLongitude ll, TimeZone timeZone, boolean dst) {
        double julian = Sun.getJulianDate(cal);
        return Sun.sunriseTime(julian, ll, timeZone, dst);
    }

    public static Time sunriseTime(double julian, LatitudeLongitude ll, TimeZone timeZone, boolean dst) {
        double timeMins = Sun.morningPhenomenon(julian, ll.getLatitude(), -ll.getLongitude(), 90.83333) + (double)timeZone.getRawOffset() / 60000.0;
        if (dst) {
            timeMins += 60.0;
        }
        return Sun.convertTime(timeMins);
    }

    public static Time morningCivilTwilightTime(Calendar cal, LatitudeLongitude ll, TimeZone timeZone, boolean dst) {
        double julian = Sun.getJulianDate(cal);
        return Sun.morningCivilTwilightTime(julian, ll, timeZone, dst);
    }

    public static Time morningCivilTwilightTime(double julian, LatitudeLongitude ll, TimeZone timeZone, boolean dst) {
        double timeMins = Sun.morningPhenomenon(julian, ll.getLatitude(), -ll.getLongitude(), 96.0) + (double)timeZone.getRawOffset() / 60000.0;
        if (dst) {
            timeMins += 60.0;
        }
        return Sun.convertTime(timeMins);
    }

    public static Time morningNauticalTwilightTime(Calendar cal, LatitudeLongitude ll, TimeZone timeZone, boolean dst) {
        double julian = Sun.getJulianDate(cal);
        return Sun.morningNauticalTwilightTime(julian, ll, timeZone, dst);
    }

    public static Time morningNauticalTwilightTime(double julian, LatitudeLongitude ll, TimeZone timeZone, boolean dst) {
        double timeMins = Sun.morningPhenomenon(julian, ll.getLatitude(), -ll.getLongitude(), 102.0) + (double)timeZone.getRawOffset() / 60000.0;
        if (dst) {
            timeMins += 60.0;
        }
        return Sun.convertTime(timeMins);
    }

    public static Time morningAstronomicalTwilightTime(Calendar cal, LatitudeLongitude ll, TimeZone timeZone, boolean dst) {
        double julian = Sun.getJulianDate(cal);
        return Sun.morningAstronomicalTwilightTime(julian, ll, timeZone, dst);
    }

    public static Time morningAstronomicalTwilightTime(double julian, LatitudeLongitude ll, TimeZone timeZone, boolean dst) {
        double timeMins = Sun.morningPhenomenon(julian, ll.getLatitude(), -ll.getLongitude(), 108.0) + (double)timeZone.getRawOffset() / 60000.0;
        if (dst) {
            timeMins += 60.0;
        }
        return Sun.convertTime(timeMins);
    }

    private static double eveningPhenomenon(double julian, double latitude, double longitude, double zenithDistance) {
        double t = Sun.julianDayToJulianCenturies(julian);
        double eqtime = Sun.equationOfTime(t);
        double solarDec = Sun.sunDeclination(t);
        double hourangle = Sun.hourAngleEvening(latitude, solarDec, zenithDistance);
        double delta = longitude - Sun.deg(hourangle);
        double timeDiff = 4.0 * delta;
        double timeUTC = 720.0 + timeDiff - eqtime;
        double newt = Sun.julianDayToJulianCenturies(Sun.julianCenturiesToJulianDay(t) + timeUTC / 1440.0);
        eqtime = Sun.equationOfTime(newt);
        solarDec = Sun.sunDeclination(newt);
        hourangle = Sun.hourAngleEvening(latitude, solarDec, zenithDistance);
        delta = longitude - Sun.deg(hourangle);
        timeDiff = 4.0 * delta;
        return 720.0 + timeDiff - eqtime;
    }

    public static Time sunsetTime(Calendar cal, LatitudeLongitude ll, TimeZone timeZone, boolean dst) {
        double julian = Sun.getJulianDate(cal);
        return Sun.sunsetTime(julian, ll, timeZone, dst);
    }

    public static Time sunsetTime(double julian, LatitudeLongitude ll, TimeZone timeZone, boolean dst) {
        double timeMins = Sun.eveningPhenomenon(julian, ll.getLatitude(), -ll.getLongitude(), 90.83333) + (double)timeZone.getRawOffset() / 60000.0;
        if (dst) {
            timeMins += 60.0;
        }
        return Sun.convertTime(timeMins);
    }

    public static Time eveningCivilTwilightTime(Calendar cal, LatitudeLongitude ll, TimeZone timeZone, boolean dst) {
        double julian = Sun.getJulianDate(cal);
        return Sun.eveningCivilTwilightTime(julian, ll, timeZone, dst);
    }

    public static Time eveningCivilTwilightTime(double julian, LatitudeLongitude ll, TimeZone timeZone, boolean dst) {
        double timeMins = Sun.eveningPhenomenon(julian, ll.getLatitude(), -ll.getLongitude(), 96.0) + (double)timeZone.getRawOffset() / 60000.0;
        if (dst) {
            timeMins += 60.0;
        }
        return Sun.convertTime(timeMins);
    }

    public static Time eveningNauticalTwilightTime(Calendar cal, LatitudeLongitude ll, TimeZone timeZone, boolean dst) {
        double julian = Sun.getJulianDate(cal);
        return Sun.eveningNauticalTwilightTime(julian, ll, timeZone, dst);
    }

    public static Time eveningNauticalTwilightTime(double julian, LatitudeLongitude ll, TimeZone timeZone, boolean dst) {
        double timeMins = Sun.eveningPhenomenon(julian, ll.getLatitude(), -ll.getLongitude(), 102.0) + (double)timeZone.getRawOffset() / 60000.0;
        if (dst) {
            timeMins += 60.0;
        }
        return Sun.convertTime(timeMins);
    }

    public static Time eveningAstronomicalTwilightTime(Calendar cal, LatitudeLongitude ll, TimeZone timeZone, boolean dst) {
        double julian = Sun.getJulianDate(cal);
        return Sun.eveningAstronomicalTwilightTime(julian, ll, timeZone, dst);
    }

    public static Time eveningAstronomicalTwilightTime(double julian, LatitudeLongitude ll, TimeZone timeZone, boolean dst) {
        double timeMins = Sun.eveningPhenomenon(julian, ll.getLatitude(), -ll.getLongitude(), 108.0) + (double)timeZone.getRawOffset() / 60000.0;
        if (dst) {
            timeMins += 60.0;
        }
        return Sun.convertTime(timeMins);
    }

    private static double getJulianDate(Calendar cal) {
        Calendar cal2 = (Calendar)cal.clone();
        cal2.set(14, 0);
        cal2.set(13, 0);
        cal2.set(12, 0);
        cal2.set(11, 12);
        double julian = JulianDateConverter.dateToJulian(cal2);
        return julian;
    }

    private static Time convertTime(double time) {
        int hours = (int)(time / 60.0);
        int minutes = (int)(time - (double)(hours * 60));
        double seconds = (time - (double)minutes - (double)(hours * 60)) * 60.0;
        if (hours > 23) {
            hours %= 24;
        }
        return new Time(hours, minutes, seconds);
    }

    private static double julianDayToJulianCenturies(double julian) {
        return (julian - 2451545.0) / 36525.0;
    }

    private static double julianCenturiesToJulianDay(double t) {
        return t * 36525.0 + 2451545.0;
    }

    private static double equationOfTime(double t) {
        double epsilon = Sun.obliquityCorrection(t);
        double l0 = Sun.geomMeanLongSun(t);
        double e = Sun.eccentricityOfEarthsOrbit(t);
        double m = Sun.geometricMeanAnomalyOfSun(t);
        double y = Math.pow(Sun.tan(Sun.rad(epsilon) / 2.0), 2.0);
        double Etime = y * Sun.sin(2.0 * Sun.rad(l0)) - 2.0 * e * Sun.sin(Sun.rad(m)) + 4.0 * e * y * Sun.sin(Sun.rad(m)) * Sun.cos(2.0 * Sun.rad(l0)) - 0.5 * y * y * Sun.sin(4.0 * Sun.rad(l0)) - 1.25 * e * e * Sun.sin(2.0 * Sun.rad(m));
        return Math.toDegrees(Etime) * 4.0;
    }

    private static double sunDeclination(double t) {
        double e = Sun.obliquityCorrection(t);
        double lambda = Sun.sunsApparentLongitude(t);
        double sint = Sun.sin(Sun.rad(e)) * Sun.sin(Sun.rad(lambda));
        return Sun.deg(Sun.asin(sint));
    }

    private static double hourAngleMorning(double lat, double solarDec, double zenithDistance) {
        return Sun.acos(Sun.cos(Sun.rad(zenithDistance)) / (Sun.cos(Sun.rad(lat)) * Sun.cos(Sun.rad(solarDec))) - Sun.tan(Sun.rad(lat)) * Sun.tan(Sun.rad(solarDec)));
    }

    private static double hourAngleEvening(double lat, double solarDec, double zenithDistance) {
        return -Sun.hourAngleMorning(lat, solarDec, zenithDistance);
    }

    private static double obliquityCorrection(double t) {
        return Sun.meanObliquityOfEcliptic(t) + 0.00256 * Sun.cos(Sun.rad(125.04 - 1934.136 * t));
    }

    private static double meanObliquityOfEcliptic(double t) {
        return 23.0 + (26.0 + (21.448 - t * (46.815 + t * (5.9E-4 - t * 0.001813)) / 60.0)) / 60.0;
    }

    private static double geomMeanLongSun(double t) {
        double l0 = 280.46646 + t * (36000.76983 + 3.032E-4 * t);
        while (l0 >= 0.0 && l0 <= 360.0) {
            if (l0 > 360.0) {
                l0 -= 360.0;
            }
            if (!(l0 < 0.0)) continue;
            l0 += 360.0;
        }
        return l0;
    }

    private static double eccentricityOfEarthsOrbit(double t) {
        return 0.016708634 - t * (4.2037E-5 + 1.267E-7 * t);
    }

    private static double geometricMeanAnomalyOfSun(double t) {
        return 357.52911 + t * (35999.05029 - 1.537E-4 * t);
    }

    private static double sunsApparentLongitude(double t) {
        return Sun.sunsTrueLongitude(t) - 0.00569 - 0.00478 * Sun.sin(Sun.rad(125.04 - 1934.136 * t));
    }

    private static double sunsTrueLongitude(double t) {
        return Sun.geomMeanLongSun(t) + Sun.equationOfCentreForSun(t);
    }

    private static double equationOfCentreForSun(double t) {
        double m = Sun.geometricMeanAnomalyOfSun(t);
        return Sun.sin(Sun.rad(m)) * (1.914602 - t * (0.004817 + 1.4E-5 * t)) + Sun.sin(2.0 * Sun.rad(m)) * (0.019993 - 1.01E-4 * t) + Sun.sin(3.0 * Sun.rad(m)) * 2.89E-4;
    }

    private static double rad(double x) {
        return Math.toRadians(x);
    }

    private static double deg(double x) {
        return Math.toDegrees(x);
    }

    private static double sin(double x) {
        return Math.sin(x);
    }

    private static double cos(double x) {
        return Math.cos(x);
    }

    private static double tan(double x) {
        return Math.tan(x);
    }

    private static double asin(double x) {
        return Math.asin(x);
    }

    private static double acos(double x) {
        return Math.acos(x);
    }
}

