/*
 * Decompiled with CFR 0.152.
 */
package uk.me.jstott.coordconv;

public class LatitudeLongitude {
    private double latitude;
    private double longitude;
    public static final int NORTH = 1;
    public static final int SOUTH = -1;
    public static final int EAST = 1;
    public static final int WEST = -1;

    public LatitudeLongitude(double lat, double lng) {
        this.latitude = lat;
        this.longitude = lng;
    }

    public LatitudeLongitude(int northSouth, int degreesLat, int minutesLat, double secondsLat, int eastWest, int degreesLong, int minutesLong, double secondsLong) {
        if (northSouth != 1 && northSouth != -1) {
            throw new IllegalArgumentException("northSouth must be one of LatitudeLongitude.NORTH or LatitudeLongitde.SOUTH");
        }
        if (eastWest != 1 && eastWest != -1) {
            throw new IllegalArgumentException("eastWest must be one of LatitudeLongitude.EAST or LatitudeLongitde.WEST");
        }
        if (degreesLat < 0 || degreesLat > 90) {
            throw new IllegalArgumentException("degreesLat must be a value from  0 through 90");
        }
        if (minutesLat < 0 || minutesLat >= 60) {
            throw new IllegalArgumentException("minutesLat must be a value from  0 through 59");
        }
        if (secondsLat < 0.0 || secondsLat >= 60.0) {
            throw new IllegalArgumentException("secondsLat must be a value from 0.0 up to, but not including 60.0");
        }
        if (degreesLong < 0 || degreesLong > 180) {
            throw new IllegalArgumentException("degreesLong must be a value from  0 through 180");
        }
        if (minutesLong < 0 || minutesLong >= 60) {
            throw new IllegalArgumentException("minutesLong must be a value from  0 through 59");
        }
        if (secondsLong < 0.0 || secondsLong >= 60.0) {
            throw new IllegalArgumentException("secondsLong must be a value from 0.0 up to, but not including 60.0");
        }
        this.latitude = (double)(northSouth * degreesLat) + ((double)minutesLat + secondsLat / 60.0) / 60.0;
        this.longitude = (double)(eastWest * degreesLong) + ((double)minutesLong + secondsLong / 60.0) / 60.0;
    }

    public LatitudeLongitude(int degreesLat, int minutesLat, double secondsLat, int degreesLong, int minutesLong, double secondsLong) {
        if (degreesLat < 0 || degreesLat > 90) {
            throw new IllegalArgumentException("degreesLat must be a value from  0 through 90");
        }
        if (minutesLat < 0 || minutesLat >= 60) {
            throw new IllegalArgumentException("minutesLat must be a value from  0 through 59");
        }
        if (secondsLat < 0.0 || secondsLat >= 60.0) {
            throw new IllegalArgumentException("secondsLat must be a value from 0.0 up to, but not including 60.0");
        }
        if (degreesLong < 0 || degreesLong > 180) {
            throw new IllegalArgumentException("degreesLong must be a value from  0 through 180");
        }
        if (minutesLong < 0 || minutesLong >= 60) {
            throw new IllegalArgumentException("minutesLong must be a value from  0 through 59");
        }
        if (secondsLong < 0.0 || secondsLong >= 60.0) {
            throw new IllegalArgumentException("secondsLong must be a value from 0.0 up to, but not including 60.0");
        }
        this.latitude = (double)degreesLat + ((double)minutesLat + secondsLat / 60.0) / 60.0;
        this.longitude = (double)degreesLong + ((double)minutesLong + secondsLong / 60.0) / 60.0;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLatitude(double latitude) {
        if (latitude > 90.0 || latitude < -90.0) {
            throw new IllegalArgumentException("latitude must be between -90 and 90");
        }
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        if (longitude > 180.0 || longitude < -180.0) {
            throw new IllegalArgumentException("longitude must be between -180 and 180");
        }
        this.longitude = longitude;
    }

    public String toString() {
        String lat = "";
        int latDeg = (int)Math.floor(Math.abs(this.getLatitude()));
        int latMin = (int)Math.floor((Math.abs(this.getLatitude()) - (double)latDeg) * 60.0);
        double latSec = ((Math.abs(this.getLatitude()) - (double)latDeg) * 60.0 - (double)latMin) * 60.0;
        lat = String.valueOf(latDeg) + "\u221e" + latMin + "'" + latSec + "\"";
        lat = this.getLatitude() < 0.0 ? String.valueOf(lat) + "S" : String.valueOf(lat) + "N";
        String lng = "";
        int lngDeg = (int)Math.floor(Math.abs(this.getLongitude()));
        int lngMin = (int)Math.floor((Math.abs(this.getLongitude()) - (double)lngDeg) * 60.0);
        double lngSec = ((Math.abs(this.getLongitude()) - (double)lngDeg) * 60.0 - (double)lngMin) * 60.0;
        lng = String.valueOf(lngDeg) + "\u221e" + lngMin + "'" + lngSec + "\"";
        lng = this.getLongitude() < 0.0 ? String.valueOf(lng) + "W" : String.valueOf(lng) + "E";
        return String.valueOf(lat) + " " + lng;
    }
}

