/*
 * Copyright 2021-2024 New Vector Ltd.
 *
 * SPDX-License-Identifier: AGPL-3.0-only OR LicenseRef-Element-Commercial
 * Please see LICENSE files in the repository root for full details.
 */
package im.vector.app.core.ui.list

import android.view.View
import androidx.core.view.updateLayoutParams
import com.airbnb.epoxy.EpoxyAttribute
import com.airbnb.epoxy.EpoxyModelClass
import im.vector.app.R
import im.vector.app.core.epoxy.VectorEpoxyHolder
import im.vector.app.core.epoxy.VectorEpoxyModel

/**
 * A generic item with empty space.
 */
@EpoxyModelClass
abstract class VerticalMarginItem : VectorEpoxyModel<VerticalMarginItem.Holder>(R.layout.item_vertical_margin) {

    @EpoxyAttribute
    var heightInPx: Int = 0

    override fun bind(holder: Holder) {
        super.bind(holder)
        holder.space.updateLayoutParams {
            height = heightInPx
        }
    }

    class Holder : VectorEpoxyHolder() {
        val space by bind<View>(R.id.item_vertical_margin_space)
    }
}
