package utiltheme

import (
	"image/color"

	"gioui.org/layout"
	"gioui.org/unit"
	"gioui.org/widget"
	"gioui.org/widget/material"
)

const (
	ThemecolorDefault Themecolor = iota
	ThemecolorDisabled
	ThemecolorFgBlackBgBlue
	ThemecolorFgBlackBgGreen
	ThemecolorFgBlackBgRed
	ThemecolorFgBlackBgGray
)

type Themecolor int

func ButtonThemeSmall(
	gtx layout.Context, baseTheme material.Theme, clickable *widget.Clickable, label string,
) func(gtx layout.Context) layout.Dimensions {
	returnTheme := baseTheme
	returnTheme.TextSize = 10
	returnTheme.Palette = material.Palette{
		Bg:         rgb(0x000000),
		Fg:         rgb(0x000000),
		ContrastBg: rgb(0xe8e8e8),
		ContrastFg: rgb(0x888888),
	}
	b := material.Button(
		&returnTheme,
		clickable,
		label,
	)
	pad := unit.Dp(10)
	b.Inset = layout.Inset{Top: pad, Left: pad, Right: pad, Bottom: pad}
	return func(gtx layout.Context) layout.Dimensions {
		gtx.Constraints.Min.X = gtx.Dp(unit.Dp(50))
		gtx.Constraints.Max.X = gtx.Dp(unit.Dp(300))
		return b.Layout(gtx)
	}
}

func MaterialTheme(baseTheme material.Theme, tc Themecolor, fontSize unit.Sp) *material.Theme {
	returnTheme := baseTheme
	returnTheme.TextSize = fontSize

	if tc == ThemecolorFgBlackBgBlue {
		returnTheme.Palette = material.Palette{
			Bg:         rgb(0x000000),
			Fg:         rgb(0x000000),
			ContrastBg: rgb(0xe6f4ff),
			ContrastFg: rgb(0x000000),
		}
	} else if tc == ThemecolorFgBlackBgRed {
		returnTheme.Palette = material.Palette{
			Bg:         rgb(0x000000),
			Fg:         rgb(0x000000),
			ContrastBg: rgb(0xffbfbf),
			ContrastFg: rgb(0x000000),
		}
	} else if tc == ThemecolorFgBlackBgGreen {
		returnTheme.Palette = material.Palette{
			Bg:         rgb(0x000000),
			Fg:         rgb(0x000000),
			ContrastBg: rgb(0xc2ffd4),
			ContrastFg: rgb(0x000000),
		}
	} else if tc == ThemecolorFgBlackBgGray {
		returnTheme.Palette = material.Palette{
			Bg:         rgb(0x000000),
			Fg:         rgb(0x000000),
			ContrastBg: rgb(0xe8e8e8),
			ContrastFg: rgb(0x000000),
		}
	} else if tc == ThemecolorDisabled {
		returnTheme.Palette = material.Palette{
			Bg:         rgb(0x000000),
			Fg:         rgb(0x000000),
			ContrastBg: rgb(0xe8e8e8),
			ContrastFg: rgb(0x888888),
		}
	}

	return &returnTheme
}

func rgb(cbase uint32) color.NRGBA {
	c := 0xff000000 | cbase
	return color.NRGBA{A: uint8(c >> 24), R: uint8(c >> 16), G: uint8(c >> 8), B: uint8(c)}
}
