package utilfuncs

import (
	"fmt"
	"sort"
	"strconv"
	"strings"
)

func ParseCsvToInts(csv string) ([]int, error) {
	r := []int{}
	for _, v := range strings.Split(csv, ",") {
		if intValue, err := strconv.Atoi(v); err != nil {
			return nil, err
		} else {
			r = append(r, intValue)
		}
	}
	return r, nil
}

func MinFloat64(a, b float64) float64 {
	if a < b {
		return a
	} else {
		return b
	}
}

func MaxFloat64(a, b float64) float64 {
	if a > b {
		return a
	} else {
		return b
	}
}

func Contains(items []int, checkItem int) bool {
	for _, item := range items {
		if item == checkItem {
			return true
		}
	}
	return false
}

func Strvals[T any](items []T) []string {
	r := []string{}
	for _, s := range items {
		r = append(r, fmt.Sprintf("%v", s))
	}
	return r
}

func Truncate(str string, nChars int) string {
	if len(str) > nChars {
		return str[0:nChars]
	} else {
		return str
	}
}

func Normalize(str string) string {
	for _, c := range []string{"[", "]", "_", "*", "#"} {
		str = strings.Replace(str, c, " ", -1)
	}
	return strings.TrimSpace(str)
}

func RemoveItem(items []int, item int) []int {
	ret := []int{}
	for _, r := range items {
		if r != item {
			ret = append(ret, r)
		}
	}
	return ret
}

func UniqueInts(items []int) []int {
	var (
		keys = map[int]any{}
		arr  = []int{}
	)

	for _, item := range items {
		keys[item] = 0
	}
	for k, _ := range keys {
		arr = append(arr, k)
	}
	sort.Ints(arr)
	return arr
}

func Fif[T any](b bool, ifTrue, ifFalse T) T {
	if b {
		return ifTrue
	} else {
		return ifFalse
	}
}
