package pagestops

import (
	"gioui.org/layout"
	"gioui.org/unit"
	"gioui.org/widget"
	"gioui.org/widget/material"
	"gioui.org/x/component"
	"gioui.org/x/richtext"
	"git.sr.ht/~mil/transito/src/components/selectlist"
	"git.sr.ht/~mil/transito/src/globalstate"
)

type PageStops struct {
	GlobalState *globalstate.GlobalState
	list        widget.List

	// Stops section related
	stopsSelectList      selectlist.SelectList
	stopsSelectListItems []string
	stopsSearchTextfield component.TextField

	// Selected
	richtextSelected richtext.InteractiveText
	clickableSetFrom widget.Clickable
	clickableSetTo   widget.Clickable
	clickableSetFav  widget.Clickable
}

func Initialize(u *globalstate.GlobalState) *PageStops {
	page := PageStops{
		GlobalState: u,
		list:        widget.List{List: layout.List{Axis: layout.Vertical}},
		stopsSelectList: selectlist.SelectList{
			List:       widget.List{List: layout.List{Axis: layout.Vertical}},
			ItemHeight: unit.Dp(24),
			Theme:      u.Theme,
		},
		stopsSelectListItems: []string{},
		stopsSearchTextfield: component.TextField{Editor: widget.Editor{}},
	}
	return &page
}

func (page *PageStops) Render(gtx layout.Context) layout.Dimensions {
	var widgetsScroll = []layout.Widget{}
	if len(page.GlobalState.Save.FeedIDsEnabled) == 0 {
		widgetsScroll = append(
			widgetsScroll,
			material.Body1(page.GlobalState.Theme, "Must enable atleast 1 GTFS source to search").Layout,
		)
	} else {
		widgetsScroll = append(widgetsScroll, page.renderSearchWidgetsStops(gtx)...)
		widgetsScroll = append(widgetsScroll, page.renderSearchWidgetsSelected(gtx)...)
	}

	return material.List(page.GlobalState.Theme, &page.list).Layout(
		gtx,
		len(widgetsScroll),
		func(gtx layout.Context, i int) layout.Dimensions {
			return layout.UniformInset(unit.Dp(16)).Layout(gtx, widgetsScroll[i])
		},
	)
}
