package pageroute

import (
	"fmt"

	"gioui.org/layout"
	"gioui.org/unit"
	"gioui.org/x/richtext"
	"git.sr.ht/~mil/transito/src/util/utillinkhandler"
)

func (page *PageRoute) widgetRowSplitToFrom(gtx layout.Context) layout.Dimensions {
	gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(50))
	//gtx.Constraints.Max.Y = gtx.Constraints.Min.Y

	fromSwitchTabClicked := utillinkhandler.HandleLinkEvents(page.GlobalState.Window, &page.richtextFrom, gtx) == "tab1"
	toSwitchTabClicked := utillinkhandler.HandleLinkEvents(page.GlobalState.Window, &page.richtextTo, gtx) == "tab1"
	if fromSwitchTabClicked || toSwitchTabClicked {
		page.GlobalState.TabSelected = "Stops"
		page.GlobalState.Window.Invalidate()
	}

	defaultLabel := "Click above to set"
	fromSpans := []richtext.SpanStyle{}
	fromLabel := defaultLabel
	if page.GlobalState.LocationFromLabel != "" {
		fromLabel = fmt.Sprintf(
			"%s\n\n([%.5f, %.5f](geo:%.5f,%.5f))",
			page.GlobalState.LocationFromLabel,
			page.GlobalState.LocationFromCoords[0],
			page.GlobalState.LocationFromCoords[1],
			page.GlobalState.LocationFromCoords[0],
			page.GlobalState.LocationFromCoords[1],
		)
	}
	if s, err := page.GlobalState.MarkdownRenderer.Render([]byte(fmt.Sprintf(
		"[**From:**](transito://tab1)\n\n%s",
		fromLabel,
	))); err == nil {
		fromSpans = s
	}

	toSpans := []richtext.SpanStyle{}
	toLabel := defaultLabel
	if page.GlobalState.LocationToLabel != "" {
		toLabel = fmt.Sprintf(
			"%s\n\n([%.5f, %.5f](geo:%.5f,%.5f))",
			page.GlobalState.LocationToLabel,
			page.GlobalState.LocationToCoords[0],
			page.GlobalState.LocationToCoords[1],
			page.GlobalState.LocationToCoords[0],
			page.GlobalState.LocationToCoords[1],
		)
	}
	if s, err := page.GlobalState.MarkdownRenderer.Render([]byte(fmt.Sprintf(
		"[**To:**](transito://tab1)\n\n%s",
		toLabel,
	))); err == nil {
		toSpans = s
	}

	return layout.Flex{Axis: layout.Horizontal}.Layout(gtx,
		layout.Flexed(1, richtext.Text(&page.richtextFrom, page.GlobalState.Theme.Shaper, fromSpans...).Layout),
		layout.Flexed(0.01, layout.Spacer{Width: unit.Dp(2)}.Layout),
		layout.Flexed(1, richtext.Text(&page.richtextTo, page.GlobalState.Theme.Shaper, toSpans...).Layout),
	)
}
