package pageroute

import (
	"encoding/json"
	"fmt"
	"log"

	"gioui.org/layout"
	"gioui.org/x/richtext"
	"git.sr.ht/~mil/transito/src/components/divider"
	"git.sr.ht/~mil/transito/src/uipages/pageroute/mrtomarkdown"
	"git.sr.ht/~mil/transito/src/util/utillinkhandler"
)

func (page *PageRoute) widgetRowResultMarkdown(gtx layout.Context) []layout.Widget {
	if page.ResultMRRouteError == nil && page.ResultMRRoute == nil {
		// Initial load (e.g. empty)
		return []layout.Widget{}
	}

	utillinkhandler.HandleLinkEvents(page.GlobalState.Window, &page.richtextResultArea, gtx)
	if spans, err := page.GlobalState.MarkdownRenderer.Render([]byte(
		func() string {
			if page.ResultMRRouteError != nil {
				return fmt.Sprintf("%v", page.ResultMRRouteError)
			} else if page.buttonRow.ActiveButtonLabel == "Overview" {
				return mrtomarkdown.MROverviewFormatMarkdown(page.ResultMRRoute)
			} else if page.buttonRow.ActiveButtonLabel == "Debug" {
				textBytes, _ := json.MarshalIndent(page.ResultMRRoute, "", "  ")
				return "```\n" + string(textBytes) + "\n```"
			} else {
				return "Unknown"
			}
		}(),
	)); err != nil {
		log.Println("Unhandled error state for route result rendering")
		return []layout.Widget{}
	} else {
		var (
			btnsRow          = page.buttonRow.Layout
			renderedRichText = richtext.Text(
				&page.richtextResultArea, page.GlobalState.Theme.Shaper, spans...,
			).Layout
		)
		if page.ResultMRRouteError != nil {
			return []layout.Widget{
				divider.Divider(page.GlobalState.Theme).Layout,
				renderedRichText,
			}
		} else {
			return []layout.Widget{
				divider.Divider(page.GlobalState.Theme).Layout,
				btnsRow,
				renderedRichText,
			}
		}
	}
}
