package pageroute

import (
	"strconv"

	"gioui.org/layout"
	"gioui.org/unit"
)

func dimensionsToWidget(d layout.Dimensions) func(gtx layout.Context) layout.Dimensions {
	return func(gtx layout.Context) layout.Dimensions {
		return d
	}
}

func blankWidget(gtx layout.Context) layout.Dimensions {
	return layout.Spacer{Height: unit.Dp(0)}.Layout(gtx)
}

func parseUint(str string) uint {
	if v, err := strconv.Atoi(str); err != nil {
		return 0
	} else {
		return uint(v)
	}
}

func parseFloat64(str string) float64 {
	if v, err := strconv.ParseFloat(str, 10); err != nil {
		return 0.0
	} else {
		return v
	}
}

func ptr[T any](a T) *T {
	return &a
}
