package pagepois

import (
	"fmt"

	"gioui.org/layout"
	"gioui.org/unit"
	"gioui.org/widget/material"
	"gioui.org/x/richtext"
	"git.sr.ht/~mil/transito/src/util/utillinkhandler"
	"git.sr.ht/~mil/transito/src/util/utiltext"
)

func (widget *PagePOI) renderSearchWidgetsSelected(gtx layout.Context) []layout.Widget {
	renderSelectedLabel, renderSelectedMDData := widget.determineSelectedData()
	widget.eventhandlersSearchWidgetsSelected(gtx, renderSelectedLabel)

	// Selected text markdown
	widgetSelectedText := func(gtx layout.Context) layout.Dimensions {
		if renderSelectedMDData == "" {
			return layout.Spacer{Height: unit.Dp(0)}.Layout(gtx)
		}
		selectedSpans := []richtext.SpanStyle{}
		if s, err := widget.GlobalState.MarkdownRenderer.Render([]byte(renderSelectedMDData)); err == nil {
			selectedSpans = s
		}
		return richtext.Text(&widget.richtextSelected, widget.GlobalState.Theme.Shaper, selectedSpans...).Layout(gtx)
	}

	// Buttons split
	widgetButtonsSplit := func(gtx layout.Context) layout.Dimensions {
		if renderSelectedLabel == "" {
			return layout.Spacer{Height: unit.Dp(0)}.Layout(gtx)
		}
		gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(50))
		gtx.Constraints.Max.Y = gtx.Constraints.Min.Y
		return layout.Flex{}.Layout(gtx, layout.Rigid(dimensionsToWidget(layout.Flex{}.Layout(
			gtx,
			layout.Flexed(0.2, func(gtx layout.Context) layout.Dimensions {
				return material.Button(widget.GlobalState.Theme, &widget.clickableSetFrom, "Set as From").Layout(gtx)
			}),
			layout.Flexed(0.01, layout.Spacer{Width: unit.Dp(2)}.Layout),
			layout.Flexed(0.2, func(gtx layout.Context) layout.Dimensions {
				return material.Button(widget.GlobalState.Theme, &widget.clickableSetTo, "Set as To").Layout(gtx)
			}),
			layout.Flexed(0.01, layout.Spacer{Width: unit.Dp(2)}.Layout),
			layout.Flexed(0.2, func(gtx layout.Context) layout.Dimensions {
				return material.Button(widget.GlobalState.Theme, &widget.clickableSetFav, "Favorite").Layout(gtx)
			}),
		))))
	}

	widgets := []layout.Widget{
		widgetSelectedText,
		widgetButtonsSplit,
	}
	return widgets
}

func (widget *PagePOI) determineSelectedData() (string, string) {
	var (
		renderSelectedLabel  string
		renderSelectedMDData string
	)

	selectListSelected := widget.poisSelectList.Selected
	selectListItems := widget.poisSelectListItems
	if selectListSelected <= len(selectListItems)-1 {
		if label, coords, err := utiltext.ParseLatLon(selectListItems[selectListSelected]); err == nil {
			renderSelectedLabel = selectListItems[selectListSelected]
			renderSelectedMDData = fmt.Sprintf(
				"**Selected:**\n\n%s ([%.5f, %.5f](geo:%.5f,%.5f))",
				label, coords[0], coords[1], coords[0], coords[1],
			)
		}
	}

	return renderSelectedLabel, renderSelectedMDData
}

func (widget *PagePOI) eventhandlersSearchWidgetsSelected(gtx layout.Context, renderSelectedLabel string) {
	utillinkhandler.HandleLinkEvents(widget.GlobalState.Window, &widget.richtextSelected, gtx)

	if widget.clickableSetFrom.Clicked(gtx) {
		if renderSelectedLabel != "" {
			setFromTo(widget, "from", renderSelectedLabel)
			widget.clearPOIearch()
		}
	}
	if widget.clickableSetTo.Clicked(gtx) {
		if renderSelectedLabel != "" {
			setFromTo(widget, "to", renderSelectedLabel)
			widget.clearPOIearch()
		}
	}
	if widget.clickableSetFav.Clicked(gtx) {
		if renderSelectedLabel != "" {
			widget.GlobalState.Save.Favorites = append(widget.GlobalState.Save.Favorites, renderSelectedLabel)
			widget.clearPOIearch()
		}
	}
}

func (widget *PagePOI) clearPOIearch() {
	widget.textfieldPOI.Clear()
	widget.poisSelectListItems = []string{}
}
