package pagepois

import (
	"gioui.org/layout"
	"git.sr.ht/~mil/transito/src/util/utiltext"
)

func wgToWidget(widget *PagePOI, wg func(widget *PagePOI, gtx layout.Context) layout.Dimensions) func(layout.Context) layout.Dimensions {
	return func(gtx layout.Context) layout.Dimensions {
		return wg(widget, gtx)
	}
}

func dimensionsToWidget(d layout.Dimensions) func(gtx layout.Context) layout.Dimensions {
	return func(gtx layout.Context) layout.Dimensions {
		return d
	}
}

func setFromTo(page *PagePOI, fromOrTo, inputTextLabel string) {
	if label, coords, err := utiltext.ParseLatLon(inputTextLabel); err == nil {
		if fromOrTo == "from" {
			page.GlobalState.LocationFromCoords = coords
			page.GlobalState.LocationFromLabel = label
		} else {
			page.GlobalState.LocationToCoords = coords
			page.GlobalState.LocationToLabel = label
		}
		page.GlobalState.TabSelected = "Route"
		page.GlobalState.Window.Invalidate()
	}
}

func removeAtIndex[T any](slice []T, idx int) []T {
	return append(slice[:idx], slice[idx+1:]...)
}
