package pagefave

import (
	"fmt"
	"strconv"
	"strings"

	"gioui.org/layout"
	"gioui.org/x/richtext"
	"git.sr.ht/~mil/transito/src/util/utilfuncs"
	"git.sr.ht/~mil/transito/src/util/utillinkhandler"
)

func (widget *PageFave) renderSearchWidgetsFavorites(gtx layout.Context) []layout.Widget {
	if len(widget.GlobalState.Save.Favorites) < 1 {
		return []layout.Widget{}
	}

	if favoritesClick := utillinkhandler.HandleLinkEvents(widget.GlobalState.Window, &widget.richtextFavorites, gtx); favoritesClick != "" {
		split := strings.Split(favoritesClick, "/")
		if len(split) == 2 {
			cmd := split[0]
			favoriteIdx, _ := strconv.Atoi(split[1])
			if cmd == "from" {
				setFromTo(widget, "from", widget.GlobalState.Save.Favorites[favoriteIdx])
			} else if cmd == "to" {
				setFromTo(widget, "to", widget.GlobalState.Save.Favorites[favoriteIdx])
			} else if cmd == "delete" {
				widget.GlobalState.Save.Favorites = removeAtIndex(
					widget.GlobalState.Save.Favorites,
					favoriteIdx,
				)
				if len(widget.GlobalState.Save.Favorites) == 0 {
					widget.GlobalState.TabSelected = "Config"
				}
			}
			widget.GlobalState.Window.Invalidate()
		}
	}

	mdText := "##### Favorites\n"
	for i, fav := range widget.GlobalState.Save.Favorites {
		mdText = fmt.Sprintf(
			"%s\n%d. **%s**  *[From](transito://from/%d) / [To](transito://to/%d) ([X](transito://delete/%d))*",
			mdText, i, utilfuncs.Normalize(utilfuncs.Truncate(fav, 20)), i, i, i,
		)
	}

	favSpans := []richtext.SpanStyle{}
	if s, err := widget.GlobalState.MarkdownRenderer.Render([]byte(mdText)); err == nil {
		favSpans = s
	}

	return []layout.Widget{
		richtext.Text(&widget.richtextFavorites, widget.GlobalState.Theme.Shaper, favSpans...).Layout,
	}
}
