package pagefave

import (
	"gioui.org/layout"
	"gioui.org/unit"
	"gioui.org/widget"
	"gioui.org/widget/material"
	"gioui.org/x/richtext"
	"git.sr.ht/~mil/transito/src/globalstate"
)

type PageFave struct {
	GlobalState *globalstate.GlobalState
	list        widget.List

	// Favorites section related
	richtextFavorites richtext.InteractiveText
}

func Initialize(u *globalstate.GlobalState) *PageFave {
	page := PageFave{
		GlobalState: u,
		list:        widget.List{List: layout.List{Axis: layout.Vertical}},
	}
	return &page
}

func (page *PageFave) Render(gtx layout.Context) layout.Dimensions {

	var widgetsScroll = []layout.Widget{}
	widgetsScroll = append(widgetsScroll, page.renderSearchWidgetsFavorites(gtx)...)

	return material.List(page.GlobalState.Theme, &page.list).Layout(
		gtx,
		len(widgetsScroll),
		func(gtx layout.Context, i int) layout.Dimensions {
			return layout.UniformInset(unit.Dp(16)).Layout(gtx, widgetsScroll[i])
		},
	)
}
