package pageconfig

import (
	"fmt"

	"gioui.org/layout"
	"gioui.org/widget/material"
	"gioui.org/x/richtext"
	"git.sr.ht/~mil/transito/src/components/divider"
	"git.sr.ht/~mil/transito/src/util/utillinkhandler"
)

func (page *PageConfig) renderConfigWidgetsHelp(gtx layout.Context) []layout.Widget {
	utillinkhandler.HandleLinkEvents(page.GlobalState.Window, &page.richtextHelp, gtx)
	helpText := func() func(gtx layout.Context) layout.Dimensions {
		spans := []richtext.SpanStyle{}
		if rendered, err := page.GlobalState.MarkdownRenderer.Render([]byte(fmt.Sprintf(
			`[**Transito**](%s) is FOSS public transportation app that downloads openly available GTFS feeds and calculates offline routes from this data ondevice.

  - **Doc:** [Transito Mobile App Userguide](%s)
  - **Doc:** [Mobroute (Algorithm) Project Page](%s)
  - **Doc:** [GTFS Sources Lookup](%s)
  - **Build:** [%s](%s)
			`,
			"https://git.sr.ht/~mil/transito",
			"https://git.sr.ht/~mil/transito/tree/master/doc/doc_transito_userguide.md",
			"https://sr.ht/~mil/mobroute",
			"https://mdb.lrdu.org/",
			Commit,
			"https://git.sr.ht/~mil/transito/refs",
		))); err == nil {
			spans = rendered
		}
		return richtext.Text(&page.richtextHelp, page.GlobalState.Theme.Shaper, spans...).Layout
	}()

	return []layout.Widget{
		divider.Divider(page.GlobalState.Theme).Layout,
		material.H6(page.GlobalState.Theme, "Help").Layout,
		helpText,
	}
}
