package pageconfig

import (
	"gioui.org/layout"
	"gioui.org/unit"
	"gioui.org/widget/material"
	"git.sr.ht/~mil/transito/src/components/divider"
	"git.sr.ht/~mil/transito/src/components/styledbutton"
	"git.sr.ht/~mil/transito/src/globalstate"
	"git.sr.ht/~mil/transito/src/util/utilfuncs"
)

func (page *PageConfig) renderConfigWidgetsAdvanced(gtx layout.Context) []layout.Widget {
	if page.clickableHideShowAdv.Clicked(gtx) {
		page.hideShowAdv = !page.hideShowAdv
	}
	if page.clickableAddGTFSZip.Clicked(gtx) {
		page.GlobalState.AppQueueload = &globalstate.AppQueueload{FeedLoadCustomPicker: true, ReturnToTab: "Config"}
	}
	if page.clickableReset.Clicked(gtx) {
		page.checkboxCfgOfflineMode.Value = false
		page.checkboxCfgSchedule.Value = false
		page.checkboxCfgCrossfeedCompute.Value = false
		page.checkboxCfgUseAgencyGTFSURLs.Value = false
		page.textfieldNominatimURL.SetText(DefaultNominatimURL)
	}

	widgetCheckboxesRowA := func(gtx layout.Context) layout.Dimensions {
		gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(40))
		gtx.Constraints.Max.Y = gtx.Constraints.Min.Y
		return layout.Flex{}.Layout(gtx, layout.Rigid(dimensionsToWidget(layout.Flex{}.Layout(
			gtx,
			layout.Flexed(0.2, material.CheckBox(page.GlobalState.Theme, &page.checkboxCfgOfflineMode, "Offline\nMode").Layout),
			layout.Flexed(0.01, layout.Spacer{Width: unit.Dp(2)}.Layout),
			layout.Flexed(0.2, material.CheckBox(page.GlobalState.Theme, &page.checkboxCfgSchedule, "Disable\nSchedules").Layout),
			layout.Flexed(0.01, layout.Spacer{Width: unit.Dp(2)}.Layout),
			layout.Flexed(0.2, material.CheckBox(page.GlobalState.Theme, &page.checkboxCfgCrossfeedCompute, "Crossfeed\nTransfers").Layout),
		))))
	}
	widgetCheckboxesRowB := func(gtx layout.Context) layout.Dimensions {
		gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(40))
		gtx.Constraints.Max.Y = gtx.Constraints.Min.Y
		return layout.Flex{}.Layout(gtx, layout.Rigid(dimensionsToWidget(layout.Flex{}.Layout(
			gtx,
			layout.Flexed(0.2, material.CheckBox(page.GlobalState.Theme, &page.checkboxCfgUseAgencyGTFSURLs, "Use Agency\nGTFS URLs").Layout),
			layout.Flexed(0.01, layout.Spacer{Width: unit.Dp(2)}.Layout),
			layout.Flexed(0.4, layout.Spacer{Width: unit.Dp(2)}.Layout),
		))))
	}

	widgetButtonsRowC := func(gtx layout.Context) layout.Dimensions {
		gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(40))
		gtx.Constraints.Max.Y = gtx.Constraints.Min.Y
		btnCustomGTFS := material.Button(page.GlobalState.Theme, &page.clickableAddGTFSZip, "Custom GTFS ZIP")
		btnResetDefaults := material.Button(page.GlobalState.Theme, &page.clickableReset, "Reset Config")

		return layout.Flex{}.Layout(gtx, layout.Rigid(dimensionsToWidget(layout.Flex{}.Layout(
			gtx,
			layout.Flexed(0.2, btnCustomGTFS.Layout),
			layout.Flexed(0.01, layout.Spacer{Width: unit.Dp(2)}.Layout),
			layout.Flexed(0.2, btnResetDefaults.Layout),
		))))
	}

	nominatimTextfield := func(gtx layout.Context) layout.Dimensions {
		return page.textfieldNominatimURL.Layout(gtx, page.GlobalState.Theme, "Nominatim URL Endpoint")
	}

	header := func(gtx layout.Context) layout.Dimensions {
		showHideButton := styledbutton.StyledButtonSmall(
			gtx, *page.GlobalState.Theme, &page.clickableHideShowAdv,
			utilfuncs.Fif(page.hideShowAdv, "↑", "↓"),
		)
		return layout.Flex{
			Spacing: layout.SpaceBetween,
		}.Layout(gtx, layout.Rigid(dimensionsToWidget(layout.Flex{}.Layout(
			gtx,
			layout.Flexed(0.4, material.H6(page.GlobalState.Theme, "Advanced Configuration").Layout),
			layout.Flexed(0.2, dimensionsToWidget(layout.Stack{Alignment: layout.E}.Layout(gtx, layout.Expanded(func(gtx layout.Context) layout.Dimensions {
				return showHideButton(gtx)
			})))),
		))))
	}

	widgets := []layout.Widget{
		divider.Divider(page.GlobalState.Theme).Layout,
		header,
	}
	if page.hideShowAdv {
		widgets = append(widgets,
			widgetCheckboxesRowA,
			widgetCheckboxesRowB,
			nominatimTextfield,
			widgetButtonsRowC,
		)
	}
	return widgets
}
